/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.util.EventObject;
import jess.Context;

public class JessEvent
extends EventObject {
    public static final int DEFRULE = 1;
    public static final int DEFRULE_FIRED = 2;
    public static final int ACTIVATION = 4;
    public static final int DEFFACTS = 8;
    public static final int FACT = 16;
    public static final int DEFINSTANCE = 32;
    public static final int DEFTEMPLATE = 64;
    public static final int DEFCLASS = 128;
    public static final int DEFGLOBAL = 256;
    public static final int USERFUNCTION = 512;
    public static final int USERPACKAGE = 1024;
    public static final int CLEAR = 2048;
    public static final int RESET = 4096;
    public static final int RUN = 8192;
    public static final int HALT = 16384;
    public static final int RETE_TOKEN = 32768;
    public static final int RETE_TOKEN_LEFT = 32768;
    public static final int RETE_TOKEN_RIGHT = 65536;
    public static final int USERFUNCTION_CALLED = 524288;
    public static final int FOCUS = 0x100000;
    public static final int USERFUNCTION_RETURNED = 0x200000;
    public static final int MODIFIED = 0x40000000;
    public static final int REMOVED = Integer.MIN_VALUE;
    Object m_obj;
    int m_type;
    int m_tag = -1;
    private Context m_context;

    public JessEvent(Object object, int n2, Object object2) {
        this(object, n2, object2, null);
    }

    public JessEvent(Object object, int n2, Object object2, Context context) {
        super(object);
        this.m_type = n2;
        this.m_obj = object2;
        this.m_context = context;
    }

    JessEvent(Object object, int n2, int n3, Object object2, Context context) {
        super(object);
        this.m_type = n2;
        this.m_obj = object2;
        this.m_tag = n3;
        this.m_context = context;
    }

    public int getType() {
        return this.m_type;
    }

    public int getTag() {
        return this.m_tag;
    }

    public Object getObject() {
        return this.m_obj;
    }

    public Context getContext() {
        return this.m_context;
    }

    public String toString() {
        return "[JessEvent: " + JessEvent.getEventName(this.m_type) + "]";
    }

    public static String getEventName(int n2) {
        switch (n2) {
            case 1: {
                return "a rule was added";
            }
            case -2147483647: {
                return "a rule was removed";
            }
            case 2: {
                return "a rule was fired";
            }
            case 4: {
                return "a rule was activated";
            }
            case -2147483644: {
                return "a rule was deactivated";
            }
            case 8: {
                return "a deffacts was added";
            }
            case 16: {
                return "a fact was asserted";
            }
            case 0x40000010: {
                return "a fact was modified";
            }
            case -2147483632: {
                return "a fact was retracted";
            }
            case 32: {
                return "an instance was added";
            }
            case -2147483616: {
                return "an instance was removed";
            }
            case 64: {
                return "a template was added";
            }
            case 128: {
                return "a class was defined";
            }
            case 256: {
                return "a global was defined";
            }
            case 512: {
                return "a user function was added";
            }
            case -2147483136: {
                return "a user function was removed";
            }
            case 1024: {
                return "a user package was added";
            }
            case 2048: {
                return "the engine was cleared";
            }
            case 4096: {
                return "the engine was reset";
            }
            case 8192: {
                return "the engine was run";
            }
            case 16384: {
                return "the engine was halted";
            }
            case 32768: {
                return "a left token in the Rete network";
            }
            case 65536: {
                return "a right token in the Rete network";
            }
            case 524288: {
                return "a userfunction was called";
            }
            case 0x200000: {
                return "a call to a userfunction has returned";
            }
            case 0x100000: {
                return "a module got the focus";
            }
        }
        return "unknown event type " + n2;
    }
}

