/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import jess.Accumulate;
import jess.ArgumentChecker;
import jess.ConditionalElementX;
import jess.Context;
import jess.Deffacts;
import jess.Deffunction;
import jess.Defglobal;
import jess.Defmodule;
import jess.Defquery;
import jess.Defrule;
import jess.Deftemplate;
import jess.ErrorSink;
import jess.Fact;
import jess.FactIDValue;
import jess.Funcall;
import jess.FuncallValue;
import jess.Group;
import jess.InfixSlotParser;
import jess.JessException;
import jess.JessToken;
import jess.JessTokenStream;
import jess.ListFunctions;
import jess.LongValue;
import jess.Named;
import jess.ParseException;
import jess.Pattern;
import jess.QueryArgumentChecker;
import jess.RU;
import jess.ReaderTokenizer;
import jess.Rete;
import jess.Test1;
import jess.Tokenizer;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;
import jess.Variable;

public class Jesp
implements ErrorSink {
    private static final String JAVACALL = "call";
    public static final String PROMPT = "Jess> ";
    private JessTokenStream m_jts;
    private Rete m_engine;
    private boolean m_issueWarnings = false;
    private ArrayList m_warnings = new ArrayList();
    private String m_fileName = "<unknown>";
    private static final String[] RULE_DECLARABLES = new String[]{"salience", "node-index-hash", "auto-focus", "no-loop"};
    private static final String[] QUERY_DECLARABLES = new String[]{"node-index-hash", "variables", "max-background-rules"};
    static final String ORDERED = "ordered";
    static final String FROM_CLASS = "from-class";
    static final String INCLUDE_VARIABLES = "include-variables";
    static final String BACKCHAIN_REACTIVE = "backchain-reactive";
    static final String SLOT_SPECIFIC = "slot-specific";
    private static final String[] DEFTEMPLATE_DECLARABLES = new String[]{"slot-specific", "backchain-reactive", "from-class", "include-variables", "ordered"};
    private static final String[] SLOT_QUALIFIERS = new String[]{"type", "default", "default-dynamic"};
    private static final String[] OPEN_PAREN = new String[]{"("};
    static final String[] CLOSE_PAREN = new String[]{")"};
    private static final String[] PARENS = new String[]{"(", ")"};
    private static final String[] SLOT_TYPE = new String[]{"slot", "multislot"};
    private static final String[] DECLARE_OR_SLOT_TYPE = new String[]{"declare", "slot", "multislot"};
    private static final String[] RIGHT_ARROW = new String[]{"=>"};
    private static final String[] CONSTRUCT_NAMES = new String[]{"defrule", "deffunction", "deftemplate", "deffacts", "defglobal", "defmodule", "defquery"};
    private HashMap m_checkers = new HashMap();

    public Jesp(Reader reader, Rete rete) {
        this(rete);
        Tokenizer tokenizer = rete.getInputWrapper(reader);
        if (tokenizer == null) {
            tokenizer = new ReaderTokenizer(reader, false);
        }
        this.m_jts = new JessTokenStream(tokenizer);
    }

    public Jesp(Tokenizer tokenizer, Rete rete) {
        this(rete);
        this.m_jts = new JessTokenStream(tokenizer);
    }

    private Jesp(Rete rete) {
        this.m_engine = rete;
        QueryArgumentChecker queryArgumentChecker = new QueryArgumentChecker();
        this.addArgumentChecker("run-query", queryArgumentChecker);
        this.addArgumentChecker("run-query*", queryArgumentChecker);
        this.addArgumentChecker("count-query-results", queryArgumentChecker);
    }

    public void addArgumentChecker(String string, ArgumentChecker argumentChecker) {
        this.m_checkers.put(string, argumentChecker);
    }

    public Rete getEngine() {
        return this.m_engine;
    }

    public void setIssueWarnings(boolean bl) {
        this.m_issueWarnings = bl;
    }

    public void clearWarnings() {
        this.m_warnings.clear();
    }

    public List getWarnings() {
        return this.m_warnings;
    }

    public int getStreamPos() {
        return this.m_jts.getStreamPos();
    }

    public void eatWhitespace() throws JessException {
        this.m_jts.eatWhitespace();
    }

    public void eatWhitespaceAndComments() throws JessException {
        JessToken jessToken = this.nextToken(this.m_jts);
        this.m_jts.pushBack(jessToken);
    }

    JessTokenStream getTokenStream() {
        return this.m_jts;
    }

    public Value parse(boolean bl) throws JessException {
        return this.parse(bl, this.m_engine.getGlobalContext());
    }

    public synchronized Value parse(boolean bl, Context context) throws JessException {
        Value value;
        Value value2 = value = Funcall.TRUE;
        while (!value.equals(Funcall.EOF)) {
            value2 = value;
            value = this.promptAndParseOneExpression(bl, context);
        }
        return value2;
    }

    public Value promptAndParseOneExpression(boolean bl, Context context) throws JessException {
        Object object;
        if (bl) {
            this.m_engine.getOutStream().print(PROMPT);
            this.m_engine.getOutStream().flush();
        }
        Value value = (object = this.parseExpression(context, true, this.m_jts)) instanceof Value ? (Value)object : Funcall.TRUE;
        if (bl && !value.equals(Funcall.NIL)) {
            if (value.type() == 512) {
                this.m_engine.getOutStream().print('(');
            }
            this.m_engine.getOutStream().print(value);
            if (value.type() == 512) {
                this.m_engine.getOutStream().print(')');
            }
            this.m_engine.getOutStream().println();
        }
        return value;
    }

    public void clear() {
        this.m_jts.clear();
    }

    public Value loadFacts(Context context) throws JessException {
        JessToken jessToken = this.nextToken(this.m_jts);
        while (jessToken.m_ttype != 0) {
            this.m_jts.pushBack(jessToken);
            Fact fact = this.parseFact(context.getEngine(), this.m_jts);
            this.m_engine.assertFact(fact, context);
            jessToken = this.nextToken(this.m_jts);
        }
        return Funcall.TRUE;
    }

    public Object parseExpression(Context context, boolean bl) throws JessException {
        return this.parseExpression(context, bl, this.m_jts);
    }

    public Object parseExpression(Context context, boolean bl, JessTokenStream jessTokenStream) throws JessException {
        try {
            JessToken jessToken = this.nextToken(jessTokenStream);
            switch (jessToken.m_ttype) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    Value value = jessToken.valueOf(context);
                    return value;
                }
                case 7: 
                case 11: {
                    Value value = Funcall.NIL;
                    return value;
                }
                case 40: {
                    break;
                }
                case 0: {
                    if ("EOF".equals(jessToken.m_sval)) {
                        Value value = Funcall.EOF;
                        return value;
                    }
                }
                default: {
                    this.error("parseExpression", "Expected a '(', constant, or global variable", 1000, jessToken);
                }
            }
            JessToken jessToken2 = this.nextToken(jessTokenStream);
            String string = Jesp.tokenAsSymbol(jessToken2);
            jessTokenStream.pushBack(jessToken2);
            jessTokenStream.pushBack(jessToken);
            if (string.equals("defrule")) {
                Defrule defrule = this.parseDefrule(context, this.m_engine, jessTokenStream);
                if (bl) {
                    this.m_engine.addDefrule(defrule);
                }
                Defrule defrule2 = defrule;
                return defrule2;
            }
            if (string.equals("defquery")) {
                Defquery defquery = this.parseDefquery(context, this.m_engine, jessTokenStream);
                if (bl) {
                    this.m_engine.addDefrule(defquery);
                }
                Defquery defquery2 = defquery;
                return defquery2;
            }
            if (string.equals("deffacts")) {
                Deffacts deffacts = this.parseDeffacts(this.m_engine, jessTokenStream);
                this.m_engine.addDeffacts(deffacts);
                Deffacts deffacts2 = deffacts;
                return deffacts2;
            }
            if (string.equals("deftemplate")) {
                Deftemplate deftemplate = this.parseDeftemplate(context, this.m_engine, jessTokenStream);
                this.m_engine.addDeftemplate(deftemplate);
                Deftemplate deftemplate2 = deftemplate;
                return deftemplate2;
            }
            if (string.equals("deffunction")) {
                Deffunction deffunction = this.parseDeffunction(this.m_engine, jessTokenStream);
                this.m_engine.addUserfunction(deffunction);
                Deffunction deffunction2 = deffunction;
                return deffunction2;
            }
            if (string.equals("defglobal")) {
                List list = this.parseDefglobal(this.m_engine, jessTokenStream);
                this.m_engine.addDefglobals(list);
                List list2 = list;
                return list2;
            }
            if (string.equals("defmodule")) {
                Defmodule defmodule = this.parseDefmodule(jessTokenStream);
                this.m_engine.addDefmodule(defmodule);
                Defmodule defmodule2 = defmodule;
                return defmodule2;
            }
            if (string.equals("EOF")) {
                if (this.m_issueWarnings) {
                    this.warning("Jesp.parse", "Expected construct or function name", this.listFunctionAndConstructNames(this.m_engine), 1001, jessToken2);
                }
                Value value = Funcall.EOF;
                return value;
            }
            if (bl) {
                jessTokenStream.eatWhitespace();
                Value value = this.parseAndExecuteFuncall(null, context, this.m_engine, jessTokenStream, true);
                return value;
            }
            FuncallValue funcallValue = new FuncallValue(this.parseFuncall(this.m_engine, jessTokenStream, true));
            return funcallValue;
        }
        catch (JessException jessException) {
            jessException.setLineNumber(jessTokenStream.getLineNumber());
            jessException.setProgramText(jessTokenStream.toString());
            throw jessException;
        }
        finally {
            jessTokenStream.clear();
        }
    }

    public void setFileName(String string) {
        this.m_fileName = string;
    }

    static String tokenAsSymbol(JessToken jessToken) {
        if (jessToken.m_ttype != 4) {
            if (jessToken.m_ttype == 45) {
                return "-";
            }
            if (jessToken.m_ttype == 61) {
                return "=";
            }
            if (jessToken.m_ttype == 2) {
                return jessToken.m_sval;
            }
            return jessToken.toString();
        }
        if (jessToken.m_sval != null) {
            return jessToken.m_sval;
        }
        return jessToken.toString();
    }

    public Defmodule parseDefmodule(JessTokenStream jessTokenStream) throws JessException {
        if (this.nextToken((JessTokenStream)jessTokenStream).m_ttype != 40 || !this.nextToken((JessTokenStream)jessTokenStream).m_sval.equals("defmodule")) {
            this.error("parseDefmodule", "Expected (defmodule...", 1000, jessTokenStream.getLastToken());
        }
        JessToken jessToken = this.nextToken(jessTokenStream);
        if (jessToken.m_ttype != 4) {
            this.error("parseDefmodule", "Expected module name", 1000, jessToken);
        }
        JessToken jessToken2 = this.nextToken(jessTokenStream);
        if (jessToken2.m_ttype == 3) {
            return new Defmodule(jessToken.m_sval, jessToken2.m_sval);
        }
        if (jessToken2.m_ttype == 41) {
            return new Defmodule(jessToken.m_sval, "");
        }
        this.error("parseDefmodule", "Expected ')'", 1000, jessToken2);
        return null;
    }

    private List parseDefglobal(Rete rete, JessTokenStream jessTokenStream) throws JessException {
        ArrayList<Defglobal> arrayList = new ArrayList<Defglobal>();
        if (this.nextToken((JessTokenStream)jessTokenStream).m_ttype != 40 || !this.nextToken((JessTokenStream)jessTokenStream).m_sval.equals("defglobal")) {
            this.error("parseDefglobal", "Expected (defglobal...", 1000, jessTokenStream.getLastToken());
        }
        block3: while (true) {
            JessToken jessToken = this.nextTokenNoWarnings(jessTokenStream);
            if (jessToken.m_ttype == 41) break;
            if (jessToken.m_ttype != 2) {
                this.error("parseDefglobal", "Expected a variable name", 1000, jessToken);
            }
            if (jessToken.m_sval.charAt(0) != '*' || jessToken.m_sval.charAt(jessToken.m_sval.length() - 1) != '*') {
                this.error("parseDefglobal", "Defglobal names must start and end with an asterisk", 1000, jessToken);
            }
            if (this.nextToken((JessTokenStream)jessTokenStream).m_ttype != 61) {
                this.error("parseDefglobal", "Expected =", new String[]{"="}, 1000, jessTokenStream.getLastToken());
            }
            JessToken jessToken2 = this.nextToken(jessTokenStream);
            switch (jessToken2.m_ttype) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 40: {
                    arrayList.add(new Defglobal(jessToken.m_sval, this.tokenToValue(jessToken2, rete, jessTokenStream)));
                    continue block3;
                }
            }
            this.error("parseDefglobal", "Bad value", 1000, jessTokenStream.getLastToken());
        }
        return arrayList;
    }

    public Funcall parseFuncall(Rete rete, JessTokenStream jessTokenStream) throws JessException {
        return this.parseFuncall(rete, jessTokenStream, false);
    }

    private Funcall parseFuncall(Rete rete, JessTokenStream jessTokenStream, boolean bl) throws JessException {
        Serializable serializable;
        Funcall funcall = null;
        if (this.nextToken((JessTokenStream)jessTokenStream).m_ttype != 40) {
            this.error("parseFuncall", "Expected '('", 1000, jessTokenStream.getLastToken());
        }
        int n2 = jessTokenStream.getLineNumber();
        JessToken jessToken = this.nextToken(jessTokenStream);
        switch (jessToken.m_ttype) {
            case 4: {
                if (Jesp.isAConstructName(jessToken.m_sval)) {
                    this.error("parseFuncall", "Can't use this construct here; function name expected", this.listFunctionNames(rete), 1000, jessToken);
                }
                if (this.m_issueWarnings && rete.findUserfunction(jessToken.m_sval) == null) {
                    if (bl) {
                        this.warning("parseFuncall", "Undefined function or construct", this.listFunctionAndConstructNames(rete), 1003, jessToken);
                    } else {
                        this.warning("parseFuncall", "Undefined function", this.listFunctionNames(rete), 1003, jessToken);
                    }
                }
                funcall = new Funcall(jessToken.m_sval, rete);
                break;
            }
            case 61: {
                funcall = new Funcall("=".intern(), rete);
                break;
            }
            case 2: {
                funcall = new Funcall(JAVACALL, rete);
                funcall.add(new Variable(jessToken.m_sval, 8));
                break;
            }
            case 40: {
                funcall = new Funcall(JAVACALL, rete);
                jessTokenStream.pushBack(jessToken);
                serializable = this.parseFuncall(rete, jessTokenStream);
                funcall.add(new FuncallValue((Funcall)serializable));
                break;
            }
            default: {
                this.error("parseFuncall", "\"" + jessTokenStream.getLastToken().toString() + "\" is not a valid function name", bl ? this.listFunctionAndConstructNames(rete) : this.listFunctionNames(rete), 1000, jessTokenStream.getLastToken());
            }
        }
        String string = funcall.get(0).stringValue(null);
        jessToken = this.nextToken(jessTokenStream);
        while (jessToken.m_ttype != 41) {
            switch (jessToken.m_ttype) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    this.checkFunctionArgument(funcall, string, jessToken);
                }
                case 1: 
                case 2: {
                    funcall.add(this.tokenToValue(jessToken, rete, jessTokenStream));
                    break;
                }
                case 40: {
                    Cloneable cloneable;
                    serializable = this.nextToken(jessTokenStream);
                    if (((JessToken)serializable).m_ttype == 41) {
                        funcall.add(Funcall.NILLIST);
                        if (!this.m_issueWarnings) break;
                        this.warning("parseFuncall", "Could be nested function call", this.listFunctionNames(rete), 2001, (JessToken)serializable);
                        break;
                    }
                    jessTokenStream.pushBack((JessToken)serializable);
                    jessTokenStream.pushBack(jessToken);
                    if (string.equals("assert")) {
                        cloneable = this.parseFact(rete, jessTokenStream);
                        funcall.add(new FactIDValue((Fact)cloneable));
                        break;
                    }
                    if ((string.equals("modify") || string.equals("duplicate")) && funcall.size() > 1) {
                        cloneable = this.parseValuePair(null, rete, true, jessTokenStream);
                        funcall.add(new Value((ValueVector)cloneable, 512));
                        break;
                    }
                    if (string.equals("lambda") && funcall.size() == 1) {
                        cloneable = this.parseArgumentList(jessTokenStream);
                        ValueVector valueVector = new ValueVector();
                        Iterator iterator = cloneable.iterator();
                        while (iterator.hasNext()) {
                            Deffunction.Argument argument = (Deffunction.Argument)iterator.next();
                            valueVector.add(new Variable(argument.getName(), argument.getType()));
                        }
                        funcall.add(new Value(valueVector, 512));
                        break;
                    }
                    cloneable = this.parseFuncall(rete, jessTokenStream);
                    funcall.add(new FuncallValue((Funcall)cloneable));
                    break;
                }
                case 0: {
                    this.error("parseFuncall", "Unexpected EOF", 1000, jessToken);
                    break;
                }
                default: {
                    funcall.add(new Value(String.valueOf((char)jessToken.m_ttype), 2));
                }
            }
            jessToken = this.nextToken(jessTokenStream);
        }
        if (rete.isDebug()) {
            Rete.recordFunction(funcall, this.m_fileName, n2);
        }
        return funcall;
    }

    private void checkFunctionArgument(Funcall funcall, String string, JessToken jessToken) {
        ArgumentChecker argumentChecker = (ArgumentChecker)this.m_checkers.get(string);
        if (argumentChecker != null) {
            argumentChecker.check(funcall, jessToken, this);
        }
    }

    private ValueVector parseValuePair(String[] stringArray, Rete rete, boolean bl, JessTokenStream jessTokenStream) throws JessException {
        ValueVector valueVector = new ValueVector(2);
        if (stringArray != null) {
            Arrays.sort(stringArray);
        }
        JessToken jessToken = this.nextToken(jessTokenStream);
        if (jessToken.m_ttype != 40) {
            this.error("parseValuePair", "Expected '('", OPEN_PAREN, 1000, jessToken);
        }
        jessToken = this.nextToken(jessTokenStream);
        if (!bl && jessToken.m_ttype != 4) {
            this.error("parseValuePair", "Expected '<atom>'", stringArray, 1000, jessToken);
        }
        if (stringArray != null && !jessToken.isVariable() && Arrays.binarySearch(stringArray, jessToken.m_sval) < 0) {
            this.error("parseValuePair", "Bad value", stringArray, 1000, jessToken);
        }
        valueVector.add(this.tokenToValue(jessToken, rete, jessTokenStream));
        do {
            jessToken = this.nextToken(jessTokenStream);
            switch (jessToken.m_ttype) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 40: {
                    valueVector.add(this.tokenToValue(jessToken, rete, jessTokenStream));
                    break;
                }
                case 41: {
                    break;
                }
                default: {
                    this.error("parseValuePair", "Bad argument", 1000, jessToken);
                }
            }
        } while (jessToken.m_ttype != 41);
        return valueVector;
    }

    public Deffacts parseDeffacts(Rete rete, JessTokenStream jessTokenStream) throws JessException {
        JessToken jessToken;
        block7: {
            block6: {
                if (this.nextToken((JessTokenStream)jessTokenStream).m_ttype != 40) break block6;
                jessToken = this.nextToken(jessTokenStream);
                if (jessToken.m_ttype == 4 && jessToken.m_sval.equals("deffacts")) break block7;
            }
            this.error("parseDeffacts", "Expected '( deffacts'", 1000, jessTokenStream.getLastToken());
        }
        jessToken = this.nextToken(jessTokenStream);
        if (jessToken.m_ttype != 4) {
            this.error("parseDeffacts", "Expected deffacts name", 1000, jessToken);
        }
        String string = jessToken.m_sval;
        jessToken = this.nextToken(jessTokenStream);
        String string2 = "";
        if (jessToken.m_ttype == 3) {
            string2 = jessToken.m_sval;
            jessToken = this.nextToken(jessTokenStream);
        }
        Deffacts deffacts = new Deffacts(string, string2, rete);
        rete.setCurrentModule(deffacts.getModule());
        while (jessToken.m_ttype == 40) {
            jessTokenStream.pushBack(jessToken);
            Fact fact = this.parseFact(rete, jessTokenStream);
            deffacts.addFact(fact);
            jessToken = this.nextToken(jessTokenStream);
        }
        this.expectCloseParen(jessToken, "parseDeffacts");
        return deffacts;
    }

    Fact parseFact(Rete rete, JessTokenStream jessTokenStream) throws JessException {
        boolean bl;
        String string = "__data";
        JessToken jessToken = null;
        if (this.nextToken((JessTokenStream)jessTokenStream).m_ttype != 40) {
            this.error("parseFact", "Expected '('", OPEN_PAREN, 1000, jessToken);
        }
        jessToken = this.nextToken(jessTokenStream);
        if (jessToken.m_ttype != 4) {
            this.error("parseFact", "Expected template name", this.listTemplateNames(rete), 1000, jessToken);
        }
        String string2 = jessToken.m_sval;
        if (this.m_issueWarnings && rete.findDeftemplate(string2) == null) {
            this.warning("parseFact", "Creating implied deftemplate", this.listTemplateNames(rete), 1002, jessToken);
        }
        Deftemplate deftemplate = rete.createDeftemplate(string2);
        Fact fact = new Fact(string2, rete);
        jessToken = this.nextToken(jessTokenStream);
        boolean bl2 = bl = !deftemplate.isOrdered();
        while (jessToken.m_ttype != 41) {
            JessToken jessToken2 = null;
            if (!deftemplate.isOrdered()) {
                this.expectOpenParen(jessToken, "parseFact");
                jessToken2 = this.nextToken(jessTokenStream);
                if (jessToken2.m_ttype != 4) {
                    this.error("parseFact", "Bad slot name", deftemplate.getSlotNames(), 1000, jessToken2);
                }
                string = jessToken2.m_sval;
                jessToken = this.nextToken(jessTokenStream);
            } else if (jessToken.m_ttype == 40) {
                JessToken jessToken3 = this.nextToken(jessTokenStream);
                if ("__data".equals(jessToken3.m_sval)) {
                    bl = true;
                    jessToken2 = jessToken3;
                    string = "__data";
                    jessToken = this.nextToken(jessTokenStream);
                } else {
                    jessTokenStream.pushBack(jessToken3);
                }
            }
            int n2 = deftemplate.getSlotIndex(string);
            if (n2 == -1) {
                this.error("parseFact", "No such slot " + string + " in template " + deftemplate.getName(), deftemplate.getSlotNames(), 1006, jessToken2);
            }
            int n3 = deftemplate.getSlotType(n2);
            switch (n3) {
                case 16384: {
                    Serializable serializable;
                    Serializable serializable2;
                    switch (jessToken.m_ttype) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 9: {
                            fact.setSlotValue(string, this.tokenToValue(jessToken, rete, jessTokenStream));
                            break;
                        }
                        case 61: {
                            serializable2 = jessToken;
                            jessToken = this.nextToken(jessTokenStream);
                            if (jessToken.m_ttype != 40) {
                                this.error("parseFact", "'=' cannot appear as an atom within a fact", 1000, (JessToken)serializable2);
                            }
                        }
                        case 40: {
                            jessTokenStream.pushBack(jessToken);
                            serializable = this.parseFuncall(rete, jessTokenStream);
                            fact.setSlotValue(string, new FuncallValue((Funcall)serializable));
                            break;
                        }
                        default: {
                            this.error("parseFact", "Bad slot value", 1000, jessToken);
                        }
                    }
                    jessToken = this.expectCloseParen(jessTokenStream, "parseFact");
                    break;
                }
                case 32768: {
                    Serializable serializable;
                    Serializable serializable2 = new ValueVector();
                    while (jessToken.m_ttype != 41) {
                        switch (jessToken.m_ttype) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 9: {
                                ((ValueVector)serializable2).add(this.tokenToValue(jessToken, rete, jessTokenStream));
                                break;
                            }
                            case 61: {
                                serializable = jessToken;
                                jessToken = this.nextToken(jessTokenStream);
                                if (jessToken.m_ttype != 40) {
                                    this.error("parseFact", "'=' cannot appear as an atom within a fact", 1000, (JessToken)serializable);
                                }
                            }
                            case 40: {
                                jessTokenStream.pushBack(jessToken);
                                Funcall funcall = this.parseFuncall(rete, jessTokenStream);
                                ((ValueVector)serializable2).add(new FuncallValue(funcall));
                                break;
                            }
                            default: {
                                this.error("parseFact", "Bad slot value", 1000, jessToken);
                            }
                        }
                        jessToken = this.nextToken(jessTokenStream);
                    }
                    fact.setSlotValue(string, new Value((ValueVector)serializable2, 512));
                    break;
                }
                default: {
                    this.error("parseFact", "No such slot in deftemplate", 1006, jessToken2);
                }
            }
            if (!bl) break;
            jessToken = this.nextToken(jessTokenStream);
        }
        this.expectCloseParen(jessToken, "parseFact");
        return fact;
    }

    public Deftemplate parseDeftemplate(Context context, Rete rete, JessTokenStream jessTokenStream) throws JessException {
        Serializable serializable;
        Object object;
        Deftemplate deftemplate;
        if (this.nextToken((JessTokenStream)jessTokenStream).m_ttype != 40 || !this.nextToken((JessTokenStream)jessTokenStream).m_sval.equals("deftemplate")) {
            this.error("parseDeftemplate", "Expected (deftemplate...", 1000, jessTokenStream.getLastToken());
        }
        JessToken jessToken = this.nextToken(jessTokenStream);
        if (jessToken.m_ttype != 4) {
            this.error("parseDeftemplate", "Expected deftemplate name", 1000, jessToken);
        }
        String string = jessToken.m_sval;
        String string2 = "";
        String string3 = null;
        JessToken jessToken2 = null;
        jessToken = this.nextToken(jessTokenStream);
        if (jessToken.m_ttype == 4) {
            if (jessToken.m_sval.equals("extends")) {
                jessToken2 = this.nextToken(jessTokenStream);
                if (jessToken2.m_ttype == 4) {
                    string3 = jessToken2.m_sval;
                } else {
                    this.error("parseDeftemplate", "Expected deftemplate name to extend", this.listTemplateNames(rete), 1000, jessToken2);
                }
            } else {
                this.error("parseDeftemplate", "Expected '(' or 'extends'", new String[]{"(", "extends"}, 1000, jessToken);
            }
            jessToken = this.nextToken(jessTokenStream);
        }
        if (jessToken.m_ttype == 3) {
            string2 = jessToken.m_sval;
        } else {
            jessTokenStream.pushBack(jessToken);
        }
        HashMap hashMap = new HashMap();
        Map map = this.parseDeclarations(hashMap, DEFTEMPLATE_DECLARABLES, rete, jessTokenStream);
        boolean bl = map.size() > 0;
        String string4 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        jessToken = this.nextToken(jessTokenStream);
        if (string3 == null) {
            deftemplate = new Deftemplate(string, string2, rete);
        } else {
            Deftemplate deftemplate2 = rete.findDeftemplate(string3);
            if (deftemplate2 == null) {
                this.error("parseDeftemplate", "Parent template is undefined", this.listTemplateNames(rete), 1000, jessToken2);
            }
            deftemplate = new Deftemplate(string, string2, rete.findDeftemplate(string3), rete);
        }
        boolean bl5 = false;
        Object object2 = hashMap.keySet().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            serializable = (ValueVector)hashMap.get(object);
            if (object.equals(SLOT_SPECIFIC)) {
                if (((ValueVector)serializable).get(1).equals(Funcall.FALSE)) continue;
                bl3 = true;
                continue;
            }
            if (object.equals(BACKCHAIN_REACTIVE)) {
                if (((ValueVector)serializable).get(1).equals(Funcall.FALSE)) continue;
                bl2 = true;
                continue;
            }
            if (object.equals(INCLUDE_VARIABLES)) {
                if (((ValueVector)serializable).get(1).equals(Funcall.FALSE)) continue;
                bl4 = true;
                if (hashMap.get(FROM_CLASS) != null) continue;
                throw new ParseException("parseDeftemplate", "include-variables requires from-class", (JessToken)map.get(INCLUDE_VARIABLES));
            }
            if (object.equals(FROM_CLASS)) {
                string4 = ((ValueVector)serializable).get(1).symbolValue(context);
                continue;
            }
            if (object.equals(ORDERED)) {
                if (!((ValueVector)serializable).get(1).equals(Funcall.TRUE)) continue;
                bl5 = true;
                if (hashMap.get(FROM_CLASS) != null) {
                    throw new ParseException("parseDeftemplate", "Ordered template can't be generated from class", (JessToken)map.get(FROM_CLASS));
                }
                if (hashMap.get(INCLUDE_VARIABLES) != null) {
                    throw new ParseException("parseDeftemplate", "Ordered template can't include variables", (JessToken)map.get(INCLUDE_VARIABLES));
                }
                if (hashMap.get(SLOT_SPECIFIC) != null) {
                    throw new ParseException("parseDeftemplate", "Ordered template can't be slot-specific", (JessToken)map.get(SLOT_SPECIFIC));
                }
                if (string3 == null) continue;
                throw new JessException("parseDeftemplate", "Ordered templates can't extend other templates", "");
            }
            throw new JessException("parseDeftemplate", "Invalid declarand", (String)object);
        }
        if (bl5) {
            deftemplate.addMultiSlot("__data", Funcall.NILLIST, "ANY");
            if (bl2) {
                deftemplate.doBackwardChaining(rete);
            }
            return deftemplate;
        }
        if (string4 != null) {
            if (jessToken.m_ttype == 40) {
                throw new ParseException("parseDeftemplate", "Templates that use from-class can't declare slots", jessToken);
            }
            if (bl2) {
                throw new JessException("Jesp.parseDeftemplate", "Defclass can't be backchain-reactive", string);
            }
            rete.defclass(string, string4, string3, bl4);
            if (bl3) {
                rete.findDeftemplate(string).setSlotSpecific(true);
            }
            return rete.findDeftemplate(string);
        }
        if (hashMap.containsKey(INCLUDE_VARIABLES)) {
            throw new JessException("Jesp.parseDeftemplate", "include-variables can only be used with from-class", string);
        }
        while (jessToken.m_ttype == 40) {
            jessToken = this.nextToken(jessTokenStream);
            if (jessToken.m_ttype != 4 || !jessToken.m_sval.equals("slot") && !jessToken.m_sval.equals("multislot")) {
                object2 = SLOT_TYPE;
                if (!bl && deftemplate.getNSlots() == 0) {
                    object2 = DECLARE_OR_SLOT_TYPE;
                }
                this.error("parseDeftemplate", "Bad slot type", (String[])object2, 1000, jessToken, deftemplate);
            }
            int n2 = jessToken.m_sval.equals("slot") ? 16384 : 32768;
            jessToken = this.nextToken(jessTokenStream);
            if (jessToken.m_ttype != 4) {
                this.error("parseDeftemplate", "Bad slot name", 1000, jessToken, deftemplate);
            }
            string = jessToken.m_sval;
            Serializable serializable2 = n2 == 16384 ? Funcall.NIL : Funcall.NILLIST;
            String string5 = "ANY";
            jessToken = this.nextToken(jessTokenStream);
            while (jessToken.m_ttype == 40) {
                jessToken = this.nextToken(jessTokenStream);
                if (jessToken.m_ttype != 4) {
                    this.error("parseDeftemplate", "Slot qualifier must be a symbol", SLOT_QUALIFIERS, 1000, jessToken, deftemplate);
                }
                if (((String)(object2 = jessToken.m_sval)).equalsIgnoreCase("default") || ((String)object2).equalsIgnoreCase("default-dynamic")) {
                    object = null;
                    if (n2 == 32768) {
                        object = new ValueVector();
                    }
                    serializable = null;
                    jessToken = this.nextToken(jessTokenStream);
                    while (jessToken.m_ttype != 41) {
                        switch (jessToken.m_ttype) {
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 9: {
                                serializable = this.tokenToValue(jessToken, rete, jessTokenStream);
                                break;
                            }
                            case 40: {
                                if (((String)object2).equalsIgnoreCase("default-dynamic")) {
                                    jessTokenStream.pushBack(jessToken);
                                    Funcall funcall = this.parseFuncall(rete, jessTokenStream);
                                    serializable = new FuncallValue(funcall);
                                    break;
                                }
                                serializable = this.parseAndExecuteFuncall(jessToken, context, rete, jessTokenStream, false);
                                break;
                            }
                            default: {
                                this.error("parseDeftemplate", "Illegal default slot value", 1000, jessToken);
                            }
                        }
                        if (n2 != 32768) break;
                        if (((Value)serializable).type() == 512) {
                            ((ValueVector)object).addAll(((Value)serializable).listValue(rete.getGlobalContext()));
                        } else {
                            ((ValueVector)object).add((Value)serializable);
                        }
                        jessToken = this.nextToken(jessTokenStream);
                    }
                    serializable2 = n2 == 32768 ? new Value((ValueVector)object, 512) : serializable;
                    if (jessToken.m_ttype == 41) {
                        jessTokenStream.pushBack(jessToken);
                    }
                } else if (((String)object2).equalsIgnoreCase("type")) {
                    jessToken = this.nextToken(jessTokenStream);
                    string5 = jessToken.m_sval;
                    if (jessToken.m_ttype != 4 || !Deftemplate.isValidSlotType(string5)) {
                        this.error("parseDeftemplate", "Invalid slot type", Deftemplate.TYPE_NAMES, 1000, jessToken, deftemplate);
                    }
                } else {
                    this.error("parseDeftemplate", "Unimplemented slot qualifier", SLOT_QUALIFIERS, 1000, jessToken, deftemplate);
                }
                this.expectCloseParen(jessTokenStream, "parseDeftemplate");
                jessToken = this.nextToken(jessTokenStream);
            }
            this.expectCloseParen(jessToken, "parseDeftemplate");
            if (n2 == 16384) {
                deftemplate.addSlot(string, (Value)serializable2, string5);
            } else {
                if (serializable2.type() != 512) {
                    this.error("parseDeftemplate", "Default value for multislot " + string + " is not a multifield: " + serializable2, 1000, jessToken, deftemplate);
                }
                deftemplate.addMultiSlot(string, (Value)serializable2, string5);
            }
            jessToken = this.nextToken(jessTokenStream);
        }
        this.expectCloseParen(jessToken, "parseDeftemplate");
        if (bl2) {
            deftemplate.doBackwardChaining(rete);
        }
        if (bl3) {
            deftemplate.setSlotSpecific(true);
        }
        return deftemplate;
    }

    public Defrule parseDefrule(Context context, Rete rete, JessTokenStream jessTokenStream) throws JessException {
        Group group;
        HashMap hashMap;
        String[] stringArray;
        block10: {
            JessToken jessToken;
            block9: {
                stringArray = this.parseNameAndDocstring("defrule", jessTokenStream);
                hashMap = new HashMap();
                this.parseDeclarations(hashMap, RULE_DECLARABLES, rete, jessTokenStream);
                String string = RU.getModuleFromName(stringArray[0], rete);
                rete.setCurrentModule(string);
                group = this.parseLHS(string, rete, jessTokenStream);
                jessToken = this.nextToken(jessTokenStream);
                if (jessToken.m_ttype != 61) break block9;
                jessToken = this.nextToken(jessTokenStream);
                if (jessToken.m_ttype == 4 && jessToken.m_sval.equals(">")) break block10;
            }
            this.error("parseDefrule", "Expected '=>'", RIGHT_ARROW, 1000, jessToken);
        }
        ArrayList arrayList = this.parseActions(rete, jessTokenStream);
        this.expect(41, ")", jessTokenStream);
        Defrule defrule = new Defrule(stringArray[0], stringArray[1], rete);
        defrule.setLHS(group, rete);
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Object k2 = iterator.next();
            ValueVector valueVector = (ValueVector)hashMap.get(k2);
            if (k2.equals("salience")) {
                defrule.setSalience(valueVector.get(1), rete);
                continue;
            }
            if (k2.equals("node-index-hash")) {
                defrule.setNodeIndexHash(valueVector.get(1).intValue(context));
                continue;
            }
            if (k2.equals("auto-focus")) {
                string = valueVector.get(1).symbolValue(context);
                defrule.setAutoFocus(!Funcall.FALSE.equals(string));
                continue;
            }
            if (k2.equals("no-loop")) {
                string = valueVector.get(1).symbolValue(context);
                defrule.setNoLoop(!Funcall.FALSE.equals(string));
                continue;
            }
            throw new JessException("parseDefrule", "Invalid declarand", (String)k2);
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            defrule.addAction((Funcall)arrayList.get(i2));
        }
        return defrule;
    }

    private String[] parseNameAndDocstring(String string, JessTokenStream jessTokenStream) throws JessException {
        if (this.nextToken((JessTokenStream)jessTokenStream).m_ttype != 40 || !this.nextToken((JessTokenStream)jessTokenStream).m_sval.equals(string)) {
            this.error("parseNameAndDocstring", "Expected " + string, 1000, jessTokenStream.getLastToken());
        }
        JessToken jessToken = this.nextToken(jessTokenStream);
        if (jessToken.m_ttype != 4) {
            this.error("parseNameAndDocstring", "Expected defrule name", 1000, jessToken);
        }
        String string2 = jessToken.m_sval;
        String string3 = "";
        jessToken = this.nextToken(jessTokenStream);
        if (jessToken.m_ttype == 3) {
            string3 = jessToken.m_sval;
        } else {
            jessTokenStream.pushBack(jessToken);
        }
        return new String[]{string2, string3};
    }

    private Map parseDeclarations(HashMap hashMap, String[] stringArray, Rete rete, JessTokenStream jessTokenStream) throws JessException {
        HashMap<String, JessToken> hashMap2 = new HashMap<String, JessToken>();
        JessToken jessToken = this.nextToken(jessTokenStream);
        if (jessToken.m_ttype != 40) {
            jessTokenStream.pushBack(jessToken);
            return hashMap2;
        }
        JessToken jessToken2 = this.nextToken(jessTokenStream);
        if (jessToken2.m_ttype == 4 && jessToken2.m_sval.equals("declare")) {
            while (true) {
                jessToken2 = this.nextToken(jessTokenStream);
                if (jessToken2.m_ttype == 41) break;
                JessToken jessToken3 = jessTokenStream.nextToken();
                jessTokenStream.pushBack(jessToken3);
                jessTokenStream.pushBack(jessToken2);
                ValueVector valueVector = this.parseValuePair(stringArray, rete, false, jessTokenStream);
                String string = valueVector.get(0).symbolValue(null);
                hashMap.put(string, valueVector);
                hashMap2.put(string, jessToken3);
            }
            return hashMap2;
        }
        jessTokenStream.pushBack(jessToken2);
        jessTokenStream.pushBack(jessToken);
        return hashMap2;
    }

    private ArrayList parseActions(Rete rete, JessTokenStream jessTokenStream) throws JessException {
        JessToken jessToken = this.nextToken(jessTokenStream);
        ArrayList<Funcall> arrayList = new ArrayList<Funcall>();
        while (jessToken.m_ttype == 40) {
            jessTokenStream.pushBack(jessToken);
            Funcall funcall = this.parseFuncall(rete, jessTokenStream);
            arrayList.add(funcall);
            jessToken = this.nextToken(jessTokenStream);
        }
        jessTokenStream.pushBack(jessToken);
        return arrayList;
    }

    private Group parseLHS(String string, Rete rete, JessTokenStream jessTokenStream) throws JessException {
        HashMap hashMap = new HashMap();
        Group group = new Group("and");
        JessToken jessToken = this.nextToken(jessTokenStream);
        while (jessToken.m_ttype == 40 || jessToken.m_ttype == 2) {
            jessTokenStream.pushBack(jessToken);
            ConditionalElementX conditionalElementX = this.parsePattern(hashMap, string, rete, jessTokenStream);
            group.add(conditionalElementX);
            jessToken = this.nextToken(jessTokenStream);
        }
        jessTokenStream.pushBack(jessToken);
        return group;
    }

    private JessToken expect(int n2, String string, JessTokenStream jessTokenStream) throws JessException {
        JessToken jessToken = this.nextToken(jessTokenStream);
        if (jessToken.m_ttype != n2 || !jessToken.m_sval.equals(string)) {
            this.error("parseLHS", "Expected '" + string + "'", new String[]{string}, 1000, jessToken);
        }
        return jessToken;
    }

    ConditionalElementX parsePattern(Map map, String string, Rete rete, JessTokenStream jessTokenStream) throws JessException {
        String string2 = null;
        JessToken jessToken = this.nextToken(jessTokenStream);
        JessToken jessToken2 = null;
        if (jessToken.m_ttype == 2) {
            string2 = jessToken.m_sval;
            jessToken2 = jessToken;
            this.expect(4, "<-", jessTokenStream);
            jessToken = this.nextToken(jessTokenStream);
        }
        this.expectOpenParen(jessToken, "parsePattern");
        JessToken jessToken3 = jessToken;
        jessToken = this.nextToken(jessTokenStream);
        if (jessToken.m_ttype != 4) {
            this.error("parsePattern", "Expected template name", this.listTemplateNames(rete), 1000, jessToken);
        }
        JessToken jessToken4 = jessToken;
        String string3 = jessToken.m_sval;
        if (string3.equals("exists")) {
            Group group = new Group("not");
            while (true) {
                jessToken = this.nextToken(jessTokenStream);
                if (jessToken.m_ttype == 41) break;
                jessTokenStream.pushBack(jessToken);
                group.add(this.parsePattern(map, string, rete, jessTokenStream));
            }
            if (group.getGroupSize() == 0) {
                this.error("parsePattern", "expected pattern", OPEN_PAREN, 1000, jessToken);
            }
            Group group2 = new Group("not");
            group2.add(group);
            if (string2 != null) {
                group2.setBoundName(string2);
            }
            return group2;
        }
        if (string3.equals("forall")) {
            Group group = new Group("not");
            Group group3 = new Group("and");
            Group group4 = new Group("not");
            Group group5 = new Group("and");
            group3.add(this.parsePattern(map, string, rete, jessTokenStream));
            while (true) {
                jessToken = this.nextToken(jessTokenStream);
                if (jessToken.m_ttype == 41) break;
                jessTokenStream.pushBack(jessToken);
                group5.add(this.parsePattern(map, string, rete, jessTokenStream));
            }
            group4.add(group5);
            group3.add(group4);
            group.add(group3);
            if (string2 != null) {
                group.setBoundName(string2);
            }
            return group;
        }
        if (string3.equals("unique")) {
            ConditionalElementX conditionalElementX = this.parsePattern(map, string, rete, jessTokenStream);
            this.expectCloseParen(jessTokenStream, "parsePattern");
            if (string2 != null) {
                conditionalElementX.setBoundName(string2);
            }
            return conditionalElementX;
        }
        if (string3.equals("accumulate")) {
            Accumulate accumulate = new Accumulate();
            accumulate.setInitializer(this.tokenToValue(this.nextToken(jessTokenStream), rete, jessTokenStream));
            accumulate.setBody(this.tokenToValue(this.nextToken(jessTokenStream), rete, jessTokenStream));
            accumulate.setReturn(this.tokenToValue(this.nextToken(jessTokenStream), rete, jessTokenStream));
            ConditionalElementX conditionalElementX = this.parsePattern(map, string, rete, jessTokenStream);
            this.expectCloseParen(jessTokenStream, "parsePattern");
            if (string2 != null) {
                accumulate.setBoundName(string2);
            }
            accumulate.add(conditionalElementX);
            return accumulate;
        }
        if (Group.isGroupName(string3)) {
            Group group = new Group(string3);
            while (true) {
                jessToken = this.nextToken(jessTokenStream);
                if (jessToken.m_ttype == 41) break;
                jessTokenStream.pushBack(jessToken);
                group.add(this.parsePattern(map, string, rete, jessTokenStream));
            }
            if (group.getGroupSize() == 0) {
                this.error("parsePattern", "expected pattern", OPEN_PAREN, 1000, jessToken);
            }
            if (string2 != null) {
                group.setBoundName(string2);
            }
            return group;
        }
        if (string3.equals("test")) {
            if (string2 != null) {
                this.error("parsePattern", "Can't bind a 'test' CE to a variable", 1000, jessToken2);
            }
            Pattern pattern = new Pattern(Deftemplate.getTestTemplate());
            Funcall funcall = this.parseFuncall(rete, jessTokenStream);
            pattern.addTest(new Test1(0, "__data", new FuncallValue(funcall)));
            this.expectCloseParen(jessTokenStream, "parsePattern");
            return pattern;
        }
        jessTokenStream.pushBack(jessToken4);
        jessTokenStream.pushBack(jessToken3);
        Pattern pattern = this.parseRegularPattern(rete, jessTokenStream, map);
        if (string2 != null) {
            pattern.setBoundName(string2);
        }
        return pattern;
    }

    private Pattern parseRegularPattern(Rete rete, JessTokenStream jessTokenStream, Map map) throws JessException {
        this.expectOpenParen(jessTokenStream, "parsePattern");
        JessToken jessToken = this.nextToken(jessTokenStream);
        if (jessToken.m_ttype != 4) {
            this.error("parsePattern", "Expected template name", this.listTemplateNames(rete), 1000, jessToken);
        }
        Deftemplate deftemplate = this.findOrCreateDeftemplate(rete, jessToken.m_sval, jessToken);
        Pattern pattern = new Pattern(deftemplate);
        jessToken = this.nextToken(jessTokenStream);
        if (deftemplate.isOrdered() && jessToken.m_ttype != 40) {
            jessTokenStream.pushBack(jessToken);
            this.parseContentsOfOneSlot(pattern, "__data", jessTokenStream, map, rete);
            return pattern;
        }
        if (!this.isParenthesis(jessToken.m_ttype) && jessToken.m_ttype != 123) {
            this.error("parsePattern", "Expected slot or end of pattern", PARENS, 1000, jessToken);
        }
        while (jessToken.m_ttype != 41) {
            Object object;
            if (jessToken.m_ttype == 40) {
                object = this.checkForValidSlotName(jessTokenStream, deftemplate);
                this.parseContentsOfOneSlot(pattern, (String)object, jessTokenStream, map, rete);
            } else if (jessToken.m_ttype == 123) {
                object = new InfixSlotParser(this);
                ((InfixSlotParser)object).parse(pattern, jessTokenStream, rete);
            } else {
                this.error("parsePattern", "Expected '(' or '{'", new String[]{"(", "{"}, 1000, jessToken);
            }
            jessToken = this.nextToken(jessTokenStream);
            if (this.isParenthesis(jessToken.m_ttype) || jessToken.m_ttype == 123) continue;
            this.error("parsePattern", "Expected ')' , '{', or '('", new String[]{")", "{", "("}, 1000, jessToken);
        }
        return pattern;
    }

    private boolean isParenthesis(int n2) {
        return n2 == 40 || n2 == 41;
    }

    private Deftemplate findOrCreateDeftemplate(Rete rete, String string, JessToken jessToken) throws JessException {
        boolean bl;
        Deftemplate deftemplate = rete.findDeftemplate(string);
        boolean bl2 = bl = deftemplate != null;
        if (deftemplate == null) {
            if (this.m_issueWarnings && !bl) {
                this.warning("Jesp.parsePattern", "Created implied ordered template", this.listTemplateNames(rete), 1002, jessToken);
            }
            deftemplate = rete.createDeftemplate(string);
        }
        return deftemplate;
    }

    String checkForValidSlotName(JessTokenStream jessTokenStream, Deftemplate deftemplate) throws JessException {
        String string;
        int n2;
        JessToken jessToken = this.nextToken(jessTokenStream);
        if (jessToken.m_ttype != 4) {
            this.error("parsePattern", "Bad slot name", deftemplate.getSlotNames(), 1000, jessToken);
        }
        if ((n2 = deftemplate.getSlotIndex(string = jessToken.m_sval)) == -1) {
            this.error("parsePattern", "No such slot " + string + " in template " + deftemplate.getName(), deftemplate.getSlotNames(), 1006, jessToken);
        }
        return string;
    }

    private void parseContentsOfOneSlot(Pattern pattern, String string, JessTokenStream jessTokenStream, Map map, Rete rete) throws JessException {
        int n2;
        Deftemplate deftemplate = pattern.getDeftemplate();
        int n3 = deftemplate.isMultislot(n2 = deftemplate.getSlotIndex(string)) ? 0 : -1;
        int n4 = 0;
        JessToken jessToken = this.nextToken(jessTokenStream);
        while (jessToken.m_ttype != 41) {
            Test1[] test1Array = this.parseASingleTest(jessTokenStream, map, n3, rete, pattern, string);
            jessToken = this.nextToken(jessTokenStream);
            for (int i2 = 0; i2 < test1Array.length; ++i2) {
                Test1 test1 = test1Array[i2];
                if (i2 == 0) {
                    test1.m_conjunction = n4;
                }
                pattern.addTest(test1);
            }
            if (jessToken.m_ttype == 38) {
                jessToken = this.nextToken(jessTokenStream);
                n4 = 1;
                continue;
            }
            if (jessToken.m_ttype == 124) {
                jessToken = this.nextToken(jessTokenStream);
                n4 = 2;
                continue;
            }
            if (!deftemplate.isMultislot(n2) && jessToken.m_ttype != 41) {
                this.error("parsePattern", string + " is not a multislot", 1000, jessToken);
                continue;
            }
            ++n3;
            n4 = 0;
        }
        if (deftemplate.isMultislot(n2)) {
            pattern.setSlotLength(string, n3);
        }
    }

    private Test1[] parseASingleTest(JessTokenStream jessTokenStream, Map map, int n2, Rete rete, Pattern pattern, String string) throws JessException {
        JessToken jessToken = jessTokenStream.getLastToken();
        boolean bl = false;
        if (jessToken.m_ttype == 126) {
            bl = true;
            jessToken = this.nextToken(jessTokenStream);
        }
        switch (jessToken.m_ttype) {
            case 1: 
            case 2: {
                return this.testForVariable(map, jessToken, bl, string, n2, rete, jessTokenStream);
            }
            case 4: {
                if (jessToken.m_sval.equals(":")) {
                    return this.testForPredicateConstraint(rete, jessTokenStream, bl, string, n2);
                }
                return this.testForLiteral(bl, n2, jessToken, string, rete, jessTokenStream);
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                return this.testForLiteral(bl, n2, jessToken, string, rete, jessTokenStream);
            }
            case 61: {
                return this.testForReturnValueConstraint(rete, jessTokenStream, pattern, string, n2, bl);
            }
            case 8: {
                return this.testForRegexp(pattern, string, n2, jessToken, rete, jessTokenStream, bl);
            }
        }
        this.error("parsePattern", "Bad slot value", 1000, jessToken);
        return null;
    }

    private Test1[] testForPredicateConstraint(Rete rete, JessTokenStream jessTokenStream, boolean bl, String string, int n2) throws JessException {
        Funcall funcall = this.parseFuncall(rete, jessTokenStream);
        Test1 test1 = new Test1(this.testFor(bl), string, n2, new FuncallValue(funcall));
        return new Test1[]{test1};
    }

    private Test1[] testForLiteral(boolean bl, int n2, JessToken jessToken, String string, Rete rete, JessTokenStream jessTokenStream) throws JessException {
        Test1 test1 = new Test1(this.testFor(bl), string, n2, this.tokenToValue(jessToken, rete, jessTokenStream));
        return new Test1[]{test1};
    }

    private Test1[] testForRegexp(Pattern pattern, String string, int n2, JessToken jessToken, Rete rete, JessTokenStream jessTokenStream, boolean bl) throws JessException {
        ArrayList<Test1> arrayList = new ArrayList<Test1>();
        int n3 = pattern.getDeftemplate().getSlotIndex(string);
        Value value = this.findAnyExistingVariable(pattern, n3, n2);
        if (value == null) {
            value = new Variable(RU.gensym("__jesp"), 8);
            arrayList.add(new Test1(0, string, n2, value));
        }
        Funcall funcall = new Funcall("regexp", this.m_engine);
        funcall.arg(new Value(jessToken.m_sval, 2));
        funcall.arg(value);
        if (rete.isDebug()) {
            Rete.recordFunction(funcall, this.m_fileName, jessTokenStream.getLineNumber());
        }
        arrayList.add(new Test1(this.testFor(bl), string, n2, new FuncallValue(funcall)));
        return arrayList.toArray(new Test1[arrayList.size()]);
    }

    Value findAnyExistingVariable(Pattern pattern, int n2, int n3) {
        Value value;
        Test1 test1;
        Value value2 = null;
        if (pattern.getNTests(n2) > 0 && (test1 = pattern.getTest(n2, 0)).getTest() == 0 && (value = test1.getValue()).type() == 8 && test1.m_subIdx == n3) {
            value2 = value;
        }
        return value2;
    }

    private Test1[] testForReturnValueConstraint(Rete rete, JessTokenStream jessTokenStream, Pattern pattern, String string, int n2, boolean bl) throws JessException {
        ArrayList<Test1> arrayList = new ArrayList<Test1>();
        Funcall funcall = this.parseFuncall(rete, jessTokenStream);
        Funcall funcall2 = new Funcall("eq*", rete);
        int n3 = pattern.getDeftemplate().getSlotIndex(string);
        Value value = this.findAnyExistingVariable(pattern, n3, n2);
        if (value == null) {
            value = new Variable(RU.gensym("__jesp"), 8);
            arrayList.add(new Test1(0, string, n2, value));
        }
        funcall2.add(value);
        funcall2.add(new FuncallValue(funcall));
        if (rete.isDebug()) {
            Rete.recordFunction(funcall2, this.m_fileName, jessTokenStream.getLineNumber());
        }
        arrayList.add(new Test1(this.testFor(bl), string, n2, new FuncallValue(funcall2)));
        return arrayList.toArray(new Test1[arrayList.size()]);
    }

    private Test1[] testForVariable(Map map, JessToken jessToken, boolean bl, String string, int n2, Rete rete, JessTokenStream jessTokenStream) throws JessException {
        Integer n3 = (Integer)map.get(jessToken.m_sval);
        if (n3 == null) {
            map.put(jessToken.m_sval, new Integer(jessToken.m_ttype));
        } else {
            jessToken.m_ttype = n3;
        }
        Test1 test1 = new Test1(this.testFor(bl), string, n2, this.tokenToValue(jessToken, rete, jessTokenStream));
        return new Test1[]{test1};
    }

    private int testFor(boolean bl) {
        return bl ? 1 : 0;
    }

    private String[] listTemplateNames(Rete rete) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = rete.getCurrentModule() + "::";
        Object[] objectArray = rete.listDeftemplates();
        while (objectArray.hasNext()) {
            String string2 = ((Deftemplate)objectArray.next()).getName();
            if (string2.startsWith("MAIN::__")) continue;
            if (string2.startsWith(string)) {
                string2 = string2.substring(string.length());
            }
            arrayList.add(string2);
        }
        objectArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private String[] listFunctionNames(Rete rete) {
        return ListFunctions.listAllFunctions(rete);
    }

    private String[] listFunctionAndConstructNames(Rete rete) {
        List<String> list = Arrays.asList(ListFunctions.listAllFunctions(rete));
        List<String> list2 = Arrays.asList(CONSTRUCT_NAMES);
        TreeSet<String> treeSet = new TreeSet<String>(list);
        treeSet.addAll(list2);
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public synchronized Defquery parseDefquery(Context context, Rete rete, JessTokenStream jessTokenStream) throws JessException {
        String[] stringArray = this.parseNameAndDocstring("defquery", jessTokenStream);
        HashMap hashMap = new HashMap();
        this.parseDeclarations(hashMap, QUERY_DECLARABLES, rete, jessTokenStream);
        String string = RU.getModuleFromName(stringArray[0], rete);
        rete.setCurrentModule(string);
        Group group = this.parseLHS(string, rete, jessTokenStream);
        JessToken jessToken = this.nextToken(jessTokenStream);
        Defquery defquery = new Defquery(stringArray[0], stringArray[1], rete);
        if (jessToken.m_ttype != 41) {
            this.error("parseDefquery", "Expected ')', got " + jessToken.toString(), CLOSE_PAREN, 1000, jessToken, defquery);
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            ValueVector valueVector = (ValueVector)hashMap.get(k2);
            if (k2.equals("variables")) {
                for (int i2 = 1; i2 < valueVector.size(); ++i2) {
                    Value value = valueVector.get(i2);
                    if (value.type() != 8) {
                        this.error("parseDefquery", "Expected variable, got " + value.toString(), new String[]{value.toString()}, 1000, jessToken, defquery);
                    }
                    defquery.addQueryVariable((Variable)value);
                }
                continue;
            }
            if (k2.equals("node-index-hash")) {
                defquery.setNodeIndexHash(valueVector.get(1).intValue(context));
                continue;
            }
            if (k2.equals("max-background-rules")) {
                defquery.setMaxBackgroundRules(valueVector.get(1).intValue(context));
                continue;
            }
            throw new JessException("parseDefquery", "Invalid declarand", (String)k2);
        }
        defquery.setLHS(group, rete);
        return defquery;
    }

    public Deffunction parseDeffunction(Rete rete, JessTokenStream jessTokenStream) throws JessException {
        String string;
        if (this.nextToken((JessTokenStream)jessTokenStream).m_ttype != 40 || !this.nextToken((JessTokenStream)jessTokenStream).m_sval.equals("deffunction")) {
            this.error("parseDeffunction", "Expected (deffunction...", 1000, jessTokenStream.getLastToken());
        }
        JessToken jessToken = this.nextToken(jessTokenStream);
        if (jessToken.m_ttype != 4) {
            this.error("parseDeffunction", "Expected deffunction name", 1000, jessTokenStream.getLastToken());
        }
        boolean bl = rete.findUserfunction(string = jessToken.m_sval) != null;
        String string2 = "";
        jessToken = this.nextToken(jessTokenStream);
        if (jessToken.m_ttype == 3) {
            string2 = jessToken.m_sval;
            jessToken = this.nextToken(jessTokenStream);
        }
        Deffunction deffunction = new Deffunction(string, string2);
        jessTokenStream.pushBack(jessToken);
        ArrayList arrayList = this.parseArgumentList(jessTokenStream);
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            Deffunction.Argument argument = (Deffunction.Argument)object.next();
            deffunction.addArgument(argument);
        }
        jessToken = this.nextToken(jessTokenStream);
        if (jessToken.m_ttype == 3) {
            deffunction.setDocstring(jessToken.m_sval);
            jessToken = this.nextToken(jessTokenStream);
        }
        if (!bl) {
            this.addDummyFunctionSoRecursiveCallsParse(rete, string);
        }
        while (jessToken.m_ttype != 41) {
            if (jessToken.m_ttype == 40) {
                jessTokenStream.pushBack(jessToken);
                object = this.parseFuncall(rete, jessTokenStream);
                deffunction.addAction((Funcall)object);
            } else {
                switch (jessToken.m_ttype) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: {
                        deffunction.addValue(this.tokenToValue(jessToken, rete, jessTokenStream));
                        break;
                    }
                    default: {
                        this.error("parseDeffunction", "Unexpected character", 1000, jessToken, deffunction);
                    }
                }
            }
            jessToken = this.nextToken(jessTokenStream);
        }
        return deffunction;
    }

    private ArrayList parseArgumentList(JessTokenStream jessTokenStream) throws JessException {
        JessToken jessToken;
        this.expectOpenParen(jessTokenStream, "parseArgumentList");
        ArrayList<Deffunction.Argument> arrayList = new ArrayList<Deffunction.Argument>();
        while (true) {
            jessToken = this.nextToken(jessTokenStream);
            if (jessToken.m_ttype != 2 && jessToken.m_ttype != 1) break;
            int n2 = jessToken.m_ttype == 2 ? 8 : 8192;
            arrayList.add(new Deffunction.Argument(jessToken.m_sval, n2));
        }
        this.expectCloseParen(jessToken, "parseArgumentList");
        return arrayList;
    }

    private void addDummyFunctionSoRecursiveCallsParse(Rete rete, String string) {
        rete.addUserfunction(new DummyFunction(string));
    }

    Value parseAndExecuteFuncall(JessToken jessToken, Context context, Rete rete, JessTokenStream jessTokenStream, boolean bl) throws JessException {
        if (jessToken != null) {
            jessTokenStream.pushBack(jessToken);
        }
        Funcall funcall = this.parseFuncall(rete, jessTokenStream, bl);
        jessTokenStream.eatWhitespace();
        return funcall.execute(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JessToken nextTokenNoWarnings(JessTokenStream jessTokenStream) throws JessException {
        boolean bl = this.m_issueWarnings;
        this.m_issueWarnings = false;
        try {
            JessToken jessToken = this.nextToken(jessTokenStream);
            return jessToken;
        }
        finally {
            this.m_issueWarnings = bl;
        }
    }

    JessToken nextToken(JessTokenStream jessTokenStream) throws JessException {
        JessToken jessToken = jessTokenStream.nextNonCommentToken();
        this.warnOnBadTokens(jessToken);
        return jessToken;
    }

    void warnOnBadTokens(JessToken jessToken) {
        if (this.m_issueWarnings && this.isAnUndefinedDefglobal(jessToken)) {
            this.warning("Jesp.nextToken", "Undefined defglobal " + jessToken.m_sval, this.listAllDefglobals(), 1004, jessToken);
        }
    }

    private boolean isAnUndefinedDefglobal(JessToken jessToken) {
        return jessToken.isVariable() && Defglobal.isADefglobalName(jessToken.m_sval) && !this.m_engine.getGlobalContext().isVariableDefined(jessToken.m_sval);
    }

    private String[] listAllDefglobals() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.m_engine.listDefglobals();
        while (iterator.hasNext()) {
            arrayList.add(((Defglobal)iterator.next()).getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    Value tokenToValue(JessToken jessToken, Rete rete, JessTokenStream jessTokenStream) throws JessException {
        switch (jessToken.m_ttype) {
            case 4: {
                return new Value(jessToken.m_sval, 1);
            }
            case 3: {
                return new Value(jessToken.m_sval, 2);
            }
            case 2: {
                return new Variable(jessToken.m_sval, 8);
            }
            case 1: {
                return new Variable(jessToken.m_sval, 8192);
            }
            case 6: {
                return new Value(jessToken.m_nval, 32);
            }
            case 5: {
                return new Value(jessToken.m_nval, 4);
            }
            case 9: {
                return new LongValue(jessToken.m_lval);
            }
            case 40: {
                jessTokenStream.pushBack(jessToken);
                Funcall funcall = this.parseFuncall(rete, jessTokenStream);
                return new FuncallValue(funcall);
            }
        }
        return Funcall.NIL;
    }

    public void error(String string, String string2, int n2, JessToken jessToken) throws JessException {
        ParseException parseException = new ParseException("Jesp." + string, string2, jessToken);
        parseException.setErrorCode(n2);
        throw parseException;
    }

    public void error(String string, String string2, int n2, JessToken jessToken, Named named) throws JessException {
        ParseException parseException = new ParseException("Jesp." + string, string2, jessToken, named);
        parseException.setErrorCode(n2);
        throw parseException;
    }

    public void error(String string, String string2, String[] stringArray, int n2, JessToken jessToken) throws JessException {
        ParseException parseException = new ParseException("Jesp." + string, string2, stringArray, jessToken);
        parseException.setErrorCode(n2);
        throw parseException;
    }

    public void error(String string, String string2, String[] stringArray, int n2, JessToken jessToken, Named named) throws JessException {
        ParseException parseException = new ParseException("Jesp." + string, string2, stringArray, jessToken, named);
        parseException.setErrorCode(n2);
        throw parseException;
    }

    public void warning(String string, String string2, String[] stringArray, int n2, JessToken jessToken) {
        ParseException parseException = new ParseException("Jesp." + string, string2, stringArray, jessToken);
        parseException.setErrorCode(n2);
        parseException.setLineNumber(jessToken.m_lineno);
        this.m_warnings.add(parseException);
    }

    public static boolean isAConstructName(String string) {
        if (string.startsWith("def")) {
            for (int i2 = 0; i2 < CONSTRUCT_NAMES.length; ++i2) {
                if (!string.equals(CONSTRUCT_NAMES[i2])) continue;
                return true;
            }
        }
        return false;
    }

    private JessToken expectCloseParen(JessTokenStream jessTokenStream, String string) throws JessException {
        return this.expectCloseParen(this.nextToken(jessTokenStream), string);
    }

    private JessToken expectCloseParen(JessToken jessToken, String string) throws JessException {
        if (jessToken.m_ttype != 41) {
            this.error(string, "Expected ')'", CLOSE_PAREN, 1000, jessToken);
        }
        return jessToken;
    }

    private JessToken expectOpenParen(JessTokenStream jessTokenStream, String string) throws JessException {
        return this.expectOpenParen(this.nextToken(jessTokenStream), string);
    }

    private JessToken expectOpenParen(JessToken jessToken, String string) throws JessException {
        if (jessToken.m_ttype != 40) {
            this.error(string, "Expected '('", CLOSE_PAREN, 1000, jessToken);
        }
        return jessToken;
    }

    static {
        Arrays.sort(CONSTRUCT_NAMES);
    }

    private static class DummyFunction
    implements Userfunction {
        private String m_name;

        public DummyFunction(String string) {
            this.m_name = string;
        }

        public String getName() {
            return this.m_name;
        }

        public Value call(ValueVector valueVector, Context context) throws JessException {
            return Funcall.NIL;
        }
    }
}

