/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.Rete;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Help
implements Userfunction,
Serializable {
    private static Map s_helpMap;
    private static Pattern m_pattern;
    static /* synthetic */ Class class$jess$Help;

    public String getName() {
        return "help";
    }

    private static synchronized void fillHelpMap() throws JessException {
        if (s_helpMap == null) {
            s_helpMap = new HashMap();
            Help.addHelpFile("/xmlsrc/functions.xml", "functiondef");
            Help.addHelpFile("/xmlsrc/constructs.xml", "constructdef");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addHelpFile(String string, String string2) throws JessException {
        InputStream inputStream = (class$jess$Help == null ? (class$jess$Help = Help.class$("jess.Help")) : class$jess$Help).getResourceAsStream(string);
        if (inputStream == null) {
            throw new JessException("help", "Can't find file", string);
        }
        try {
            try {
                String string4;
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = documentBuilder.parse(inputStream);
                NodeList nodeList = document.getElementsByTagName(string2);
                for (int i2 = 0; i2 < nodeList.getLength(); string4 = string4.trim(), ++i2) {
                    Element element = (Element)nodeList.item(i2);
                    String string3 = element.getAttribute("name");
                    Node node = element.getElementsByTagName("description").item(0);
                    string4 = Help.addLineBreaks(Help.emitNodeAsText(node), 65);
                    s_helpMap.put(string3, string4);
                }
                Object var12_14 = null;
                if (inputStream == null) return;
            }
            catch (IOException iOException) {
                throw new JessException("help", "I/O error on help file", iOException);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new JessException("help", "XML parser error", exception);
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        return;
    }

    public Value call(ValueVector valueVector, Context context) throws JessException {
        Rete rete = context.getEngine();
        PrintWriter printWriter = rete.getOutStream();
        if (valueVector.size() == 1) {
            printWriter.println("Type \"(help name)\" to get help for the function named \"name\".");
            printWriter.println("Type \"(help intro)\" to get some help getting started.");
            printWriter.flush();
            return Funcall.NIL;
        }
        String string = valueVector.get(1).symbolValue(context);
        String string2 = Help.getHelpFor(string);
        if (string2 == null) {
            printWriter.println("No help found for function '" + string + "'");
        } else {
            printWriter.println(string2);
        }
        return Funcall.NIL;
    }

    public static String getHelpFor(String string) throws JessException {
        try {
            Help.fillHelpMap();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new JessException("help", "Help system unavailable; can't find class", noClassDefFoundError.getMessage());
        }
        if (string.equals("intro")) {
            return "(list-function$) -- list all Jess functions.\n(help defrule) -- learn to define a rule.\n(facts) -- show the contents of working memory.\n(rules) -- list all the defined rules.\n";
        }
        return (String)s_helpMap.get(string);
    }

    private static String emitNodeAsText(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Object object;
            Node node2 = nodeList.item(i2);
            if (node2.hasChildNodes()) {
                stringBuffer.append(Help.emitNodeAsText(node2));
                continue;
            }
            if (node2 instanceof Element) {
                object = (Element)node2;
                String string = object.getTagName();
                if (string.equals("jessf")) {
                    stringBuffer.append(object.getAttribute("name"));
                } else if (string.equals("javac")) {
                    stringBuffer.append(object.getAttribute("class"));
                } else if (string.equals("apic")) {
                    stringBuffer.append(object.getAttribute("class"));
                } else if (string.equals("construct")) {
                    stringBuffer.append(object.getAttribute("name"));
                }
            }
            if ((object = node2.getNodeValue()) != null) {
                stringBuffer.append(Help.flowText((String)object));
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    static String flowText(String string) {
        Matcher matcher = m_pattern.matcher(string.trim());
        return matcher.replaceAll(" ");
    }

    static String addLineBreaks(String string, int n2) {
        String[] stringArray = string.split(" ");
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            stringBuffer.append(string2);
            if ((n3 += string2.length() + 1) > n2) {
                n3 = 0;
                stringBuffer.append('\n');
                continue;
            }
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        m_pattern = Pattern.compile("[ \t\n\r]+");
    }
}

