/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.Iterator;
import jess.Activation;
import jess.Strategy;

class HeapPriorityQueue
implements Serializable {
    private Activation[] m_queue;
    private Strategy m_strategy;
    private int m_size;

    public HeapPriorityQueue(Strategy strategy) {
        this.m_queue = new Activation[10];
        this.m_strategy = strategy;
    }

    private HeapPriorityQueue(HeapPriorityQueue heapPriorityQueue) {
        this.m_queue = (Activation[])heapPriorityQueue.m_queue.clone();
        for (int i2 = 1; i2 <= heapPriorityQueue.m_size; ++i2) {
            this.m_queue[i2] = new Activation(this.m_queue[i2]);
        }
        this.m_size = heapPriorityQueue.m_size;
        this.m_strategy = heapPriorityQueue.m_strategy;
    }

    public Strategy setStrategy(Strategy strategy) {
        Strategy strategy2 = this.m_strategy;
        this.m_strategy = strategy;
        return strategy2;
    }

    public Strategy getStrategy() {
        return this.m_strategy;
    }

    public boolean isEmpty() {
        return this.m_size == 0;
    }

    public synchronized void remove(Activation activation) {
        if (this.m_size > 0) {
            int n2 = activation.getIndex();
            activation.setIndex(-1);
            this.m_queue[n2] = this.m_queue[this.m_size];
            this.m_queue[n2].setIndex(n2);
            this.m_queue[this.m_size] = null;
            --this.m_size;
            this.fixDown(n2);
        }
    }

    public synchronized void push(Activation activation) {
        if (this.m_size == this.m_queue.length - 1) {
            Activation[] activationArray = new Activation[this.m_size * 2];
            System.arraycopy(this.m_queue, 1, activationArray, 1, this.m_size);
            this.m_queue = activationArray;
        }
        ++this.m_size;
        this.m_queue[this.m_size] = activation;
        activation.setIndex(this.m_size);
        this.fixUp(this.m_size);
        this.notify();
    }

    public synchronized Activation pop() {
        if (this.isEmpty()) {
            return null;
        }
        Activation activation = this.m_queue[1];
        this.remove(activation);
        return activation;
    }

    public synchronized Activation peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.m_queue[1];
    }

    public void clear() {
        this.m_queue = new Activation[10];
        this.m_size = 0;
    }

    public Iterator iterator() {
        final HeapPriorityQueue heapPriorityQueue = new HeapPriorityQueue(this);
        return new Iterator(){

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return !heapPriorityQueue.isEmpty();
            }

            public Object next() {
                return heapPriorityQueue.pop();
            }
        };
    }

    private void fixDown(int n2) {
        Activation[] activationArray = this.m_queue;
        while (2 * n2 <= this.m_size) {
            int n3 = 2 * n2;
            if (n3 < this.m_size && this.m_strategy.compare(activationArray[n3], activationArray[n3 + 1]) > 0) {
                ++n3;
            }
            if (this.m_strategy.compare(activationArray[n2], activationArray[n3]) <= 0) break;
            this.exch(n2, n3);
            n2 = n3;
        }
    }

    private void fixUp(int n2) {
        Activation[] activationArray = this.m_queue;
        while (n2 > 1 && this.m_strategy.compare(activationArray[n2 / 2], activationArray[n2]) > 0) {
            int n3 = n2 / 2;
            this.exch(n2, n3);
            n2 = n3;
        }
    }

    private void exch(int n2, int n3) {
        Activation[] activationArray = this.m_queue;
        Activation activation = activationArray[n2];
        activationArray[n2] = activationArray[n3];
        activationArray[n3] = activation;
        activationArray[n2].setIndex(n2);
        activationArray[n3].setIndex(n3);
    }

    public int size() {
        return this.m_size;
    }
}

