/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jess.ConditionalElement;
import jess.ConditionalElementX;
import jess.Deftemplate;
import jess.JessException;
import jess.Pattern;
import jess.PatternIterator;
import jess.Visitable;
import jess.Visitor;

public class Group
implements ConditionalElement,
ConditionalElementX,
Serializable,
Visitable {
    private String m_name;
    private boolean m_explicit;
    private boolean m_logical;
    CEVector m_data = new CEVector();
    private boolean m_unary = false;
    public static final String AND = "and";
    public static final String UNIQUE = "unique";
    public static final String EXPLICIT = "explicit";
    public static final String NOT = "not";
    public static final String EXISTS = "exists";
    public static final String TEST = "test";
    public static final String OR = "or";
    public static final String LOGICAL = "logical";
    public static final String FORALL = "forall";
    public static final String ACCUMULATE = "accumulate";
    private static final Pattern s_initialFactPattern = new Pattern(Deftemplate.getInitialTemplate());
    private static final Pattern s_logicalInitialFactPattern = new Pattern(Deftemplate.getInitialTemplate());

    public Object clone() {
        try {
            Group group = (Group)super.clone();
            group.m_data = new CEVector();
            for (int i2 = 0; i2 < this.m_data.size(); ++i2) {
                group.m_data.add((ConditionalElementX)this.getConditionalElementX(i2).clone());
            }
            return group;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException();
        }
    }

    public Group(String string) throws JessException {
        this.m_name = string;
        if (this.m_name.equals(EXPLICIT)) {
            this.m_explicit = true;
            this.m_unary = true;
        } else if (this.m_name.equals(LOGICAL)) {
            this.m_logical = true;
            this.m_unary = false;
        } else if (this.m_name.equals(NOT)) {
            this.m_unary = true;
        } else if (this.m_name.equals(ACCUMULATE)) {
            this.m_unary = true;
        } else if (this.m_name.equals(EXISTS)) {
            throw new JessException("Group::Group", "Invalid CE name", EXISTS);
        }
    }

    public String getName() {
        return this.m_name;
    }

    public int getPatternCount() {
        if (Group.isNegatedName(this.m_name)) {
            return 1;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.m_data.size(); ++i2) {
            n2 += this.m_data.get(i2).getPatternCount();
        }
        return n2;
    }

    public void add(ConditionalElement conditionalElement) throws JessException {
        this.add((ConditionalElementX)conditionalElement);
    }

    public void add(ConditionalElementX conditionalElementX) throws JessException {
        this.verifyAdditionIsAllowed(conditionalElementX);
        if (conditionalElementX.getName().equals(OR) && conditionalElementX.getGroupSize() == 1) {
            conditionalElementX = conditionalElementX.getConditionalElementX(0);
        }
        if (conditionalElementX.getName().equals(AND) && conditionalElementX.getGroupSize() == 1 && !this.getName().equals(OR)) {
            conditionalElementX = conditionalElementX.getConditionalElementX(0);
        }
        if (this.m_name.equals(OR) && conditionalElementX.getName().equals(OR)) {
            Group group = (Group)conditionalElementX;
            for (int i2 = 0; i2 < group.m_data.size(); ++i2) {
                this.add(group.m_data.get(i2));
            }
        } else if (this.m_name.equals(AND) && conditionalElementX.getName().equals(AND)) {
            Group group = (Group)conditionalElementX;
            for (int i3 = 0; i3 < group.m_data.size(); ++i3) {
                this.add(group.m_data.get(i3));
            }
        } else if (this.m_name.equals(NOT) && conditionalElementX.getName().equals(OR)) {
            this.m_name = AND;
            this.m_unary = false;
            Group group = (Group)conditionalElementX;
            for (int i4 = 0; i4 < group.m_data.size(); ++i4) {
                Group group2 = new Group(NOT);
                group2.add(group.m_data.get(i4));
                this.add(group2);
            }
        } else if (this.m_name.equals(NOT) && conditionalElementX.getName().equals(AND) && this.hasEmbeddedORs((Group)conditionalElementX)) {
            conditionalElementX = conditionalElementX.canonicalize();
            this.add(conditionalElementX);
        } else {
            this.m_data.add(conditionalElementX);
        }
        if (this.m_explicit) {
            this.setExplicit();
        }
        if (this.m_logical) {
            this.setLogical();
        }
        if (this.getNegated()) {
            this.setNegated();
        }
    }

    private boolean hasEmbeddedORs(Group group) {
        if (group.getName().equals(OR)) {
            return true;
        }
        for (int i2 = 0; i2 < group.getGroupSize(); ++i2) {
            ConditionalElementX conditionalElementX = group.getConditionalElementX(i2);
            if (!(conditionalElementX instanceof Group) || !this.hasEmbeddedORs((Group)conditionalElementX)) continue;
            return true;
        }
        return false;
    }

    private void verifyAdditionIsAllowed(ConditionalElementX conditionalElementX) throws JessException {
        if (this.m_data.size() > 0 && this.m_unary) {
            throw new JessException("Group.add", "CE is a unary modifier", this.m_name);
        }
        if (this.m_name.equals(LOGICAL) && conditionalElementX.getName().equals(TEST)) {
            throw new JessException("Group.add", "CE can't be used in logical:", TEST);
        }
        if (this.m_name.equals(NOT) && conditionalElementX.getName().equals(LOGICAL)) {
            throw new JessException("Group.add", "CE can't be used in not:", LOGICAL);
        }
    }

    public boolean getBackwardChaining() {
        return false;
    }

    public void setExplicit() throws JessException {
        for (int i2 = 0; i2 < this.m_data.size(); ++i2) {
            this.m_data.get(i2).setExplicit();
        }
        this.m_explicit = true;
    }

    public void setLogical() throws JessException {
        for (int i2 = 0; i2 < this.m_data.size(); ++i2) {
            this.m_data.get(i2).setLogical();
        }
        this.m_logical = true;
    }

    public boolean getLogical() {
        return this.m_logical;
    }

    public boolean getNegated() {
        return this.m_name.equals(NOT);
    }

    public void setNegated() throws JessException {
        for (int i2 = 0; i2 < this.m_data.size(); ++i2) {
            this.m_data.get(i2).setNegated();
        }
    }

    public void setBoundName(String string) throws JessException {
        if (this.m_name.equals(NOT) || this.m_name.equals(TEST) || this.m_data.size() > 1 && !this.m_name.equals(OR)) {
            throw new JessException("Group.setBoundName", "This CE can't be bound to a variable", this.m_name);
        }
        for (int i2 = 0; i2 < this.m_data.size(); ++i2) {
            this.m_data.get(i2).setBoundName(string);
        }
    }

    public String getBoundName() {
        return this.m_data.get(0).getBoundName();
    }

    static boolean isGroupName(String string) {
        return Group.isNegatedName(string) || string.equals(AND) || string.equals(OR) || string.equals(LOGICAL) || string.equals(EXPLICIT) || string.equals(ACCUMULATE);
    }

    public static boolean isNegatedName(String string) {
        return string.equals(NOT);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.m_name);
        for (int i2 = 0; i2 < this.m_data.size(); ++i2) {
            stringBuffer.append('\n');
            stringBuffer.append(' ');
            stringBuffer.append(this.m_data.get(i2));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private int countNumberOfBranches(ConditionalElementX[] conditionalElementXArray) throws JessException {
        int n2;
        for (n2 = 0; n2 < conditionalElementXArray.length; ++n2) {
            conditionalElementXArray[n2] = this.m_data.get(n2).canonicalize();
        }
        if (this.m_name.equals(OR)) {
            n2 = 0;
            for (int i2 = 0; i2 < conditionalElementXArray.length; ++i2) {
                n2 += conditionalElementXArray[i2].getGroupSize();
            }
        } else {
            n2 = 1;
            for (int i3 = 0; i3 < conditionalElementXArray.length; ++i3) {
                n2 *= conditionalElementXArray[i3].getGroupSize();
            }
        }
        return n2;
    }

    public ConditionalElementX canonicalize() throws JessException {
        int n2;
        int n3;
        int n4;
        ConditionalElementX[] conditionalElementXArray = new ConditionalElementX[this.m_data.size()];
        int n5 = this.countNumberOfBranches(conditionalElementXArray);
        if (n5 == 1) {
            Group group = new Group(OR);
            group.add(this);
            return group;
        }
        Group[] groupArray = new Group[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            groupArray[n4] = new Group(AND);
        }
        if (this.m_name.equals(OR)) {
            n4 = 0;
            for (n3 = 0; n3 < conditionalElementXArray.length; ++n3) {
                for (n2 = 0; n2 < conditionalElementXArray[n3].getGroupSize(); ++n2) {
                    groupArray[n4++].add(conditionalElementXArray[n3].getConditionalElementX(n2));
                }
            }
        } else {
            n4 = n5;
            for (n3 = 0; n3 < conditionalElementXArray.length; ++n3) {
                if (conditionalElementXArray[n3].getGroupSize() == 1) {
                    for (n2 = 0; n2 < n5; ++n2) {
                        groupArray[n2].add(conditionalElementXArray[n3].getConditionalElementX(0));
                    }
                    continue;
                }
                n2 = n5 / ((n4 /= conditionalElementXArray[n3].getGroupSize()) * conditionalElementXArray[n3].getGroupSize());
                int n6 = 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    for (int i3 = 0; i3 < conditionalElementXArray[n3].getGroupSize(); ++i3) {
                        for (int i4 = 0; i4 < n4; ++i4) {
                            groupArray[n6++].add(conditionalElementXArray[n3].getConditionalElementX(i3));
                        }
                    }
                }
            }
        }
        Group group = new Group(OR);
        for (n3 = 0; n3 < n5; ++n3) {
            if (groupArray[n3].getGroupSize() == 1 && !groupArray[n3].getConditionalElementX(0).getName().equals(NOT) && !groupArray[n3].getConditionalElementX(0).getName().equals(TEST)) {
                group.add(groupArray[n3].getConditionalElementX(0));
                continue;
            }
            group.add(groupArray[n3]);
        }
        if (this.m_name.equals(NOT)) {
            Group group2 = new Group(NOT);
            group2.add(group);
            return group2.canonicalize();
        }
        return group;
    }

    void insertInitialFacts() {
        ConditionalElementX conditionalElementX = this.getConditionalElementX(0);
        if (this.needsPrecedingInitialFact(conditionalElementX)) {
            this.m_data.addAtStart(conditionalElementX == null || !conditionalElementX.getLogical() ? (Pattern)s_initialFactPattern.clone() : (Pattern)s_logicalInitialFactPattern.clone());
        }
    }

    private boolean needsPrecedingInitialFact(ConditionalElementX conditionalElementX) {
        if (conditionalElementX == null) {
            return true;
        }
        String string = conditionalElementX.getName();
        return string.equals(NOT) || string.equals(TEST) || string.equals(ACCUMULATE) || conditionalElementX.getBackwardChaining() || string.equals(LOGICAL) && this.needsPrecedingInitialFact(conditionalElementX.getConditionalElementX(0));
    }

    void renameVariables(ConditionalElementX conditionalElementX, int n2) throws JessException {
        HashSet hashSet = new HashSet();
        HashMap hashMap = new HashMap();
        this.addDirectlyMatchedVariables(hashSet);
        conditionalElementX.renameUnmentionedVariables(hashSet, hashMap, n2);
    }

    public void addToGroup(Group group) throws JessException {
        this.insertInitialFacts();
        for (int i2 = 0; i2 < this.m_data.size(); ++i2) {
            ConditionalElementX conditionalElementX = this.m_data.get(i2);
            group.m_data.add((ConditionalElementX)conditionalElementX.clone());
        }
    }

    public int getGroupSize() {
        return this.m_data.size();
    }

    public boolean isGroup() {
        return true;
    }

    public ConditionalElement getConditionalElement(int n2) {
        return this.getConditionalElementX(n2);
    }

    public ConditionalElementX getConditionalElementX(int n2) {
        return this.m_data.get(n2);
    }

    public void addDirectlyMatchedVariables(Set set) throws JessException {
        for (int i2 = 0; i2 < this.m_data.size(); ++i2) {
            this.m_data.get(i2).addDirectlyMatchedVariables(set);
        }
    }

    public void renameUnmentionedVariables(Set set, Map hashMap, int n2) throws JessException {
        if (Group.isNegatedName(this.m_name)) {
            hashMap = new HashMap(hashMap);
            ++n2;
        }
        for (int i2 = 0; i2 < this.m_data.size(); ++i2) {
            this.m_data.get(i2).renameUnmentionedVariables(set, hashMap, n2);
        }
    }

    public void recordTestedSlots(int n2, Set set) {
        PatternIterator patternIterator = new PatternIterator(this);
        int n3 = n2;
        while (patternIterator.hasNext()) {
            Pattern pattern = (Pattern)patternIterator.next();
            pattern.recordTestedSlots(n3, set);
            ++n3;
        }
    }

    public boolean isBackwardChainingTrigger() {
        return false;
    }

    public Object accept(Visitor visitor) {
        return visitor.visitGroup(this);
    }

    public void findVariableDefinitions(int n2, Map map, Map map2) throws JessException {
        PatternIterator patternIterator = new PatternIterator(this);
        int n3 = n2;
        while (patternIterator.hasNext()) {
            Pattern pattern = (Pattern)patternIterator.next();
            pattern.findVariableDefinitions(n3, map, map2);
            ++n3;
        }
    }

    static {
        s_logicalInitialFactPattern.setLogical();
    }

    static class CEVector
    implements Serializable {
        private ConditionalElementX[] m_data = new ConditionalElementX[1];
        private int m_nData;

        CEVector() {
        }

        void addAtStart(ConditionalElementX conditionalElementX) {
            if (this.m_data.length == this.m_nData) {
                ConditionalElementX[] conditionalElementXArray = new ConditionalElementX[this.m_nData * 2];
                System.arraycopy(this.m_data, 0, conditionalElementXArray, 0, this.m_nData);
                this.m_data = conditionalElementXArray;
            }
            System.arraycopy(this.m_data, 0, this.m_data, 1, this.m_nData);
            this.m_data[0] = conditionalElementX;
            ++this.m_nData;
        }

        void add(ConditionalElementX conditionalElementX) {
            if (this.m_data.length == this.m_nData) {
                ConditionalElementX[] conditionalElementXArray = new ConditionalElementX[this.m_nData * 2];
                System.arraycopy(this.m_data, 0, conditionalElementXArray, 0, this.m_nData);
                this.m_data = conditionalElementXArray;
            }
            this.m_data[this.m_nData++] = conditionalElementX;
        }

        ConditionalElementX get(int n2) {
            return this.m_data[n2];
        }

        int size() {
            return this.m_nData;
        }
    }
}

