/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.RU;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

class Foreach
implements Userfunction,
Serializable {
    Foreach() {
    }

    public String getName() {
        return "foreach";
    }

    public Value call(ValueVector valueVector, Context context) throws JessException {
        Value value = valueVector.get(2).resolveValue(context);
        if (value.type() == 512) {
            return this.processValueVector(valueVector, value, context);
        }
        if (value.type() == 2048) {
            Object object = value.javaObjectValue(context);
            if (object instanceof Collection) {
                return this.processIterator(valueVector, ((Collection)object).iterator(), context);
            }
            if (object instanceof Iterator) {
                return this.processIterator(valueVector, (Iterator)object, context);
            }
        }
        throw new JessException("foreach", "Argument must be ValueVector, Collection, or Iterator:", value.toString());
    }

    private Value processIterator(ValueVector valueVector, Iterator iterator, Context context) throws JessException {
        String string = valueVector.get(1).variableValue(context);
        Value value = Funcall.NIL;
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            Value value2 = e2 instanceof Value ? (Value)e2 : RU.objectToValue(e2.getClass(), e2);
            context.setVariable(string, value2.resolveValue(context));
            for (int i2 = 3; i2 < valueVector.size(); ++i2) {
                value = valueVector.get(i2).resolveValue(context);
                if (!context.returning()) continue;
                value = context.getReturnValue();
                return value;
            }
        }
        return value;
    }

    private Value processValueVector(ValueVector valueVector, Value value, Context context) throws JessException {
        String string = valueVector.get(1).variableValue(context);
        ValueVector valueVector2 = value.listValue(context);
        Value value2 = Funcall.NIL;
        for (int i2 = 0; i2 < valueVector2.size(); ++i2) {
            context.setVariable(string, valueVector2.get(i2).resolveValue(context));
            for (int i3 = 3; i3 < valueVector.size(); ++i3) {
                value2 = valueVector.get(i3).resolveValue(context);
                if (!context.returning()) continue;
                value2 = context.getReturnValue();
                return value2;
            }
        }
        return value2;
    }
}

