/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jess.Context;
import jess.Defrule;
import jess.Fact;
import jess.Funcall;
import jess.JessException;
import jess.MockBean;
import jess.Node;
import jess.Rete;
import jess.Token;
import jess.Value;
import jess.ValueVector;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class FactListTest
extends TestCase {
    private Rete m_engine;
    private Fact m_supporter;
    private Fact m_supportee;
    static /* synthetic */ Class class$jess$FactListTest;

    public static TestSuite suite() {
        return new TestSuite(class$jess$FactListTest == null ? (class$jess$FactListTest = FactListTest.class$("jess.FactListTest")) : class$jess$FactListTest);
    }

    public FactListTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.m_engine = new Rete();
        this.m_engine.eval("(deftemplate supporter (slot s1 (default 1)))");
        this.m_engine.eval("(deftemplate supportee (slot s1 (default 1)))");
        this.m_engine.eval("(defrule rule-1 (logical (supporter)) => (assert (supportee)))");
        this.m_engine.reset();
        this.m_supporter = this.m_engine.assertString("(supporter)");
        this.m_engine.run();
        this.m_supportee = this.m_engine.findFactByID(2);
    }

    protected void tearDown() throws Exception {
        this.m_engine = null;
        this.m_supportee = null;
        this.m_supporter = null;
    }

    public void testRetractNoSuchFact() throws Exception {
        Funcall funcall = new Funcall("retract", this.m_engine);
        funcall.arg(new Value(5000, 4));
        FactListTest.assertEquals((Object)Funcall.FALSE, (Object)funcall.execute(this.m_engine.getGlobalContext()));
        funcall.set(new Value(1, 4), 1);
        FactListTest.assertEquals((Object)Funcall.TRUE, (Object)funcall.execute(this.m_engine.getGlobalContext()));
    }

    public void testModifyNoSuchFact() throws Exception {
        Funcall funcall = new Funcall("modify", this.m_engine);
        ValueVector valueVector = new ValueVector();
        valueVector.add(new Value("foo", 1));
        valueVector.add(new Value(3, 4));
        funcall.add(new Value(5000, 4));
        funcall.add(new Value(valueVector, 512));
        try {
            funcall.execute(this.m_engine.getGlobalContext());
        }
        catch (NullPointerException nullPointerException) {
            FactListTest.fail((String)"Got NPE");
        }
        catch (JessException jessException) {
            FactListTest.assertTrue((jessException.getData().indexOf("5000") > -1 ? 1 : 0) != 0);
        }
    }

    public void testDuplicateNoSuchFact() throws Exception {
        Funcall funcall = new Funcall("duplicate", this.m_engine);
        ValueVector valueVector = new ValueVector();
        valueVector.add(new Value("foo", 1));
        valueVector.add(new Value(3, 4));
        funcall.add(new Value(5000, 4));
        funcall.add(new Value(valueVector, 512));
        try {
            funcall.execute(this.m_engine.getGlobalContext());
        }
        catch (NullPointerException nullPointerException) {
            FactListTest.fail((String)"Got NPE");
        }
        catch (JessException jessException) {
            FactListTest.assertTrue((jessException.getData().indexOf("5000") > -1 ? 1 : 0) != 0);
        }
    }

    public void testLogicalCleanupAfterRetract() throws Exception {
        List list = this.m_engine.getSupportingTokens(this.m_supportee);
        FactListTest.assertEquals((int)1, (int)list.size());
        Token token = (Token)list.get(0);
        FactListTest.assertEquals((String)"Fact has support", (Object)this.m_supporter, (Object)token.topFact());
        this.m_engine.retract(this.m_supportee);
        FactListTest.assertNull((String)"Support disappeared", (Object)this.m_engine.getSupportingTokens(this.m_supportee));
        list = this.m_engine.getSupportedFacts(this.m_supporter);
        FactListTest.assertEquals((String)"Doesn't support anything", (int)0, (int)list.size());
    }

    public void testLogicalCleanupAfterModify() throws Exception {
        List list = this.m_engine.getSupportingTokens(this.m_supportee);
        FactListTest.assertEquals((int)1, (int)list.size());
        Token token = (Token)list.get(0);
        FactListTest.assertEquals((String)"Fact has support", (Object)this.m_supporter, (Object)token.topFact());
        this.m_engine.modify(this.m_supportee, "s1", new Value(2, 4));
        list = this.m_engine.getSupportedFacts(this.m_supporter);
        FactListTest.assertEquals((String)"Doesn't support anything", (int)0, (int)list.size());
        List list2 = this.m_engine.getSupportingTokens(this.m_supportee);
        FactListTest.assertNull((Object)list2);
    }

    public void testProvidesSupport() throws Exception {
        List list = this.m_engine.getSupportedFacts(this.m_supporter);
        FactListTest.assertEquals((int)1, (int)list.size());
        FactListTest.assertEquals((Object)this.m_supportee, list.get(0));
    }

    public void testModifyLogical() throws Exception {
        this.m_engine.modify(this.m_supporter, "s1", new Value(2, 4));
        FactListTest.assertNull((String)"Support disappeared", (Object)this.m_engine.getSupportingTokens(this.m_supportee));
        FactListTest.assertEquals((String)"Doesn't support anything", (int)0, (int)this.m_engine.getSupportedFacts(this.m_supporter).size());
    }

    public void testBeanLogicalRetract() throws Exception {
        MockBean mockBean = new MockBean();
        mockBean.setFoo("bioputty");
        this.m_engine.clear();
        this.m_engine.defclass("bean", "jess.MockBean", null);
        this.m_engine.definstance("bean", mockBean, true);
        this.m_engine.eval("(defrule rule (logical (bean)) => (assert (foo)))");
        this.m_engine.reset();
        this.m_engine.run();
        Fact fact = this.m_engine.findFactByID(2);
        FactListTest.assertEquals((String)"MAIN::foo", (String)fact.getName());
        mockBean.setFoo("gak");
        FactListTest.assertNull((Object)this.m_engine.findFactByID(2));
    }

    public void testModifySlotInfo() throws Exception {
        this.m_engine.eval("(deftemplate ss (declare (slot-specific TRUE)) (slot s1 (default 1)))");
        this.m_engine.eval("(defrule rule (ss) => )");
        Defrule defrule = (Defrule)this.m_engine.findDefrule("rule");
        Iterator iterator = defrule.getNodes();
        int n2 = defrule.getNodeCount();
        for (int i2 = 0; i2 < n2 - 2; ++i2) {
            iterator.next();
        }
        Node node = (Node)iterator.next();
        ArrayList arrayList = new ArrayList();
        node.addSuccessor(new MockDefrule(arrayList), defrule);
        Fact fact = new Fact("ss", this.m_engine);
        this.m_engine.assertFact(fact);
        this.m_engine.modify(fact, "s1", new Value(37, 4));
        FactListTest.assertEquals((int)4, (int)arrayList.size());
        FactListTest.assertEquals((Object)fact, arrayList.get(0));
        this.assertArrayEquals(new String[]{"s1"}, (String[])arrayList.get(1));
        FactListTest.assertEquals((Object)fact, arrayList.get(2));
        this.assertArrayEquals(new String[]{"s1"}, (String[])arrayList.get(3));
    }

    private void assertArrayEquals(Object[] objectArray, Object[] objectArray2) {
        FactListTest.assertEquals((String)"length", (int)objectArray.length, (int)objectArray2.length);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            FactListTest.assertEquals((String)("Element at " + String.valueOf(i2)), (Object)objectArray[i2], (Object)objectArray2[i2]);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MockDefrule
    extends Defrule {
        private final ArrayList m_results;

        public MockDefrule(ArrayList arrayList) throws JessException {
            super("rule2", "", FactListTest.this.m_engine);
            this.m_results = arrayList;
        }

        public void callNodeLeft(int n2, Token token, Context context) throws JessException {
            if (context.getSlotSpecificModifiedFact() != null) {
                this.m_results.add(context.getSlotSpecificModifiedFact());
                this.m_results.add(context.getModifiedSlots());
            }
            super.callNodeLeft(n2, token, context);
        }
    }
}

