/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import jess.Context;
import jess.Deftemplate;
import jess.FactIDValue;
import jess.JessException;
import jess.ListRenderer;
import jess.Modular;
import jess.Rete;
import jess.Value;
import jess.ValueVector;
import jess.Visitable;
import jess.Visitor;

public class Fact
extends ValueVector
implements Serializable,
Modular,
Visitable {
    private int m_id = -1;
    private Deftemplate m_deft;
    public static final int NO = 0;
    public static final int DYNAMIC = 1;
    public static final int STATIC = 2;
    private int m_shadow;
    private String m_name;
    private Fact m_icon;
    private int m_time;
    private static Fact s_nullFact;
    private static Fact s_initialFact;
    private static Fact s_clearFact;

    public Fact getIcon() {
        return this.m_icon;
    }

    void setIcon(Fact fact) {
        this.m_icon = fact;
    }

    static Fact getNullFact() {
        return s_nullFact;
    }

    static Fact getInitialFact() {
        return (Fact)s_initialFact.clone();
    }

    static Fact getClearFact() {
        return s_clearFact;
    }

    public String getName() {
        return this.m_name;
    }

    public int getFactId() {
        return this.m_id;
    }

    void setFactId(int n2) {
        this.m_id = n2;
    }

    void setShadowMode(int n2) {
        this.m_shadow = n2;
    }

    public boolean isShadow() {
        return this.m_shadow > 0;
    }

    public int getShadowMode() {
        return this.m_shadow;
    }

    public final Deftemplate getDeftemplate() {
        return this.m_deft;
    }

    public final String getModule() {
        return this.m_deft.getModule();
    }

    public int getTime() {
        return this.m_time;
    }

    void updateTime(int n2) {
        this.m_time = n2;
    }

    public Value get(int n2) throws JessException {
        if (n2 >= 0 && n2 < this.m_ptr) {
            return this.m_v[n2];
        }
        if (n2 == -1) {
            return new FactIDValue(this);
        }
        throw new JessException("Fact.get", "Slot index " + n2 + " out of bounds on this fact:", this.toStringWithParens());
    }

    public Fact(Deftemplate deftemplate) throws JessException {
        this.m_deft = deftemplate;
        this.createNewFact();
        this.m_time = 0;
        this.m_icon = this;
    }

    public Fact(String string, Rete rete) throws JessException {
        if (string.equals("not") || string.equals("test") || string.equals("explicit") || string.indexOf(32) != -1 || string.indexOf(40) != -1) {
            throw new JessException("Fact.Fact", "Illegal fact name:", string);
        }
        this.m_deft = rete.createDeftemplate(string);
        this.createNewFact();
        this.m_time = rete.getTime();
        this.m_icon = this;
    }

    public Fact(Fact fact) throws JessException {
        this.m_name = fact.m_name;
        this.m_deft = fact.m_deft;
        this.setLength(fact.size());
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.set(fact.get(i2), i2);
        }
        this.m_time = fact.m_time;
        this.m_id = fact.m_id;
        this.m_icon = this;
    }

    public Object clone() {
        try {
            return new Fact(this);
        }
        catch (JessException jessException) {
            return null;
        }
    }

    private void createNewFact() throws JessException {
        int n2 = this.m_deft.getNSlots();
        this.setLength(n2);
        this.m_name = this.m_deft.getName();
        this.m_shadow = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.set(this.m_deft.getSlotDefault(i2), i2);
        }
    }

    private int findSlot(String string) throws JessException {
        int n2 = this.m_deft.getSlotIndex(string);
        if (n2 == -1) {
            throw new JessException("Fact.findSlot", "No slot " + string + " in deftemplate ", this.m_deft.getName());
        }
        return n2;
    }

    public final Value getSlotValue(String string) throws JessException {
        return this.get(this.findSlot(string));
    }

    public final void setSlotValue(String string, Value value) throws JessException {
        int n2 = this.findSlot(string);
        if (this.m_deft.getSlotType(n2) == 32768 && value.type() != 512) {
            value = new Value(new ValueVector().add(value), 512);
        }
        this.set(value, n2);
    }

    Fact expand(Context context) throws JessException {
        Fact fact = (Fact)this.clone();
        for (int i2 = 0; i2 < fact.size(); ++i2) {
            Value value = fact.get(i2).resolveValue(context);
            if (value.type() == 512) {
                ValueVector valueVector = new ValueVector();
                ValueVector valueVector2 = value.listValue(context);
                for (int i3 = 0; i3 < valueVector2.size(); ++i3) {
                    Value value2 = valueVector2.get(i3).resolveValue(context);
                    if (value2.type() == 512) {
                        ValueVector valueVector3 = value2.listValue(context);
                        for (int i4 = 0; i4 < valueVector3.size(); ++i4) {
                            valueVector.add(valueVector3.get(i4).resolveValue(context));
                        }
                        continue;
                    }
                    valueVector.add(value2);
                }
                value = this.getDeftemplate().getSlotType(i2) == 16384 ? valueVector.get(0) : new Value(valueVector, 512);
            }
            fact.set(value, i2);
        }
        return fact;
    }

    ListRenderer toList() {
        try {
            ListRenderer listRenderer = new ListRenderer(this.m_name);
            int n2 = this.size();
            if (n2 == 1 && this.m_deft.getSlotName(0).equals("__data")) {
                if (this.get(0).type() != 512) {
                    listRenderer.add(this.get(0));
                    return listRenderer;
                }
                if (this.get(0).listValue(null).size() == 0) {
                    return listRenderer;
                }
                listRenderer.add(this.get(0));
                return listRenderer;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                listRenderer.add(new ListRenderer(this.m_deft.getSlotName(i2), this.get(i2)));
            }
            return listRenderer;
        }
        catch (JessException jessException) {
            return new ListRenderer(jessException.toString());
        }
    }

    public String toString() {
        return this.toList().toString();
    }

    public String toStringWithParens() {
        return this.toList().toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Fact)) {
            return false;
        }
        Fact fact = (Fact)object;
        if (!this.m_name.equals(fact.m_name)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n2 = this.m_name.hashCode();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            n2 += this.m_v[i2].hashCode();
        }
        return n2;
    }

    public final String getConstructType() {
        return "fact";
    }

    public final String getDocstring() {
        return null;
    }

    public Object accept(Visitor visitor) {
        return visitor.visitFact(this);
    }

    static {
        try {
            s_nullFact = new Fact(Deftemplate.getNullTemplate());
            s_clearFact = new Fact(Deftemplate.getClearTemplate());
            s_initialFact = new Fact(Deftemplate.getInitialTemplate());
        }
        catch (JessException jessException) {
            // empty catch block
        }
    }
}

