/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import jess.Activation;
import jess.ConditionalElementX;
import jess.Context;
import jess.Fact;
import jess.Funcall;
import jess.HasLHS;
import jess.JessException;
import jess.LogicalNode;
import jess.MatchInfoSource;
import jess.Rete;
import jess.TestedSlot;
import jess.Token;
import jess.Value;
import jess.Visitor;

public class Defrule
extends HasLHS
implements Serializable,
MatchInfoSource {
    private HashMap m_activations = new HashMap();
    private Funcall[] m_actions;
    private int m_nActions;
    private int m_salience = 0;
    private Value m_salienceVal;
    private boolean m_autoFocus = false;
    private boolean m_noLoop;
    private Set m_testedSlots = new HashSet();
    private LogicalNode m_logicalNode = null;

    public Defrule(String string, String string2, Rete rete) throws JessException {
        super(string, string2, rete);
        this.m_salienceVal = new Value(0, 4);
    }

    public final int getSalience() {
        return this.m_salience;
    }

    public Value getSalienceValue() {
        return this.m_salienceVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSalience(Value value, Rete rete) throws JessException {
        try {
            this.m_salienceVal = value;
            this.evalSalience(rete);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.getNext() != null) {
                ((Defrule)this.getNext()).setSalience(value, rete);
            }
            throw throwable;
        }
        if (this.getNext() != null) {
            ((Defrule)this.getNext()).setSalience(value, rete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int evalSalience(Rete rete) throws JessException {
        Context context = rete.getGlobalContext().push();
        try {
            this.m_salience = this.m_salienceVal.intValue(context);
        }
        finally {
            context.pop();
        }
        return this.m_salience;
    }

    public boolean hasNonDefaultSalience() {
        try {
            return this.m_salienceVal.type() != 4 || this.m_salienceVal.intValue(null) != 0;
        }
        catch (JessException jessException) {
            return true;
        }
    }

    public boolean getAutoFocus() {
        return this.m_autoFocus;
    }

    public void setAutoFocus(boolean bl) {
        this.m_autoFocus = bl;
        if (this.getNext() != null) {
            ((Defrule)this.getNext()).setAutoFocus(bl);
        }
    }

    public void addCE(ConditionalElementX conditionalElementX, Rete rete) throws JessException {
        if (conditionalElementX.getLogical() && this.getGroupSize() > 0 && !this.getLHSComponent(this.getGroupSize() - 1).getLogical()) {
            throw new JessException("Defrule.addCE", "Logical CEs can't follow non-logical CEs", this.m_name);
        }
        int n2 = this.getPatternCount();
        super.addCE(conditionalElementX, rete);
        conditionalElementX.recordTestedSlots(n2, this.m_testedSlots);
    }

    boolean isSlotTested(int n2, int n3) {
        TestedSlot testedSlot = new TestedSlot(n2, n3);
        return this.m_testedSlots.contains(testedSlot);
    }

    boolean isSlotTested(Token token, Context context) {
        Fact fact = context.getSlotSpecificModifiedFact();
        String[] stringArray = context.getModifiedSlots();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            int n2 = fact.getDeftemplate().getSlotIndex(string);
            int n3 = token.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!fact.equals(token.fact(i3).getIcon()) || !this.isSlotTested(i3, n2)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isSlotTested(int n2, Context context) {
        Fact fact = context.getSlotSpecificModifiedFact();
        String[] stringArray = context.getModifiedSlots();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            int n3 = fact.getDeftemplate().getSlotIndex(string);
            if (!this.isSlotTested(n2, n3)) continue;
            return true;
        }
        return false;
    }

    private void doAddCall(int n2, Token token, Context context, Rete rete) throws JessException {
        if (this.shouldAddCall(n2, token, context)) {
            Activation activation = new Activation(token, this);
            rete.addActivation(activation);
            this.m_activations.put(token, activation);
        }
    }

    private void removeCall(int n2, Token token, Context context) throws JessException {
        Activation activation;
        if (this.shouldRemoveCall(n2, token, context) && (activation = (Activation)this.m_activations.remove(token)) != null) {
            context.getEngine().removeActivation(activation);
        }
    }

    private boolean shouldRemoveCall(int n2, Token token, Context context) {
        if (n2 == 5) {
            return context.getSlotSpecificModifiedFact() == null || this.isSlotTested(token, context);
        }
        return true;
    }

    private boolean shouldAddCall(int n2, Token token, Context context) {
        Activation activation;
        if (this.m_noLoop && (activation = context.getEngine().getThisActivation()) != null && activation.getRule() == this) {
            return false;
        }
        if (n2 == 4) {
            return context.getSlotSpecificModifiedFact() == null || this.isSlotTested(token, context);
        }
        return true;
    }

    private void possiblyDoAddCall(Token token, Context context, Rete rete) throws JessException {
        if (!this.m_new) {
            return;
        }
        if (this.m_activations.get(token) != null) {
            return;
        }
        this.doAddCall(2, token, context, rete);
    }

    public void callNodeLeft(int n2, Token token, Context context) throws JessException {
        this.broadcastEvent(n2, 32768, token);
        switch (n2) {
            case 0: 
            case 4: {
                this.doAddCall(n2, token, context, context.getEngine());
                break;
            }
            case 1: 
            case 5: {
                this.removeCall(n2, token, context);
                break;
            }
            case 2: {
                this.possiblyDoAddCall(token, context, context.getEngine());
                break;
            }
            case 3: {
                this.m_activations.clear();
            }
        }
    }

    void ready(Token token, Context context) {
        super.ready(token, context);
        if (this.m_logicalNode != null) {
            Token token2 = token;
            int n2 = this.m_logicalNode.getTokenSize();
            for (int i2 = token.size(); i2 > n2; --i2) {
                token2 = token2.getParent();
            }
            context.setLogicalSupportNode(this.m_logicalNode);
            context.setToken(token2);
        }
    }

    void fire(Token token, Rete rete, Context context) throws JessException {
        this.m_activations.remove(token);
        Context context2 = context.push();
        context2.clearReturnValue();
        this.ready(token, context2);
        try {
            for (int i2 = 0; i2 < this.m_nActions; ++i2) {
                this.m_actions[i2].execute(context2);
                if (!context2.returning()) continue;
                context2.clearReturnValue();
                context2.pop();
                rete.popFocus(this.getModule());
                return;
            }
        }
        catch (JessException jessException) {
            jessException.addContext("defrule " + this.getDisplayName());
            throw jessException;
        }
        finally {
            context2.pop();
        }
    }

    void debugPrint(Token token, int n2, PrintWriter printWriter) {
        printWriter.print("FIRE ");
        printWriter.print(n2);
        printWriter.print(" ");
        printWriter.print(this.getDisplayName());
        for (int i2 = 0; i2 < token.size(); ++i2) {
            Fact fact = token.fact(i2);
            if (fact.getFactId() != -1) {
                printWriter.print(" f-" + fact.getFactId());
            }
            if (i2 >= token.size() - 1) continue;
            printWriter.print(",");
        }
        printWriter.println();
        printWriter.flush();
    }

    public int getNActions() {
        return this.m_nActions;
    }

    public Funcall getAction(int n2) {
        return this.m_actions[n2];
    }

    public void addAction(Funcall funcall) {
        if (this.m_actions == null || this.m_nActions == this.m_actions.length) {
            Funcall[] funcallArray = this.m_actions;
            this.m_actions = new Funcall[this.m_nActions + 5];
            if (funcallArray != null) {
                System.arraycopy(funcallArray, 0, this.m_actions, 0, this.m_nActions);
            }
        }
        this.m_actions[this.m_nActions++] = funcall;
        if (this.getNext() != null) {
            ((Defrule)this.getNext()).addAction(funcall);
        }
    }

    public Object accept(Visitor visitor) {
        return visitor.visitDefrule(this);
    }

    void setLogicalInformation(LogicalNode logicalNode) {
        this.m_logicalNode = logicalNode;
        logicalNode.setMatchInfoSource(this);
    }

    public String toString() {
        return "Defrule " + this.getName();
    }

    LogicalNode getLogicalNode() {
        return this.m_logicalNode;
    }

    public void setNoLoop(boolean bl) {
        this.m_noLoop = bl;
        if (this.getNext() != null) {
            ((Defrule)this.getNext()).setNoLoop(bl);
        }
    }

    public boolean isNoLoop() {
        return this.m_noLoop;
    }

    void createChain(ConditionalElementX conditionalElementX, Rete rete) throws JessException {
        this.doSetLHS(conditionalElementX.getConditionalElementX(0), rete);
        Defrule defrule = this;
        String string = this.getName();
        for (int i2 = 1; i2 < conditionalElementX.getGroupSize(); ++i2) {
            ConditionalElementX conditionalElementX2 = conditionalElementX.getConditionalElementX(i2);
            Defrule defrule2 = new Defrule(string + "&" + i2, this.getDocstring(), rete);
            defrule2.doSetLHS(conditionalElementX2, rete);
            defrule.setNext(defrule2);
            defrule = defrule2;
        }
    }

    public final String getConstructType() {
        return "defrule";
    }

    public boolean isRelevantChange(int n2, Token token, Context context) {
        Fact fact = context.getSlotSpecificModifiedFact();
        if (fact == null) {
            return true;
        }
        Fact fact2 = token.fact(n2).getIcon();
        if (fact2 == Fact.getNullFact()) {
            return true;
        }
        if (!fact.equals(fact2)) {
            return false;
        }
        return this.isSlotTested(n2, context);
    }
}

