/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.ArrayList;
import jess.Context;
import jess.Fact;
import jess.JessException;
import jess.Named;
import jess.Rete;
import jess.Visitable;
import jess.Visitor;

public class Deffacts
implements Serializable,
Visitable,
Named {
    private String m_name;
    private String m_module;
    private ArrayList m_facts;
    private String m_docstring = "";

    public final String getName() {
        return this.m_name;
    }

    public final String getModule() {
        return this.m_module;
    }

    public final String getDocstring() {
        return this.m_docstring;
    }

    public Deffacts(String string, String string2, Rete rete) throws JessException {
        int n2 = string.indexOf("::");
        if (n2 != -1) {
            this.m_module = string.substring(0, n2);
            rete.verifyModule(this.m_module);
            this.m_name = string;
        } else {
            this.m_module = rete.getCurrentModule();
            this.m_name = rete.resolveName(string);
        }
        this.m_facts = new ArrayList();
        this.m_docstring = string2;
    }

    public void addFact(Fact fact) {
        this.m_facts.add(fact);
    }

    public int getNFacts() {
        return this.m_facts.size();
    }

    public Fact getFact(int n2) {
        return (Fact)this.m_facts.get(n2);
    }

    public void reset(Rete rete) throws JessException {
        try {
            Context context = rete.getGlobalContext();
            for (int i2 = 0; i2 < this.m_facts.size(); ++i2) {
                Fact fact = (Fact)this.m_facts.get(i2);
                fact = fact.expand(context);
                rete.assertFact(fact, rete.getGlobalContext());
            }
        }
        catch (JessException jessException) {
            jessException.addContext("assert from deffacts " + this.m_name);
            throw jessException;
        }
    }

    public String toString() {
        return "[deffacts " + this.m_name + "]";
    }

    public Object accept(Visitor visitor) {
        return visitor.visitDeffacts(this);
    }

    public final String getConstructType() {
        return "deffacts";
    }
}

