/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import jess.BindingValue;
import jess.Defglobal;
import jess.Fact;
import jess.Funcall;
import jess.JessException;
import jess.LogicalNode;
import jess.Rete;
import jess.StackFrame;
import jess.Token;
import jess.Value;
import jess.server.LineNumberRecord;

public class Context
implements Serializable {
    private Map m_variables;
    private final Context m_parent;
    private boolean m_return;
    private Value m_retval;
    private transient Rete m_engine;
    private LogicalNode m_logicalSupportNode;
    private Fact m_slotSpecificModifiedFact;
    private String[] m_modifiedSlots;
    private Token m_token;
    private Fact m_fact;
    private static final String STACK = "%STACK";
    private boolean m_inAdvice;

    public final Token getToken() {
        if (this.m_token == null && this.m_parent != null) {
            return this.m_parent.getToken();
        }
        return this.m_token;
    }

    final void setToken(Token token) {
        this.m_token = token;
    }

    public final Fact getFact() {
        return this.m_fact;
    }

    final void setFact(Fact fact) {
        this.m_fact = fact;
    }

    public final synchronized LogicalNode getLogicalSupportNode() {
        if (this.m_logicalSupportNode == null && this.m_parent != null) {
            return this.m_parent.getLogicalSupportNode();
        }
        return this.m_logicalSupportNode;
    }

    final void setLogicalSupportNode(LogicalNode logicalNode) {
        this.m_logicalSupportNode = logicalNode;
    }

    synchronized boolean getInAdvice() {
        return this.m_inAdvice;
    }

    synchronized void setInAdvice(boolean bl) {
        this.m_inAdvice = bl;
    }

    synchronized void setEngine(Rete rete) {
        this.m_engine = rete;
    }

    public Context(Context context) {
        this.m_engine = context.m_engine;
        this.m_parent = context;
    }

    Context(Rete rete) {
        this.m_engine = rete;
        this.m_parent = null;
    }

    public Context(Context context, Rete rete) {
        this.m_engine = rete;
        this.m_parent = context;
    }

    synchronized void clear() {
        this.m_fact = null;
        this.m_token = null;
        this.m_inAdvice = false;
        this.m_logicalSupportNode = null;
        this.m_return = false;
        this.m_retval = null;
        this.m_variables = null;
        this.m_slotSpecificModifiedFact = null;
    }

    public final synchronized boolean returning() {
        return this.m_return;
    }

    public final synchronized Value setReturnValue(Value value) {
        this.m_return = true;
        this.m_retval = value;
        return value;
    }

    public final synchronized Value getReturnValue() {
        return this.m_retval;
    }

    public final synchronized void clearReturnValue() {
        this.m_return = false;
        this.m_retval = null;
    }

    private synchronized int nVariables() {
        if (this.m_variables == null) {
            return 0;
        }
        return this.m_variables.size();
    }

    private synchronized Map getVariables() {
        if (this.m_variables == null) {
            this.m_variables = Collections.synchronizedMap(new HashMap());
        }
        return this.m_variables;
    }

    public Iterator getVariableNames() {
        Map map = this.getVariables();
        return map.keySet().iterator();
    }

    public final Rete getEngine() {
        return this.m_engine;
    }

    public Context push() {
        return new Context(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context pop() {
        if (this.m_parent != null) {
            Context context = this.m_parent;
            synchronized (context) {
                this.m_parent.m_return = this.m_return;
                this.m_parent.m_retval = this.m_retval;
                return this.m_parent;
            }
        }
        return this;
    }

    public Context getParent() {
        return this.m_parent;
    }

    private synchronized Map findVariable(String string) {
        Context context = this;
        while (context != null) {
            Map map = context.getVariables();
            Value value = (Value)map.get(string);
            if (value != null) {
                return map;
            }
            context = context.m_parent;
        }
        return null;
    }

    synchronized void removeNonGlobals() {
        if (this.m_variables == null) {
            return;
        }
        HashMap hashMap = new HashMap(10);
        Iterator iterator = this.m_variables.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith("%") && this.m_engine.findDefglobal(string) == null) continue;
            hashMap.put(string, this.m_variables.get(string));
        }
        this.m_variables = Collections.synchronizedMap(hashMap);
    }

    public Value getVariable(String string) throws JessException {
        Map map = this.findVariable(string);
        if (map == null) {
            try {
                return this.getBindingVariable(string);
            }
            catch (JessException jessException) {
                throw new JessException("Context.getReturn", "No such variable", string);
            }
        }
        return ((Value)map.get(string)).resolveValue(this);
    }

    public boolean isVariableDefined(String string) {
        return this.findVariable(string) != null;
    }

    public synchronized void setVariable(String string, Value value) throws JessException {
        if (Defglobal.isADefglobalName(string)) {
            this.m_engine.getGlobalContext().getVariables().put(string, value);
            return;
        }
        Map map = this.getVariables();
        map.put(string, value);
    }

    public void setExistingVariable(String string, Value value) throws JessException {
        Map map = this.findVariable(string);
        if (map == null) {
            map = this.getVariables();
        }
        map.put(string, value);
    }

    public synchronized void pushStackFrame(Funcall funcall) throws JessException {
        Stack stack = this.getStackData();
        LineNumberRecord lineNumberRecord = Rete.lookupFunction(funcall);
        stack.push(new StackFrame(funcall, lineNumberRecord));
    }

    public synchronized Stack getStackData() throws JessException {
        Value value = (Value)this.getVariables().get(STACK);
        if (value == null) {
            value = new Value(new Stack());
            this.getVariables().put(STACK, value);
        }
        return (Stack)value.javaObjectValue(this);
    }

    public synchronized void popStackFrame(Funcall funcall) throws JessException {
        Stack stack = this.getStackData();
        if (stack.size() > 0) {
            stack.pop();
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[Context, ").append(this.nVariables()).append(" variables: ");
        Iterator iterator = this.getVariables().keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            stringBuffer.append(k2).append("=").append(this.m_variables.get(k2)).append(";");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    synchronized Fact getSlotSpecificModifiedFact() {
        if (this.m_slotSpecificModifiedFact == null && this.m_parent != null) {
            return this.m_parent.getSlotSpecificModifiedFact();
        }
        return this.m_slotSpecificModifiedFact;
    }

    synchronized void setSlotSpecificModifiedFact(Fact fact) {
        this.m_slotSpecificModifiedFact = fact;
    }

    synchronized String[] getModifiedSlots() {
        if (this.m_modifiedSlots == null && this.m_parent != null) {
            return this.m_parent.getModifiedSlots();
        }
        return this.m_modifiedSlots;
    }

    synchronized void setModifiedSlots(String[] stringArray) {
        this.m_modifiedSlots = stringArray;
    }

    public synchronized Funcall getFuncall() throws JessException {
        Stack stack = this.getStackData();
        if (stack.size() > 0) {
            StackFrame stackFrame = (StackFrame)stack.peek();
            return stackFrame.getFuncall();
        }
        return null;
    }

    public synchronized LineNumberRecord getLineNumberRecord() throws JessException {
        Stack stack = this.getStackData();
        if (stack.size() > 0) {
            StackFrame stackFrame = (StackFrame)stack.peek();
            return stackFrame.getLineNumberRecord();
        }
        return null;
    }

    public synchronized Value getBindingVariable(String string) throws JessException {
        Funcall funcall = this.getFuncall();
        if (funcall == null) {
            throw new JessException("Context.getBindingVariable", "No current function", "");
        }
        for (int i2 = 1; i2 < funcall.size(); ++i2) {
            BindingValue bindingValue;
            Value value = funcall.get(i2);
            if (!(value instanceof BindingValue) || !(bindingValue = (BindingValue)value).getName().equals(string)) continue;
            return bindingValue.resolveValue(this);
        }
        throw new JessException("Context.getBindingVariable", "No such variable", string);
    }
}

