/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.MethodNameComparator;
import jess.RU;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

class Call
implements Userfunction,
Serializable {
    String m_name = "call";
    private static HashMap s_methods = new HashMap();
    private static final Object[] NO_ARGS = new Object[0];
    private static final Value[] NO_PARAMS = new Value[0];
    static /* synthetic */ Class class$java$lang$String;

    Call() {
    }

    public String getName() {
        return this.m_name;
    }

    static Method[] getMethods(Class clazz) {
        if (s_methods.get(clazz) != null) {
            return (Method[])s_methods.get(clazz);
        }
        Method[] methodArray = clazz.getMethods();
        Arrays.sort(methodArray, MethodNameComparator.getInstance());
        s_methods.put(clazz, methodArray);
        return methodArray;
    }

    public Value call(ValueVector valueVector, Context context) throws JessException {
        if (valueVector.size() < 3) {
            throw new JessException("call", "Not enough arguments", "");
        }
        Value value = valueVector.get(1).resolveValue(context);
        String string = valueVector.get(2).symbolValue(context);
        Class clazz = null;
        try {
            int n2;
            Object object = null;
            if (value.type() == 2 || value.type() == 1) {
                try {
                    if (value.equals(Funcall.NIL)) {
                        throw new JessException("call", "Can't call method on nil reference:", string);
                    }
                    if (Call.hasMethodOfName(class$java$lang$String == null ? (class$java$lang$String = Call.class$("java.lang.String")) : class$java$lang$String, string)) {
                        object = value.stringValue(context);
                        clazz = class$java$lang$String == null ? (class$java$lang$String = Call.class$("java.lang.String")) : class$java$lang$String;
                    } else {
                        clazz = context.getEngine().findClass(value.stringValue(context));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new JessException("call", "Class not found", classNotFoundException);
                }
            }
            if (clazz == null) {
                object = value.javaObjectValue(context);
                clazz = object.getClass();
            }
            Object[] objectArray = (n2 = valueVector.size() - 3) == 0 ? NO_ARGS : new Object[n2];
            Value[] valueArray = n2 == 0 ? NO_PARAMS : new Value[n2];
            for (int i2 = 3; i2 < valueVector.size(); ++i2) {
                valueArray[i2 - 3] = valueVector.get(i2).resolveValue(context);
            }
            Method[] methodArray = Call.getMethods(clazz);
            int n3 = Arrays.binarySearch(methodArray, string, MethodNameComparator.getInstance());
            if (n3 < 0) {
                throw new JessException("call", "No method named '" + string + "' found", "in class " + clazz.getName());
            }
            while (n3 > 0 && methodArray[n3 - 1].getName().equals(string)) {
                --n3;
            }
            for (int i3 = n3; i3 < methodArray.length && methodArray[i3].getName().equals(string); ++i3) {
                try {
                    Method method = methodArray[i3];
                    Class<?>[] classArray = method.getParameterTypes();
                    if (n2 != classArray.length) continue;
                    if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                        Class<?> clazz2 = method.getDeclaringClass();
                        method = null;
                        Class<?>[] classArray2 = clazz.getInterfaces();
                        for (int i4 = 0; i4 < classArray2.length; ++i4) {
                            try {
                                method = classArray2[i4].getMethod(string, classArray);
                                break;
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                continue;
                            }
                        }
                        if (method == null) {
                            try {
                                method = clazz2.getMethod(string, classArray);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                        }
                        if (method == null) {
                            throw new JessException("call", "Method not accessible:", string);
                        }
                    }
                    if (object == null && !Modifier.isStatic(method.getModifiers())) continue;
                    try {
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                    }
                    catch (SecurityException securityException) {
                        throw new JessException("call", "Method not accessible:", string);
                    }
                    for (int i5 = 0; i5 < n2; ++i5) {
                        objectArray[i5] = RU.valueToObject(classArray[i5], valueArray[i5], context);
                    }
                    Object object2 = method.invoke(object, objectArray);
                    methodArray[i3] = method;
                    return RU.objectToValue(method.getReturnType(), object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            throw new NoSuchMethodException(string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (!Call.hasMethodOfName(clazz, string)) {
                throw new JessException("call", "No method named '" + string + "' found", "in class " + clazz.getName());
            }
            throw new JessException("call", "No overloading of method '" + string + "'", "in class " + clazz.getName() + " I can call with these arguments: " + valueVector.toStringWithParens());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof JessException) {
                throw (JessException)invocationTargetException.getTargetException();
            }
            throw new JessException("call", "Called method threw an exception", invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JessException("call", "Method is not accessible", illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JessException("call", "Invalid argument to " + string, illegalArgumentException);
        }
    }

    static boolean hasMethodOfName(Class clazz, String string) {
        Method[] methodArray = Call.getMethods(clazz);
        return Arrays.binarySearch(methodArray, string, MethodNameComparator.getInstance()) > -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

