/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import jess.ConditionalElementX;
import jess.Context;
import jess.Fact;
import jess.JessException;
import jess.Token;
import jess.Value;
import jess.ValueVector;

public class BindingValue
extends Value
implements Serializable {
    private String m_name;
    private int m_factNumber;
    private int m_slotIndex;
    private int m_subIndex;
    private int m_type;
    private ConditionalElementX m_pattern;

    BindingValue(String string, ConditionalElementX conditionalElementX, int n2, int n3, int n4, int n5) {
        this.m_name = string;
        this.m_pattern = conditionalElementX;
        this.m_factNumber = n2;
        this.m_slotIndex = n3;
        this.m_subIndex = n4;
        this.m_type = n5;
    }

    BindingValue(BindingValue bindingValue) {
        super(bindingValue);
        this.m_name = bindingValue.m_name;
        this.m_factNumber = bindingValue.m_factNumber;
        this.m_slotIndex = bindingValue.m_slotIndex;
        this.m_subIndex = bindingValue.m_subIndex;
        this.m_type = bindingValue.m_type;
        this.m_pattern = bindingValue.m_pattern;
    }

    BindingValue(String string) {
        this(string, null, -1, -1, -1, -2);
    }

    public void resetFactNumber() {
        this.m_factNumber = 0;
    }

    public String getName() {
        return this.m_name;
    }

    public int getFactNumber() {
        return this.m_factNumber;
    }

    public int getSlotIndex() {
        return this.m_slotIndex;
    }

    public int getSubIndex() {
        return this.m_subIndex;
    }

    public int getType() {
        return this.m_type;
    }

    ConditionalElementX getCE() {
        return this.m_pattern;
    }

    public Value resolveValue(Context context) throws JessException {
        if (context == null) {
            throw new JessException("BindingValue.resolveValue", "Null context ", "");
        }
        Token token = context.getToken();
        Fact fact = token == null || this.m_factNumber == token.size() ? context.getFact() : token.fact(this.m_factNumber);
        Value value = fact.get(this.m_slotIndex);
        if (this.m_subIndex == -1) {
            return value;
        }
        ValueVector valueVector = value.listValue(null);
        return valueVector.get(this.m_subIndex);
    }

    public final Object javaObjectValue(Context context) throws JessException {
        return this.resolveValue(context).javaObjectValue(context);
    }

    public final Fact factValue(Context context) throws JessException {
        return this.resolveValue(context).factValue(context);
    }

    public final ValueVector listValue(Context context) throws JessException {
        return this.resolveValue(context).listValue(context);
    }

    public final int intValue(Context context) throws JessException {
        return this.resolveValue(context).intValue(context);
    }

    public final double floatValue(Context context) throws JessException {
        return this.resolveValue(context).floatValue(context);
    }

    public final double numericValue(Context context) throws JessException {
        return this.resolveValue(context).numericValue(context);
    }

    public final String symbolValue(Context context) throws JessException {
        return this.resolveValue(context).symbolValue(context);
    }

    public final String variableValue(Context context) {
        return this.m_name;
    }

    public final String stringValue(Context context) throws JessException {
        return this.resolveValue(context).stringValue(context);
    }

    public String toString() {
        return "?" + this.m_name;
    }

    public int hashCode() {
        return this.m_factNumber + 512 * this.m_slotIndex + 262144 * this.m_subIndex;
    }

    public boolean equals(Value value) {
        if (!(value instanceof BindingValue)) {
            return false;
        }
        BindingValue bindingValue = (BindingValue)value;
        return this.m_factNumber == bindingValue.m_factNumber && this.m_slotIndex == bindingValue.m_slotIndex && this.m_subIndex == bindingValue.m_subIndex;
    }
}

