/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Serializable;
import java.net.URL;
import jess.Context;
import jess.ErrorHandler;
import jess.Funcall;
import jess.Jesp;
import jess.JessException;
import jess.Rete;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;
import jess.xml.JessSAXParser;
import org.xml.sax.InputSource;

public class Batch
implements Userfunction,
Serializable {
    public String getName() {
        return "batch";
    }

    public static Value batch(String string, Rete rete) throws JessException {
        return Batch.batch(string, rete, rete.getGlobalContext());
    }

    public static Value batch(String string, Rete rete, Context context) throws JessException {
        return Batch.batch(string, rete, context, new ErrorHandler.DefaultHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Value batch(String string, Rete rete, Context context, ErrorHandler errorHandler) throws JessException {
        Value value = Funcall.FALSE;
        PushbackReader pushbackReader = null;
        pushbackReader = Batch.findDocument(rete, string);
        if (Batch.isXMLDocument(pushbackReader)) {
            Batch.parseXMLDocument(rete, pushbackReader, errorHandler);
            value = Funcall.TRUE;
        } else {
            Jesp jesp = new Jesp(pushbackReader, rete);
            jesp.setFileName(string);
            while (true) {
                try {
                    value = jesp.parse(false, context);
                }
                catch (JessException jessException) {
                    errorHandler.handleError(jessException);
                    continue;
                }
                break;
            }
        }
        Object var9_9 = null;
        if (pushbackReader == null) return value;
        try {
            pushbackReader.close();
            return value;
        }
        catch (IOException iOException) {}
        return value;
        {
            catch (IOException iOException) {
                errorHandler.handleError(new JessException("batch", "I/O Exception", iOException));
                Object var9_10 = null;
                if (pushbackReader == null) return value;
                try {
                    pushbackReader.close();
                    return value;
                }
                catch (IOException iOException2) {}
                return value;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (pushbackReader == null) throw throwable;
            try {
                pushbackReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static void parseXMLDocument(Rete rete, PushbackReader pushbackReader, ErrorHandler errorHandler) throws JessException {
        JessSAXParser jessSAXParser = new JessSAXParser(rete);
        while (true) {
            try {
                jessSAXParser.parse(new InputSource(pushbackReader));
            }
            catch (JessException jessException) {
                errorHandler.handleError(jessException);
                continue;
            }
            break;
        }
    }

    public static PushbackReader findDocument(Rete rete, String string) throws JessException, IOException {
        PushbackReader pushbackReader;
        try {
            if (rete.getApplet() == null) {
                pushbackReader = new PushbackReader(new FileReader(string));
            } else {
                URL uRL = new URL(rete.getApplet().getDocumentBase(), string);
                pushbackReader = new PushbackReader(new InputStreamReader(uRL.openStream()));
            }
        }
        catch (Exception exception) {
            URL uRL = rete.getResource(string);
            if (uRL == null) {
                throw new JessException("batch", "Cannot open file", exception);
            }
            InputStream inputStream = uRL.openStream();
            pushbackReader = new PushbackReader(new InputStreamReader(inputStream));
        }
        return pushbackReader;
    }

    public static boolean isXMLDocument(PushbackReader pushbackReader) throws IOException {
        int n2 = pushbackReader.read();
        if (n2 != -1) {
            pushbackReader.unread(n2);
        }
        return n2 == 60;
    }

    public Value call(ValueVector valueVector, Context context) throws JessException {
        String string = valueVector.get(1).stringValue(context);
        return Batch.batch(string, context.getEngine(), context);
    }
}

