/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.PrintWriter;
import java.io.Serializable;
import jess.Context;
import jess.Defrule;
import jess.JessException;
import jess.Rete;
import jess.Token;

public class Activation
implements Serializable {
    private int m_index = -1;
    private Token m_token;
    private volatile boolean m_inactive;
    private int m_salience;
    private Defrule m_rule;
    private int m_seq;

    public final Token getToken() {
        return this.m_token;
    }

    public final Defrule getRule() {
        return this.m_rule;
    }

    Activation(Token token, Defrule defrule) {
        this.m_token = token;
        this.m_rule = defrule;
        this.m_salience = this.m_rule.getSalience();
    }

    Activation(Activation activation) {
        this(activation.m_token, activation.m_rule);
        this.m_index = activation.m_index;
    }

    public boolean isInactive() {
        return this.m_inactive;
    }

    public int getSalience() {
        return this.m_salience;
    }

    void fire(Rete rete, Context context) throws JessException {
        this.m_rule.fire(this.m_token, rete, context);
    }

    void setSequenceNumber(int n2) {
        this.m_seq = n2;
    }

    void debugPrint(PrintWriter printWriter) {
        this.m_rule.debugPrint(this.m_token, this.m_seq, printWriter);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Activation)) {
            return false;
        }
        Activation activation = (Activation)object;
        return this.m_rule == activation.m_rule && this.m_token.dataEquals(activation.m_token);
    }

    public int hashCode() {
        return this.m_rule.getName().hashCode() + this.m_token.hashCode();
    }

    boolean getAutoFocus() {
        return this.m_rule.getAutoFocus();
    }

    String getModule() {
        return this.m_rule.getModule();
    }

    void evalSalience(Rete rete) throws JessException {
        this.m_salience = this.m_rule.evalSalience(rete);
    }

    int getIndex() {
        return this.m_index;
    }

    void setIndex(int n2) {
        this.m_index = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("[Activation: ");
        stringBuffer.append(this.m_rule.getDisplayName());
        stringBuffer.append(" ");
        stringBuffer.append(this.m_token.factList());
        stringBuffer.append(" ; time=");
        stringBuffer.append(this.m_token.getTime());
        stringBuffer.append(" ; salience=");
        stringBuffer.append(this.getSalience());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

