/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

public final class Equalizer {
    public static final float BAND_NOT_PRESENT = Float.NEGATIVE_INFINITY;
    public static final Equalizer PASS_THRU_EQ = new Equalizer();
    private static final int BANDS = 32;
    private final float[] settings = new float[32];

    public Equalizer() {
    }

    public Equalizer(float[] fArray) {
        this.setFrom(fArray);
    }

    public Equalizer(EQFunction eQFunction) {
        this.setFrom(eQFunction);
    }

    public void setFrom(float[] fArray) {
        this.reset();
        int n2 = fArray.length > 32 ? 32 : fArray.length;
        int n3 = 0;
        while (n3 < n2) {
            this.settings[n3] = this.limit(fArray[n3]);
            ++n3;
        }
    }

    public void setFrom(EQFunction eQFunction) {
        this.reset();
        int n2 = 32;
        int n3 = 0;
        while (n3 < n2) {
            this.settings[n3] = this.limit(eQFunction.getBand(n3));
            ++n3;
        }
    }

    public void setFrom(Equalizer equalizer) {
        if (equalizer != this) {
            this.setFrom(equalizer.settings);
        }
    }

    public void reset() {
        int n2 = 0;
        while (n2 < 32) {
            this.settings[n2] = 0.0f;
            ++n2;
        }
    }

    public int getBandCount() {
        return this.settings.length;
    }

    public float setBand(int n2, float f2) {
        float f3 = 0.0f;
        if (n2 >= 0 && n2 < 32) {
            f3 = this.settings[n2];
            this.settings[n2] = this.limit(f2);
        }
        return f3;
    }

    public float getBand(int n2) {
        float f2 = 0.0f;
        if (n2 >= 0 && n2 < 32) {
            f2 = this.settings[n2];
        }
        return f2;
    }

    private float limit(float f2) {
        if (f2 == Float.NEGATIVE_INFINITY) {
            return f2;
        }
        if (f2 > 1.0f) {
            return 1.0f;
        }
        if (f2 < -1.0f) {
            return -1.0f;
        }
        return f2;
    }

    float[] getBandFactors() {
        float[] fArray = new float[32];
        int n2 = 0;
        int n3 = 32;
        while (n2 < n3) {
            fArray[n2] = this.getBandFactor(this.settings[n2]);
            ++n2;
        }
        return fArray;
    }

    float getBandFactor(float f2) {
        if (f2 == Float.NEGATIVE_INFINITY) {
            return 0.0f;
        }
        float f3 = (float)Math.pow(2.0, f2);
        return f3;
    }

    public static abstract class EQFunction {
        public float getBand(int n2) {
            return 0.0f;
        }
    }
}

