/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import javazoom.jl.decoder.BitstreamErrors;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Crc16;
import javazoom.jl.decoder.Header;

public final class Bitstream
implements BitstreamErrors {
    static byte INITIAL_SYNC = 0;
    static byte STRICT_SYNC = 1;
    private static final int BUFFER_INT_SIZE = 433;
    private final int[] framebuffer = new int[433];
    private int framesize;
    private byte[] frame_bytes = new byte[1732];
    private int wordpointer;
    private int bitindex;
    private int syncword;
    private boolean single_ch_mode;
    private final int[] bitmask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071};
    private final PushbackInputStream source;
    private final Header header = new Header();
    private final byte[] syncbuf = new byte[4];
    private Crc16[] crc = new Crc16[1];

    public Bitstream(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("in");
        }
        this.source = new PushbackInputStream(inputStream, 1024);
        this.closeFrame();
    }

    public void close() throws BitstreamException {
        try {
            this.source.close();
        }
        catch (IOException iOException) {
            throw this.newBitstreamException(258, iOException);
        }
    }

    public Header readFrame() throws BitstreamException {
        Header header;
        block2: {
            header = null;
            try {
                header = this.readNextFrame();
            }
            catch (BitstreamException bitstreamException) {
                if (bitstreamException.getErrorCode() == 260) break block2;
                throw this.newBitstreamException(bitstreamException.getErrorCode(), bitstreamException);
            }
        }
        return header;
    }

    private Header readNextFrame() throws BitstreamException {
        if (this.framesize == -1) {
            this.nextFrame();
        }
        return this.header;
    }

    private void nextFrame() throws BitstreamException {
        this.header.read_header(this, this.crc);
    }

    public void unreadFrame() throws BitstreamException {
        if (this.wordpointer == -1 && this.bitindex == -1 && this.framesize > 0) {
            try {
                this.source.unread(this.frame_bytes, 0, this.framesize);
            }
            catch (IOException iOException) {
                throw this.newBitstreamException(258);
            }
        }
    }

    public void closeFrame() {
        this.framesize = -1;
        this.wordpointer = -1;
        this.bitindex = -1;
    }

    public boolean isSyncCurrentPosition(int n2) throws BitstreamException {
        int n3 = this.readBytes(this.syncbuf, 0, 4);
        int n4 = this.syncbuf[0] << 24 & 0xFF000000 | this.syncbuf[1] << 16 & 0xFF0000 | this.syncbuf[2] << 8 & 0xFF00 | this.syncbuf[3] << 0 & 0xFF;
        try {
            this.source.unread(this.syncbuf, 0, n3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = false;
        switch (n3) {
            case 0: {
                bl = true;
                break;
            }
            case 4: {
                bl = this.isSyncMark(n4, n2, this.syncword);
            }
        }
        return bl;
    }

    public int readBits(int n2) {
        return this.get_bits(n2);
    }

    public int readCheckedBits(int n2) {
        return this.get_bits(n2);
    }

    protected BitstreamException newBitstreamException(int n2) {
        return new BitstreamException(n2, null);
    }

    protected BitstreamException newBitstreamException(int n2, Throwable throwable) {
        return new BitstreamException(n2, throwable);
    }

    int syncHeader(byte by) throws BitstreamException {
        boolean bl;
        int n2 = this.readBytes(this.syncbuf, 0, 3);
        if (n2 != 3) {
            throw this.newBitstreamException(260, null);
        }
        int n3 = this.syncbuf[0] << 16 & 0xFF0000 | this.syncbuf[1] << 8 & 0xFF00 | this.syncbuf[2] << 0 & 0xFF;
        do {
            n3 <<= 8;
            if (this.readBytes(this.syncbuf, 3, 1) == 1) continue;
            throw this.newBitstreamException(260, null);
        } while (!(bl = this.isSyncMark(n3 |= this.syncbuf[3] & 0xFF, by, this.syncword)));
        return n3;
    }

    public boolean isSyncMark(int n2, int n3, int n4) {
        boolean bl = false;
        if (n3 == INITIAL_SYNC) {
            bl = (n2 & 0xFFE00000) == -2097152;
        } else {
            boolean bl2 = (n2 & 0xFFF80C00) == n4 && (n2 & 0xC0) == 192 == this.single_ch_mode ? true : (bl = false);
        }
        if (bl) {
            boolean bl3 = bl = (n2 >>> 10 & 3) != 3;
        }
        if (bl) {
            boolean bl4 = bl = (n2 >>> 17 & 3) != 0;
        }
        if (bl) {
            bl = (n2 >>> 19 & 3) != 1;
        }
        return bl;
    }

    void read_frame_data(int n2) throws BitstreamException {
        boolean bl = false;
        this.readFully(this.frame_bytes, 0, n2);
        this.framesize = n2;
        this.wordpointer = -1;
        this.bitindex = -1;
    }

    void parse_frame() throws BitstreamException {
        int n2 = 0;
        byte[] byArray = this.frame_bytes;
        int n3 = this.framesize;
        int n4 = 0;
        while (n4 < n3) {
            boolean bl = false;
            byte by = 0;
            byte by2 = 0;
            byte by3 = 0;
            byte by4 = 0;
            by = byArray[n4];
            if (n4 + 1 < n3) {
                by2 = byArray[n4 + 1];
            }
            if (n4 + 2 < n3) {
                by3 = byArray[n4 + 2];
            }
            if (n4 + 3 < n3) {
                by4 = byArray[n4 + 3];
            }
            this.framebuffer[n2++] = by << 24 & 0xFF000000 | by2 << 16 & 0xFF0000 | by3 << 8 & 0xFF00 | by4 & 0xFF;
            n4 += 4;
        }
        this.wordpointer = 0;
        this.bitindex = 0;
    }

    public int get_bits(int n2) {
        int n3 = 0;
        int n4 = this.bitindex + n2;
        if (this.wordpointer < 0) {
            this.wordpointer = 0;
        }
        if (n4 <= 32) {
            n3 = this.framebuffer[this.wordpointer] >>> 32 - n4 & this.bitmask[n2];
            if ((this.bitindex += n2) == 32) {
                this.bitindex = 0;
                ++this.wordpointer;
            }
            return n3;
        }
        int n5 = this.framebuffer[this.wordpointer] & 0xFFFF;
        ++this.wordpointer;
        int n6 = this.framebuffer[this.wordpointer] & 0xFFFF0000;
        n3 = n5 << 16 & 0xFFFF0000 | n6 >>> 16 & 0xFFFF;
        n3 >>>= 48 - n4;
        this.bitindex = n4 - 32;
        return n3 &= this.bitmask[n2];
    }

    void set_syncword(int n2) {
        this.syncword = n2 & 0xFFFFFF3F;
        this.single_ch_mode = (n2 & 0xC0) == 192;
    }

    private void readFully(byte[] byArray, int n2, int n3) throws BitstreamException {
        try {
            while (n3 > 0) {
                int n4 = this.source.read(byArray, n2, n3);
                if (n4 == -1) {
                    while (n3-- > 0) {
                        byArray[n2++] = 0;
                    }
                    break;
                }
                n2 += n4;
                n3 -= n4;
            }
        }
        catch (IOException iOException) {
            throw this.newBitstreamException(258, iOException);
        }
    }

    private int readBytes(byte[] byArray, int n2, int n3) throws BitstreamException {
        int n4 = 0;
        try {
            while (n3 > 0) {
                int n5 = this.source.read(byArray, n2, n3);
                if (n5 != -1) {
                    n4 += n5;
                    n2 += n5;
                    n3 -= n5;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw this.newBitstreamException(258, iOException);
        }
        return n4;
    }
}

