/*
 * Decompiled with CFR 0.152.
 */
package javax.speech.synthesis;

public class Voice
implements Cloneable {
    public static final int GENDER_DONT_CARE = 65535;
    public static final int GENDER_FEMALE = 1;
    public static final int GENDER_MALE = 2;
    public static final int GENDER_NEUTRAL = 4;
    public static final int AGE_DONT_CARE = 65535;
    public static final int AGE_CHILD = 1;
    public static final int AGE_TEENAGER = 2;
    public static final int AGE_YOUNGER_ADULT = 4;
    public static final int AGE_MIDDLE_ADULT = 8;
    public static final int AGE_OLDER_ADULT = 16;
    public static final int AGE_NEUTRAL = 32;
    protected String name;
    protected String style;
    protected int age;
    protected int gender;

    public String toString() {
        String string = String.valueOf(super.toString()) + " [ name=\"" + this.name + "\", ";
        switch (this.age) {
            case 1: {
                string = String.valueOf(string) + "AGE_CHILD";
                break;
            }
            case 65535: {
                string = String.valueOf(string) + "AGE_DONT_CARE";
                break;
            }
            case 8: {
                string = String.valueOf(string) + "AGE_MIDDLE_ADULT";
                break;
            }
            case 32: {
                string = String.valueOf(string) + "AGE_NEUTRAL";
                break;
            }
            case 16: {
                string = String.valueOf(string) + "AGE_OLDER_ADULT";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "AGE_TEENAGER";
                break;
            }
            case 4: {
                string = String.valueOf(string) + "AGE_YOUNGER_ADULT";
            }
        }
        string = String.valueOf(string) + ", ";
        switch (this.gender) {
            case 65535: {
                string = String.valueOf(string) + "GENDER_DONT_CARE";
                break;
            }
            case 1: {
                string = String.valueOf(string) + "GENDER_FEMALE";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "GENDER_MALE";
                break;
            }
            case 4: {
                string = String.valueOf(string) + "GENDER_NEUTRAL";
            }
        }
        string = String.valueOf(string) + ", style=" + this.style;
        return String.valueOf(string) + " ]";
    }

    public Voice() {
        this.style = null;
        this.name = null;
        this.age = 65535;
        this.gender = 65535;
    }

    public Voice(String string, int n2, int n3, String string2) {
        this.name = string;
        this.gender = n2;
        this.age = n3;
        this.style = string2;
    }

    public Object clone() {
        return new Voice(this.name, this.gender, this.age, this.style);
    }

    public boolean equals(Object object) {
        Voice voice = (Voice)object;
        return voice != null && voice.getAge() == this.age && voice.getGender() == this.gender && voice.getStyle().equals(this.style) && voice.getName().equals(this.name);
    }

    public int getAge() {
        return this.age;
    }

    public int getGender() {
        return this.gender;
    }

    public String getName() {
        return this.name;
    }

    public String getStyle() {
        return this.style;
    }

    public boolean match(Voice voice) {
        if (voice == null) {
            return true;
        }
        return !(voice.getAge() != 65535 && voice.getAge() != this.age || voice.getGender() != 65535 && voice.getGender() != this.gender || voice.getName() != null && !voice.getName().equals("") && this.name.indexOf(voice.getName()) < 0 || voice.getStyle() != null && !voice.getStyle().equals("") && !voice.getStyle().equals(this.style));
    }

    public void setAge(int n2) {
        this.age = n2;
    }

    public void setGender(int n2) {
        this.gender = n2;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setStyle(String string) {
        this.style = string;
    }
}

