/*
 * Decompiled with CFR 0.152.
 */
package javax.speech.recognition;

import java.util.Vector;
import javax.speech.recognition.Rule;
import javax.speech.recognition.RuleToken;

public class RuleAlternatives
extends Rule {
    protected Rule[] rules;
    protected float[] weights = null;

    public RuleAlternatives(Rule[] ruleArray, float[] fArray) {
        this.weights = fArray;
        this.rules = ruleArray;
    }

    public RuleAlternatives(Rule[] ruleArray) {
        this.rules = ruleArray;
    }

    public RuleAlternatives(Rule rule) {
        this.rules = new Rule[1];
        this.rules[0] = rule;
    }

    public RuleAlternatives() {
        this.rules = new Rule[0];
    }

    public RuleAlternatives(String[] stringArray) {
        this.rules = new Rule[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.rules[n2] = new RuleToken(stringArray[n2]);
            ++n2;
        }
    }

    public void append(Rule rule) {
        int n2 = this.rules.length;
        Rule[] ruleArray = new Rule[n2 + 1];
        System.arraycopy(this.rules, 0, ruleArray, 0, n2);
        this.rules = ruleArray;
        this.rules[n2] = rule;
    }

    public Rule copy() {
        RuleAlternatives ruleAlternatives = new RuleAlternatives();
        int n2 = 0;
        while (n2 < this.rules.length) {
            ruleAlternatives.append(this.rules[n2].copy());
            ++n2;
        }
        if (this.weights != null) {
            float[] fArray = new float[this.weights.length];
            System.arraycopy(this.weights, 0, fArray, 0, this.weights.length);
            ruleAlternatives.setWeights(fArray);
        }
        return ruleAlternatives;
    }

    public Rule[] getRules() {
        return this.rules;
    }

    public float[] getWeights() {
        return this.weights;
    }

    public void setRules(Rule[] ruleArray) {
        this.rules = ruleArray;
    }

    public void setWeights(float[] fArray) {
        this.weights = fArray;
    }

    public String toString() {
        String string = "( ";
        int n2 = 0;
        while (n2 < this.rules.length) {
            string = String.valueOf(string) + this.rules[n2].toString();
            if (n2 != this.rules.length - 1) {
                string = String.valueOf(string) + " | ";
            }
            ++n2;
        }
        return String.valueOf(string) + " ) ";
    }

    protected void getTagVector(Vector vector) {
        int n2 = 0;
        while (n2 < this.rules.length) {
            this.rules[n2].getTagVector(vector);
            ++n2;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof RuleAlternatives)) {
            return false;
        }
        RuleAlternatives ruleAlternatives = (RuleAlternatives)object;
        Rule[] ruleArray = ruleAlternatives.getRules();
        if (ruleArray.length != this.rules.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.rules.length) {
            if (!this.rules[n2].equals(ruleArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

