/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.widget;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.RenderedImage;
import java.util.Vector;
import javax.media.jai.widget.ImageCanvas;
import javax.media.jai.widget.ViewportListener;

public class ScrollingImagePanel
extends ScrollPane
implements AdjustmentListener,
ComponentListener,
MouseListener,
MouseMotionListener {
    protected ImageCanvas ic;
    protected RenderedImage im;
    protected int panelWidth;
    protected int panelHeight;
    protected Vector viewportListeners = new Vector();
    protected Point moveSource;
    protected boolean beingDragged = false;
    protected Cursor defaultCursor = null;

    public ScrollingImagePanel(RenderedImage renderedImage, int n2, int n3) {
        this.im = renderedImage;
        this.panelWidth = n2;
        this.panelHeight = n3;
        this.ic = new ImageCanvas(renderedImage);
        this.getHAdjustable().addAdjustmentListener(this);
        this.getVAdjustable().addAdjustmentListener(this);
        super.setSize(n2, n3);
        this.addComponentListener(this);
        this.add("Center", this.ic);
    }

    public void addViewportListener(ViewportListener viewportListener) {
        this.viewportListeners.addElement(viewportListener);
        viewportListener.setViewport(this.getXOrigin(), this.getYOrigin(), this.panelWidth, this.panelHeight);
    }

    public void removeViewportListener(ViewportListener viewportListener) {
        this.viewportListeners.removeElement(viewportListener);
    }

    private void notifyViewportListeners(int n2, int n3, int n4, int n5) {
        int n6 = this.viewportListeners.size();
        int n7 = 0;
        while (n7 < n6) {
            ViewportListener viewportListener = (ViewportListener)this.viewportListeners.elementAt(n7);
            viewportListener.setViewport(n2, n3, n4, n5);
            ++n7;
        }
    }

    public ImageCanvas getImageCanvas() {
        return this.ic;
    }

    public int getXOrigin() {
        return this.ic.getXOrigin();
    }

    public int getYOrigin() {
        return this.ic.getYOrigin();
    }

    public void setOrigin(int n2, int n3) {
        this.ic.setOrigin(n2, n3);
        this.notifyViewportListeners(n2, n3, this.panelWidth, this.panelHeight);
    }

    public synchronized void setCenter(int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = this.im.getWidth();
        int n7 = this.im.getHeight();
        int n8 = this.getViewportSize().width;
        int n9 = this.getViewportSize().height;
        int n10 = this.getHAdjustable().getBlockIncrement();
        int n11 = this.getVAdjustable().getBlockIncrement();
        n4 = n2 < n8 - n6 / 2 ? 0 : (n2 > n6 / 2 ? n6 - n8 : n2 + (n6 - n8 - n10) / 2);
        n5 = n3 < n9 - n7 / 2 ? 0 : (n3 > n7 / 2 ? n7 - n9 : n3 + (n7 - n9 - n11) / 2);
        this.getHAdjustable().setValue(n4);
        this.getVAdjustable().setValue(n5);
        this.notifyViewportListeners(this.getXOrigin(), this.getYOrigin(), this.panelWidth, this.panelHeight);
    }

    public void set(RenderedImage renderedImage) {
        this.im = renderedImage;
        this.ic.set(renderedImage);
    }

    public int getXCenter() {
        return this.getXOrigin() + this.panelWidth / 2;
    }

    public int getYCenter() {
        return this.getYOrigin() + this.panelHeight / 2;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.panelWidth, this.panelHeight);
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        int n6 = this.getViewportSize().width;
        int n7 = this.getViewportSize().height;
        int n8 = this.im.getWidth();
        int n9 = this.im.getHeight();
        if (n6 >= n8 && n7 >= n9) {
            this.ic.setBounds(n2, n3, n4, n5);
        } else {
            this.ic.setBounds(n2, n3, n6, n7);
        }
        this.panelWidth = n4;
        this.panelHeight = n5;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.notifyViewportListeners(this.getXOrigin(), this.getYOrigin(), this.panelWidth, this.panelHeight);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    private synchronized void startDrag(Point point) {
        this.setCursor(Cursor.getPredefinedCursor(13));
        this.beingDragged = true;
        this.moveSource = point;
    }

    protected synchronized void updateDrag(Point point) {
        if (this.beingDragged) {
            int n2 = this.moveSource.x - point.x;
            int n3 = this.moveSource.y - point.y;
            this.moveSource = point;
            int n4 = this.getHAdjustable().getValue() + n2;
            int n5 = this.getVAdjustable().getValue() + n3;
            this.setOrigin(n4, n5);
        }
    }

    private synchronized void endDrag() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.beingDragged = false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.startDrag(mouseEvent.getPoint());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.updateDrag(mouseEvent.getPoint());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.endDrag();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.endDrag();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }
}

