/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.widget;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.HashSet;
import java.util.Iterator;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.widget.JaiI18N;

public class ImageCanvas
extends Canvas {
    protected RenderedImage im;
    protected SampleModel sampleModel;
    protected ColorModel colorModel;
    protected int minTileX;
    protected int maxTileX;
    protected int minTileY;
    protected int maxTileY;
    protected int tileWidth;
    protected int tileHeight;
    protected int tileGridXOffset;
    protected int tileGridYOffset;
    protected int imWidth;
    protected int imHeight;
    protected int padX;
    protected int padY;
    protected boolean drawBorder = false;
    protected int originX;
    protected int originY;
    protected int canvasWidth = 0;
    protected int canvasHeight = 0;
    private Color grayColor = new Color(192, 192, 192);
    private Color backgroundColor = null;
    private HashSet paintListeners = new HashSet();

    private synchronized void initialize() {
        Object object;
        int n2 = this.im.getMinX();
        int n3 = this.im.getMinY();
        if (n2 < 0 || n3 < 0) {
            object = new ParameterBlock();
            ((ParameterBlock)object).addSource(this.im);
            ((ParameterBlock)object).add((float)Math.max(-n2, 0));
            ((ParameterBlock)object).add((float)Math.max(-n3, 0));
            ((ParameterBlock)object).add(new InterpolationNearest());
            this.im = JAI.create("translate", (ParameterBlock)object, null);
        }
        this.sampleModel = this.im.getSampleModel();
        this.colorModel = this.im.getColorModel();
        if (this.colorModel == null) {
            this.colorModel = PlanarImage.createColorModel(this.im.getSampleModel());
            if (this.colorModel == null) {
                throw new IllegalArgumentException(JaiI18N.getString("ImageCanvas0"));
            }
        }
        if ((object = this.im.getProperty("background_color")) != Image.UndefinedProperty) {
            this.backgroundColor = (Color)object;
        }
        this.minTileX = this.im.getMinTileX();
        this.maxTileX = this.im.getMinTileX() + this.im.getNumXTiles() - 1;
        this.minTileY = this.im.getMinTileY();
        this.maxTileY = this.im.getMinTileY() + this.im.getNumYTiles() - 1;
        this.tileWidth = this.im.getTileWidth();
        this.tileHeight = this.im.getTileHeight();
        this.tileGridXOffset = this.im.getTileGridXOffset();
        this.tileGridYOffset = this.im.getTileGridYOffset();
        this.imWidth = this.im.getMinX() + this.im.getWidth();
        this.imHeight = this.im.getMinY() + this.im.getHeight();
        this.originY = 0;
        this.originX = 0;
    }

    public ImageCanvas(RenderedImage renderedImage, boolean bl) {
        this.im = renderedImage;
        this.drawBorder = bl;
        this.initialize();
    }

    public ImageCanvas(RenderedImage renderedImage) {
        this(renderedImage, false);
    }

    public void addNotify() {
        super.addNotify();
        this.initialize();
    }

    public synchronized void set(RenderedImage renderedImage) {
        this.im = renderedImage;
        this.initialize();
        this.repaint();
    }

    public void setOrigin(int n2, int n3) {
        this.padX = 0;
        this.padY = 0;
        this.originX = n2;
        this.originY = n3;
        this.repaint();
    }

    public int getXOrigin() {
        return this.originX;
    }

    public int getYOrigin() {
        return this.originY;
    }

    public int getXPad() {
        return this.padX;
    }

    public int getYPad() {
        return this.padY;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.im.getMinX() + this.im.getWidth() + (this.drawBorder ? 4 : 0), this.im.getMinY() + this.im.getHeight() + (this.drawBorder ? 4 : 0));
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        return this.getMinimumSize();
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        this.canvasWidth = n4;
        this.canvasHeight = n5;
        this.padX = Math.max((this.canvasWidth - this.imWidth - (this.drawBorder ? 4 : 0)) / 2, 0);
        this.padY = Math.max((this.canvasHeight - this.imHeight - (this.drawBorder ? 4 : 0)) / 2, 0);
    }

    private int XtoTileX(int n2) {
        return (int)Math.floor((double)(n2 - this.tileGridXOffset) / (double)this.tileWidth);
    }

    private int YtoTileY(int n2) {
        return (int)Math.floor((double)(n2 - this.tileGridYOffset) / (double)this.tileHeight);
    }

    private int TileXtoX(int n2) {
        return n2 * this.tileWidth + this.tileGridXOffset;
    }

    private int TileYtoY(int n2) {
        return n2 * this.tileHeight + this.tileGridYOffset;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        Rectangle rectangle;
        if (this.im == null) {
            return;
        }
        Graphics2D graphics2D = null;
        if (!(graphics instanceof Graphics2D)) {
            System.err.println(JaiI18N.getString("ImageCanvas1"));
            return;
        }
        graphics2D = (Graphics2D)graphics;
        Color color = graphics2D.getColor();
        if (this.drawBorder) {
            graphics.setColor(new Color(171, 171, 171));
            graphics.draw3DRect(this.padX, this.padY, this.imWidth + 3, this.imHeight + 3, true);
            graphics.draw3DRect(this.padX + 1, this.padY + 1, this.imWidth + 1, this.imHeight + 1, true);
        }
        if ((rectangle = graphics.getClipBounds()) == null) {
            rectangle = new Rectangle(0, 0, this.canvasWidth, this.canvasHeight);
        }
        int n2 = this.drawBorder ? 2 : 0;
        int n3 = this.padX + n2 - this.originX;
        int n4 = this.padY + n2 - this.originY;
        rectangle.translate(-n3, -n4);
        int n5 = this.XtoTileX(rectangle.x);
        n5 = Math.max(n5, this.minTileX);
        n5 = Math.min(n5, this.maxTileX);
        int n6 = this.XtoTileX(rectangle.x + rectangle.width - 1);
        n6 = Math.max(n6, this.minTileX);
        n6 = Math.min(n6, this.maxTileX);
        int n7 = this.YtoTileY(rectangle.y);
        n7 = Math.max(n7, this.minTileY);
        n7 = Math.min(n7, this.maxTileY);
        int n8 = this.YtoTileY(rectangle.y + rectangle.height - 1);
        n8 = Math.max(n8, this.minTileY);
        n8 = Math.min(n8, this.maxTileY);
        if (this.backgroundColor != null) {
            graphics2D.setColor(this.backgroundColor);
        } else {
            graphics2D.setColor(this.grayColor);
        }
        int n9 = this.im.getMinX();
        int n10 = this.im.getMinX() + this.im.getWidth();
        int n11 = this.im.getMinY();
        int n12 = this.im.getMinY() + this.im.getHeight();
        int n13 = rectangle.x + rectangle.width;
        int n14 = rectangle.y + rectangle.height;
        if (n9 > rectangle.x) {
            graphics2D.fillRect(rectangle.x + n3, rectangle.y + n4, n9 - rectangle.x, rectangle.height);
        }
        if (n10 < n13) {
            graphics2D.fillRect(n10 + n3, rectangle.y + n4, n13 - n10, rectangle.height);
        }
        if (n11 > rectangle.y) {
            graphics2D.fillRect(n9 + n3, rectangle.y + n4, n10 - n9, n11 - rectangle.y);
        }
        if (n12 < n14) {
            graphics2D.fillRect(n9 + n3, n12 + n4, n10 - n9, n14 - n12);
        }
        graphics2D.setClip(new Rectangle(n3 + this.im.getMinX(), n4 + this.im.getMinY(), this.im.getWidth(), this.im.getHeight()));
        Point[] pointArray = new Point[(n6 - n5 + 1) * (n8 - n7 + 1)];
        int n15 = 0;
        int n16 = n7;
        while (n16 <= n8) {
            int n17 = n5;
            while (n17 <= n6) {
                pointArray[n15++] = new Point(n17, n16);
                ++n17;
            }
            ++n16;
        }
        Raster[] rasterArray = PlanarImage.wrapRenderedImage(this.im).getTiles(pointArray);
        int n18 = rasterArray.length;
        int n19 = 0;
        while (n19 < n18) {
            Raster raster = rasterArray[n19];
            int n20 = raster.getMinX();
            int n21 = raster.getMinY();
            if (raster != null) {
                WritableRaster writableRaster = raster instanceof WritableRaster ? ((WritableRaster)raster).createWritableTranslatedChild(0, 0) : Raster.createWritableRaster(this.sampleModel, raster.getDataBuffer(), new Point(0, 0));
                BufferedImage bufferedImage = new BufferedImage(this.colorModel, writableRaster, this.colorModel.isAlphaPremultiplied(), null);
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(n20 + n3, n21 + n4);
                if (this.backgroundColor != null) {
                    graphics2D.fillRect(n20 + n3, n21 + n4, this.tileWidth, this.tileHeight);
                }
                graphics2D.drawRenderedImage(bufferedImage, affineTransform);
            }
            ++n19;
        }
        graphics2D.setColor(color);
        this.notifyPaintListeners(graphics2D);
    }

    public void addPaintListener(PaintListener paintListener) {
        this.paintListeners.add(paintListener);
    }

    public void removePaintListener(PaintListener paintListener) {
        this.paintListeners.remove(paintListener);
    }

    private void notifyPaintListeners(Graphics graphics) {
        Iterator iterator = this.paintListeners.iterator();
        while (iterator.hasNext()) {
            ((PaintListener)iterator.next()).paint(this, graphics);
        }
    }

    public static interface PaintListener {
        public void paint(ImageCanvas var1, Graphics var2);
    }
}

