/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.util;

import java.io.Serializable;
import javax.media.jai.util.JaiI18N;

public class Range
implements Serializable {
    private Class elementClass;
    private Comparable minValue;
    private Comparable maxValue;
    private boolean isMinIncluded = true;
    private boolean isMaxIncluded = true;

    public Range(Class clazz, Comparable comparable, Comparable comparable2) {
        if (comparable == null && comparable2 == null) {
            Class<?> clazz2 = null;
            try {
                clazz2 = Class.forName("java.lang.Comparable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (!clazz2.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(JaiI18N.getString("Range0"));
            }
        }
        this.elementClass = clazz;
        if (comparable != null && comparable.getClass() != this.elementClass) {
            throw new IllegalArgumentException(JaiI18N.getString("Range1"));
        }
        this.minValue = comparable;
        if (comparable2 != null && comparable2.getClass() != this.elementClass) {
            throw new IllegalArgumentException(JaiI18N.getString("Range2"));
        }
        this.maxValue = comparable2;
    }

    public Range(Class clazz, Comparable comparable, boolean bl, Comparable comparable2, boolean bl2) {
        this(clazz, comparable, comparable2);
        this.isMinIncluded = bl;
        this.isMaxIncluded = bl2;
    }

    public boolean isMinIncluded() {
        if (this.minValue == null) {
            return true;
        }
        return this.isMinIncluded;
    }

    public boolean isMaxIncluded() {
        if (this.maxValue == null) {
            return true;
        }
        return this.isMaxIncluded;
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public Comparable getMinValue() {
        return this.minValue;
    }

    public Comparable getMaxValue() {
        return this.maxValue;
    }

    public boolean contains(Comparable comparable) {
        if (comparable != null && comparable.getClass() != this.elementClass) {
            throw new IllegalArgumentException(JaiI18N.getString("Range3"));
        }
        if (this.isEmpty()) {
            return false;
        }
        return this.isUnderUpperBound(comparable) && this.isOverLowerBound(comparable);
    }

    private boolean isUnderUpperBound(Comparable comparable) {
        if (this.maxValue == null) {
            return true;
        }
        if (comparable == null) {
            return false;
        }
        if (this.isMaxIncluded) {
            return this.maxValue.compareTo(comparable) >= 0;
        }
        return this.maxValue.compareTo(comparable) > 0;
    }

    private boolean isOverLowerBound(Comparable comparable) {
        if (this.minValue == null) {
            return true;
        }
        if (comparable == null) {
            return false;
        }
        if (this.isMinIncluded) {
            return this.minValue.compareTo(comparable) <= 0;
        }
        return this.minValue.compareTo(comparable) < 0;
    }

    public boolean contains(Range range) {
        boolean bl;
        if (range == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Range5"));
        }
        if (this.elementClass != range.getElementClass()) {
            throw new IllegalArgumentException(JaiI18N.getString("Range4"));
        }
        if (range.isEmpty()) {
            return true;
        }
        Comparable comparable = range.getMinValue();
        Comparable comparable2 = range.getMaxValue();
        if (comparable2 == null) {
            bl = this.maxValue == null;
        } else {
            boolean bl2 = bl = this.isUnderUpperBound(comparable2) || this.isMaxIncluded == range.isMaxIncluded() && comparable2.equals(this.maxValue);
        }
        boolean bl3 = comparable == null ? this.minValue == null : this.isOverLowerBound(comparable) || this.isMinIncluded == range.isMinIncluded() && comparable.equals(this.minValue);
        return bl3 && bl;
    }

    public boolean intersects(Range range) {
        if (range == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Range5"));
        }
        if (this.elementClass != range.getElementClass()) {
            throw new IllegalArgumentException(JaiI18N.getString("Range4"));
        }
        return !this.intersect(range).isEmpty();
    }

    public Range union(Range range) {
        if (range == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Range5"));
        }
        if (this.elementClass != range.getElementClass()) {
            throw new IllegalArgumentException(JaiI18N.getString("Range4"));
        }
        if (this.isEmpty()) {
            return new Range(this.elementClass, range.getMinValue(), range.isMinIncluded(), range.getMaxValue(), range.isMaxIncluded());
        }
        if (range.isEmpty()) {
            return new Range(this.elementClass, this.minValue, this.isMinIncluded, this.maxValue, this.isMaxIncluded);
        }
        boolean bl = !this.isOverLowerBound(range.getMinValue());
        boolean bl2 = !this.isUnderUpperBound(range.getMaxValue());
        Comparable comparable = bl ? range.getMinValue() : this.minValue;
        Comparable comparable2 = bl2 ? range.getMaxValue() : this.maxValue;
        boolean bl3 = bl ? range.isMinIncluded() : this.isMinIncluded;
        boolean bl4 = bl2 ? range.isMaxIncluded() : this.isMaxIncluded;
        return new Range(this.elementClass, comparable, bl3, comparable2, bl4);
    }

    public Range intersect(Range range) {
        if (range == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Range5"));
        }
        if (this.elementClass != range.getElementClass()) {
            throw new IllegalArgumentException(JaiI18N.getString("Range4"));
        }
        if (this.isEmpty()) {
            Comparable comparable = this.minValue;
            if (comparable == null) {
                comparable = this.maxValue;
            }
            return new Range(this.elementClass, comparable, false, comparable, false);
        }
        if (range.isEmpty()) {
            Comparable comparable = range.getMinValue();
            if (comparable == null) {
                comparable = range.getMaxValue();
            }
            return new Range(this.elementClass, comparable, false, comparable, false);
        }
        boolean bl = !this.isOverLowerBound(range.getMinValue());
        boolean bl2 = !this.isUnderUpperBound(range.getMaxValue());
        Comparable comparable = bl ? this.minValue : range.getMinValue();
        Comparable comparable2 = bl2 ? this.maxValue : range.getMaxValue();
        boolean bl3 = bl ? this.isMinIncluded : range.isMinIncluded();
        boolean bl4 = bl2 ? this.isMaxIncluded : range.isMaxIncluded();
        return new Range(this.elementClass, comparable, bl3, comparable2, bl4);
    }

    public Range[] subtract(Range range) {
        if (range == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Range5"));
        }
        if (this.elementClass != range.getElementClass()) {
            throw new IllegalArgumentException(JaiI18N.getString("Range4"));
        }
        if (this.isEmpty() || range.isEmpty()) {
            Range[] rangeArray = new Range[]{new Range(this.elementClass, this.minValue, this.isMinIncluded, this.maxValue, this.isMaxIncluded)};
            return rangeArray;
        }
        Comparable comparable = range.getMinValue();
        Comparable comparable2 = range.getMaxValue();
        boolean bl = range.isMinIncluded();
        boolean bl2 = range.isMaxIncluded();
        if (this.minValue == null && this.maxValue == null && comparable == null && comparable2 == null) {
            Range[] rangeArray = new Range[]{null};
            return rangeArray;
        }
        boolean bl3 = this.contains(comparable);
        boolean bl4 = this.contains(comparable2);
        if (bl3 && bl4) {
            Range range2 = new Range(this.elementClass, this.minValue, this.isMinIncluded, comparable, !bl);
            Range range3 = new Range(this.elementClass, comparable2, !bl2, this.maxValue, this.isMaxIncluded);
            if (range2.isEmpty() || this.minValue == null && comparable == null) {
                Range[] rangeArray = new Range[]{range3};
                return rangeArray;
            }
            if (range3.isEmpty() || this.maxValue == null && comparable2 == null) {
                Range[] rangeArray = new Range[]{range2};
                return rangeArray;
            }
            Range[] rangeArray = new Range[]{range2, range3};
            return rangeArray;
        }
        if (bl4) {
            Range[] rangeArray = new Range[]{new Range(this.elementClass, comparable2, !bl2, this.maxValue, this.isMaxIncluded)};
            return rangeArray;
        }
        if (bl3) {
            Range[] rangeArray = new Range[]{new Range(this.elementClass, this.minValue, this.isMinIncluded, comparable, !bl)};
            return rangeArray;
        }
        if (comparable != null && !this.isUnderUpperBound(comparable) || comparable2 != null && !this.isOverLowerBound(comparable2)) {
            Range[] rangeArray = new Range[]{new Range(this.elementClass, this.minValue, this.isMinIncluded, this.maxValue, this.isMaxIncluded)};
            return rangeArray;
        }
        comparable = this.minValue == null ? this.maxValue : this.minValue;
        Range[] rangeArray = new Range[]{new Range(this.elementClass, comparable, false, comparable, false)};
        return rangeArray;
    }

    public int hashCode() {
        int n2 = this.elementClass.hashCode();
        if (this.isEmpty()) {
            return n2;
        }
        n2 ^= Integer.MAX_VALUE;
        if (this.minValue != null) {
            n2 ^= this.minValue.hashCode();
            if (this.isMinIncluded) {
                n2 ^= 0xFFFF0000;
            }
        }
        if (this.maxValue != null) {
            n2 ^= this.maxValue.hashCode() * 31;
            if (this.isMaxIncluded) {
                n2 ^= 0xFFFF;
            }
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Range)) {
            return false;
        }
        Range range = (Range)object;
        if (this.elementClass != range.getElementClass()) {
            return false;
        }
        if (this.isEmpty() && range.isEmpty()) {
            return true;
        }
        Comparable comparable = range.getMinValue();
        if (this.minValue != null) {
            if (!this.minValue.equals(comparable)) {
                return false;
            }
            if (this.isMinIncluded != range.isMinIncluded()) {
                return false;
            }
        } else if (comparable != null) {
            return false;
        }
        Comparable comparable2 = range.getMaxValue();
        if (this.maxValue != null) {
            if (!this.maxValue.equals(comparable2)) {
                return false;
            }
            if (this.isMaxIncluded != range.isMaxIncluded()) {
                return false;
            }
        } else if (comparable2 != null) {
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        if (this.minValue == null || this.maxValue == null) {
            return false;
        }
        int n2 = this.minValue.compareTo(this.maxValue);
        if (n2 > 0) {
            return true;
        }
        if (n2 == 0) {
            return !(this.isMinIncluded & this.isMaxIncluded);
        }
        return false;
    }

    public String toString() {
        char c2;
        char c3 = this.isMinIncluded ? (char)'[' : '(';
        char c4 = c2 = this.isMaxIncluded ? (char)']' : ')';
        if (this.minValue != null && this.maxValue != null) {
            return new String(c3 + this.minValue.toString() + ", " + this.maxValue.toString() + c2);
        }
        if (this.maxValue != null) {
            return new String(c3 + "---, " + this.maxValue.toString() + c2);
        }
        if (this.minValue != null) {
            return new String(c3 + this.minValue.toString() + ", " + "---" + c2);
        }
        return new String(c3 + "---, ---" + c2);
    }
}

