/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.remote;

import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PropertyChangeEventJAI;
import javax.media.jai.RegistryMode;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.WritablePropertySource;
import javax.media.jai.registry.RemoteCRIFRegistry;
import javax.media.jai.remote.JaiI18N;
import javax.media.jai.remote.NegotiableCapability;
import javax.media.jai.remote.NegotiableCapabilitySet;
import javax.media.jai.remote.RemoteCRIF;
import javax.media.jai.remote.RemoteDescriptor;
import javax.media.jai.remote.RemoteImagingException;
import javax.media.jai.remote.RemoteJAI;
import javax.media.jai.remote.RemoteRIF;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public class RemoteRenderableOp
extends RenderableOp {
    protected String protocolName;
    protected String serverName;
    private transient RemoteCRIF remoteCRIF = null;
    private NegotiableCapabilitySet negotiated = null;
    private transient RenderedImage linkToRemoteOp;
    static /* synthetic */ Class class$javax$media$jai$remote$RemoteDescriptor;

    public RemoteRenderableOp(String string, String string2, String string3, ParameterBlock parameterBlock) {
        this(null, string, string2, string3, parameterBlock);
    }

    public RemoteRenderableOp(OperationRegistry operationRegistry, String string, String string2, String string3, ParameterBlock parameterBlock) {
        super(operationRegistry, string3, parameterBlock);
        if (string == null || string3 == null) {
            throw new IllegalArgumentException();
        }
        this.protocolName = string;
        this.serverName = string2;
    }

    public String getRegistryModeName() {
        return RegistryMode.getMode("remoteRenderable").getName();
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic2"));
        }
        if (string.equalsIgnoreCase(this.serverName)) {
            return;
        }
        String string2 = this.serverName;
        this.serverName = string;
        this.fireEvent("ServerName", string2, string);
        this.nodeSupport.resetPropertyEnvironment(false);
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public void setProtocolName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        if (string.equalsIgnoreCase(this.protocolName)) {
            return;
        }
        String string2 = this.protocolName;
        this.protocolName = string;
        this.fireEvent("ProtocolName", string2, string);
        this.nodeSupport.resetPropertyEnvironment(false);
    }

    public void setProtocolAndServerNames(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic2"));
        }
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        boolean bl = string.equalsIgnoreCase(this.protocolName);
        boolean bl2 = string2.equalsIgnoreCase(this.serverName);
        if (bl) {
            if (bl2) {
                return;
            }
            this.setServerName(string2);
            return;
        }
        if (bl2) {
            this.setProtocolName(string);
            return;
        }
        String string3 = this.protocolName;
        String string4 = this.serverName;
        this.protocolName = string;
        this.serverName = string2;
        this.fireEvent("ProtocolAndServerName", new String[]{string3, string4}, new String[]{string, string2});
        this.nodeSupport.resetPropertyEnvironment(false);
    }

    private void fireEvent(String string, Object object, Object object2) {
        if (this.eventManager != null) {
            Object object3 = this.eventManager.getPropertyChangeEventSource();
            PropertyChangeEventJAI propertyChangeEventJAI = new PropertyChangeEventJAI(object3, string, object, object2);
            this.eventManager.firePropertyChange(propertyChangeEventJAI);
        }
    }

    public float getWidth() {
        this.findRemoteCRIF();
        Rectangle2D rectangle2D = this.remoteCRIF.getBounds2D(this.serverName, this.nodeSupport.getOperationName(), this.nodeSupport.getParameterBlock());
        return (float)rectangle2D.getWidth();
    }

    public float getHeight() {
        this.findRemoteCRIF();
        Rectangle2D rectangle2D = this.remoteCRIF.getBounds2D(this.serverName, this.nodeSupport.getOperationName(), this.nodeSupport.getParameterBlock());
        return (float)rectangle2D.getHeight();
    }

    public float getMinX() {
        this.findRemoteCRIF();
        Rectangle2D rectangle2D = this.remoteCRIF.getBounds2D(this.serverName, this.nodeSupport.getOperationName(), this.nodeSupport.getParameterBlock());
        return (float)rectangle2D.getX();
    }

    public float getMinY() {
        this.findRemoteCRIF();
        Rectangle2D rectangle2D = this.remoteCRIF.getBounds2D(this.serverName, this.nodeSupport.getOperationName(), this.nodeSupport.getParameterBlock());
        return (float)rectangle2D.getY();
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Object object;
        Cloneable cloneable;
        this.findRemoteCRIF();
        ParameterBlock parameterBlock = (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
        RenderContext renderContext2 = renderContext;
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        if (renderingHints != null) {
            cloneable = renderContext.getRenderingHints();
            if (cloneable == null) {
                object = renderingHints;
            } else if (renderingHints == null || renderingHints.isEmpty()) {
                object = cloneable;
            } else {
                object = new RenderingHints(renderingHints);
                ((RenderingHints)object).add((RenderingHints)cloneable);
            }
            if (object != cloneable) {
                renderContext2 = new RenderContext(renderContext.getTransform(), renderContext.getAreaOfInterest(), (RenderingHints)object);
            }
        }
        cloneable = this.nodeSupport.getParameterBlock().getSources();
        try {
            String[] stringArray;
            Object object2;
            Object object3;
            Object object4;
            if (cloneable != null) {
                object = new Vector();
                int n2 = 0;
                while (n2 < ((Vector)cloneable).size()) {
                    object4 = null;
                    Object e2 = ((Vector)cloneable).elementAt(n2);
                    if (e2 instanceof RenderableImage) {
                        object3 = this.remoteCRIF.mapRenderContext(this.serverName, this.nodeSupport.getOperationName(), n2, renderContext, this.nodeSupport.getParameterBlock(), this);
                        object2 = (RenderableImage)e2;
                        object4 = object2.createRendering((RenderContext)object3);
                    } else if (e2 instanceof RenderedOp) {
                        object4 = ((RenderedOp)e2).getRendering();
                    } else if (e2 instanceof RenderedImage) {
                        object4 = (RenderedImage)e2;
                    }
                    if (object4 == null) {
                        return null;
                    }
                    ((Vector)object).addElement(object4);
                    ++n2;
                }
                if (((Vector)object).size() > 0) {
                    parameterBlock.setSources((Vector<Object>)object);
                }
            }
            if ((object = this.remoteCRIF.create(this.serverName, this.nodeSupport.getOperationName(), renderContext, parameterBlock)) instanceof RenderedOp) {
                object = ((RenderedOp)object).getRendering();
            }
            this.linkToRemoteOp = object;
            if (object != null && object instanceof WritablePropertySource && (stringArray = this.getPropertyNames()) != null) {
                object4 = (WritablePropertySource)object;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    object3 = stringArray[n3];
                    object2 = this.getProperty((String)object3);
                    if (object2 != null && object2 != Image.UndefinedProperty) {
                        object4.setProperty((String)object3, object2);
                    }
                    ++n3;
                }
            }
            return object;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private RemoteCRIF findRemoteCRIF() {
        if (this.remoteCRIF == null) {
            this.remoteCRIF = RemoteCRIFRegistry.get(this.nodeSupport.getRegistry(), this.protocolName);
            if (this.remoteCRIF == null) {
                throw new ImagingException(JaiI18N.getString("RemoteRenderableOp0"));
            }
        }
        return this.remoteCRIF;
    }

    public int getRetryInterval() {
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        if (renderingHints == null) {
            return 1000;
        }
        Integer n2 = (Integer)renderingHints.get(JAI.KEY_RETRY_INTERVAL);
        if (n2 == null) {
            return 1000;
        }
        return n2;
    }

    public void setRetryInterval(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic3"));
        }
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        if (renderingHints == null) {
            RenderingHints renderingHints2 = new RenderingHints(null);
            this.nodeSupport.setRenderingHints(renderingHints2);
        }
        this.nodeSupport.getRenderingHints().put(JAI.KEY_RETRY_INTERVAL, new Integer(n2));
    }

    public int getNumRetries() {
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        if (renderingHints == null) {
            return 5;
        }
        Integer n2 = (Integer)renderingHints.get(JAI.KEY_NUM_RETRIES);
        if (n2 == null) {
            return 5;
        }
        return n2;
    }

    public void setNumRetries(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic4"));
        }
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        if (renderingHints == null) {
            RenderingHints renderingHints2 = new RenderingHints(null);
            this.nodeSupport.setRenderingHints(renderingHints2);
        }
        this.nodeSupport.getRenderingHints().put(JAI.KEY_NUM_RETRIES, new Integer(n2));
    }

    public NegotiableCapabilitySet getNegotiationPreferences() {
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        NegotiableCapabilitySet negotiableCapabilitySet = renderingHints == null ? null : (NegotiableCapabilitySet)renderingHints.get(JAI.KEY_NEGOTIATION_PREFERENCES);
        return negotiableCapabilitySet;
    }

    public void setNegotiationPreferences(NegotiableCapabilitySet negotiableCapabilitySet) {
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        if (negotiableCapabilitySet != null) {
            if (renderingHints == null) {
                RenderingHints renderingHints2 = new RenderingHints(null);
                this.nodeSupport.setRenderingHints(renderingHints2);
            }
            this.nodeSupport.getRenderingHints().put(JAI.KEY_NEGOTIATION_PREFERENCES, negotiableCapabilitySet);
        } else if (renderingHints != null) {
            renderingHints.remove(JAI.KEY_NEGOTIATION_PREFERENCES);
        }
        this.negotiated = this.negotiate(negotiableCapabilitySet);
    }

    private NegotiableCapabilitySet negotiate(NegotiableCapabilitySet negotiableCapabilitySet) {
        OperationRegistry operationRegistry = this.nodeSupport.getRegistry();
        NegotiableCapabilitySet negotiableCapabilitySet2 = null;
        RemoteDescriptor remoteDescriptor = (RemoteDescriptor)operationRegistry.getDescriptor(class$javax$media$jai$remote$RemoteDescriptor == null ? (class$javax$media$jai$remote$RemoteDescriptor = RemoteRenderableOp.class$("javax.media.jai.remote.RemoteDescriptor")) : class$javax$media$jai$remote$RemoteDescriptor, this.protocolName);
        if (remoteDescriptor == null) {
            Object[] objectArray = new Object[]{new String(this.protocolName)};
            MessageFormat messageFormat = new MessageFormat("");
            messageFormat.setLocale(Locale.getDefault());
            messageFormat.applyPattern(JaiI18N.getString("RemoteJAI16"));
            throw new RuntimeException(messageFormat.format(objectArray));
        }
        int n2 = 0;
        int n3 = this.getNumRetries();
        int n4 = this.getRetryInterval();
        RemoteImagingException remoteImagingException = null;
        while (n2++ < n3) {
            try {
                negotiableCapabilitySet2 = remoteDescriptor.getServerCapabilities(this.serverName);
                break;
            }
            catch (RemoteImagingException remoteImagingException2) {
                System.err.println(JaiI18N.getString("RemoteJAI24"));
                remoteImagingException = remoteImagingException2;
                try {
                    Thread.sleep(n4);
                }
                catch (InterruptedException interruptedException) {
                    this.sendExceptionToListener(JaiI18N.getString("Generic5"), new ImagingException(JaiI18N.getString("Generic5"), interruptedException));
                }
            }
        }
        if (negotiableCapabilitySet2 == null && n2 > n3) {
            this.sendExceptionToListener(JaiI18N.getString("RemoteJAI18"), remoteImagingException);
        }
        RemoteRIF remoteRIF = (RemoteRIF)operationRegistry.getFactory("remoteRenderable", this.protocolName);
        return RemoteJAI.negotiate(negotiableCapabilitySet, negotiableCapabilitySet2, remoteRIF.getClientCapabilities());
    }

    public NegotiableCapabilitySet getNegotiatedValues() throws RemoteImagingException {
        return this.negotiated;
    }

    public NegotiableCapability getNegotiatedValues(String string) throws RemoteImagingException {
        if (this.negotiated != null) {
            return this.negotiated.getNegotiatedValue(string);
        }
        return null;
    }

    void sendExceptionToListener(String string, Exception exception) {
        ImagingListener imagingListener = (ImagingListener)this.getRenderingHints().get(JAI.KEY_IMAGING_LISTENER);
        imagingListener.errorOccurred(string, exception, this, false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

