/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.remote;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.jai.remote.JaiI18N;
import javax.media.jai.remote.NegotiableCapability;
import javax.media.jai.util.CaselessStringKey;

public class NegotiableCapabilitySet
implements Serializable {
    private Hashtable categories = new Hashtable();
    private boolean isPreference = false;

    public NegotiableCapabilitySet(boolean bl) {
        this.isPreference = bl;
    }

    public boolean isPreference() {
        return this.isPreference;
    }

    public void add(NegotiableCapability negotiableCapability) {
        if (negotiableCapability == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet0"));
        }
        if (this.isPreference != negotiableCapability.isPreference()) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet1"));
        }
        SequentialMap sequentialMap = this.getCategoryMap(negotiableCapability.getCategory());
        sequentialMap.put(negotiableCapability);
    }

    public void remove(NegotiableCapability negotiableCapability) {
        if (negotiableCapability == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet0"));
        }
        SequentialMap sequentialMap = this.getCategoryMap(negotiableCapability.getCategory());
        sequentialMap.remove(negotiableCapability);
    }

    public List get(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet3"));
        }
        if (string2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet4"));
        }
        SequentialMap sequentialMap = this.getCategoryMap(string);
        return sequentialMap.getNCList(string2);
    }

    public List get(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet3"));
        }
        SequentialMap sequentialMap = this.getCategoryMap(string);
        Vector vector = sequentialMap.getCapabilityNames();
        Vector vector2 = new Vector();
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            Vector vector3 = (Vector)sequentialMap.getNCList((String)iterator.next());
            Iterator iterator2 = ((AbstractList)vector3).iterator();
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                if (vector2.contains(e2)) continue;
                vector2.add(e2);
            }
        }
        return vector2;
    }

    public List getCategories() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.categories.keys();
        while (enumeration.hasMoreElements()) {
            CaselessStringKey caselessStringKey = (CaselessStringKey)enumeration.nextElement();
            vector.add(caselessStringKey.toString());
        }
        return vector;
    }

    public List getCapabilityNames(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet3"));
        }
        SequentialMap sequentialMap = this.getCategoryMap(string);
        Vector vector = sequentialMap.getCapabilityNames();
        return vector;
    }

    public NegotiableCapabilitySet negotiate(NegotiableCapabilitySet negotiableCapabilitySet) {
        if (negotiableCapabilitySet == null) {
            return null;
        }
        NegotiableCapabilitySet negotiableCapabilitySet2 = new NegotiableCapabilitySet(this.isPreference & negotiableCapabilitySet.isPreference());
        Vector vector = new Vector(this.getCategories());
        vector.retainAll(negotiableCapabilitySet.getCategories());
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = this.get(string);
            List list2 = negotiableCapabilitySet.get(string);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                NegotiableCapability negotiableCapability = (NegotiableCapability)iterator2.next();
                Iterator iterator3 = list2.iterator();
                while (iterator3.hasNext()) {
                    NegotiableCapability negotiableCapability2 = (NegotiableCapability)iterator3.next();
                    NegotiableCapability negotiableCapability3 = negotiableCapability.negotiate(negotiableCapability2);
                    if (negotiableCapability3 == null) continue;
                    negotiableCapabilitySet2.add(negotiableCapability3);
                }
            }
        }
        if (negotiableCapabilitySet2.isEmpty()) {
            return null;
        }
        return negotiableCapabilitySet2;
    }

    public NegotiableCapability getNegotiatedValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet3"));
        }
        List list = this.get(string);
        if (list.isEmpty()) {
            return null;
        }
        return (NegotiableCapability)list.get(0);
    }

    public NegotiableCapability getNegotiatedValue(NegotiableCapabilitySet negotiableCapabilitySet, String string) {
        if (negotiableCapabilitySet == null) {
            return null;
        }
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet3"));
        }
        List list = this.get(string);
        List list2 = negotiableCapabilitySet.get(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NegotiableCapability negotiableCapability = (NegotiableCapability)iterator.next();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                NegotiableCapability negotiableCapability2 = (NegotiableCapability)iterator2.next();
                NegotiableCapability negotiableCapability3 = negotiableCapability.negotiate(negotiableCapability2);
                if (negotiableCapability3 == null) continue;
                return negotiableCapability3;
            }
        }
        return null;
    }

    public boolean isEmpty() {
        return this.categories.isEmpty();
    }

    private SequentialMap getCategoryMap(String string) {
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        SequentialMap sequentialMap = (SequentialMap)this.categories.get(caselessStringKey);
        if (sequentialMap == null) {
            sequentialMap = new SequentialMap();
            this.categories.put(caselessStringKey, sequentialMap);
        }
        return sequentialMap;
    }

    class SequentialMap
    implements Serializable {
        Vector keys = new Vector();
        Vector values = new Vector();

        SequentialMap() {
        }

        void put(NegotiableCapability negotiableCapability) {
            CaselessStringKey caselessStringKey = new CaselessStringKey(negotiableCapability.getCapabilityName());
            int n2 = this.keys.indexOf(caselessStringKey);
            if (n2 == -1) {
                this.keys.add(caselessStringKey);
                Vector<NegotiableCapability> vector = new Vector<NegotiableCapability>();
                vector.add(negotiableCapability);
                this.values.add(vector);
            } else {
                Vector<NegotiableCapability> vector = (Vector<NegotiableCapability>)this.values.elementAt(n2);
                if (vector == null) {
                    vector = new Vector<NegotiableCapability>();
                }
                vector.add(negotiableCapability);
            }
        }

        List getNCList(String string) {
            CaselessStringKey caselessStringKey = new CaselessStringKey(string);
            int n2 = this.keys.indexOf(caselessStringKey);
            if (n2 == -1) {
                Vector vector = new Vector();
                return vector;
            }
            Vector vector = (Vector)this.values.elementAt(n2);
            return vector;
        }

        void remove(NegotiableCapability negotiableCapability) {
            CaselessStringKey caselessStringKey = new CaselessStringKey(negotiableCapability.getCapabilityName());
            int n2 = this.keys.indexOf(caselessStringKey);
            if (n2 == -1) {
                throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet2"));
            }
            Vector vector = (Vector)this.values.elementAt(n2);
            if (!vector.remove(negotiableCapability)) {
                throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet2"));
            }
            if (vector.isEmpty()) {
                this.keys.remove(caselessStringKey);
                this.values.remove(n2);
            }
            if (this.keys.isEmpty()) {
                NegotiableCapabilitySet.this.categories.remove(new CaselessStringKey(negotiableCapability.getCategory()));
            }
        }

        Vector getCapabilityNames() {
            Vector<String> vector = new Vector<String>();
            Iterator iterator = ((AbstractList)this.keys).iterator();
            while (iterator.hasNext()) {
                CaselessStringKey caselessStringKey = (CaselessStringKey)iterator.next();
                vector.add(caselessStringKey.getName());
            }
            return vector;
        }
    }
}

