/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Map;
import javax.media.jai.JaiI18N;
import javax.media.jai.PropertyChangeSupportJAI;
import javax.media.jai.PropertySource;
import javax.media.jai.PropertySourceChangeEvent;
import javax.media.jai.PropertySourceImpl;
import javax.media.jai.WritablePropertySource;
import javax.media.jai.util.CaselessStringKey;

public class WritablePropertySourceImpl
extends PropertySourceImpl
implements WritablePropertySource {
    protected PropertyChangeSupportJAI manager = null;

    public WritablePropertySourceImpl() {
    }

    public WritablePropertySourceImpl(Map map, PropertySource propertySource, PropertyChangeSupportJAI propertyChangeSupportJAI) {
        super(map, propertySource);
        this.manager = propertyChangeSupportJAI;
    }

    public Object getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Map map = this.properties;
        synchronized (map) {
            Object object;
            boolean bl = this.properties.containsKey(new CaselessStringKey(string));
            Object object2 = super.getProperty(string);
            if (this.manager != null && !bl && object2 != Image.UndefinedProperty) {
                object = this.manager.getPropertyChangeEventSource();
                PropertySourceChangeEvent propertySourceChangeEvent = new PropertySourceChangeEvent(object, string, Image.UndefinedProperty, object2);
                this.manager.firePropertyChange(propertySourceChangeEvent);
            }
            object = object2;
            return object;
        }
    }

    public void setProperty(String string, Object object) {
        if (string == null || object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Map map = this.properties;
        synchronized (map) {
            CaselessStringKey caselessStringKey = new CaselessStringKey(string);
            Object object2 = this.properties.put(caselessStringKey, object);
            if (object2 == null) {
                object2 = Image.UndefinedProperty;
            }
            this.cachedPropertyNames.remove(caselessStringKey);
            if (this.manager != null && !object2.equals(object)) {
                Object object3 = this.manager.getPropertyChangeEventSource();
                PropertySourceChangeEvent propertySourceChangeEvent = new PropertySourceChangeEvent(object3, string, object2, object);
                this.manager.firePropertyChange(propertySourceChangeEvent);
            }
        }
    }

    public void removeProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Map map = this.properties;
        synchronized (map) {
            CaselessStringKey caselessStringKey = new CaselessStringKey(string);
            Object v2 = this.properties.remove(caselessStringKey);
            this.propertySources.remove(caselessStringKey);
            this.cachedPropertyNames.remove(caselessStringKey);
            if (this.manager != null && v2 != null) {
                Object object = this.manager.getPropertyChangeEventSource();
                PropertySourceChangeEvent propertySourceChangeEvent = new PropertySourceChangeEvent(object, string, v2, Image.UndefinedProperty);
                this.manager.firePropertyChange(propertySourceChangeEvent);
            }
        }
    }

    public void addProperties(Map map) {
        if (map != null) {
            Map map2 = this.properties;
            synchronized (map2) {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k2 = iterator.next();
                    if (k2 instanceof String) {
                        this.setProperty((String)k2, map.get(k2));
                        continue;
                    }
                    if (!(k2 instanceof CaselessStringKey)) continue;
                    this.setProperty(((CaselessStringKey)k2).getName(), map.get(k2));
                }
            }
        }
    }

    public void addProperties(PropertySource propertySource) {
        if (propertySource != null) {
            Map map = this.properties;
            synchronized (map) {
                String[] stringArray = propertySource.getPropertyNames();
                if (stringArray != null) {
                    int n2 = stringArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        this.propertySources.put(new CaselessStringKey(stringArray[n3]), propertySource);
                        ++n3;
                    }
                }
            }
        }
    }

    public void clearProperties() {
        Map map = this.properties;
        synchronized (map) {
            String[] stringArray = this.getPropertyNames();
            if (stringArray != null) {
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    this.removeProperty(stringArray[n3]);
                    ++n3;
                }
            }
        }
    }

    public void clearPropertyMap() {
        Map map = this.properties;
        synchronized (map) {
            Iterator iterator = this.properties.keySet().iterator();
            while (iterator.hasNext()) {
                CaselessStringKey caselessStringKey = (CaselessStringKey)iterator.next();
                Object v2 = this.properties.get(caselessStringKey);
                iterator.remove();
                if (this.manager == null) continue;
                Object object = this.manager.getPropertyChangeEventSource();
                PropertySourceChangeEvent propertySourceChangeEvent = new PropertySourceChangeEvent(object, caselessStringKey.getName(), v2, Image.UndefinedProperty);
                this.manager.firePropertyChange(propertySourceChangeEvent);
            }
            this.cachedPropertyNames.clear();
        }
    }

    public void clearPropertySourceMap() {
        Map map = this.properties;
        synchronized (map) {
            this.propertySources.clear();
        }
    }

    public void clearCachedProperties() {
        Map map = this.properties;
        synchronized (map) {
            Iterator iterator = this.cachedPropertyNames.iterator();
            while (iterator.hasNext()) {
                CaselessStringKey caselessStringKey = (CaselessStringKey)iterator.next();
                Object v2 = this.properties.remove(caselessStringKey);
                iterator.remove();
                if (this.manager == null) continue;
                Object object = this.manager.getPropertyChangeEventSource();
                PropertySourceChangeEvent propertySourceChangeEvent = new PropertySourceChangeEvent(object, caselessStringKey.getName(), v2, Image.UndefinedProperty);
                this.manager.firePropertyChange(propertySourceChangeEvent);
            }
        }
    }

    public void removePropertySource(PropertySource propertySource) {
        Map map = this.properties;
        synchronized (map) {
            Iterator iterator = this.propertySources.keySet().iterator();
            while (iterator.hasNext()) {
                Object v2 = this.propertySources.get(iterator.next());
                if (!v2.equals(propertySource)) continue;
                iterator.remove();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getEventManager().addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getEventManager().addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getEventManager().removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getEventManager().removePropertyChangeListener(string, propertyChangeListener);
    }

    private PropertyChangeSupportJAI getEventManager() {
        if (this.manager == null) {
            WritablePropertySourceImpl writablePropertySourceImpl = this;
            synchronized (writablePropertySourceImpl) {
                this.manager = new PropertyChangeSupportJAI(this);
            }
        }
        return this.manager;
    }
}

