/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import javax.media.jai.WarpPolynomial;

public abstract class WarpOpImage
extends GeometricOpImage {
    protected Warp warp;

    private static ImageLayout getLayout(ImageLayout imageLayout, RenderedImage renderedImage, Warp warp) {
        Point[] pointArray;
        if (imageLayout != null && imageLayout.isValid(15)) {
            return imageLayout;
        }
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        Rectangle rectangle2 = warp.mapSourceRect(rectangle);
        if (rectangle2 == null) {
            pointArray = new Point[]{new Point(rectangle.x, rectangle.y), new Point(rectangle.x + rectangle.width, rectangle.y), new Point(rectangle.x, rectangle.y + rectangle.height), new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height)};
            boolean bl = true;
            double d2 = Double.MAX_VALUE;
            double d3 = -1.7976931348623157E308;
            double d4 = Double.MAX_VALUE;
            double d5 = -1.7976931348623157E308;
            int n2 = 0;
            while (n2 < 4) {
                Point2D point2D = warp.mapSourcePoint(pointArray[n2]);
                if (point2D == null) {
                    bl = false;
                    break;
                }
                double d6 = point2D.getX();
                double d7 = point2D.getY();
                if (d6 < d2) {
                    d2 = d6;
                }
                if (d6 > d3) {
                    d3 = d6;
                }
                if (d7 < d4) {
                    d4 = d7;
                }
                if (d7 > d5) {
                    d5 = d7;
                }
                ++n2;
            }
            if (bl) {
                rectangle2 = new Rectangle();
                rectangle2.x = (int)Math.floor(d2);
                rectangle2.y = (int)Math.floor(d4);
                rectangle2.width = (int)Math.ceil(d3 - (double)rectangle2.x);
                rectangle2.height = (int)Math.ceil(d5 - (double)rectangle2.y);
            }
        }
        if (rectangle2 == null && !(warp instanceof WarpAffine)) {
            Serializable serializable;
            pointArray = new Point[]{new Point(rectangle.x, rectangle.y), new Point(rectangle.x + rectangle.width, rectangle.y), new Point(rectangle.x, rectangle.y + rectangle.height), new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height)};
            float[] fArray = new float[8];
            float[] fArray2 = new float[8];
            int n3 = 0;
            int n4 = 0;
            while (n4 < 4) {
                serializable = pointArray[n4];
                Point2D point2D = warp.mapDestPoint(pointArray[n4]);
                fArray2[n3] = (float)((Point2D)((Object)serializable)).getX();
                fArray2[n3 + 1] = (float)((Point2D)((Object)serializable)).getY();
                fArray[n3] = (float)point2D.getX();
                fArray[n3 + 1] = (float)point2D.getY();
                n3 += 2;
                ++n4;
            }
            serializable = (WarpAffine)WarpPolynomial.createWarp(fArray, 0, fArray2, 0, 8, 1.0f, 1.0f, 1.0f, 1.0f, 1);
            rectangle2 = ((WarpAffine)serializable).mapSourceRect(rectangle);
        }
        if (rectangle2 != null) {
            if (imageLayout == null) {
                imageLayout = new ImageLayout(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            } else {
                imageLayout = (ImageLayout)imageLayout.clone();
                imageLayout.setMinX(rectangle2.x);
                imageLayout.setMinY(rectangle2.y);
                imageLayout.setWidth(rectangle2.width);
                imageLayout.setHeight(rectangle2.height);
            }
        }
        return imageLayout;
    }

    public WarpOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, boolean bl, BorderExtender borderExtender, Interpolation interpolation, Warp warp) {
        this(renderedImage, imageLayout, map, bl, borderExtender, interpolation, warp, null);
    }

    public WarpOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, boolean bl, BorderExtender borderExtender, Interpolation interpolation, Warp warp, double[] dArray) {
        super(OpImage.vectorize(renderedImage), WarpOpImage.getLayout(imageLayout, renderedImage, warp), map, bl, borderExtender, interpolation, dArray);
        if (warp == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.warp = warp;
        if (bl && borderExtender == null) {
            int n2 = interpolation == null ? 0 : interpolation.getLeftPadding();
            int n3 = interpolation == null ? 0 : interpolation.getRightPadding();
            int n4 = interpolation == null ? 0 : interpolation.getTopPadding();
            int n5 = interpolation == null ? 0 : interpolation.getBottomPadding();
            int n6 = this.getMinX() + n2;
            int n7 = this.getMinY() + n4;
            int n8 = Math.max(this.getWidth() - n2 - n3, 0);
            int n9 = Math.max(this.getHeight() - n4 - n5, 0);
            this.computableBounds = new Rectangle(n6, n7, n8, n9);
        } else {
            this.computableBounds = this.getBounds();
        }
    }

    public int getLeftPadding() {
        return this.interp == null ? 0 : this.interp.getLeftPadding();
    }

    public int getRightPadding() {
        return this.interp == null ? 0 : this.interp.getRightPadding();
    }

    public int getTopPadding() {
        return this.interp == null ? 0 : this.interp.getTopPadding();
    }

    public int getBottomPadding() {
        return this.interp == null ? 0 : this.interp.getBottomPadding();
    }

    public Point2D mapDestPoint(Point2D point2D, int n2) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        return this.warp.mapDestPoint(point2D);
    }

    public Point2D mapSourcePoint(Point2D point2D, int n2) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        return this.warp.mapSourcePoint(point2D);
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return this.warp.mapSourceRect(rectangle);
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        Rectangle rectangle2 = this.warp.mapDestRect(rectangle);
        return rectangle2 == null ? this.getSource(0).getBounds() : rectangle2;
    }

    public Raster computeTile(int n2, int n3) {
        Point point = new Point(this.tileXToX(n2), this.tileYToY(n3));
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.tileWidth, this.tileHeight).intersection(this.computableBounds);
        if (rectangle.isEmpty()) {
            if (this.setBackground) {
                ImageUtil.fillBackground(writableRaster, rectangle, this.backgroundValues);
            }
            return writableRaster;
        }
        PlanarImage planarImage = this.getSource(0);
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        if (!rectangle2.intersects(planarImage.getBounds())) {
            if (this.setBackground) {
                ImageUtil.fillBackground(writableRaster, rectangle, this.backgroundValues);
            }
            return writableRaster;
        }
        if (this.cobbleSources) {
            Raster[] rasterArray = new Raster[]{this.extender != null ? planarImage.getExtendedData(rectangle2, this.extender) : planarImage.getData(rectangle2)};
            this.computeRect(rasterArray, writableRaster, rectangle);
            if (planarImage.overlapsMultipleTiles(rectangle2)) {
                this.recycleTile(rasterArray[0]);
            }
        } else {
            PlanarImage[] planarImageArray = new PlanarImage[]{planarImage};
            this.computeRect(planarImageArray, writableRaster, rectangle);
        }
        return writableRaster;
    }
}

