/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.geom.Point2D;
import javax.media.jai.JaiI18N;
import javax.media.jai.Warp;

public final class WarpGrid
extends Warp {
    private int xStart;
    private int yStart;
    private int xEnd;
    private int yEnd;
    private int xStep;
    private int yStep;
    private int xNumCells;
    private int yNumCells;
    private float[] xWarpPos;
    private float[] yWarpPos;

    private void initialize(int n2, int n3, int n4, int n5, int n6, int n7, float[] fArray) {
        this.xStart = n2;
        this.yStart = n5;
        this.xEnd = n2 + n3 * n4;
        this.yEnd = n5 + n6 * n7;
        this.xStep = n3;
        this.yStep = n6;
        this.xNumCells = n4;
        this.yNumCells = n7;
        int n8 = n4 + 1;
        int n9 = n7 + 1;
        int n10 = n9 * n8;
        this.xWarpPos = new float[n10];
        this.yWarpPos = new float[n10];
        int n11 = 0;
        int n12 = 0;
        while (n12 < n10) {
            this.xWarpPos[n12] = fArray[n11++];
            this.yWarpPos[n12] = fArray[n11++];
            ++n12;
        }
    }

    public WarpGrid(int n2, int n3, int n4, int n5, int n6, int n7, float[] fArray) {
        if (fArray.length != 2 * (n4 + 1) * (n7 + 1)) {
            throw new IllegalArgumentException(JaiI18N.getString("WarpGrid0"));
        }
        this.initialize(n2, n3, n4, n5, n6, n7, fArray);
    }

    public WarpGrid(Warp warp, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 2 * (n4 + 1) * (n7 + 1);
        float[] fArray = new float[n8];
        fArray = warp.warpSparseRect(n2, n5, n4 * n3 + 1, n7 * n6 + 1, n3, n6, fArray);
        this.initialize(n2, n3, n4, n5, n6, n7, fArray);
    }

    public int getXStart() {
        return this.xStart;
    }

    public int getYStart() {
        return this.yStart;
    }

    public int getXStep() {
        return this.xStep;
    }

    public int getYStep() {
        return this.yStep;
    }

    public int getXNumCells() {
        return this.xNumCells;
    }

    public int getYNumCells() {
        return this.yNumCells;
    }

    public float[] getXWarpPos() {
        return this.xWarpPos;
    }

    public float[] getYWarpPos() {
        return this.yWarpPos;
    }

    private float[] noWarpSparseRect(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n10 = n4;
        while (n10 <= n5) {
            int n11 = n8;
            n8 += n9;
            int n12 = n2;
            while (n12 <= n3) {
                fArray[n11++] = n12;
                fArray[n11++] = n10;
                n12 += n6;
            }
            n10 += n7;
        }
        return fArray;
    }

    public float[] warpSparseRect(int n2, int n3, int n4, int n5, int n6, int n7, float[] fArray) {
        int n8;
        int n9 = 2 * ((n4 + n6 - 1) / n6);
        if (fArray == null) {
            fArray = new float[n9 * ((n5 + n7 - 1) / n7)];
        }
        int n10 = n2;
        int n11 = n2 + n4 - 1;
        int n12 = n3;
        int n13 = n3 + n5 - 1;
        if (n12 >= this.yEnd || n13 < this.yStart || n10 >= this.xEnd || n11 < this.xStart) {
            return this.noWarpSparseRect(n10, n11, n12, n13, n6, n7, 0, n9, fArray);
        }
        if (n12 < this.yStart) {
            n8 = (this.yStart - n12 + n7 - 1) / n7;
            this.noWarpSparseRect(n10, n11, n12, this.yStart - 1, n6, n7, 0, n9, fArray);
            n12 += n8 * n7;
        }
        if (n13 >= this.yEnd) {
            n8 = (this.yEnd - n3 + n7 - 1) / n7;
            this.noWarpSparseRect(n10, n11, n3 + n8 * n7, n13, n6, n7, n8 * n9, n9, fArray);
            n13 = n3 + (n8 - 1) * n7;
        }
        if (n10 < this.xStart) {
            n8 = (this.xStart - n10 + n6 - 1) / n6;
            this.noWarpSparseRect(n10, this.xStart - 1, n12, n13, n6, n7, (n12 - n3) / n7 * n9, n9, fArray);
            n10 += n8 * n6;
        }
        if (n11 >= this.xEnd) {
            n8 = (this.xEnd - n2 + n6 - 1) / n6;
            this.noWarpSparseRect(n2 + n8 * n6, n11, n12, n13, n6, n7, (n12 - n3) / n7 * n9 + n8 * 2, n9, fArray);
            n11 = n2 + (n8 - 1) * n6;
        }
        int[] nArray = new int[this.xNumCells];
        int n14 = n10;
        while (n14 <= n11) {
            int n15 = (n14 - this.xStart) / this.xStep;
            nArray[n15] = nArray[n15] + 1;
            n14 += n6;
        }
        int n16 = (n12 - n3) / n7 * n9 + (n10 - n2) / n6 * 2;
        int n17 = this.xNumCells + 1;
        float f2 = (float)n6 / (float)this.xStep;
        int n18 = n12;
        while (n18 <= n13) {
            int n19 = n16;
            n16 += n9;
            int n20 = (n18 - this.yStart) / this.yStep;
            int n21 = this.yStart + n20 * this.yStep;
            float f3 = ((float)n18 + 0.5f - (float)n21) / (float)this.yStep;
            float f4 = (1.0f - f3) * f2;
            float f5 = f3 * f2;
            int n22 = n10;
            while (n22 <= n11) {
                int n23 = (n22 - this.xStart) / this.xStep;
                int n24 = this.xStart + n23 * this.xStep;
                float f6 = ((float)n22 + 0.5f - (float)n24) / (float)this.xStep;
                int n25 = n20 * n17 + n23;
                float f7 = this.xWarpPos[n25];
                float f8 = this.yWarpPos[n25];
                float f9 = this.xWarpPos[++n25];
                float f10 = this.yWarpPos[n25];
                float f11 = this.xWarpPos[n25 += this.xNumCells];
                float f12 = this.yWarpPos[n25];
                float f13 = this.xWarpPos[++n25];
                float f14 = this.yWarpPos[n25];
                float f15 = f7 + (f9 - f7) * f6;
                float f16 = f8 + (f10 - f8) * f6;
                float f17 = f11 + (f13 - f11) * f6;
                float f18 = f12 + (f14 - f12) * f6;
                float f19 = f15 + (f17 - f15) * f3;
                float f20 = f16 + (f18 - f16) * f3;
                float f21 = (f9 - f7) * f4 + (f13 - f11) * f5;
                float f22 = (f10 - f8) * f4 + (f14 - f12) * f5;
                int n26 = nArray[n23];
                int n27 = 0;
                while (n27 < n26) {
                    fArray[n19++] = f19 - 0.5f;
                    fArray[n19++] = f20 - 0.5f;
                    f19 += f21;
                    f20 += f22;
                    n22 += n6;
                    ++n27;
                }
            }
            n18 += n7;
        }
        return fArray;
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        float[] fArray = this.warpSparseRect((int)point2D.getX(), (int)point2D.getY(), 2, 2, 1, 1, null);
        double d2 = point2D.getX() - (double)((int)point2D.getX());
        double d3 = 1.0 - d2;
        double d4 = point2D.getY() - (double)((int)point2D.getY());
        double d5 = 1.0 - d4;
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(((double)fArray[0] * d3 + (double)fArray[2] * d2) * d5 + ((double)fArray[4] * d3 + (double)fArray[6] * d2) * d4, ((double)fArray[1] * d3 + (double)fArray[3] * d2) * d5 + ((double)fArray[5] * d3 + (double)fArray[7] * d2) * d4);
        return point2D2;
    }
}

