/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.Serializable;
import javax.media.jai.JaiI18N;

public abstract class Warp
implements Serializable {
    protected Warp() {
    }

    public int[] warpRect(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (nArray != null && nArray.length < n4 * n5 * 2) {
            throw new IllegalArgumentException(JaiI18N.getString("Warp0"));
        }
        return this.warpSparseRect(n2, n3, n4, n5, 1, 1, n6, n7, nArray);
    }

    public float[] warpRect(int n2, int n3, int n4, int n5, float[] fArray) {
        if (fArray != null && fArray.length < n4 * n5 * 2) {
            throw new IllegalArgumentException(JaiI18N.getString("Warp0"));
        }
        return this.warpSparseRect(n2, n3, n4, n5, 1, 1, fArray);
    }

    public int[] warpPoint(int n2, int n3, int n4, int n5, int[] nArray) {
        if (nArray != null && nArray.length < 2) {
            throw new IllegalArgumentException(JaiI18N.getString("Warp0"));
        }
        return this.warpSparseRect(n2, n3, 1, 1, 1, 1, n4, n5, nArray);
    }

    public float[] warpPoint(int n2, int n3, float[] fArray) {
        if (fArray != null && fArray.length < 2) {
            throw new IllegalArgumentException(JaiI18N.getString("Warp0"));
        }
        return this.warpSparseRect(n2, n3, 1, 1, 1, 1, fArray);
    }

    public int[] warpSparseRect(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int[] nArray) {
        int n10 = 2 * ((n4 + n6 - 1) / n6) * ((n5 + n7 - 1) / n7);
        if (nArray != null && nArray.length < n10) {
            throw new IllegalArgumentException(JaiI18N.getString("Warp0"));
        }
        float[] fArray = this.warpSparseRect(n2, n3, n4, n5, n6, n7, null);
        int n11 = fArray.length;
        if (nArray == null) {
            nArray = new int[n11];
        }
        int n12 = 1 << n8;
        int n13 = 1 << n9;
        int n14 = 0;
        while (n14 < n11) {
            nArray[n14] = (int)Math.floor(fArray[n14] * (float)n12);
            nArray[n14 + 1] = (int)Math.floor(fArray[n14 + 1] * (float)n13);
            n14 += 2;
        }
        return nArray;
    }

    public abstract float[] warpSparseRect(int var1, int var2, int var3, int var4, int var5, int var6, float[] var7);

    public Rectangle mapSourceRect(Rectangle rectangle) {
        return null;
    }

    public Rectangle mapDestRect(Rectangle rectangle) {
        float f2;
        float f3;
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        float[] fArray = new float[Math.max(n4 * 2, (n5 - 2) * 2)];
        int n6 = n4 * 2;
        this.warpSparseRect(n2, n3, n4, 1, 1, 1, fArray);
        float f4 = fArray[0];
        float f5 = fArray[0];
        float f6 = fArray[1];
        float f7 = fArray[1];
        int n7 = 2;
        while (n7 < n6) {
            f3 = fArray[n7];
            f2 = fArray[n7 + 1];
            if (f3 < f4) {
                f4 = f3;
            } else if (f3 > f5) {
                f5 = f3;
            }
            if (f2 < f6) {
                f6 = f2;
            } else if (f2 > f7) {
                f7 = f2;
            }
            n7 += 2;
        }
        this.warpSparseRect(n2, n3 + n5 - 1, n4, 1, 1, 1, fArray);
        int n8 = 0;
        while (n8 < n6) {
            f3 = fArray[n8];
            f2 = fArray[n8 + 1];
            if (f3 < f4) {
                f4 = f3;
            } else if (f3 > f5) {
                f5 = f3;
            }
            if (f2 < f6) {
                f6 = f2;
            } else if (f2 > f7) {
                f7 = f2;
            }
            n8 += 2;
        }
        n6 = (n5 - 2) * 2;
        this.warpSparseRect(n2, n3 + 1, 1, n5 - 2, 1, 1, fArray);
        int n9 = 0;
        while (n9 < n6) {
            f3 = fArray[n9];
            f2 = fArray[n9 + 1];
            if (f3 < f4) {
                f4 = f3;
            } else if (f3 > f5) {
                f5 = f3;
            }
            if (f2 < f6) {
                f6 = f2;
            } else if (f2 > f7) {
                f7 = f2;
            }
            n9 += 2;
        }
        this.warpSparseRect(n2 + n4 - 1, n3 + 1, 1, n5 - 2, 1, 1, fArray);
        int n10 = 0;
        while (n10 < n6) {
            f3 = fArray[n10];
            f2 = fArray[n10 + 1];
            if (f3 < f4) {
                f4 = f3;
            } else if (f3 > f5) {
                f5 = f3;
            }
            if (f2 < f6) {
                f6 = f2;
            } else if (f2 > f7) {
                f7 = f2;
            }
            n10 += 2;
        }
        n2 = (int)Math.floor(f4);
        n3 = (int)Math.floor(f6);
        n4 = (int)Math.ceil(f5 - (float)n2) + 1;
        n5 = (int)Math.ceil(f7 - (float)n3) + 1;
        return new Rectangle(n2, n3, n4, n5);
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        float[] fArray = this.warpSparseRect((int)point2D.getX(), (int)point2D.getY(), 1, 1, 1, 1, null);
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(fArray[0], fArray[1]);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return null;
    }
}

