/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Rectangle;
import java.awt.image.Raster;

public final class UnpackedImageData {
    public final Raster raster;
    public final Rectangle rect;
    public final int type;
    public final Object data;
    public final int pixelStride;
    public final int lineStride;
    public final int[] bandOffsets;
    public final boolean convertToDest;

    public UnpackedImageData(Raster raster, Rectangle rectangle, int n2, Object object, int n3, int n4, int[] nArray, boolean bl) {
        this.raster = raster;
        this.rect = rectangle;
        this.type = n2;
        this.data = object;
        this.pixelStride = n3;
        this.lineStride = n4;
        this.bandOffsets = nArray;
        this.convertToDest = bl;
    }

    public byte[][] getByteData() {
        return this.type == 0 ? (byte[][])this.data : null;
    }

    public byte[] getByteData(int n2) {
        byte[][] byArray = this.getByteData();
        return byArray == null ? null : byArray[n2];
    }

    public short[][] getShortData() {
        return (short[][])(this.type == 1 || this.type == 2 ? (short[][])this.data : null);
    }

    public short[] getShortData(int n2) {
        short[][] sArray = this.getShortData();
        return sArray == null ? null : sArray[n2];
    }

    public int[][] getIntData() {
        return this.type == 3 ? (int[][])this.data : null;
    }

    public int[] getIntData(int n2) {
        int[][] nArray = this.getIntData();
        return nArray == null ? null : nArray[n2];
    }

    public float[][] getFloatData() {
        return this.type == 4 ? (float[][])this.data : null;
    }

    public float[] getFloatData(int n2) {
        float[][] fArray = this.getFloatData();
        return fArray == null ? null : fArray[n2];
    }

    public double[][] getDoubleData() {
        return this.type == 5 ? (double[][])this.data : null;
    }

    public double[] getDoubleData(int n2) {
        double[][] dArray = this.getDoubleData();
        return dArray == null ? null : dArray[n2];
    }

    public int getOffset(int n2) {
        return this.bandOffsets[n2];
    }

    public int getMinOffset() {
        int n2 = this.bandOffsets[0];
        int n3 = 1;
        while (n3 < this.bandOffsets.length) {
            n2 = Math.min(n2, this.bandOffsets[n3]);
            ++n3;
        }
        return n2;
    }

    public int getMaxOffset() {
        int n2 = this.bandOffsets[0];
        int n3 = 1;
        while (n3 < this.bandOffsets.length) {
            n2 = Math.max(n2, this.bandOffsets[n3]);
            ++n3;
        }
        return n2;
    }
}

