/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.TiledImage;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

class TiledImageGraphics
extends Graphics2D {
    private static final Class GRAPHICS2D_CLASS = class$java$awt$Graphics2D == null ? (class$java$awt$Graphics2D = TiledImageGraphics.class$("java.awt.Graphics2D")) : class$java$awt$Graphics2D;
    private static final int PAINT_MODE = 1;
    private static final int XOR_MODE = 2;
    private TiledImage tiledImage;
    Hashtable properties;
    private RenderingHints renderingHints;
    private int tileWidth;
    private int tileHeight;
    private int tileXMinimum;
    private int tileXMaximum;
    private int tileYMinimum;
    private int tileYMaximum;
    private ColorModel colorModel;
    private Point origin;
    private Shape clip;
    private Color color;
    private Font font;
    private int paintMode = 1;
    private Color XORColor;
    private Color background;
    private Composite composite;
    private Paint paint;
    private Stroke stroke;
    private AffineTransform transform;
    static /* synthetic */ Class class$java$awt$Graphics2D;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$java$awt$image$ImageObserver;
    static /* synthetic */ Class class$java$awt$image$RenderedImage;
    static /* synthetic */ Class class$java$awt$geom$AffineTransform;
    static /* synthetic */ Class class$java$awt$image$renderable$RenderableImage;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$awt$Shape;
    static /* synthetic */ Class class$java$awt$image$BufferedImage;
    static /* synthetic */ Class class$java$awt$image$BufferedImageOp;
    static /* synthetic */ Class class$java$text$AttributedCharacterIterator;
    static /* synthetic */ Class class$java$awt$font$GlyphVector;

    private static final Rectangle getBoundingBox(int[] nArray, int[] nArray2, int n2) {
        int n3;
        int n4;
        if (n2 <= 0) {
            return null;
        }
        int n5 = n4 = nArray[0];
        int n6 = n3 = nArray2[0];
        int n7 = 1;
        while (n7 < n2) {
            n5 = Math.min(n5, nArray[n7]);
            n4 = Math.max(n4, nArray[n7]);
            n6 = Math.min(n6, nArray2[n7]);
            n3 = Math.max(n3, nArray2[n7]);
            ++n7;
        }
        return new Rectangle(n5, n6, n4 - n5 + 1, n3 - n6 + 1);
    }

    public TiledImageGraphics(TiledImage tiledImage) {
        int n2 = tiledImage.getSampleModel().getTransferType();
        if (n2 != 0 && n2 != 2 && n2 != 1 && n2 != 3) {
            throw new UnsupportedOperationException(JaiI18N.getString("TiledImageGraphics0"));
        }
        this.tiledImage = tiledImage;
        this.tileWidth = tiledImage.getTileWidth();
        this.tileHeight = tiledImage.getTileHeight();
        this.tileXMinimum = tiledImage.getMinTileX();
        this.tileXMaximum = tiledImage.getMaxTileX();
        this.tileYMinimum = tiledImage.getMinTileY();
        this.tileYMaximum = tiledImage.getMaxTileY();
        this.colorModel = TiledImageGraphics.getColorModel(this.tiledImage);
        Graphics2D graphics2D = this.getBogusGraphics2D(false);
        this.origin = new Point(0, 0);
        this.setClip(this.tiledImage.getBounds());
        this.setColor(graphics2D.getColor());
        this.setFont(graphics2D.getFont());
        this.setPaintMode();
        this.setBackground(graphics2D.getBackground());
        this.setComposite(graphics2D.getComposite());
        this.setStroke(graphics2D.getStroke());
        this.setTransform(graphics2D.getTransform());
        graphics2D.dispose();
        this.properties = this.tiledImage.getProperties();
        this.renderingHints = new RenderingHints(this.properties);
    }

    private void copyState(Graphics2D graphics2D) {
        graphics2D.translate(this.origin.x, this.origin.y);
        this.setClip(this.getClip());
        graphics2D.setColor(this.getColor());
        if (this.paintMode == 1) {
            graphics2D.setPaintMode();
        } else if (this.XORColor != null) {
            graphics2D.setXORMode(this.XORColor);
        }
        graphics2D.setFont(this.getFont());
        graphics2D.setBackground(this.getBackground());
        graphics2D.setComposite(this.getComposite());
        if (this.paint != null) {
            graphics2D.setPaint(this.getPaint());
        }
        graphics2D.setRenderingHints(this.renderingHints);
        graphics2D.setStroke(this.getStroke());
        graphics2D.setTransform(this.getTransform());
    }

    private Graphics2D getBogusGraphics2D(boolean bl) {
        Raster raster = this.tiledImage.getTile(this.tileXMinimum, this.tileYMinimum);
        WritableRaster writableRaster = raster.createCompatibleWritableRaster(1, 1);
        BufferedImage bufferedImage = new BufferedImage(this.colorModel, writableRaster, this.colorModel.isAlphaPremultiplied(), this.properties);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (bl) {
            this.copyState(graphics2D);
        }
        return graphics2D;
    }

    private static ColorModel getColorModel(TiledImage tiledImage) {
        ColorModel colorModel = tiledImage.getColorModel();
        if (colorModel == null && colorModel == null) {
            ColorModel colorModel2;
            SampleModel sampleModel = tiledImage.getSampleModel();
            colorModel = PlanarImage.createColorModel(sampleModel);
            if (colorModel == null && JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel2 = ColorModel.getRGBdefault())) {
                colorModel = colorModel2;
            }
            if (colorModel == null) {
                throw new UnsupportedOperationException(JaiI18N.getString("TiledImageGraphics1"));
            }
        }
        return colorModel;
    }

    private boolean doGraphicsOp(int n2, int n3, int n4, int n5, String string, Class[] classArray, Object[] objectArray) {
        int n6;
        int n7;
        int n8;
        boolean bl = false;
        Method method = null;
        try {
            method = GRAPHICS2D_CLASS.getMethod(string, classArray);
        }
        catch (Exception exception) {
            String string2 = JaiI18N.getString("TiledImageGraphics2") + string;
            this.sendExceptionToListener(string2, new ImagingException(exception));
        }
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        rectangle = this.getTransform().createTransformedShape(rectangle).getBounds();
        int n9 = this.tiledImage.XToTileX(rectangle.x);
        if (n9 < this.tileXMinimum) {
            n9 = this.tileXMinimum;
        }
        if ((n8 = this.tiledImage.YToTileY(rectangle.y)) < this.tileYMinimum) {
            n8 = this.tileYMinimum;
        }
        if ((n7 = this.tiledImage.XToTileX(rectangle.x + rectangle.width - 1)) > this.tileXMaximum) {
            n7 = this.tileXMaximum;
        }
        if ((n6 = this.tiledImage.YToTileY(rectangle.y + rectangle.height - 1)) > this.tileYMaximum) {
            n6 = this.tileYMaximum;
        }
        int n10 = n8;
        while (n10 <= n6) {
            int n11 = this.tiledImage.tileYToY(n10);
            int n12 = n9;
            while (n12 <= n7) {
                Object object;
                Object object2;
                int n13 = this.tiledImage.tileXToX(n12);
                WritableRaster writableRaster = this.tiledImage.getWritableTile(n12, n10);
                writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
                BufferedImage bufferedImage = new BufferedImage(this.colorModel, writableRaster, this.colorModel.isAlphaPremultiplied(), this.properties);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                this.copyState(graphics2D);
                try {
                    object2 = graphics2D.getTransform().transform(new Point2D.Double(), null);
                    object = new Point((int)((Point2D)object2).getX() - n13, (int)((Point2D)object2).getY() - n11);
                    Point2D point2D = graphics2D.getTransform().inverseTransform((Point2D)object, null);
                    graphics2D.translate(point2D.getX(), point2D.getY());
                }
                catch (Exception exception) {
                    object = JaiI18N.getString("TiledImageGraphics3");
                    this.sendExceptionToListener((String)object, new ImagingException(exception));
                }
                try {
                    object2 = method.invoke((Object)graphics2D, objectArray);
                    if (object2 != null && object2.getClass() == Boolean.TYPE) {
                        bl = (Boolean)object2;
                    }
                }
                catch (Exception exception) {
                    object = JaiI18N.getString("TiledImageGraphics3") + " " + string;
                    this.sendExceptionToListener((String)object, new ImagingException(exception));
                }
                graphics2D.dispose();
                this.tiledImage.releaseWritableTile(n12, n10);
                ++n12;
            }
            ++n10;
        }
        return bl;
    }

    private boolean doGraphicsOp(Shape shape, String string, Class[] classArray, Object[] objectArray) {
        Rectangle rectangle = shape.getBounds();
        return this.doGraphicsOp(rectangle.x, rectangle.y, rectangle.width, rectangle.height, string, classArray, objectArray);
    }

    public Graphics create() {
        TiledImageGraphics tiledImageGraphics = new TiledImageGraphics(this.tiledImage);
        this.copyState(tiledImageGraphics);
        return tiledImageGraphics;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setPaintMode() {
        this.paintMode = 1;
    }

    public void setXORMode(Color color) {
        this.paintMode = 2;
        this.XORColor = color;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public FontMetrics getFontMetrics(Font font) {
        Graphics2D graphics2D = this.getBogusGraphics2D(true);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        graphics2D.dispose();
        return fontMetrics;
    }

    public Rectangle getClipBounds() {
        return this.clip.getBounds();
    }

    public void clipRect(int n2, int n3, int n4, int n5) {
        this.clip(new Rectangle(n2, n3, n4, n5));
    }

    public void setClip(int n2, int n3, int n4, int n5) {
        this.setClip(new Rectangle(n2, n3, n4, n5));
    }

    public Shape getClip() {
        return this.clip;
    }

    public void setClip(Shape shape) {
        this.clip = shape;
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = TiledImageGraphics.getBoundingBox(new int[]{n2, n2 + n6, n2 + n4 - 1, n2 + n4 - 1 + n6}, new int[]{n3, n3 + n7, n3 + n5 - 1, n3 + n5 - 1 + n7}, 4);
        this.doGraphicsOp(rectangle, "copyArea", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6), new Integer(n7)});
    }

    public void drawLine(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = TiledImageGraphics.getBoundingBox(new int[]{n2, n4}, new int[]{n3, n5}, 2);
        this.doGraphicsOp(rectangle, "drawLine", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5)});
    }

    public void fillRect(int n2, int n3, int n4, int n5) {
        this.doGraphicsOp(n2, n3, n4, n5, "fillRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5)});
    }

    public void clearRect(int n2, int n3, int n4, int n5) {
        this.doGraphicsOp(n2, n3, n4, n5, "clearRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5)});
    }

    public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.doGraphicsOp(n2 - n6, n3 - n7, n4 + 2 * n6, n5 + 2 * n7, "drawRoundRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6), new Integer(n7)});
    }

    public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.doGraphicsOp(n2 - n6, n3 - n7, n4 + 2 * n6, n5 + 2 * n7, "fillRoundRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6), new Integer(n7)});
    }

    public void draw3DRect(int n2, int n3, int n4, int n5, boolean bl) {
        this.doGraphicsOp(n2, n3, n4, n5, "draw3DRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE}, new Object[]{new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Boolean(bl)});
    }

    public void fill3DRect(int n2, int n3, int n4, int n5, boolean bl) {
        this.doGraphicsOp(n2, n3, n4, n5, "fill3DRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE}, new Object[]{new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Boolean(bl)});
    }

    public void drawOval(int n2, int n3, int n4, int n5) {
        this.doGraphicsOp(n2, n3, n4, n5, "drawOval", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5)});
    }

    public void fillOval(int n2, int n3, int n4, int n5) {
        this.doGraphicsOp(n2, n3, n4, n5, "fillOval", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5)});
    }

    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.doGraphicsOp(n2, n3, n4, n5, "drawArc", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6), new Integer(n7)});
    }

    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.doGraphicsOp(n2, n3, n4, n5, "fillArc", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6), new Integer(n7)});
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        Class<?> clazz = nArray.getClass();
        Rectangle rectangle = TiledImageGraphics.getBoundingBox(nArray, nArray2, n2);
        if (rectangle == null) {
            return;
        }
        this.doGraphicsOp(rectangle, "drawPolyline", new Class[]{clazz, clazz, Integer.TYPE}, new Object[]{nArray, nArray2, new Integer(n2)});
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        Class<?> clazz = nArray.getClass();
        Rectangle rectangle = TiledImageGraphics.getBoundingBox(nArray, nArray2, n2);
        if (rectangle == null) {
            return;
        }
        this.doGraphicsOp(rectangle, "drawPolygon", new Class[]{clazz, clazz, Integer.TYPE}, new Object[]{nArray, nArray2, new Integer(n2)});
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        Class<?> clazz = nArray.getClass();
        Rectangle rectangle = TiledImageGraphics.getBoundingBox(nArray, nArray2, n2);
        if (rectangle == null) {
            return;
        }
        this.doGraphicsOp(rectangle, "fillPolygon", new Class[]{clazz, clazz, Integer.TYPE}, new Object[]{nArray, nArray2, new Integer(n2)});
    }

    public void drawString(String string, int n2, int n3) {
        Rectangle2D rectangle2D = this.getFontMetrics(this.getFont()).getStringBounds(string, this);
        rectangle2D.setRect(n2, (double)n3 - rectangle2D.getHeight() + 1.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        this.doGraphicsOp(rectangle2D, "drawString", new Class[]{class$java$lang$String == null ? (class$java$lang$String = TiledImageGraphics.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, Integer.TYPE}, new Object[]{string, new Integer(n2), new Integer(n3)});
    }

    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.doGraphicsOp(n2, n3, image.getWidth(imageObserver), image.getHeight(imageObserver), "drawImage", new Class[]{class$java$awt$Image == null ? (class$java$awt$Image = TiledImageGraphics.class$("java.awt.Image")) : class$java$awt$Image, Integer.TYPE, Integer.TYPE, class$java$awt$image$ImageObserver == null ? (class$java$awt$image$ImageObserver = TiledImageGraphics.class$("java.awt.image.ImageObserver")) : class$java$awt$image$ImageObserver}, new Object[]{image, new Integer(n2), new Integer(n3), imageObserver});
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        Rectangle2D rectangle2D = affineTransform.createTransformedShape(double_).getBounds2D();
        this.doGraphicsOp(rectangle2D, "drawRenderedImage", new Class[]{class$java$awt$image$RenderedImage == null ? (class$java$awt$image$RenderedImage = TiledImageGraphics.class$("java.awt.image.RenderedImage")) : class$java$awt$image$RenderedImage, class$java$awt$geom$AffineTransform == null ? (class$java$awt$geom$AffineTransform = TiledImageGraphics.class$("java.awt.geom.AffineTransform")) : class$java$awt$geom$AffineTransform}, new Object[]{renderedImage, affineTransform});
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(renderableImage.getMinX(), renderableImage.getMinY(), renderableImage.getWidth(), renderableImage.getHeight());
        Rectangle2D rectangle2D = affineTransform.createTransformedShape(double_).getBounds2D();
        this.doGraphicsOp(rectangle2D, "drawRenderableImage", new Class[]{class$java$awt$image$renderable$RenderableImage == null ? (class$java$awt$image$renderable$RenderableImage = TiledImageGraphics.class$("java.awt.image.renderable.RenderableImage")) : class$java$awt$image$renderable$RenderableImage, class$java$awt$geom$AffineTransform == null ? (class$java$awt$geom$AffineTransform = TiledImageGraphics.class$("java.awt.geom.AffineTransform")) : class$java$awt$geom$AffineTransform}, new Object[]{renderableImage, affineTransform});
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        return this.doGraphicsOp(n2, n3, n4, n5, "drawImage", new Class[]{class$java$awt$Image == null ? (class$java$awt$Image = TiledImageGraphics.class$("java.awt.Image")) : class$java$awt$Image, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, class$java$awt$image$ImageObserver == null ? (class$java$awt$image$ImageObserver = TiledImageGraphics.class$("java.awt.image.ImageObserver")) : class$java$awt$image$ImageObserver}, new Object[]{image, new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), imageObserver});
    }

    public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        return this.doGraphicsOp(n2, n3, image.getWidth(imageObserver), image.getHeight(imageObserver), "drawImage", new Class[]{class$java$awt$Image == null ? (class$java$awt$Image = TiledImageGraphics.class$("java.awt.Image")) : class$java$awt$Image, Integer.TYPE, Integer.TYPE, class$java$awt$Color == null ? (class$java$awt$Color = TiledImageGraphics.class$("java.awt.Color")) : class$java$awt$Color, class$java$awt$image$ImageObserver == null ? (class$java$awt$image$ImageObserver = TiledImageGraphics.class$("java.awt.image.ImageObserver")) : class$java$awt$image$ImageObserver}, new Object[]{image, new Integer(n2), new Integer(n3), color, imageObserver});
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        return this.doGraphicsOp(n2, n3, n4, n5, "drawImage", new Class[]{class$java$awt$Image == null ? (class$java$awt$Image = TiledImageGraphics.class$("java.awt.Image")) : class$java$awt$Image, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, class$java$awt$Color == null ? (class$java$awt$Color = TiledImageGraphics.class$("java.awt.Color")) : class$java$awt$Color, class$java$awt$image$ImageObserver == null ? (class$java$awt$image$ImageObserver = TiledImageGraphics.class$("java.awt.image.ImageObserver")) : class$java$awt$image$ImageObserver}, new Object[]{image, new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), color, imageObserver});
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        return this.doGraphicsOp(n2, n3, n4 - n2 + 1, n5 - n3 + 1, "drawImage", new Class[]{class$java$awt$Image == null ? (class$java$awt$Image = TiledImageGraphics.class$("java.awt.Image")) : class$java$awt$Image, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, class$java$awt$image$ImageObserver == null ? (class$java$awt$image$ImageObserver = TiledImageGraphics.class$("java.awt.image.ImageObserver")) : class$java$awt$image$ImageObserver}, new Object[]{image, new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6), new Integer(n7), new Integer(n8), new Integer(n9), imageObserver});
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        return this.doGraphicsOp(n2, n3, n4 - n2 + 1, n5 - n3 + 1, "drawImage", new Class[]{class$java$awt$Image == null ? (class$java$awt$Image = TiledImageGraphics.class$("java.awt.Image")) : class$java$awt$Image, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, class$java$awt$Color == null ? (class$java$awt$Color = TiledImageGraphics.class$("java.awt.Color")) : class$java$awt$Color, class$java$awt$image$ImageObserver == null ? (class$java$awt$image$ImageObserver = TiledImageGraphics.class$("java.awt.image.ImageObserver")) : class$java$awt$image$ImageObserver}, new Object[]{image, new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6), new Integer(n7), new Integer(n8), new Integer(n9), color, imageObserver});
    }

    public void dispose() {
    }

    public void addRenderingHints(Map map) {
        this.renderingHints.putAll((Map<?, ?>)map);
    }

    public void draw(Shape shape) {
        this.doGraphicsOp(shape.getBounds(), "draw", new Class[]{class$java$awt$Shape == null ? (class$java$awt$Shape = TiledImageGraphics.class$("java.awt.Shape")) : class$java$awt$Shape}, new Object[]{shape});
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, image.getWidth(imageObserver), image.getHeight(imageObserver));
        Rectangle2D rectangle2D = this.transform.createTransformedShape(double_).getBounds2D();
        return this.doGraphicsOp(rectangle2D, "drawImage", new Class[]{class$java$awt$Image == null ? (class$java$awt$Image = TiledImageGraphics.class$("java.awt.Image")) : class$java$awt$Image, class$java$awt$geom$AffineTransform == null ? (class$java$awt$geom$AffineTransform = TiledImageGraphics.class$("java.awt.geom.AffineTransform")) : class$java$awt$geom$AffineTransform, class$java$awt$image$ImageObserver == null ? (class$java$awt$image$ImageObserver = TiledImageGraphics.class$("java.awt.image.ImageObserver")) : class$java$awt$image$ImageObserver}, new Object[]{image, affineTransform, imageObserver});
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        this.doGraphicsOp(bufferedImageOp.getBounds2D(bufferedImage), "drawImage", new Class[]{class$java$awt$image$BufferedImage == null ? (class$java$awt$image$BufferedImage = TiledImageGraphics.class$("java.awt.image.BufferedImage")) : class$java$awt$image$BufferedImage, class$java$awt$image$BufferedImageOp == null ? (class$java$awt$image$BufferedImageOp = TiledImageGraphics.class$("java.awt.image.BufferedImageOp")) : class$java$awt$image$BufferedImageOp, Integer.TYPE, Integer.TYPE}, new Object[]{bufferedImage, bufferedImageOp, new Integer(n2), new Integer(n3)});
    }

    public void drawString(String string, float f2, float f3) {
        Rectangle2D rectangle2D = this.getFontMetrics(this.getFont()).getStringBounds(string, this);
        rectangle2D.setRect(f2, (double)f3 - rectangle2D.getHeight() + 1.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        this.doGraphicsOp(rectangle2D, "drawString", new Class[]{class$java$lang$String == null ? (class$java$lang$String = TiledImageGraphics.class$("java.lang.String")) : class$java$lang$String, Float.TYPE, Float.TYPE}, new Object[]{string, new Float(f2), new Float(f3)});
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        Rectangle2D rectangle2D = this.getFontMetrics(this.getFont()).getStringBounds(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), (Graphics)this);
        rectangle2D.setRect(n2, (double)n3 - rectangle2D.getHeight() + 1.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        this.doGraphicsOp(rectangle2D, "drawString", new Class[]{class$java$text$AttributedCharacterIterator == null ? (class$java$text$AttributedCharacterIterator = TiledImageGraphics.class$("java.text.AttributedCharacterIterator")) : class$java$text$AttributedCharacterIterator, Integer.TYPE, Integer.TYPE}, new Object[]{attributedCharacterIterator, new Integer(n2), new Integer(n3)});
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        Rectangle2D rectangle2D = this.getFontMetrics(this.getFont()).getStringBounds(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), (Graphics)this);
        rectangle2D.setRect(f2, (double)f3 - rectangle2D.getHeight() + 1.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        this.doGraphicsOp(rectangle2D, "drawString", new Class[]{class$java$text$AttributedCharacterIterator == null ? (class$java$text$AttributedCharacterIterator = TiledImageGraphics.class$("java.text.AttributedCharacterIterator")) : class$java$text$AttributedCharacterIterator, Float.TYPE, Float.TYPE}, new Object[]{attributedCharacterIterator, new Float(f2), new Float(f3)});
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f2, float f3) {
        this.doGraphicsOp(glyphVector.getVisualBounds(), "drawGlyphVector", new Class[]{class$java$awt$font$GlyphVector == null ? (class$java$awt$font$GlyphVector = TiledImageGraphics.class$("java.awt.font.GlyphVector")) : class$java$awt$font$GlyphVector, Float.TYPE, Float.TYPE}, new Object[]{glyphVector, new Float(f2), new Float(f3)});
    }

    public void fill(Shape shape) {
        this.doGraphicsOp(shape.getBounds(), "fill", new Class[]{class$java$awt$Shape == null ? (class$java$awt$Shape = TiledImageGraphics.class$("java.awt.Shape")) : class$java$awt$Shape}, new Object[]{shape});
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        Graphics2D graphics2D = this.getBogusGraphics2D(true);
        boolean bl2 = graphics2D.hit(rectangle, shape, bl);
        graphics2D.dispose();
        return bl2;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        Graphics2D graphics2D = this.getBogusGraphics2D(true);
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        graphics2D.dispose();
        return graphicsConfiguration;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.renderingHints.put(key, object);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.renderingHints.get(key);
    }

    public void setRenderingHints(Map map) {
        this.renderingHints.putAll((Map<?, ?>)map);
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void translate(int n2, int n3) {
        this.origin = new Point(n2, n3);
        this.transform.translate(n2, n3);
    }

    public void translate(double d2, double d3) {
        this.transform.translate(d2, d3);
    }

    public void rotate(double d2) {
        this.transform.rotate(d2);
    }

    public void rotate(double d2, double d3, double d4) {
        this.transform.rotate(d2, d3, d4);
    }

    public void scale(double d2, double d3) {
        this.transform.scale(d2, d3);
    }

    public void shear(double d2, double d3) {
        this.transform.shear(d2, d3);
    }

    public void transform(AffineTransform affineTransform) {
        this.transform.concatenate(affineTransform);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void clip(Shape shape) {
        if (this.clip == null) {
            this.clip = shape;
        } else {
            Area area = this.clip instanceof Area ? (Area)this.clip : new Area(this.clip);
            area.intersect(shape instanceof Area ? (Area)shape : new Area(shape));
            this.clip = area;
        }
    }

    public FontRenderContext getFontRenderContext() {
        Graphics2D graphics2D = this.getBogusGraphics2D(true);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        graphics2D.dispose();
        return fontRenderContext;
    }

    void sendExceptionToListener(String string, Exception exception) {
        ImagingListener imagingListener = null;
        if (this.renderingHints != null) {
            imagingListener = (ImagingListener)this.renderingHints.get(JAI.KEY_IMAGING_LISTENER);
        }
        if (imagingListener == null) {
            imagingListener = JAI.getDefaultInstance().getImagingListener();
        }
        imagingListener.errorOccurred(string, exception, this, false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

