/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.PropertyUtil;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;

public abstract class StatisticsOpImage
extends OpImage {
    protected ROI roi;
    protected int xStart;
    protected int yStart;
    protected int xPeriod;
    protected int yPeriod;
    private boolean checkForSkippedTiles;

    public StatisticsOpImage(RenderedImage renderedImage, ROI rOI, int n2, int n3, int n4, int n5) {
        super(OpImage.vectorize(renderedImage), new ImageLayout(renderedImage), null, false);
        this.roi = rOI == null ? new ROIShape(this.getSource(0).getBounds()) : rOI;
        this.xStart = n2;
        this.yStart = n3;
        this.xPeriod = n4;
        this.yPeriod = n5;
        this.checkForSkippedTiles = n4 > this.tileWidth || n5 > this.tileHeight;
    }

    public boolean computesUniqueTiles() {
        return false;
    }

    public Raster getTile(int n2, int n3) {
        return this.getSource(0).getTile(n2, n3);
    }

    public Raster computeTile(int n2, int n3) {
        return this.getSource(0).getTile(n2, n3);
    }

    public Raster[] getTiles(Point[] pointArray) {
        if (pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.getSource(0).getTiles(pointArray);
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return new Rectangle(rectangle);
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return new Rectangle(rectangle);
    }

    public Object getProperty(String string) {
        Object object;
        block9: {
            if (string == null) {
                throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
            }
            object = super.getProperty(string);
            if (!object.equals(Image.UndefinedProperty)) break block9;
            StatisticsOpImage statisticsOpImage = this;
            synchronized (statisticsOpImage) {
                object = this.createStatistics(string);
                if (object.equals(Image.UndefinedProperty)) break block9;
                PlanarImage planarImage = this.getSource(0);
                int n2 = planarImage.getMinTileX();
                int n3 = planarImage.getMaxTileX();
                int n4 = planarImage.getMinTileY();
                int n5 = planarImage.getMaxTileY();
                int n6 = n4;
                while (n6 <= n5) {
                    int n7 = n2;
                    while (n7 <= n3) {
                        block10: {
                            Rectangle rectangle;
                            block11: {
                                rectangle = this.getTileRect(n7, n6);
                                if (!this.roi.intersects(rectangle)) break block10;
                                if (!this.checkForSkippedTiles || rectangle.x < this.xStart || rectangle.y < this.yStart) break block11;
                                int n8 = (this.xPeriod - (rectangle.x - this.xStart) % this.xPeriod) % this.xPeriod;
                                int n9 = (this.yPeriod - (rectangle.y - this.yStart) % this.yPeriod) % this.yPeriod;
                                if (n8 >= rectangle.width || n9 >= rectangle.height) break block10;
                            }
                            this.accumulateStatistics(string, planarImage.getData(rectangle), object);
                        }
                        ++n7;
                    }
                    ++n6;
                }
                this.setProperty(string, object);
            }
        }
        return object;
    }

    public String[] getPropertyNames() {
        int n2;
        String[] stringArray;
        String[] stringArray2 = this.getStatisticsNames();
        String[] stringArray3 = super.getPropertyNames();
        if (stringArray3 == null) {
            return stringArray2;
        }
        Vector<String[]> vector = new Vector<String[]>();
        int n3 = 0;
        while (n3 < stringArray2.length) {
            stringArray = stringArray2[n3];
            String[] stringArray4 = PropertyUtil.getPropertyNames(stringArray3, (String)stringArray);
            if (stringArray4 != null) {
                n2 = 0;
                while (n2 < stringArray4.length) {
                    if (stringArray4[n2].equalsIgnoreCase((String)stringArray)) {
                        vector.add(stringArray);
                    }
                    ++n2;
                }
            }
            ++n3;
        }
        if (vector.size() == 0) {
            return stringArray3;
        }
        stringArray = new String[stringArray3.length + vector.size()];
        System.arraycopy(stringArray3, 0, stringArray, 0, stringArray3.length);
        int n4 = stringArray3.length;
        n2 = 0;
        while (n2 < vector.size()) {
            stringArray[n4++] = (String)vector.get(n2);
            ++n2;
        }
        return stringArray;
    }

    protected abstract String[] getStatisticsNames();

    protected abstract Object createStatistics(String var1);

    protected abstract void accumulateStatistics(String var1, Raster var2, Object var3);
}

