/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.image.Raster;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.SnapshotImage;
import javax.media.jai.TileCopy;

final class Snapshot
extends PlanarImage {
    SnapshotImage parent;
    Snapshot next;
    Snapshot prev;
    Hashtable tiles = new Hashtable();
    boolean disposed = false;

    Snapshot(SnapshotImage snapshotImage) {
        super(new ImageLayout(snapshotImage), null, null);
        this.parent = snapshotImage;
    }

    public Raster getTile(int n2, int n3) {
        SnapshotImage snapshotImage = this.parent;
        synchronized (snapshotImage) {
            TileCopy tileCopy = (TileCopy)this.tiles.get(new Point(n2, n3));
            if (tileCopy != null) {
                Raster raster = tileCopy.tile;
                return raster;
            }
            if (this.next != null) {
                Raster raster = this.next.getTile(n2, n3);
                return raster;
            }
            Raster raster = this.parent.getTrueSource().getTile(n2, n3);
            return raster;
        }
    }

    void setNext(Snapshot snapshot) {
        this.next = snapshot;
    }

    void setPrev(Snapshot snapshot) {
        this.prev = snapshot;
    }

    boolean hasTile(int n2, int n3) {
        TileCopy tileCopy = (TileCopy)this.tiles.get(new Point(n2, n3));
        return tileCopy != null;
    }

    void addTile(Raster raster, int n2, int n3) {
        TileCopy tileCopy = new TileCopy(raster, n2, n3);
        this.tiles.put(new Point(n2, n3), tileCopy);
    }

    public void dispose() {
        SnapshotImage snapshotImage = this.parent;
        synchronized (snapshotImage) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            if (this.parent.getTail() == this) {
                this.parent.setTail(this.prev);
            }
            if (this.prev != null) {
                this.prev.setNext(this.next);
            }
            if (this.next != null) {
                this.next.setPrev(this.prev);
            }
            if (this.prev != null) {
                Enumeration enumeration = this.tiles.elements();
                while (enumeration.hasMoreElements()) {
                    TileCopy tileCopy = (TileCopy)enumeration.nextElement();
                    if (this.prev.hasTile(tileCopy.tileX, tileCopy.tileY)) continue;
                    this.prev.addTile(tileCopy.tile, tileCopy.tileX, tileCopy.tileY);
                }
            }
            this.parent = null;
            this.prev = null;
            this.next = null;
            this.tiles = null;
        }
    }
}

