/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.Rational;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;

public abstract class ScaleOpImage
extends GeometricOpImage {
    protected float scaleX;
    protected float scaleY;
    protected float transX;
    protected float transY;
    protected Rational scaleXRational;
    protected Rational scaleYRational;
    protected long scaleXRationalNum;
    protected long scaleXRationalDenom;
    protected long scaleYRationalNum;
    protected long scaleYRationalDenom;
    protected Rational invScaleXRational;
    protected Rational invScaleYRational;
    protected long invScaleXRationalNum;
    protected long invScaleXRationalDenom;
    protected long invScaleYRationalNum;
    protected long invScaleYRationalDenom;
    protected Rational transXRational;
    protected Rational transYRational;
    protected long transXRationalNum;
    protected long transXRationalDenom;
    protected long transYRationalNum;
    protected long transYRationalDenom;
    protected static float rationalTolerance = 1.0E-6f;
    private int lpad;
    private int rpad;
    private int tpad;
    private int bpad;

    private static ImageLayout layoutHelper(RenderedImage renderedImage, float f2, float f3, float f4, float f5, Interpolation interpolation, ImageLayout imageLayout) {
        Rational rational = Rational.approximate(f2, rationalTolerance);
        Rational rational2 = Rational.approximate(f3, rationalTolerance);
        long l2 = rational.num;
        long l3 = rational.denom;
        long l4 = rational2.num;
        long l5 = rational2.denom;
        Rational rational3 = Rational.approximate(f4, rationalTolerance);
        Rational rational4 = Rational.approximate(f5, rationalTolerance);
        long l6 = rational3.num;
        long l7 = rational3.denom;
        long l8 = rational4.num;
        long l9 = rational4.denom;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        int n2 = renderedImage.getMinX();
        int n3 = renderedImage.getMinY();
        int n4 = renderedImage.getWidth();
        int n5 = renderedImage.getHeight();
        long l10 = n2;
        long l11 = 1L;
        long l12 = n3;
        long l13 = 1L;
        long l14 = n2 + n4;
        long l15 = 1L;
        long l16 = n3 + n5;
        long l17 = 1L;
        l10 *= l2;
        l11 *= l3;
        l12 *= l4;
        l13 *= l5;
        l14 *= l2;
        l15 *= l3;
        l16 *= l4;
        l17 *= l5;
        l10 = 2L * l10 - l11;
        l11 *= 2L;
        l12 = 2L * l12 - l13;
        l13 *= 2L;
        l14 = 2L * l14 - 3L * l15;
        l16 = 2L * l16 - 3L * l17;
        l10 = l10 * l7 + l6 * l11;
        l12 = l12 * l9 + l8 * l13;
        l14 = l14 * l7 + l6 * (l15 *= 2L);
        l16 = l16 * l9 + l8 * (l17 *= 2L);
        int n6 = Rational.ceil(l10, l11 *= l7);
        int n7 = Rational.ceil(l12, l13 *= l9);
        int n8 = Rational.ceil(l14, l15 *= l7);
        int n9 = Rational.ceil(l16, l17 *= l9);
        imageLayout2.setMinX(n6);
        imageLayout2.setMinY(n7);
        imageLayout2.setWidth(n8 - n6 + 1);
        imageLayout2.setHeight(n9 - n7 + 1);
        return imageLayout2;
    }

    private static Map configHelper(RenderedImage renderedImage, Map map, Interpolation interpolation) {
        Map map2 = map;
        if (ImageUtil.isBinary(renderedImage.getSampleModel()) && (interpolation == null || interpolation instanceof InterpolationNearest || interpolation instanceof InterpolationBilinear)) {
            if (map == null) {
                map2 = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            } else if (!map2.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints renderingHints = new RenderingHints(null);
                renderingHints.putAll((Map<?, ?>)map);
                map2 = renderingHints;
                map2.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
            }
        }
        return map2;
    }

    public ScaleOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, boolean bl, BorderExtender borderExtender, Interpolation interpolation, float f2, float f3, float f4, float f5) {
        super(OpImage.vectorize(renderedImage), ScaleOpImage.layoutHelper(renderedImage, f2, f3, f4, f5, interpolation, imageLayout), ScaleOpImage.configHelper(renderedImage, map, interpolation), bl, borderExtender, interpolation, null);
        this.scaleX = f2;
        this.scaleY = f3;
        this.transX = f4;
        this.transY = f5;
        this.scaleXRational = Rational.approximate(f2, rationalTolerance);
        this.scaleYRational = Rational.approximate(f3, rationalTolerance);
        this.scaleXRationalNum = this.scaleXRational.num;
        this.scaleXRationalDenom = this.scaleXRational.denom;
        this.scaleYRationalNum = this.scaleYRational.num;
        this.scaleYRationalDenom = this.scaleYRational.denom;
        this.transXRational = Rational.approximate(f4, rationalTolerance);
        this.transYRational = Rational.approximate(f5, rationalTolerance);
        this.transXRationalNum = this.transXRational.num;
        this.transXRationalDenom = this.transXRational.denom;
        this.transYRationalNum = this.transYRational.num;
        this.transYRationalDenom = this.transYRational.denom;
        this.invScaleXRational = new Rational(this.scaleXRational);
        this.invScaleXRational.invert();
        this.invScaleYRational = new Rational(this.scaleYRational);
        this.invScaleYRational.invert();
        this.invScaleXRationalNum = this.invScaleXRational.num;
        this.invScaleXRationalDenom = this.invScaleXRational.denom;
        this.invScaleYRationalNum = this.invScaleYRational.num;
        this.invScaleYRationalDenom = this.invScaleYRational.denom;
        this.lpad = interpolation.getLeftPadding();
        this.rpad = interpolation.getRightPadding();
        this.tpad = interpolation.getTopPadding();
        this.bpad = interpolation.getBottomPadding();
        if (borderExtender == null) {
            int n2;
            long l2;
            long l3;
            long l4;
            long l5;
            long l6;
            long l7;
            long l8;
            long l9;
            int n3 = renderedImage.getMinX();
            int n4 = renderedImage.getMinY();
            int n5 = renderedImage.getWidth();
            int n6 = renderedImage.getHeight();
            if (interpolation instanceof InterpolationNearest) {
                l9 = n3;
                l8 = 1L;
                l7 = n4;
                l6 = 1L;
                l5 = n3 + n5;
                l4 = 1L;
                l3 = n4 + n6;
                l2 = 1L;
            } else {
                l9 = 2 * n3 + 1;
                l8 = 2L;
                l7 = 2 * n4 + 1;
                l6 = 2L;
                l5 = 2 * n3 + 2 * n5 + 1;
                l4 = 2L;
                l3 = 2 * n4 + 2 * n6 + 1;
                l2 = 2L;
                l9 += l8 * (long)this.lpad;
                l7 += l6 * (long)this.tpad;
                l5 -= l4 * (long)this.rpad;
                l3 -= l2 * (long)this.bpad;
            }
            l9 *= this.scaleXRationalNum;
            l9 = l9 * this.transXRationalDenom + this.transXRationalNum * (l8 *= this.scaleXRationalDenom);
            l8 *= this.transXRationalDenom;
            l7 *= this.scaleYRationalNum;
            l7 = l7 * this.transYRationalDenom + this.transYRationalNum * (l6 *= this.scaleYRationalDenom);
            l6 *= this.transYRationalDenom;
            l5 *= this.scaleXRationalNum;
            l5 = l5 * this.transXRationalDenom + this.transXRationalNum * (l4 *= this.scaleXRationalDenom);
            l4 *= this.transXRationalDenom;
            l3 *= this.scaleYRationalNum;
            l3 = l3 * this.transYRationalDenom + this.transYRationalNum * (l2 *= this.scaleYRationalDenom);
            l2 *= this.transYRationalDenom;
            l9 = 2L * l9 - l8;
            l7 = 2L * l7 - l6;
            int n7 = Rational.ceil(l9, l8 *= 2L);
            int n8 = Rational.ceil(l7, l6 *= 2L);
            l5 = 2L * l5 - l4;
            l3 = 2L * l3 - l2;
            l2 *= 2L;
            int n9 = Rational.floor(l5, l4 *= 2L);
            if ((long)n9 * l4 == l5) {
                --n9;
            }
            if ((long)(n2 = Rational.floor(l3, l2)) * l2 == l3) {
                --n2;
            }
            this.computableBounds = new Rectangle(n7, n8, n9 - n7 + 1, n2 - n8 + 1);
        } else {
            this.computableBounds = this.getBounds();
        }
    }

    public int getLeftPadding() {
        return this.interp == null ? 0 : this.interp.getLeftPadding();
    }

    public int getRightPadding() {
        return this.interp == null ? 0 : this.interp.getRightPadding();
    }

    public int getTopPadding() {
        return this.interp == null ? 0 : this.interp.getTopPadding();
    }

    public int getBottomPadding() {
        return this.interp == null ? 0 : this.interp.getBottomPadding();
    }

    public Point2D mapDestPoint(Point2D point2D, int n2) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation((point2D.getX() - (double)this.transX + 0.5) / (double)this.scaleX - 0.5, (point2D.getY() - (double)this.transY + 0.5) / (double)this.scaleY - 0.5);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D, int n2) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation((double)this.scaleX * (point2D.getX() + 0.5) + (double)this.transX - 0.5, (double)this.scaleY * (point2D.getY() + 0.5) + (double)this.transY - 0.5);
        return point2D2;
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int n2) {
        int n3;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8;
        long l9;
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        if (this.interp instanceof InterpolationNearest) {
            l9 = n4;
            l8 = 1L;
            l7 = n5;
            l6 = 1L;
            l5 = n4 + n6;
            l4 = 1L;
            l3 = n5 + n7;
            l2 = 1L;
        } else {
            l9 = 2 * n4 + 1;
            l8 = 2L;
            l7 = 2 * n5 + 1;
            l6 = 2L;
            l5 = 2 * n4 + 2 * n6 + 1;
            l4 = 2L;
            l3 = 2 * n5 + 2 * n7 + 1;
            l2 = 2L;
        }
        l9 *= this.scaleXRationalNum;
        l8 *= this.scaleXRationalDenom;
        l7 *= this.scaleYRationalNum;
        l6 *= this.scaleYRationalDenom;
        l5 *= this.scaleXRationalNum;
        l4 *= this.scaleXRationalDenom;
        l3 *= this.scaleYRationalNum;
        l2 *= this.scaleYRationalDenom;
        l9 = l9 * this.transXRationalDenom + this.transXRationalNum * l8;
        l8 *= this.transXRationalDenom;
        l7 = l7 * this.transYRationalDenom + this.transYRationalNum * l6;
        l6 *= this.transYRationalDenom;
        l5 = l5 * this.transXRationalDenom + this.transXRationalNum * l4;
        l4 *= this.transXRationalDenom;
        l3 = l3 * this.transYRationalDenom + this.transYRationalNum * l2;
        l2 *= this.transYRationalDenom;
        l9 = 2L * l9 - l8;
        l7 = 2L * l7 - l6;
        int n8 = Rational.ceil(l9, l8 *= 2L);
        int n9 = Rational.ceil(l7, l6 *= 2L);
        l5 = 2L * l5 - l4;
        l3 = 2L * l3 - l2;
        l2 *= 2L;
        int n10 = Rational.floor(l5, l4 *= 2L);
        if ((long)n10 * l4 == l5) {
            --n10;
        }
        if ((long)(n3 = Rational.floor(l3, l2)) * l2 == l3) {
            --n3;
        }
        return new Rectangle(n8, n9, n10 - n8 + 1, n3 - n9 + 1);
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        long l2 = n3 * 2 + 1;
        long l3 = 2L;
        long l4 = n4 * 2 + 1;
        long l5 = 2L;
        long l6 = 2 * n3 + 2 * n5 - 1;
        long l7 = 2L;
        long l8 = 2 * n4 + 2 * n6 - 1;
        long l9 = 2L;
        l2 = l2 * this.transXRationalDenom - this.transXRationalNum * l3;
        l3 *= this.transXRationalDenom;
        l4 = l4 * this.transYRationalDenom - this.transYRationalNum * l5;
        l5 *= this.transYRationalDenom;
        l6 = l6 * this.transXRationalDenom - this.transXRationalNum * l7;
        l7 *= this.transXRationalDenom;
        l8 = l8 * this.transYRationalDenom - this.transYRationalNum * l9;
        l9 *= this.transYRationalDenom;
        l2 *= this.invScaleXRationalNum;
        l3 *= this.invScaleXRationalDenom;
        l4 *= this.invScaleYRationalNum;
        l5 *= this.invScaleYRationalDenom;
        l6 *= this.invScaleXRationalNum;
        l7 *= this.invScaleXRationalDenom;
        l8 *= this.invScaleYRationalNum;
        l9 *= this.invScaleYRationalDenom;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if (this.interp instanceof InterpolationNearest) {
            n7 = Rational.floor(l2, l3);
            n8 = Rational.floor(l4, l5);
            n9 = Rational.floor(l6, l7);
            n10 = Rational.floor(l8, l9);
        } else {
            n7 = Rational.floor(2L * l2 - l3, 2L * l3);
            n8 = Rational.floor(2L * l4 - l5, 2L * l5);
            n9 = Rational.floor(2L * l6 - l7, 2L * l7);
            n10 = Rational.floor(2L * l8 - l9, 2L * l9);
        }
        return new Rectangle(n7, n8, n9 - n7 + 1, n10 - n8 + 1);
    }

    public Raster computeTile(int n2, int n3) {
        if (!this.cobbleSources) {
            return super.computeTile(n2, n3);
        }
        int n4 = this.tileXToX(n2);
        int n5 = this.tileYToY(n3);
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, new Point(n4, n5));
        Rectangle rectangle = new Rectangle(n4, n5, this.tileWidth, this.tileHeight);
        Rectangle rectangle2 = rectangle.intersection(this.computableBounds);
        if (rectangle2.width <= 0 || rectangle2.height <= 0) {
            return writableRaster;
        }
        Rectangle rectangle3 = this.mapDestRect(rectangle2, 0);
        Raster[] rasterArray = new Raster[1];
        PlanarImage planarImage = this.getSource(0);
        IntegerSequence integerSequence = new IntegerSequence();
        IntegerSequence integerSequence2 = new IntegerSequence();
        planarImage.getSplits(integerSequence, integerSequence2, rectangle3);
        if (integerSequence.getNumElements() == 1 && integerSequence2.getNumElements() == 1) {
            rasterArray[0] = this.extender == null ? planarImage.getData(rectangle3) : planarImage.getExtendedData(rectangle3, this.extender);
            this.computeRect(rasterArray, writableRaster, rectangle2);
        } else {
            int n6 = planarImage.getTileWidth();
            int n7 = planarImage.getTileHeight();
            integerSequence2.startEnumeration();
            while (integerSequence2.hasMoreElements()) {
                int n8 = integerSequence2.nextElement();
                integerSequence.startEnumeration();
                while (integerSequence.hasMoreElements()) {
                    Rectangle rectangle4;
                    Rectangle rectangle5;
                    int n9 = integerSequence.nextElement();
                    Rectangle rectangle6 = new Rectangle(n9, n8, n6, n7);
                    Rectangle rectangle7 = rectangle3.intersection(rectangle6);
                    if (!(this.interp instanceof InterpolationNearest)) {
                        if (rectangle7.width <= this.interp.getWidth()) {
                            rectangle5 = new Rectangle();
                            rectangle5.x = rectangle7.x;
                            rectangle5.y = rectangle7.y - this.tpad - 1;
                            rectangle5.width = 2 * (this.lpad + this.rpad + 1);
                            rectangle5.height = rectangle7.height + this.bpad + this.tpad + 2;
                            rectangle5 = rectangle5.intersection(planarImage.getBounds());
                            rectangle4 = this.mapSourceRect(rectangle5, 0);
                            rectangle4 = rectangle4.intersection(rectangle2);
                            if (rectangle4.width > 0 && rectangle4.height > 0) {
                                rasterArray[0] = this.extender == null ? planarImage.getData(rectangle5) : planarImage.getExtendedData(rectangle5, this.extender);
                                this.computeRect(rasterArray, writableRaster, rectangle4);
                            }
                        }
                        if (rectangle7.height <= this.interp.getHeight()) {
                            rectangle5 = new Rectangle();
                            rectangle5.x = rectangle7.x - this.lpad - 1;
                            rectangle5.y = rectangle7.y;
                            rectangle5.width = rectangle7.width + this.lpad + this.rpad + 2;
                            rectangle5.height = 2 * (this.tpad + this.bpad + 1);
                            rectangle5 = rectangle5.intersection(planarImage.getBounds());
                            rectangle4 = this.mapSourceRect(rectangle5, 0);
                            rectangle4 = rectangle4.intersection(rectangle2);
                            if (rectangle4.width > 0 && rectangle4.height > 0) {
                                rasterArray[0] = this.extender == null ? planarImage.getData(rectangle5) : planarImage.getExtendedData(rectangle5, this.extender);
                                this.computeRect(rasterArray, writableRaster, rectangle4);
                            }
                        }
                    }
                    if (rectangle7.width <= 0 || rectangle7.height <= 0) continue;
                    rectangle5 = this.mapSourceRect(rectangle7, 0);
                    rectangle5 = rectangle5.intersection(rectangle2);
                    if (rectangle5.width > 0 && rectangle5.height > 0) {
                        rasterArray[0] = this.extender == null ? planarImage.getData(rectangle7) : planarImage.getExtendedData(rectangle7, this.extender);
                        this.computeRect(rasterArray, writableRaster, rectangle5);
                    }
                    if (this.interp instanceof InterpolationNearest) continue;
                    rectangle4 = new Rectangle();
                    rectangle4.x = rectangle7.x + rectangle7.width - 1 - this.rpad - this.lpad;
                    rectangle4.y = rectangle7.y;
                    rectangle4.width = 2 * (this.lpad + this.rpad + 1);
                    rectangle4.height = rectangle7.height;
                    Rectangle rectangle8 = this.mapSourceRect(rectangle4, 0);
                    rectangle8 = rectangle8.intersection(rectangle2);
                    rectangle4 = this.mapDestRect(rectangle8, 0);
                    if (rectangle8.width > 0 && rectangle8.height > 0) {
                        rasterArray[0] = this.extender == null ? planarImage.getData(rectangle4) : planarImage.getExtendedData(rectangle4, this.extender);
                        this.computeRect(rasterArray, writableRaster, rectangle8);
                    }
                    Rectangle rectangle9 = new Rectangle();
                    rectangle9.x = rectangle7.x;
                    rectangle9.y = rectangle7.y + rectangle7.height - 1 - this.bpad - this.tpad;
                    rectangle9.width = rectangle7.width;
                    rectangle9.height = 2 * (this.tpad + this.bpad + 1);
                    Rectangle rectangle10 = this.mapSourceRect(rectangle9, 0);
                    rectangle10 = rectangle10.intersection(rectangle2);
                    rectangle9 = this.mapDestRect(rectangle10, 0);
                    if (rectangle10.width > 0 && rectangle10.height > 0) {
                        rasterArray[0] = this.extender == null ? planarImage.getData(rectangle9) : planarImage.getExtendedData(rectangle9, this.extender);
                        this.computeRect(rasterArray, writableRaster, rectangle10);
                    }
                    Rectangle rectangle11 = new Rectangle();
                    rectangle11.x = rectangle7.x + rectangle7.width - 1 - this.rpad - this.lpad;
                    rectangle11.y = rectangle7.y + rectangle7.height - 1 - this.bpad - this.tpad;
                    rectangle11.width = 2 * (this.rpad + this.lpad + 1);
                    rectangle11.height = 2 * (this.tpad + this.bpad + 1);
                    Rectangle rectangle12 = this.mapSourceRect(rectangle11, 0);
                    rectangle12 = rectangle12.intersection(rectangle2);
                    rectangle11 = this.mapDestRect(rectangle12, 0);
                    if (rectangle12.width <= 0 || rectangle12.height <= 0) continue;
                    rasterArray[0] = this.extender == null ? planarImage.getData(rectangle11) : planarImage.getExtendedData(rectangle11, this.extender);
                    this.computeRect(rasterArray, writableRaster, rectangle12);
                }
            }
        }
        return writableRaster;
    }
}

