/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.PropertyUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationNode;
import javax.media.jai.OperationNodeSupport;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PropertyChangeSupportJAI;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.PropertySource;
import javax.media.jai.RegistryMode;
import javax.media.jai.RenderedOp;
import javax.media.jai.WritablePropertySource;
import javax.media.jai.WritablePropertySourceImpl;
import javax.media.jai.registry.CRIFRegistry;
import javax.media.jai.util.CaselessStringKey;

public class RenderableOp
implements RenderableImage,
OperationNode,
WritablePropertySource,
Serializable {
    protected PropertyChangeSupportJAI eventManager = null;
    protected WritablePropertySourceImpl properties = null;
    protected OperationNodeSupport nodeSupport;
    protected transient PropertySource thePropertySource;
    protected transient ContextualRenderedImageFactory crif = null;

    public RenderableOp(OperationRegistry operationRegistry, String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        parameterBlock = parameterBlock == null ? new ParameterBlock() : (ParameterBlock)parameterBlock.clone();
        if (renderingHints != null) {
            renderingHints = (RenderingHints)renderingHints.clone();
        }
        this.eventManager = new PropertyChangeSupportJAI(this);
        this.properties = new WritablePropertySourceImpl(null, null, this.eventManager);
        this.nodeSupport = new OperationNodeSupport(this.getRegistryModeName(), string, operationRegistry, parameterBlock, renderingHints, this.eventManager);
    }

    public RenderableOp(OperationRegistry operationRegistry, String string, ParameterBlock parameterBlock) {
        this(operationRegistry, string, parameterBlock, null);
    }

    public RenderableOp(String string, ParameterBlock parameterBlock) {
        this(null, string, parameterBlock);
    }

    public String getRegistryModeName() {
        return RegistryMode.getMode("renderable").getName();
    }

    public synchronized OperationRegistry getRegistry() {
        return this.nodeSupport.getRegistry();
    }

    public synchronized void setRegistry(OperationRegistry operationRegistry) {
        this.nodeSupport.setRegistry(operationRegistry);
    }

    public String getOperationName() {
        return this.nodeSupport.getOperationName();
    }

    public synchronized void setOperationName(String string) {
        this.nodeSupport.setOperationName(string);
    }

    public ParameterBlock getParameterBlock() {
        return (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
    }

    public synchronized void setParameterBlock(ParameterBlock parameterBlock) {
        this.nodeSupport.setParameterBlock(parameterBlock == null ? new ParameterBlock() : (ParameterBlock)parameterBlock.clone());
    }

    public RenderingHints getRenderingHints() {
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        return renderingHints == null ? null : (RenderingHints)renderingHints.clone();
    }

    public synchronized void setRenderingHints(RenderingHints renderingHints) {
        if (renderingHints != null) {
            renderingHints = (RenderingHints)renderingHints.clone();
        }
        this.nodeSupport.setRenderingHints(renderingHints);
    }

    private Vector getRenderableSources() {
        Vector<Object> vector = null;
        int n2 = this.nodeSupport.getParameterBlock().getNumSources();
        if (n2 > 0) {
            vector = new Vector<Object>();
            int n3 = 0;
            while (n3 < n2) {
                Object object = this.nodeSupport.getParameterBlock().getSource(n3);
                if (object instanceof RenderableImage) {
                    vector.add(object);
                }
                ++n3;
            }
        }
        return vector;
    }

    public Vector getSources() {
        return this.getRenderableSources();
    }

    private synchronized ContextualRenderedImageFactory findCRIF() {
        if (this.crif == null) {
            this.crif = CRIFRegistry.get(this.getRegistry(), this.getOperationName());
        }
        if (this.crif == null) {
            throw new RuntimeException(JaiI18N.getString("RenderableOp2"));
        }
        return this.crif;
    }

    public float getWidth() {
        this.findCRIF();
        ParameterBlock parameterBlock = ImageUtil.evaluateParameters(this.nodeSupport.getParameterBlock());
        Rectangle2D rectangle2D = this.crif.getBounds2D(parameterBlock);
        return (float)rectangle2D.getWidth();
    }

    public float getHeight() {
        this.findCRIF();
        ParameterBlock parameterBlock = ImageUtil.evaluateParameters(this.nodeSupport.getParameterBlock());
        Rectangle2D rectangle2D = this.crif.getBounds2D(parameterBlock);
        return (float)rectangle2D.getHeight();
    }

    public float getMinX() {
        this.findCRIF();
        ParameterBlock parameterBlock = ImageUtil.evaluateParameters(this.nodeSupport.getParameterBlock());
        Rectangle2D rectangle2D = this.crif.getBounds2D(parameterBlock);
        return (float)rectangle2D.getX();
    }

    public float getMinY() {
        this.findCRIF();
        ParameterBlock parameterBlock = ImageUtil.evaluateParameters(this.nodeSupport.getParameterBlock());
        Rectangle2D rectangle2D = this.crif.getBounds2D(parameterBlock);
        return (float)rectangle2D.getY();
    }

    public RenderedImage createDefaultRendering() {
        Dimension dimension = null;
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        if (renderingHints != null && renderingHints.containsKey(JAI.KEY_DEFAULT_RENDERING_SIZE)) {
            dimension = (Dimension)renderingHints.get(JAI.KEY_DEFAULT_RENDERING_SIZE);
        }
        if (dimension == null || dimension.width <= 0 && dimension.height <= 0) {
            dimension = JAI.getDefaultRenderingSize();
        }
        double d2 = 1.0;
        double d3 = 1.0;
        if (dimension != null && (dimension.width > 0 || dimension.height > 0)) {
            if (dimension.width > 0 && dimension.height > 0) {
                d2 = (float)dimension.width / this.getWidth();
                d3 = (float)dimension.height / this.getHeight();
            } else {
                d2 = dimension.width > 0 ? (d3 = (double)((float)dimension.width / this.getWidth())) : (d3 = (double)((float)dimension.height / this.getHeight()));
            }
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d2, d3);
        return this.createRendering(new RenderContext(affineTransform));
    }

    public RenderedImage createScaledRendering(int n2, int n3, RenderingHints renderingHints) {
        if (n2 == 0 && n3 == 0) {
            throw new IllegalArgumentException(JaiI18N.getString("RenderableOp3"));
        }
        if (n2 == 0) {
            n2 = Math.round((float)n3 * (this.getWidth() / this.getHeight()));
        } else if (n3 == 0) {
            n3 = Math.round((float)n2 * (this.getHeight() / this.getWidth()));
        }
        double d2 = (double)n2 / (double)this.getWidth();
        double d3 = (double)n3 / (double)this.getHeight();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d2, d3);
        RenderContext renderContext = new RenderContext(affineTransform, renderingHints);
        return this.createRendering(renderContext);
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        this.findCRIF();
        ParameterBlock parameterBlock = this.nodeSupport.getParameterBlock();
        Vector vector = ImageUtil.evaluateParameters(parameterBlock.getParameters());
        ParameterBlock parameterBlock2 = new ParameterBlock((Vector)parameterBlock.getSources().clone(), vector);
        Vector vector2 = this.getRenderableSources();
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String[] stringArray;
            RenderContext renderContext2 = renderContext;
            RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
            if (renderingHints != null && (stringArray = JAI.mergeRenderingHints(renderingHints, (RenderingHints)(object4 = renderContext.getRenderingHints()))) != object4) {
                renderContext2 = new RenderContext(renderContext.getTransform(), renderContext.getAreaOfInterest(), (RenderingHints)stringArray);
            }
            if (vector2 != null) {
                object4 = new Vector();
                int n2 = 0;
                while (n2 < vector2.size()) {
                    object3 = this.crif.mapRenderContext(n2, renderContext2, parameterBlock2, this);
                    object2 = (RenderableImage)vector2.elementAt(n2);
                    object = object2.createRendering((RenderContext)object3);
                    if (object == null) {
                        return null;
                    }
                    ((Vector)object4).addElement(object);
                    ++n2;
                }
                if (((Vector)object4).size() > 0) {
                    parameterBlock2.setSources((Vector<Object>)object4);
                }
            }
            if ((object4 = this.crif.create(renderContext2, parameterBlock2)) instanceof RenderedOp) {
                object4 = ((RenderedOp)object4).getRendering();
            }
            if (object4 != null && object4 instanceof WritablePropertySource && (stringArray = this.getPropertyNames()) != null) {
                int n3;
                object3 = (WritablePropertySource)object4;
                object2 = null;
                object = object3.getPropertyNames();
                if (object != null) {
                    object2 = new HashSet();
                    n3 = 0;
                    while (n3 < ((String[])object).length) {
                        ((HashSet)object2).add(new CaselessStringKey(object[n3]));
                        ++n3;
                    }
                }
                n3 = 0;
                while (n3 < stringArray.length) {
                    Object object5;
                    String string = stringArray[n3];
                    if (!(object2 != null && ((HashSet)object2).contains(new CaselessStringKey(string)) || (object5 = this.getProperty(string)) == null || object5 == Image.UndefinedProperty)) {
                        object3.setProperty(string, object5);
                    }
                    ++n3;
                }
            }
            return object4;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public boolean isDynamic() {
        return false;
    }

    private synchronized void createPropertySource() {
        if (this.thePropertySource == null) {
            this.thePropertySource = this.nodeSupport.getPropertySource(this, null);
            this.properties.addProperties(this.thePropertySource);
        }
    }

    public String[] getPropertyNames() {
        this.createPropertySource();
        return this.properties.getPropertyNames();
    }

    public String[] getPropertyNames(String string) {
        return PropertyUtil.getPropertyNames(this.getPropertyNames(), string);
    }

    public Class getPropertyClass(String string) {
        this.createPropertySource();
        return this.properties.getPropertyClass(string);
    }

    public Object getProperty(String string) {
        this.createPropertySource();
        return this.properties.getProperty(string);
    }

    public void setProperty(String string, Object object) {
        this.createPropertySource();
        this.properties.setProperty(string, object);
    }

    public void removeProperty(String string) {
        this.createPropertySource();
        this.properties.removeProperty(string);
    }

    public synchronized Object getDynamicProperty(String string) {
        this.createPropertySource();
        return this.thePropertySource.getProperty(string);
    }

    public void addPropertyGenerator(PropertyGenerator propertyGenerator) {
        this.nodeSupport.addPropertyGenerator(propertyGenerator);
    }

    public synchronized void copyPropertyFromSource(String string, int n2) {
        this.nodeSupport.copyPropertyFromSource(string, n2);
    }

    public void suppressProperty(String string) {
        this.nodeSupport.suppressProperty(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(string, propertyChangeListener);
    }

    public Object getSource(int n2) {
        Vector<Object> vector = this.nodeSupport.getParameterBlock().getSources();
        return vector.elementAt(n2);
    }

    public void setSource(Object object, int n2) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        ParameterBlock parameterBlock = (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
        parameterBlock.setSource(object, n2);
        this.nodeSupport.setParameterBlock(parameterBlock);
    }

    public void removeSources() {
        ParameterBlock parameterBlock = (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
        parameterBlock.removeSources();
        this.nodeSupport.setParameterBlock(parameterBlock);
    }

    public byte getByteParameter(int n2) {
        return this.nodeSupport.getParameterBlock().getByteParameter(n2);
    }

    public char getCharParameter(int n2) {
        return this.nodeSupport.getParameterBlock().getCharParameter(n2);
    }

    public short getShortParameter(int n2) {
        return this.nodeSupport.getParameterBlock().getShortParameter(n2);
    }

    public int getIntParameter(int n2) {
        return this.nodeSupport.getParameterBlock().getIntParameter(n2);
    }

    public long getLongParameter(int n2) {
        return this.nodeSupport.getParameterBlock().getLongParameter(n2);
    }

    public float getFloatParameter(int n2) {
        return this.nodeSupport.getParameterBlock().getFloatParameter(n2);
    }

    public double getDoubleParameter(int n2) {
        return this.nodeSupport.getParameterBlock().getDoubleParameter(n2);
    }

    public Object getObjectParameter(int n2) {
        return this.nodeSupport.getParameterBlock().getObjectParameter(n2);
    }

    public void setParameter(byte by, int n2) {
        this.setParameter(new Byte(by), n2);
    }

    public void setParameter(char c2, int n2) {
        this.setParameter(new Character(c2), n2);
    }

    public void setParameter(short s2, int n2) {
        this.setParameter(new Short(s2), n2);
    }

    public void setParameter(int n2, int n3) {
        this.setParameter(new Integer(n2), n3);
    }

    public void setParameter(long l2, int n2) {
        this.setParameter(new Long(l2), n2);
    }

    public void setParameter(float f2, int n2) {
        this.setParameter(new Float(f2), n2);
    }

    public void setParameter(double d2, int n2) {
        this.setParameter(new Double(d2), n2);
    }

    public void setParameter(Object object, int n2) {
        ParameterBlock parameterBlock = (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
        parameterBlock.set(object, n2);
        this.nodeSupport.setParameterBlock(parameterBlock);
    }
}

