/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.DataBufferUtils;
import java.awt.Point;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Observable;
import javax.media.jai.JaiI18N;
import javax.media.jai.TileFactory;
import javax.media.jai.TileRecycler;

public class RecyclingTileFactory
extends Observable
implements TileFactory,
TileRecycler {
    private static final boolean DEBUG = false;
    private HashMap recycledArrays = new HashMap(32);
    private long memoryUsed = 0L;

    private static long getBufferSizeCSM(ComponentSampleModel componentSampleModel) {
        int n2;
        int n3;
        int[] nArray = componentSampleModel.getBandOffsets();
        int n4 = nArray[0];
        int n5 = 1;
        while (n5 < nArray.length) {
            n4 = Math.max(n4, nArray[n5]);
            ++n5;
        }
        long l2 = 0L;
        if (n4 >= 0) {
            l2 += (long)(n4 + 1);
        }
        if ((n3 = componentSampleModel.getPixelStride()) > 0) {
            l2 += (long)(n3 * (componentSampleModel.getWidth() - 1));
        }
        if ((n2 = componentSampleModel.getScanlineStride()) > 0) {
            l2 += (long)(n2 * (componentSampleModel.getHeight() - 1));
        }
        return l2;
    }

    private static long getNumBanksCSM(ComponentSampleModel componentSampleModel) {
        int[] nArray = componentSampleModel.getBankIndices();
        int n2 = nArray[0];
        int n3 = 1;
        while (n3 < nArray.length) {
            int n4 = nArray[n3];
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
        }
        return n2 + 1;
    }

    private static SoftReference getBankReference(DataBuffer dataBuffer) {
        Object object = null;
        switch (dataBuffer.getDataType()) {
            case 0: {
                object = ((DataBufferByte)dataBuffer).getBankData();
                break;
            }
            case 1: {
                object = ((DataBufferUShort)dataBuffer).getBankData();
                break;
            }
            case 2: {
                object = ((DataBufferShort)dataBuffer).getBankData();
                break;
            }
            case 3: {
                object = ((DataBufferInt)dataBuffer).getBankData();
                break;
            }
            case 4: {
                object = DataBufferUtils.getBankDataFloat(dataBuffer);
                break;
            }
            case 5: {
                object = DataBufferUtils.getBankDataDouble(dataBuffer);
                break;
            }
            default: {
                throw new UnsupportedOperationException(JaiI18N.getString("Generic3"));
            }
        }
        return new SoftReference<float[][]>((float[][])object);
    }

    private static long getDataBankSize(int n2, int n3, int n4) {
        int n5 = 0;
        switch (n2) {
            case 0: {
                n5 = 1;
                break;
            }
            case 1: 
            case 2: {
                n5 = 2;
                break;
            }
            case 3: 
            case 4: {
                n5 = 4;
                break;
            }
            case 5: {
                n5 = 8;
                break;
            }
            default: {
                throw new UnsupportedOperationException(JaiI18N.getString("Generic3"));
            }
        }
        return n3 * n4 * n5;
    }

    public boolean canReclaimMemory() {
        return true;
    }

    public boolean isMemoryCache() {
        return true;
    }

    public long getMemoryUsed() {
        return this.memoryUsed;
    }

    public void flush() {
        HashMap hashMap = this.recycledArrays;
        synchronized (hashMap) {
            this.recycledArrays.clear();
            this.memoryUsed = 0L;
        }
    }

    public WritableRaster createTile(SampleModel sampleModel, Point point) {
        Object object;
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel == null!");
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        DataBuffer dataBuffer = null;
        int n2 = sampleModel.getTransferType();
        long l2 = 0L;
        long l3 = 0L;
        if (sampleModel instanceof ComponentSampleModel) {
            object = (ComponentSampleModel)sampleModel;
            l2 = RecyclingTileFactory.getNumBanksCSM((ComponentSampleModel)object);
            l3 = RecyclingTileFactory.getBufferSizeCSM((ComponentSampleModel)object);
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            object = (MultiPixelPackedSampleModel)sampleModel;
            l2 = 1L;
            int n3 = DataBuffer.getDataTypeSize(n2);
            l3 = ((MultiPixelPackedSampleModel)object).getScanlineStride() * ((SampleModel)object).getHeight() + (((MultiPixelPackedSampleModel)object).getDataBitOffset() + n3 - 1) / n3;
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            object = (SinglePixelPackedSampleModel)sampleModel;
            l2 = 1L;
            l3 = ((SinglePixelPackedSampleModel)object).getScanlineStride() * (((SampleModel)object).getHeight() - 1) + ((SampleModel)object).getWidth();
        }
        if (l3 != 0L && (object = this.getRecycledArray(n2, l2, l3)) != null) {
            switch (n2) {
                case 0: {
                    byte[][] byArray = (byte[][])object;
                    int n4 = 0;
                    while ((long)n4 < l2) {
                        Arrays.fill(byArray[n4], (byte)0);
                        ++n4;
                    }
                    dataBuffer = new DataBufferByte(byArray, (int)l3);
                    break;
                }
                case 1: {
                    short[][] sArray = (short[][])object;
                    int n5 = 0;
                    while ((long)n5 < l2) {
                        Arrays.fill(sArray[n5], (short)0);
                        ++n5;
                    }
                    dataBuffer = new DataBufferUShort(sArray, (int)l3);
                    break;
                }
                case 2: {
                    short[][] sArray = (short[][])object;
                    int n6 = 0;
                    while ((long)n6 < l2) {
                        Arrays.fill(sArray[n6], (short)0);
                        ++n6;
                    }
                    dataBuffer = new DataBufferShort(sArray, (int)l3);
                    break;
                }
                case 3: {
                    int[][] nArray = (int[][])object;
                    int n7 = 0;
                    while ((long)n7 < l2) {
                        Arrays.fill(nArray[n7], 0);
                        ++n7;
                    }
                    dataBuffer = new DataBufferInt(nArray, (int)l3);
                    break;
                }
                case 4: {
                    float[][] fArray = (float[][])object;
                    int n8 = 0;
                    while ((long)n8 < l2) {
                        Arrays.fill(fArray[n8], 0.0f);
                        ++n8;
                    }
                    dataBuffer = DataBufferUtils.createDataBufferFloat(fArray, (int)l3);
                    break;
                }
                case 5: {
                    double[][] dArray = (double[][])object;
                    int n9 = 0;
                    while ((long)n9 < l2) {
                        Arrays.fill(dArray[n9], 0.0);
                        ++n9;
                    }
                    dataBuffer = DataBufferUtils.createDataBufferDouble(dArray, (int)l3);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JaiI18N.getString("Generic3"));
                }
            }
        }
        if (dataBuffer == null) {
            dataBuffer = sampleModel.createDataBuffer();
        }
        return Raster.createWritableRaster(sampleModel, dataBuffer, point);
    }

    public void recycleTile(Raster raster) {
        DataBuffer dataBuffer = raster.getDataBuffer();
        Long l2 = new Long((long)dataBuffer.getDataType() << 56 | (long)dataBuffer.getNumBanks() << 32 | (long)dataBuffer.getSize());
        HashMap hashMap = this.recycledArrays;
        synchronized (hashMap) {
            Object v2 = this.recycledArrays.get(l2);
            ArrayList<SoftReference> arrayList = null;
            arrayList = v2 != null ? (ArrayList<SoftReference>)v2 : new ArrayList<SoftReference>();
            this.memoryUsed += RecyclingTileFactory.getDataBankSize(dataBuffer.getDataType(), dataBuffer.getNumBanks(), dataBuffer.getSize());
            arrayList.add(RecyclingTileFactory.getBankReference(dataBuffer));
            if (v2 == null) {
                this.recycledArrays.put(l2, arrayList);
            }
        }
    }

    private Object getRecycledArray(int n2, long l2, long l3) {
        Long l4 = new Long((long)n2 << 56 | l2 << 32 | l3);
        HashMap hashMap = this.recycledArrays;
        synchronized (hashMap) {
            Object v2 = this.recycledArrays.get(l4);
            if (v2 != null) {
                ArrayList arrayList = (ArrayList)v2;
                int n3 = arrayList.size() - 1;
                while (n3 >= 0) {
                    Object t2;
                    SoftReference softReference = (SoftReference)arrayList.remove(n3);
                    this.memoryUsed -= RecyclingTileFactory.getDataBankSize(n2, (int)l2, (int)l3);
                    if (n3 == 0) {
                        this.recycledArrays.remove(l4);
                    }
                    if ((t2 = softReference.get()) != null) {
                        Object t3 = t2;
                        return t3;
                    }
                    --n3;
                }
            }
        }
        return null;
    }
}

