/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.PropertyUtil;
import com.sun.media.jai.util.Service;
import java.awt.RenderingHints;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.jai.CollectionImage;
import javax.media.jai.CollectionImageFactory;
import javax.media.jai.DescriptorCache;
import javax.media.jai.FactoryCache;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationGraph;
import javax.media.jai.OperationNode;
import javax.media.jai.OperationRegistrySpi;
import javax.media.jai.PartialOrderNode;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.PropertySource;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.RegistryFileParser;
import javax.media.jai.RegistryMode;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.ThreadSafeOperationRegistry;
import javax.media.jai.registry.CIFRegistry;
import javax.media.jai.registry.CRIFRegistry;
import javax.media.jai.registry.RIFRegistry;
import javax.media.jai.util.CaselessStringKey;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public class OperationRegistry
implements Externalizable {
    static String JAI_REGISTRY_FILE = "META-INF/javax.media.jai.registryFile.jai";
    static String USR_REGISTRY_FILE = "META-INF/registryFile.jai";
    private Hashtable descriptors;
    private Hashtable factories;
    static /* synthetic */ Class class$javax$media$jai$OperationRegistry;
    static /* synthetic */ Class class$javax$media$jai$OperationRegistrySpi;
    static /* synthetic */ Class class$javax$media$jai$OperationDescriptor;

    private FactoryCache getFactoryCache(String string) {
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        FactoryCache factoryCache = (FactoryCache)this.factories.get(caselessStringKey);
        if (factoryCache == null) {
            if (RegistryMode.getMode(string) != null) {
                factoryCache = new FactoryCache(string);
                this.factories.put(caselessStringKey, factoryCache);
            } else {
                throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry0", new Object[]{string}));
            }
        }
        return factoryCache;
    }

    private DescriptorCache getDescriptorCache(String string) {
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        DescriptorCache descriptorCache = (DescriptorCache)this.descriptors.get(caselessStringKey);
        if (descriptorCache == null) {
            if (RegistryMode.getMode(string) != null) {
                descriptorCache = new DescriptorCache(string);
                this.descriptors.put(caselessStringKey, descriptorCache);
            } else {
                throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry0", new Object[]{string}));
            }
        }
        return descriptorCache;
    }

    private void initialize() {
        this.descriptors = new Hashtable();
        this.factories = new Hashtable();
    }

    public OperationRegistry() {
        this.initialize();
    }

    public static OperationRegistry getThreadSafeOperationRegistry() {
        return new ThreadSafeOperationRegistry();
    }

    static OperationRegistry initializeRegistry() {
        try {
            InputStream inputStream = PropertyUtil.getFileFromClasspath(JAI_REGISTRY_FILE);
            if (inputStream == null) {
                throw new RuntimeException(JaiI18N.getString("OperationRegistry1"));
            }
            ThreadSafeOperationRegistry threadSafeOperationRegistry = new ThreadSafeOperationRegistry();
            if (inputStream != null) {
                RegistryFileParser.loadOperationRegistry((OperationRegistry)threadSafeOperationRegistry, null, inputStream);
            }
            ((OperationRegistry)threadSafeOperationRegistry).registerServices(null);
            return threadSafeOperationRegistry;
        }
        catch (IOException iOException) {
            ImagingListener imagingListener = JAI.getDefaultInstance().getImagingListener();
            String string = JaiI18N.getString("OperationRegistry2");
            imagingListener.errorOccurred(string, new ImagingException(string, iOException), class$javax$media$jai$OperationRegistry == null ? (class$javax$media$jai$OperationRegistry = OperationRegistry.class$("javax.media.jai.OperationRegistry")) : class$javax$media$jai$OperationRegistry, false);
            return null;
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            RegistryFileParser.writeOperationRegistry(this, new BufferedWriter(stringWriter));
            return stringWriter.getBuffer().toString();
        }
        catch (Exception exception) {
            return "\n[ERROR!] " + exception.getMessage();
        }
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        RegistryFileParser.writeOperationRegistry(this, outputStream);
    }

    public void initializeFromStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initialize();
        this.updateFromStream(inputStream);
    }

    public void updateFromStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        RegistryFileParser.loadOperationRegistry(this, null, inputStream);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (objectInput == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        byte[] byArray = (byte[])objectInput.readObject();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.initializeFromStream(byteArrayInputStream);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (objectOutput == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeToStream(byteArrayOutputStream);
        objectOutput.writeObject(byteArrayOutputStream.toByteArray());
    }

    public void removeRegistryMode(String string) {
        if (this.getDescriptorCache(string) != null) {
            this.descriptors.remove(new CaselessStringKey(string));
        }
        if (this.getFactoryCache(string) != null) {
            this.factories.remove(new CaselessStringKey(string));
        }
    }

    public String[] getRegistryModes() {
        Enumeration enumeration = this.descriptors.keys();
        int n2 = this.descriptors.size();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            CaselessStringKey caselessStringKey = (CaselessStringKey)enumeration.nextElement();
            stringArray[n3] = caselessStringKey.getName();
            ++n3;
        }
        return stringArray;
    }

    public void registerDescriptor(RegistryElementDescriptor registryElementDescriptor) {
        if (registryElementDescriptor == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        String[] stringArray = registryElementDescriptor.getSupportedModes();
        String string = registryElementDescriptor.getName();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (RegistryMode.getMode(stringArray[n2]) == null) {
                throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry3", new Object[]{string, stringArray[n2]}));
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            DescriptorCache descriptorCache = this.getDescriptorCache(stringArray[n3]);
            descriptorCache.addDescriptor(registryElementDescriptor);
            ++n3;
        }
    }

    public void unregisterDescriptor(RegistryElementDescriptor registryElementDescriptor) {
        if (registryElementDescriptor == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        String string = registryElementDescriptor.getName();
        String[] stringArray = registryElementDescriptor.getSupportedModes();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (RegistryMode.getMode(stringArray[n2]) == null) {
                throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry3", new Object[]{string, stringArray[n2]}));
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            DescriptorCache descriptorCache = this.getDescriptorCache(stringArray[n3]);
            descriptorCache.removeDescriptor(registryElementDescriptor);
            ++n3;
        }
    }

    public RegistryElementDescriptor getDescriptor(Class clazz, String string) {
        if (clazz == null || string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        String[] stringArray = RegistryMode.getModeNames(clazz);
        if (stringArray == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry4", new Object[]{clazz.getName()}));
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            DescriptorCache descriptorCache = this.getDescriptorCache(stringArray[n2]);
            RegistryElementDescriptor registryElementDescriptor = descriptorCache.getDescriptor(string);
            if (registryElementDescriptor != null) {
                return registryElementDescriptor;
            }
            ++n2;
        }
        return null;
    }

    public List getDescriptors(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        String[] stringArray = RegistryMode.getModeNames(clazz);
        if (stringArray == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry4", new Object[]{clazz.getName()}));
        }
        HashSet hashSet = new HashSet();
        int n2 = 0;
        while (n2 < stringArray.length) {
            DescriptorCache descriptorCache = this.getDescriptorCache(stringArray[n2]);
            List list = descriptorCache.getDescriptors();
            if (list != null) {
                hashSet.addAll(list);
            }
            ++n2;
        }
        return new ArrayList(hashSet);
    }

    public String[] getDescriptorNames(Class clazz) {
        List list = this.getDescriptors(clazz);
        if (list != null) {
            Iterator iterator = list.iterator();
            String[] stringArray = new String[list.size()];
            int n2 = 0;
            while (iterator.hasNext()) {
                RegistryElementDescriptor registryElementDescriptor = (RegistryElementDescriptor)iterator.next();
                stringArray[n2++] = registryElementDescriptor.getName();
            }
            return stringArray;
        }
        return null;
    }

    public RegistryElementDescriptor getDescriptor(String string, String string2) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        if (descriptorCache != null) {
            return descriptorCache.getDescriptor(string2);
        }
        return null;
    }

    public List getDescriptors(String string) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        if (descriptorCache != null) {
            return descriptorCache.getDescriptors();
        }
        return null;
    }

    public String[] getDescriptorNames(String string) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        if (descriptorCache != null) {
            return descriptorCache.getDescriptorNames();
        }
        return null;
    }

    public void setProductPreference(String string, String string2, String string3, String string4) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        if (descriptorCache != null) {
            descriptorCache.setProductPreference(string2, string3, string4);
        }
    }

    public void unsetProductPreference(String string, String string2, String string3, String string4) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        if (descriptorCache != null) {
            descriptorCache.unsetProductPreference(string2, string3, string4);
        }
    }

    public void clearProductPreferences(String string, String string2) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        if (descriptorCache != null) {
            descriptorCache.clearProductPreferences(string2);
        }
    }

    public String[][] getProductPreferences(String string, String string2) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        if (descriptorCache != null) {
            return descriptorCache.getProductPreferences(string2);
        }
        return null;
    }

    public Vector getOrderedProductList(String string, String string2) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        if (descriptorCache != null) {
            return descriptorCache.getOrderedProductList(string2);
        }
        return null;
    }

    String getLocalName(String string, Object object) {
        FactoryCache factoryCache = this.getFactoryCache(string);
        if (factoryCache != null) {
            return factoryCache.getLocalName(object);
        }
        return null;
    }

    public void registerFactory(String string, String string2, String string3, Object object) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        FactoryCache factoryCache = this.getFactoryCache(string);
        if (descriptorCache.getDescriptor(string2) == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry5", new Object[]{string2, string}));
        }
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (descriptorCache.arePreferencesSupported) {
            OperationGraph operationGraph = descriptorCache.addProduct(string2, string3);
            if (operationGraph == null) {
                throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry5", new Object[]{string2, string}));
            }
            operationGraph.addOp(new PartialOrderNode(object, object.getClass().getName()));
        }
        factoryCache.addFactory(string2, string3, object);
    }

    public void unregisterFactory(String string, String string2, String string3, Object object) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        FactoryCache factoryCache = this.getFactoryCache(string);
        if (descriptorCache.getDescriptor(string2) == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry5", new Object[]{string2, string}));
        }
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        factoryCache.removeFactory(string2, string3, object);
        if (descriptorCache.arePreferencesSupported) {
            OperationGraph operationGraph = descriptorCache.lookupProduct(string2, string3);
            if (operationGraph == null) {
                throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry5", new Object[]{string2, string}));
            }
            operationGraph.removeOp(object);
        }
    }

    public void setFactoryPreference(String string, String string2, String string3, Object object, Object object2) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        FactoryCache factoryCache = this.getFactoryCache(string);
        if (descriptorCache.getDescriptor(string2) == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry5", new Object[]{string2, string}));
        }
        factoryCache.setPreference(string2, string3, object, object2);
        if (descriptorCache.arePreferencesSupported) {
            OperationGraph operationGraph = descriptorCache.lookupProduct(string2, string3);
            if (operationGraph == null) {
                throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry5", new Object[]{string2, string}));
            }
            operationGraph.setPreference(object, object2);
        }
    }

    public void unsetFactoryPreference(String string, String string2, String string3, Object object, Object object2) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        FactoryCache factoryCache = this.getFactoryCache(string);
        if (descriptorCache.getDescriptor(string2) == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry5", new Object[]{string2, string}));
        }
        factoryCache.unsetPreference(string2, string3, object, object2);
        if (descriptorCache.arePreferencesSupported) {
            OperationGraph operationGraph = descriptorCache.lookupProduct(string2, string3);
            if (operationGraph == null) {
                throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry5", new Object[]{string2, string}));
            }
            operationGraph.unsetPreference(object, object2);
        }
    }

    public void clearFactoryPreferences(String string, String string2, String string3) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        FactoryCache factoryCache = this.getFactoryCache(string);
        if (descriptorCache.getDescriptor(string2) == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry5", new Object[]{string2, string}));
        }
        Object[][] objectArray = factoryCache.getPreferences(string2, string3);
        if (objectArray != null) {
            OperationGraph operationGraph = descriptorCache.lookupProduct(string2, string3);
            if (operationGraph == null) {
                throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry5", new Object[]{string2, string}));
            }
            int n2 = 0;
            while (n2 < objectArray.length) {
                operationGraph.unsetPreference(objectArray[n2][0], objectArray[n2][1]);
                ++n2;
            }
        }
        factoryCache.clearPreferences(string2, string3);
    }

    public Object[][] getFactoryPreferences(String string, String string2, String string3) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        FactoryCache factoryCache = this.getFactoryCache(string);
        if (descriptorCache.getDescriptor(string2) == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry5", new Object[]{string2, string}));
        }
        return factoryCache.getPreferences(string2, string3);
    }

    public List getOrderedFactoryList(String string, String string2, String string3) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        FactoryCache factoryCache = this.getFactoryCache(string);
        if (descriptorCache.getDescriptor(string2) == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry5", new Object[]{string2, string}));
        }
        if (descriptorCache.arePreferencesSupported) {
            OperationGraph operationGraph = descriptorCache.lookupProduct(string2, string3);
            if (operationGraph == null) {
                return null;
            }
            Vector vector = operationGraph.getOrderedOperationList();
            if (vector == null || vector.size() <= 0) {
                return null;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(vector.size());
            int n2 = 0;
            while (n2 < vector.size()) {
                arrayList.add(((PartialOrderNode)vector.elementAt(n2)).getData());
                ++n2;
            }
            return arrayList;
        }
        return factoryCache.getFactoryList(string2, string3);
    }

    public Iterator getFactoryIterator(String string, String string2) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        FactoryCache factoryCache = this.getFactoryCache(string);
        if (descriptorCache.getDescriptor(string2) == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("OperationRegistry5", new Object[]{string2, string}));
        }
        if (descriptorCache.arePreferencesSupported) {
            Vector vector = this.getOrderedProductList(string, string2);
            if (vector == null || vector.size() <= 0) {
                return null;
            }
            ArrayList arrayList = new ArrayList();
            int n2 = 0;
            while (n2 < vector.size()) {
                List list = this.getOrderedFactoryList(string, string2, (String)vector.get(n2));
                if (list != null) {
                    arrayList.addAll(list);
                }
                ++n2;
            }
            return ((AbstractList)arrayList).iterator();
        }
        List list = factoryCache.getFactoryList(string2, null);
        if (list != null) {
            return list.iterator();
        }
        return null;
    }

    public Object getFactory(String string, String string2) {
        Iterator iterator = this.getFactoryIterator(string, string2);
        if (iterator != null && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public Object invokeFactory(String string, String string2, Object[] objectArray) {
        Iterator iterator = this.getFactoryIterator(string, string2);
        if (iterator == null) {
            return null;
        }
        FactoryCache factoryCache = this.getFactoryCache(string);
        ImagingListener imagingListener = JAI.getDefaultInstance().getImagingListener();
        Exception exception = null;
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            try {
                Object object = factoryCache.invoke(e2, objectArray);
                if (object != null) {
                    return object;
                }
                exception = null;
            }
            catch (Exception exception2) {
                imagingListener.errorOccurred(JaiI18N.getString("OperationRegistry6") + " \"" + string2 + "\"", exception2, this, false);
                exception = exception2;
            }
        }
        if (exception != null) {
            throw new ImagingException(JaiI18N.getString("OperationRegistry7") + " \"" + string2 + "\"", exception);
        }
        return null;
    }

    public void addPropertyGenerator(String string, String string2, PropertyGenerator propertyGenerator) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        if (descriptorCache != null) {
            descriptorCache.addPropertyGenerator(string2, propertyGenerator);
        }
    }

    public void removePropertyGenerator(String string, String string2, PropertyGenerator propertyGenerator) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        if (descriptorCache != null) {
            descriptorCache.removePropertyGenerator(string2, propertyGenerator);
        }
    }

    public void copyPropertyFromSource(String string, String string2, String string3, int n2) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        if (descriptorCache != null) {
            descriptorCache.copyPropertyFromSource(string2, string3, n2);
        }
    }

    public void suppressProperty(String string, String string2, String string3) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        if (descriptorCache != null) {
            descriptorCache.suppressProperty(string2, string3);
        }
    }

    public void suppressAllProperties(String string, String string2) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        if (descriptorCache != null) {
            descriptorCache.suppressAllProperties(string2);
        }
    }

    public void clearPropertyState(String string) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        if (descriptorCache != null) {
            descriptorCache.clearPropertyState();
        }
    }

    public String[] getGeneratedPropertyNames(String string, String string2) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        if (descriptorCache != null) {
            return descriptorCache.getGeneratedPropertyNames(string2);
        }
        return null;
    }

    public PropertySource getPropertySource(String string, String string2, Object object, Vector vector) {
        DescriptorCache descriptorCache = this.getDescriptorCache(string);
        if (descriptorCache != null) {
            return descriptorCache.getPropertySource(string2, object, vector);
        }
        return null;
    }

    public PropertySource getPropertySource(OperationNode operationNode) {
        Vector<Object> vector;
        if (operationNode == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        ParameterBlock parameterBlock = operationNode.getParameterBlock();
        Vector<Object> vector2 = vector = parameterBlock == null ? null : parameterBlock.getSources();
        if (vector == null) {
            vector = new Vector();
        }
        return this.getPropertySource(operationNode.getRegistryModeName(), operationNode.getOperationName(), operationNode, vector);
    }

    public void registerServices(ClassLoader classLoader) throws IOException {
        Object object;
        Enumeration<URL> enumeration = classLoader == null ? ClassLoader.getSystemResources(USR_REGISTRY_FILE) : classLoader.getResources(USR_REGISTRY_FILE);
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            RegistryFileParser.loadOperationRegistry(this, classLoader, (URL)object);
        }
        object = classLoader == null ? Service.providers(class$javax$media$jai$OperationRegistrySpi == null ? (class$javax$media$jai$OperationRegistrySpi = OperationRegistry.class$("javax.media.jai.OperationRegistrySpi")) : class$javax$media$jai$OperationRegistrySpi) : Service.providers(class$javax$media$jai$OperationRegistrySpi == null ? (class$javax$media$jai$OperationRegistrySpi = OperationRegistry.class$("javax.media.jai.OperationRegistrySpi")) : class$javax$media$jai$OperationRegistrySpi, classLoader);
        while (object.hasNext()) {
            OperationRegistrySpi operationRegistrySpi = (OperationRegistrySpi)object.next();
            operationRegistrySpi.updateRegistry(this);
        }
    }

    public void registerOperationDescriptor(OperationDescriptor operationDescriptor, String string) {
        this.registerDescriptor(operationDescriptor);
    }

    public void unregisterOperationDescriptor(String string) {
        String[] stringArray = RegistryMode.getModeNames(class$javax$media$jai$OperationDescriptor == null ? (class$javax$media$jai$OperationDescriptor = OperationRegistry.class$("javax.media.jai.OperationDescriptor")) : class$javax$media$jai$OperationDescriptor);
        int n2 = 0;
        while (n2 < stringArray.length) {
            RegistryElementDescriptor registryElementDescriptor = this.getDescriptor(stringArray[n2], string);
            if (registryElementDescriptor != null) {
                this.unregisterDescriptor(registryElementDescriptor);
            }
            ++n2;
        }
    }

    public OperationDescriptor getOperationDescriptor(String string) {
        return (OperationDescriptor)this.getDescriptor(class$javax$media$jai$OperationDescriptor == null ? (class$javax$media$jai$OperationDescriptor = OperationRegistry.class$("javax.media.jai.OperationDescriptor")) : class$javax$media$jai$OperationDescriptor, string);
    }

    public Vector getOperationDescriptors() {
        List list = this.getDescriptors(class$javax$media$jai$OperationDescriptor == null ? (class$javax$media$jai$OperationDescriptor = OperationRegistry.class$("javax.media.jai.OperationDescriptor")) : class$javax$media$jai$OperationDescriptor);
        return list == null ? null : new Vector(list);
    }

    public String[] getOperationNames() {
        return this.getDescriptorNames(class$javax$media$jai$OperationDescriptor == null ? (class$javax$media$jai$OperationDescriptor = OperationRegistry.class$("javax.media.jai.OperationDescriptor")) : class$javax$media$jai$OperationDescriptor);
    }

    public void registerRIF(String string, String string2, RenderedImageFactory renderedImageFactory) {
        this.registerFactory("rendered", string, string2, renderedImageFactory);
    }

    public void unregisterRIF(String string, String string2, RenderedImageFactory renderedImageFactory) {
        this.unregisterFactory("rendered", string, string2, renderedImageFactory);
    }

    public void registerCRIF(String string, ContextualRenderedImageFactory contextualRenderedImageFactory) {
        this.registerFactory("renderable", string, null, contextualRenderedImageFactory);
    }

    public void unregisterCRIF(String string, ContextualRenderedImageFactory contextualRenderedImageFactory) {
        this.unregisterFactory("renderable", string, null, contextualRenderedImageFactory);
    }

    public void registerCIF(String string, String string2, CollectionImageFactory collectionImageFactory) {
        this.registerFactory("collection", string, string2, collectionImageFactory);
    }

    public void unregisterCIF(String string, String string2, CollectionImageFactory collectionImageFactory) {
        this.unregisterFactory("collection", string, string2, collectionImageFactory);
    }

    public void setProductPreference(String string, String string2, String string3) {
        this.setProductPreference("rendered", string, string2, string3);
    }

    public void unsetProductPreference(String string, String string2, String string3) {
        this.unsetProductPreference("rendered", string, string2, string3);
    }

    public void clearProductPreferences(String string) {
        this.clearProductPreferences("rendered", string);
    }

    public String[][] getProductPreferences(String string) {
        return this.getProductPreferences("rendered", string);
    }

    public Vector getOrderedProductList(String string) {
        return this.getOrderedProductList("rendered", string);
    }

    public void setRIFPreference(String string, String string2, RenderedImageFactory renderedImageFactory, RenderedImageFactory renderedImageFactory2) {
        this.setFactoryPreference("rendered", string, string2, renderedImageFactory, renderedImageFactory2);
    }

    public void setCIFPreference(String string, String string2, CollectionImageFactory collectionImageFactory, CollectionImageFactory collectionImageFactory2) {
        this.setFactoryPreference("collection", string, string2, collectionImageFactory, collectionImageFactory2);
    }

    public void unsetRIFPreference(String string, String string2, RenderedImageFactory renderedImageFactory, RenderedImageFactory renderedImageFactory2) {
        this.unsetFactoryPreference("rendered", string, string2, renderedImageFactory, renderedImageFactory2);
    }

    public void unsetCIFPreference(String string, String string2, CollectionImageFactory collectionImageFactory, CollectionImageFactory collectionImageFactory2) {
        this.unsetFactoryPreference("collection", string, string2, collectionImageFactory, collectionImageFactory2);
    }

    public void clearRIFPreferences(String string, String string2) {
        this.clearFactoryPreferences("rendered", string, string2);
    }

    public void clearCIFPreferences(String string, String string2) {
        this.clearFactoryPreferences("collection", string, string2);
    }

    public void clearOperationPreferences(String string, String string2) {
        String[] stringArray = RegistryMode.getModeNames(class$javax$media$jai$OperationDescriptor == null ? (class$javax$media$jai$OperationDescriptor = OperationRegistry.class$("javax.media.jai.OperationDescriptor")) : class$javax$media$jai$OperationDescriptor);
        int n2 = 0;
        while (n2 < stringArray.length) {
            DescriptorCache descriptorCache = this.getDescriptorCache(stringArray[n2]);
            if (descriptorCache.arePreferencesSupported && this.getDescriptor(stringArray[n2], string) != null) {
                this.clearFactoryPreferences(stringArray[n2], string, string2);
            }
            ++n2;
        }
    }

    public Vector getOrderedRIFList(String string, String string2) {
        List list = this.getOrderedFactoryList("rendered", string, string2);
        return list == null ? null : new Vector(list);
    }

    public Vector getOrderedCIFList(String string, String string2) {
        List list = this.getOrderedFactoryList("collection", string, string2);
        return list == null ? null : new Vector(list);
    }

    public PlanarImage create(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        return PlanarImage.wrapRenderedImage(RIFRegistry.create(this, string, parameterBlock, renderingHints));
    }

    public ContextualRenderedImageFactory createRenderable(String string, ParameterBlock parameterBlock) {
        return CRIFRegistry.get(this, string);
    }

    public CollectionImage createCollection(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        return CIFRegistry.create(this, string, parameterBlock, renderingHints);
    }

    public void clearPropertyState() {
        this.clearPropertyState("rendered");
    }

    public void addPropertyGenerator(String string, PropertyGenerator propertyGenerator) {
        this.addPropertyGenerator("rendered", string, propertyGenerator);
    }

    public void removePropertyGenerator(String string, PropertyGenerator propertyGenerator) {
        this.removePropertyGenerator("rendered", string, propertyGenerator);
    }

    public void suppressProperty(String string, String string2) {
        this.suppressProperty("rendered", string, string2);
    }

    public void suppressAllProperties(String string) {
        this.suppressAllProperties("rendered", string);
    }

    public void copyPropertyFromSource(String string, String string2, int n2) {
        this.copyPropertyFromSource("rendered", string, string2, n2);
    }

    public String[] getGeneratedPropertyNames(String string) {
        return this.getGeneratedPropertyNames("rendered", string);
    }

    public PropertySource getPropertySource(RenderedOp renderedOp) {
        return RIFRegistry.getPropertySource(renderedOp);
    }

    public PropertySource getPropertySource(RenderableOp renderableOp) {
        return CRIFRegistry.getPropertySource(renderableOp);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

