/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.jai.JaiI18N;
import javax.media.jai.PartialOrderNode;

class OperationGraph
implements Serializable {
    Vector operations = new Vector();
    Vector orderedOperations;
    boolean isChanged = true;
    private boolean lookupByName = false;

    OperationGraph() {
    }

    OperationGraph(boolean bl) {
        this.lookupByName = bl;
    }

    private boolean compare(PartialOrderNode partialOrderNode, Object object) {
        if (this.lookupByName) {
            return partialOrderNode.getName().equalsIgnoreCase((String)object);
        }
        return partialOrderNode.getData() == object;
    }

    void addOp(PartialOrderNode partialOrderNode) {
        this.operations.addElement(partialOrderNode);
        this.isChanged = true;
    }

    synchronized boolean removeOp(Object object) {
        boolean bl = false;
        PartialOrderNode partialOrderNode = this.lookupOp(object);
        if (partialOrderNode != null && (bl = this.operations.removeElement(partialOrderNode))) {
            this.isChanged = true;
        }
        return bl;
    }

    PartialOrderNode lookupOp(Object object) {
        int n2 = this.operations.size();
        int n3 = 0;
        while (n3 < n2) {
            PartialOrderNode partialOrderNode = (PartialOrderNode)this.operations.elementAt(n3);
            if (this.compare(partialOrderNode, object)) {
                PartialOrderNode partialOrderNode2 = partialOrderNode;
                return partialOrderNode2;
            }
            ++n3;
        }
        return null;
    }

    synchronized boolean setPreference(Object object, Object object2) {
        boolean bl = false;
        if (object == null || object2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (object == object2) {
            return bl;
        }
        PartialOrderNode partialOrderNode = this.lookupOp(object);
        PartialOrderNode partialOrderNode2 = this.lookupOp(object2);
        if (partialOrderNode != null && partialOrderNode2 != null) {
            partialOrderNode.addEdge(partialOrderNode2);
            bl = true;
            this.isChanged = true;
        }
        return bl;
    }

    synchronized boolean unsetPreference(Object object, Object object2) {
        boolean bl = false;
        if (object == null || object2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (object == object2) {
            return bl;
        }
        PartialOrderNode partialOrderNode = this.lookupOp(object);
        PartialOrderNode partialOrderNode2 = this.lookupOp(object2);
        if (partialOrderNode != null && partialOrderNode2 != null) {
            partialOrderNode.removeEdge(partialOrderNode2);
            bl = true;
            this.isChanged = true;
        }
        return bl;
    }

    public synchronized Vector getOrderedOperationList() {
        Cloneable cloneable;
        PartialOrderNode partialOrderNode;
        PartialOrderNode partialOrderNode2;
        if (!this.isChanged) {
            Vector vector = this.orderedOperations;
            return vector;
        }
        int n2 = this.operations.size();
        int n3 = 0;
        while (n3 < n2) {
            partialOrderNode2 = (PartialOrderNode)this.operations.elementAt(n3);
            partialOrderNode2.setCopyInDegree(partialOrderNode2.getInDegree());
            ++n3;
        }
        this.orderedOperations = new Vector(n2);
        this.isChanged = false;
        partialOrderNode2 = null;
        int n4 = 0;
        while (n4 < n2) {
            partialOrderNode = (PartialOrderNode)this.operations.elementAt(n4);
            if (partialOrderNode.getCopyInDegree() == 0) {
                partialOrderNode.setZeroLink(partialOrderNode2);
                partialOrderNode2 = partialOrderNode;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            if (partialOrderNode2 == null) {
                this.orderedOperations = null;
                return null;
            }
            cloneable = partialOrderNode2;
            this.orderedOperations.addElement(cloneable);
            partialOrderNode2 = partialOrderNode2.getZeroLink();
            Enumeration enumeration = ((PartialOrderNode)cloneable).getNeighbors();
            while (enumeration.hasMoreElements()) {
                partialOrderNode = (PartialOrderNode)enumeration.nextElement();
                partialOrderNode.decrementCopyInDegree();
                if (partialOrderNode.getCopyInDegree() != 0) continue;
                partialOrderNode.setZeroLink(partialOrderNode2);
                partialOrderNode2 = partialOrderNode;
            }
            ++n4;
        }
        cloneable = this.orderedOperations;
        return cloneable;
    }
}

