/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import javax.media.jai.Interpolation;
import javax.media.jai.JaiI18N;

public class InterpolationTable
extends Interpolation {
    protected int precisionBits;
    private int round;
    private int numSubsamplesH;
    private int numSubsamplesV;
    protected double[] dataHd;
    protected double[] dataVd;
    protected float[] dataHf;
    protected float[] dataVf;
    protected int[] dataHi;
    protected int[] dataVi;

    public InterpolationTable(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray, int[] nArray2) {
        this.leftPadding = n2;
        this.topPadding = n3;
        this.width = n4;
        this.rightPadding = n4 - n2 - 1;
        this.precisionBits = n8;
        if (n8 > 0) {
            this.round = 1 << n8 - 1;
        }
        this.subsampleBitsH = n6;
        this.numSubsamplesH = 1 << n6;
        int n9 = n4 * this.numSubsamplesH;
        if (nArray.length != n9) {
            throw new IllegalArgumentException(JaiI18N.getString("InterpolationTable0"));
        }
        double d2 = 1 << n8;
        this.dataHi = (int[])nArray.clone();
        this.dataHf = new float[n9];
        this.dataHd = new double[n9];
        int n10 = 0;
        while (n10 < n9) {
            double d3 = (double)this.dataHi[n10] / d2;
            this.dataHf[n10] = (float)d3;
            this.dataHd[n10] = d3;
            ++n10;
        }
        if (nArray2 != null) {
            this.height = n5;
            this.subsampleBitsV = n7;
            this.numSubsamplesV = 1 << n7;
            int n11 = n5 * this.numSubsamplesV;
            if (nArray2.length != n11) {
                throw new IllegalArgumentException(JaiI18N.getString("InterpolationTable1"));
            }
            this.dataVi = (int[])nArray2.clone();
            this.dataVf = new float[n11];
            this.dataVd = new double[n11];
            n10 = 0;
            while (n10 < n11) {
                double d4 = (double)this.dataVi[n10] / d2;
                this.dataVf[n10] = (float)d4;
                this.dataVd[n10] = d4;
                ++n10;
            }
        } else {
            this.height = n4;
            this.subsampleBitsV = n6;
            this.numSubsamplesV = this.numSubsamplesH;
            this.dataVf = this.dataHf;
            this.dataVi = this.dataHi;
            this.dataVd = this.dataHd;
        }
        this.bottomPadding = this.height - n3 - 1;
    }

    public InterpolationTable(int n2, int n3, int n4, int n5, int[] nArray) {
        this(n2, n2, n3, n3, n4, n4, n5, nArray, (int[])null);
    }

    public InterpolationTable(int n2, int n3, int n4, int n5, int n6, int n7, int n8, float[] fArray, float[] fArray2) {
        this.leftPadding = n2;
        this.topPadding = n3;
        this.width = n4;
        this.rightPadding = n4 - n2 - 1;
        this.precisionBits = n8;
        if (n8 > 0) {
            this.round = 1 << n8 - 1;
        }
        this.subsampleBitsH = n6;
        this.numSubsamplesH = 1 << n6;
        int n9 = n4 * this.numSubsamplesH;
        if (fArray.length != n9) {
            throw new IllegalArgumentException(JaiI18N.getString("InterpolationTable0"));
        }
        float f2 = 1 << n8;
        this.dataHf = (float[])fArray.clone();
        this.dataHi = new int[n9];
        this.dataHd = new double[n9];
        int n10 = 0;
        while (n10 < n9) {
            float f3 = this.dataHf[n10];
            this.dataHi[n10] = Math.round(f3 * f2);
            this.dataHd[n10] = f3;
            ++n10;
        }
        if (fArray2 != null) {
            this.height = n5;
            this.subsampleBitsV = n7;
            this.numSubsamplesV = 1 << n7;
            int n11 = n5 * this.numSubsamplesV;
            if (fArray2.length != n11) {
                throw new IllegalArgumentException(JaiI18N.getString("InterpolationTable1"));
            }
            this.dataVf = (float[])fArray2.clone();
            this.dataVi = new int[n11];
            this.dataVd = new double[n11];
            n10 = 0;
            while (n10 < n11) {
                float f4 = this.dataVf[n10];
                this.dataVi[n10] = Math.round(f4 * f2);
                this.dataVd[n10] = f4;
                ++n10;
            }
        } else {
            this.height = n4;
            this.subsampleBitsV = n6;
            this.numSubsamplesV = this.numSubsamplesH;
            this.dataVf = this.dataHf;
            this.dataVi = this.dataHi;
            this.dataVd = this.dataHd;
        }
        this.bottomPadding = this.height - n3 - 1;
    }

    public InterpolationTable(int n2, int n3, int n4, int n5, float[] fArray) {
        this(n2, n2, n3, n3, n4, n4, n5, fArray, (float[])null);
    }

    public InterpolationTable(int n2, int n3, int n4, int n5, int n6, int n7, int n8, double[] dArray, double[] dArray2) {
        this.leftPadding = n2;
        this.topPadding = n3;
        this.width = n4;
        this.rightPadding = n4 - n2 - 1;
        this.precisionBits = n8;
        if (n8 > 0) {
            this.round = 1 << n8 - 1;
        }
        this.subsampleBitsH = n6;
        this.numSubsamplesH = 1 << n6;
        int n9 = n4 * this.numSubsamplesH;
        if (dArray.length != n9) {
            throw new IllegalArgumentException(JaiI18N.getString("InterpolationTable0"));
        }
        double d2 = 1 << n8;
        this.dataHd = (double[])dArray.clone();
        this.dataHi = new int[n9];
        this.dataHf = new float[n9];
        int n10 = 0;
        while (n10 < n9) {
            double d3 = this.dataHd[n10];
            this.dataHi[n10] = (int)Math.round(d3 * d2);
            this.dataHf[n10] = (float)d3;
            ++n10;
        }
        if (dArray2 != null) {
            this.height = n5;
            this.subsampleBitsV = n7;
            this.numSubsamplesV = 1 << n7;
            int n11 = n5 * this.numSubsamplesV;
            if (dArray2.length != n11) {
                throw new IllegalArgumentException(JaiI18N.getString("InterpolationTable1"));
            }
            this.dataVd = (double[])dArray2.clone();
            this.dataVi = new int[n11];
            this.dataVf = new float[n11];
            n10 = 0;
            while (n10 < n11) {
                double d4 = this.dataVd[n10];
                this.dataVi[n10] = (int)Math.round(d4 * d2);
                this.dataVf[n10] = (float)d4;
                ++n10;
            }
        } else {
            this.height = n4;
            this.subsampleBitsV = n6;
            this.numSubsamplesV = this.numSubsamplesH;
            this.dataVd = this.dataHd;
            this.dataVf = this.dataHf;
            this.dataVi = this.dataHi;
        }
        this.bottomPadding = this.height - n3 - 1;
    }

    public InterpolationTable(int n2, int n3, int n4, int n5, double[] dArray) {
        this(n2, n2, n3, n3, n4, n4, n5, dArray, null);
    }

    public int getPrecisionBits() {
        return this.precisionBits;
    }

    public int[] getHorizontalTableData() {
        return this.dataHi;
    }

    public int[] getVerticalTableData() {
        return this.dataVi;
    }

    public float[] getHorizontalTableDataFloat() {
        return this.dataHf;
    }

    public float[] getVerticalTableDataFloat() {
        return this.dataVf;
    }

    public double[] getHorizontalTableDataDouble() {
        return this.dataHd;
    }

    public double[] getVerticalTableDataDouble() {
        return this.dataVd;
    }

    public int interpolateH(int[] nArray, int n2) {
        int n3 = 0;
        int n4 = this.width * n2;
        int n5 = 0;
        while (n5 < this.width) {
            n3 += this.dataHi[n4 + n5] * nArray[n5];
            ++n5;
        }
        return n3 + this.round >> this.precisionBits;
    }

    public int interpolateV(int[] nArray, int n2) {
        int n3 = 0;
        int n4 = this.width * n2;
        int n5 = 0;
        while (n5 < this.width) {
            n3 += this.dataVi[n4 + n5] * nArray[n5];
            ++n5;
        }
        return n3 + this.round >> this.precisionBits;
    }

    public int interpolateH(int n2, int n3, int n4) {
        int n5 = 2 * n4;
        int n6 = this.dataHi[n5] * n2;
        return (n6 += this.dataHi[n5 + 1] * n3) + this.round >> this.precisionBits;
    }

    public int interpolateH(int n2, int n3, int n4, int n5, int n6) {
        int n7 = 4 * n6;
        int n8 = this.dataHi[n7] * n2;
        n8 += this.dataHi[n7 + 1] * n3;
        n8 += this.dataHi[n7 + 2] * n4;
        return (n8 += this.dataHi[n7 + 3] * n5) + this.round >> this.precisionBits;
    }

    public int interpolateV(int n2, int n3, int n4) {
        int n5 = 2 * n4;
        int n6 = this.dataVi[n5] * n2;
        return (n6 += this.dataVi[n5 + 1] * n3) + this.round >> this.precisionBits;
    }

    public int interpolateV(int n2, int n3, int n4, int n5, int n6) {
        int n7 = 4 * n6;
        int n8 = this.dataVi[n7] * n2;
        n8 += this.dataVi[n7 + 1] * n3;
        n8 += this.dataVi[n7 + 2] * n4;
        return (n8 += this.dataVi[n7 + 3] * n5) + this.round >> this.precisionBits;
    }

    public int interpolate(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 2 * n6;
        int n9 = this.dataHi[n8] * n2 + this.dataHi[n8 + 1] * n3;
        int n10 = this.dataHi[n8] * n4 + this.dataHi[n8 + 1] * n5;
        n9 = n9 + this.round >> this.precisionBits;
        n10 = n10 + this.round >> this.precisionBits;
        int n11 = 2 * n7;
        int n12 = this.dataVi[n11] * n9 + this.dataVi[n11 + 1] * n10;
        return n12 + this.round >> this.precisionBits;
    }

    public int interpolate(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19) {
        int n20 = 4 * n18;
        int n21 = n20 + 1;
        int n22 = n20 + 2;
        int n23 = n20 + 3;
        long l2 = (long)this.dataHi[n20] * (long)n2;
        l2 += (long)this.dataHi[n21] * (long)n3;
        l2 += (long)this.dataHi[n22] * (long)n4;
        l2 += (long)this.dataHi[n23] * (long)n5;
        long l3 = (long)this.dataHi[n20] * (long)n6;
        l3 += (long)this.dataHi[n21] * (long)n7;
        l3 += (long)this.dataHi[n22] * (long)n8;
        l3 += (long)this.dataHi[n23] * (long)n9;
        long l4 = (long)this.dataHi[n20] * (long)n10;
        l4 += (long)this.dataHi[n21] * (long)n11;
        l4 += (long)this.dataHi[n22] * (long)n12;
        l4 += (long)this.dataHi[n23] * (long)n13;
        long l5 = (long)this.dataHi[n20] * (long)n14;
        l5 += (long)this.dataHi[n21] * (long)n15;
        l5 += (long)this.dataHi[n22] * (long)n16;
        l5 += (long)this.dataHi[n23] * (long)n17;
        l2 = l2 + (long)this.round >> this.precisionBits;
        l3 = l3 + (long)this.round >> this.precisionBits;
        l4 = l4 + (long)this.round >> this.precisionBits;
        l5 = l5 + (long)this.round >> this.precisionBits;
        int n24 = 4 * n19;
        long l6 = (long)this.dataVi[n24] * l2;
        l6 += (long)this.dataVi[n24 + 1] * l3;
        l6 += (long)this.dataVi[n24 + 2] * l4;
        return (int)((l6 += (long)this.dataVi[n24 + 3] * l5) + (long)this.round >> this.precisionBits);
    }

    public int interpolateF(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19) {
        int n20 = 4 * n18;
        float f2 = this.dataHf[n20] * (float)n2;
        f2 += this.dataHf[n20 + 1] * (float)n3;
        f2 += this.dataHf[n20 + 2] * (float)n4;
        f2 += this.dataHf[n20 + 3] * (float)n5;
        float f3 = this.dataHf[n20] * (float)n6;
        f3 += this.dataHf[n20 + 1] * (float)n7;
        f3 += this.dataHf[n20 + 2] * (float)n8;
        f3 += this.dataHf[n20 + 3] * (float)n9;
        float f4 = this.dataHf[n20] * (float)n10;
        f4 += this.dataHf[n20 + 1] * (float)n11;
        f4 += this.dataHf[n20 + 2] * (float)n12;
        f4 += this.dataHf[n20 + 3] * (float)n13;
        float f5 = this.dataHf[n20] * (float)n14;
        f5 += this.dataHf[n20 + 1] * (float)n15;
        f5 += this.dataHf[n20 + 2] * (float)n16;
        int n21 = 4 * n19;
        float f6 = this.dataVf[n21] * f2;
        f6 += this.dataVf[n21 + 1] * f3;
        f6 += this.dataVf[n21 + 2] * f4;
        int n22 = (int)(f6 += this.dataVf[n21 + 3] * (f5 += this.dataHf[n20 + 3] * (float)n17));
        return n22;
    }

    public float interpolateH(float[] fArray, float f2) {
        float f3 = 0.0f;
        int n2 = (int)(f2 * (float)this.numSubsamplesH);
        int n3 = this.width * n2;
        int n4 = 0;
        while (n4 < this.width) {
            f3 += this.dataHf[n3 + n4] * fArray[n4];
            ++n4;
        }
        return f3;
    }

    public float interpolateV(float[] fArray, float f2) {
        float f3 = 0.0f;
        int n2 = (int)(f2 * (float)this.numSubsamplesV);
        int n3 = this.width * n2;
        int n4 = 0;
        while (n4 < this.width) {
            f3 += this.dataVf[n3 + n4] * fArray[n4];
            ++n4;
        }
        return f3;
    }

    public float interpolateH(float f2, float f3, float f4) {
        float f5 = 0.0f;
        int n2 = (int)(f4 * (float)this.numSubsamplesH);
        int n3 = 2 * n2;
        f5 = this.dataHf[n3] * f2 + this.dataHf[n3 + 1] * f3;
        return f5;
    }

    public float interpolateH(float f2, float f3, float f4, float f5, float f6) {
        int n2 = (int)(f6 * (float)this.numSubsamplesH);
        int n3 = 4 * n2;
        float f7 = this.dataHf[n3] * f2;
        f7 += this.dataHf[n3 + 1] * f3;
        f7 += this.dataHf[n3 + 2] * f4;
        return f7 += this.dataHf[n3 + 3] * f5;
    }

    public float interpolateV(float f2, float f3, float f4) {
        int n2 = (int)(f4 * (float)this.numSubsamplesV);
        int n3 = 2 * n2;
        float f5 = this.dataVf[n3] * f2;
        return f5 += this.dataVf[n3 + 1] * f3;
    }

    public float interpolateV(float f2, float f3, float f4, float f5, float f6) {
        int n2 = (int)(f6 * (float)this.numSubsamplesV);
        int n3 = 4 * n2;
        float f7 = this.dataVf[n3] * f2;
        f7 += this.dataVf[n3 + 1] * f3;
        f7 += this.dataVf[n3 + 2] * f4;
        return f7 += this.dataVf[n3 + 3] * f5;
    }

    public float interpolate(float f2, float f3, float f4, float f5, float f6, float f7) {
        int n2 = (int)(f6 * (float)this.numSubsamplesH);
        int n3 = 2 * n2;
        float f8 = this.dataHf[n3] * f2 + this.dataHf[n3 + 1] * f3;
        float f9 = this.dataHf[n3] * f4 + this.dataHf[n3 + 1] * f5;
        n2 = (int)(f7 * (float)this.numSubsamplesV);
        int n4 = 2 * n2;
        float f10 = this.dataVf[n4] * f8 + this.dataVf[n4 + 1] * f9;
        return f10;
    }

    public float interpolate(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19) {
        int n2 = (int)(f18 * (float)this.numSubsamplesH);
        int n3 = 4 * n2;
        int n4 = n3 + 1;
        int n5 = n3 + 2;
        int n6 = n3 + 3;
        float f20 = this.dataHf[n3] * f2;
        f20 += this.dataHf[n4] * f3;
        f20 += this.dataHf[n5] * f4;
        f20 += this.dataHf[n6] * f5;
        float f21 = this.dataHf[n3] * f6;
        f21 += this.dataHf[n4] * f7;
        f21 += this.dataHf[n5] * f8;
        f21 += this.dataHf[n6] * f9;
        float f22 = this.dataHf[n3] * f10;
        f22 += this.dataHf[n4] * f11;
        f22 += this.dataHf[n5] * f12;
        f22 += this.dataHf[n6] * f13;
        float f23 = this.dataHf[n3] * f14;
        f23 += this.dataHf[n4] * f15;
        f23 += this.dataHf[n5] * f16;
        f23 += this.dataHf[n6] * f17;
        n2 = (int)(f19 * (float)this.numSubsamplesV);
        int n7 = 4 * n2;
        float f24 = this.dataVf[n7] * f20;
        f24 += this.dataVf[n7 + 1] * f21;
        f24 += this.dataVf[n7 + 2] * f22;
        return f24 += this.dataVf[n7 + 3] * f23;
    }

    public double interpolateH(double[] dArray, float f2) {
        double d2 = 0.0;
        int n2 = (int)(f2 * (float)this.numSubsamplesH);
        int n3 = this.width * n2;
        int n4 = 0;
        while (n4 < this.width) {
            d2 += this.dataHd[n3 + n4] * dArray[n4];
            ++n4;
        }
        return d2;
    }

    public double interpolateV(double[] dArray, float f2) {
        double d2 = 0.0;
        int n2 = (int)(f2 * (float)this.numSubsamplesV);
        int n3 = this.width * n2;
        int n4 = 0;
        while (n4 < this.width) {
            d2 += this.dataVd[n3 + n4] * dArray[n4];
            ++n4;
        }
        return d2;
    }

    public double interpolateH(double d2, double d3, float f2) {
        double d4 = 0.0;
        int n2 = (int)(f2 * (float)this.numSubsamplesH);
        int n3 = 2 * n2;
        d4 = this.dataHd[n3] * d2 + this.dataHd[n3 + 1] * d3;
        return d4;
    }

    public double interpolateH(double d2, double d3, double d4, double d5, float f2) {
        int n2 = (int)(f2 * (float)this.numSubsamplesH);
        int n3 = 4 * n2;
        double d6 = this.dataHd[n3] * d2;
        d6 += this.dataHd[n3 + 1] * d3;
        d6 += this.dataHd[n3 + 2] * d4;
        return d6 += this.dataHd[n3 + 3] * d5;
    }

    public double interpolateV(double d2, double d3, float f2) {
        int n2 = (int)(f2 * (float)this.numSubsamplesV);
        int n3 = 2 * n2;
        double d4 = this.dataVd[n3] * d2;
        return d4 += this.dataVd[n3 + 1] * d3;
    }

    public double interpolateV(double d2, double d3, double d4, double d5, float f2) {
        int n2 = (int)(f2 * (float)this.numSubsamplesV);
        int n3 = 4 * n2;
        double d6 = this.dataVd[n3] * d2;
        d6 += this.dataVd[n3 + 1] * d3;
        d6 += this.dataVd[n3 + 2] * d4;
        return d6 += this.dataVd[n3 + 3] * d5;
    }

    public double interpolate(double d2, double d3, double d4, double d5, float f2, float f3) {
        int n2 = (int)(f2 * (float)this.numSubsamplesH);
        int n3 = 2 * n2;
        double d6 = this.dataHd[n3] * d2 + this.dataHd[n3 + 1] * d3;
        double d7 = this.dataHd[n3] * d4 + this.dataHd[n3 + 1] * d5;
        n2 = (int)(f3 * (float)this.numSubsamplesV);
        int n4 = 2 * n2;
        double d8 = this.dataVd[n4] * d6 + this.dataVd[n4 + 1] * d7;
        return d8;
    }

    public double interpolate(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17, float f2, float f3) {
        int n2 = (int)(f2 * (float)this.numSubsamplesH);
        int n3 = 4 * n2;
        int n4 = n3 + 1;
        int n5 = n3 + 2;
        int n6 = n3 + 3;
        double d18 = this.dataHd[n3] * d2;
        d18 += this.dataHd[n4] * d3;
        d18 += this.dataHd[n5] * d4;
        d18 += this.dataHd[n6] * d5;
        double d19 = this.dataHd[n3] * d6;
        d19 += this.dataHd[n4] * d7;
        d19 += this.dataHd[n5] * d8;
        d19 += this.dataHd[n6] * d9;
        double d20 = this.dataHd[n3] * d10;
        d20 += this.dataHd[n4] * d11;
        d20 += this.dataHd[n5] * d12;
        d20 += this.dataHd[n6] * d13;
        double d21 = this.dataHd[n3] * d14;
        d21 += this.dataHd[n4] * d15;
        d21 += this.dataHd[n5] * d16;
        d21 += this.dataHd[n6] * d17;
        n2 = (int)(f3 * (float)this.numSubsamplesV);
        int n7 = 4 * n2;
        double d22 = this.dataVd[n7] * d18;
        d22 += this.dataVd[n7 + 1] * d19;
        d22 += this.dataVd[n7 + 2] * d20;
        return d22 += this.dataVd[n7 + 3] * d21;
    }
}

