/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;

public abstract class GeometricOpImage
extends OpImage {
    protected Interpolation interp;
    protected BorderExtender extender = null;
    protected Rectangle computableBounds;
    protected boolean setBackground;
    protected double[] backgroundValues;
    protected int[] intBackgroundValues;

    public GeometricOpImage(Vector vector, ImageLayout imageLayout, Map map, boolean bl, BorderExtender borderExtender, Interpolation interpolation) {
        this(vector, imageLayout, map, bl, borderExtender, interpolation, null);
    }

    private static Map configHelper(Map map) {
        Map map2;
        if (map == null) {
            map2 = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
        } else {
            map2 = map;
            if (!map2.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints renderingHints = new RenderingHints(null);
                renderingHints.putAll((Map<?, ?>)map);
                map2 = renderingHints;
                map2.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
            }
        }
        return map2;
    }

    public GeometricOpImage(Vector vector, ImageLayout imageLayout, Map map, boolean bl, BorderExtender borderExtender, Interpolation interpolation, double[] dArray) {
        super(vector, imageLayout, GeometricOpImage.configHelper(map), bl);
        int n2;
        this.extender = borderExtender;
        Interpolation interpolation2 = this.interp = interpolation != null ? interpolation : new InterpolationNearest();
        if (dArray == null) {
            dArray = new double[]{0.0};
        }
        this.setBackground = false;
        int n3 = 0;
        while (n3 < dArray.length) {
            if (dArray[n3] != 0.0) {
                this.setBackground = true;
            }
            ++n3;
        }
        this.backgroundValues = dArray;
        int n4 = this.getSampleModel().getNumBands();
        if (dArray.length < n4) {
            this.backgroundValues = new double[n4];
            n2 = 0;
            while (n2 < n4) {
                this.backgroundValues[n2] = dArray[0];
                ++n2;
            }
        }
        if (this.sampleModel.getDataType() <= 3) {
            n2 = this.backgroundValues.length;
            this.intBackgroundValues = new int[n2];
            int n5 = 0;
            while (n5 < n2) {
                this.intBackgroundValues[n5] = (int)this.backgroundValues[n5];
                ++n5;
            }
        }
        this.computableBounds = this.getBounds();
    }

    public Interpolation getInterpolation() {
        return this.interp;
    }

    public BorderExtender getBorderExtender() {
        return this.extender;
    }

    public Point2D mapDestPoint(Point2D point2D, int n2) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        Rectangle rectangle = new Rectangle((int)point2D.getX(), (int)point2D.getY(), 1, 1);
        Rectangle rectangle2 = this.backwardMapRect(rectangle, n2);
        if (rectangle2 == null) {
            return null;
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation((double)rectangle2.x + ((double)rectangle2.width - 1.0) / 2.0, (double)rectangle2.y + ((double)rectangle2.height - 1.0) / 2.0);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D, int n2) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        Rectangle rectangle = new Rectangle((int)point2D.getX(), (int)point2D.getY(), 1, 1);
        Rectangle rectangle2 = this.forwardMapRect(rectangle, n2);
        if (rectangle2 == null) {
            return null;
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation((double)rectangle2.x + ((double)rectangle2.width - 1.0) / 2.0, (double)rectangle2.y + ((double)rectangle2.height - 1.0) / 2.0);
        return point2D2;
    }

    protected abstract Rectangle forwardMapRect(Rectangle var1, int var2);

    protected abstract Rectangle backwardMapRect(Rectangle var1, int var2);

    public Rectangle mapSourceRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n3 = this.interp.getLeftPadding();
        int n4 = this.interp.getTopPadding();
        Rectangle rectangle2 = (Rectangle)rectangle.clone();
        rectangle2.x += n3;
        rectangle2.y += n4;
        rectangle2.width -= n3 + this.interp.getRightPadding();
        rectangle2.height -= n4 + this.interp.getBottomPadding();
        Rectangle rectangle3 = this.forwardMapRect(rectangle2, n2);
        return rectangle3 == null ? this.getBounds() : rectangle3;
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        Rectangle rectangle2 = this.backwardMapRect(rectangle, n2);
        if (rectangle2 == null) {
            return this.getSource(n2).getBounds();
        }
        int n3 = this.interp.getLeftPadding();
        int n4 = this.interp.getTopPadding();
        return new Rectangle(rectangle2.x - n3, rectangle2.y - n4, rectangle2.width + n3 + this.interp.getRightPadding(), rectangle2.height + n4 + this.interp.getBottomPadding());
    }

    public Raster computeTile(int n2, int n3) {
        Point point = new Point(this.tileXToX(n2), this.tileYToY(n3));
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = this.getTileRect(n2, n3).intersection(this.getBounds());
        if (rectangle.isEmpty()) {
            if (this.setBackground) {
                ImageUtil.fillBackground(writableRaster, rectangle, this.backgroundValues);
            }
            return writableRaster;
        }
        int n4 = this.getNumSources();
        if (this.cobbleSources) {
            Object object;
            Raster[] rasterArray = new Raster[n4];
            int n5 = 0;
            while (n5 < n4) {
                PlanarImage planarImage = this.getSource(n5);
                object = this.mapDestRect(rectangle, n5);
                if (object == null) {
                    object = planarImage.getBounds();
                } else if (!((Rectangle)object).intersects(planarImage.getBounds())) {
                    if (this.setBackground) {
                        ImageUtil.fillBackground(writableRaster, rectangle, this.backgroundValues);
                    }
                    return writableRaster;
                }
                rasterArray[n5] = this.extender != null ? planarImage.getExtendedData((Rectangle)object, this.extender) : planarImage.getData((Rectangle)object);
                ++n5;
            }
            this.computeRect(rasterArray, writableRaster, rectangle);
            int n6 = 0;
            while (n6 < n4) {
                PlanarImage planarImage;
                object = rasterArray[n6];
                if (object != null && (planarImage = this.getSourceImage(n6)).overlapsMultipleTiles(((Raster)object).getBounds())) {
                    this.recycleTile((Raster)object);
                }
                ++n6;
            }
        } else {
            PlanarImage[] planarImageArray = new PlanarImage[n4];
            int n7 = 0;
            while (n7 < n4) {
                planarImageArray[n7] = this.getSource(n7);
                ++n7;
            }
            this.computeRect(planarImageArray, writableRaster, rectangle);
        }
        return writableRaster;
    }
}

