/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;

public final class BorderExtenderConstant
extends BorderExtender {
    private double[] constants;

    public BorderExtenderConstant(double[] dArray) {
        this.constants = dArray;
    }

    private int clamp(int n2, int n3, int n4) {
        double d2;
        int n5 = this.constants.length;
        if (n5 == 1) {
            d2 = this.constants[0];
        } else if (n2 < n5) {
            d2 = this.constants[n2];
        } else {
            throw new UnsupportedOperationException(JaiI18N.getString("BorderExtenderConstant0"));
        }
        return d2 > (double)n3 ? (d2 > (double)n4 ? n4 : (int)d2) : n3;
    }

    public final double[] getConstants() {
        return this.constants;
    }

    public final void extend(WritableRaster writableRaster, PlanarImage planarImage) {
        if (writableRaster == null || planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n2 = writableRaster.getWidth();
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getNumBands();
        int n5 = writableRaster.getMinX();
        int n6 = n5 + n2;
        int n7 = writableRaster.getMinY();
        int n8 = n7 + n3;
        int n9 = Math.max(planarImage.getMinX(), n5);
        int n10 = Math.min(planarImage.getMaxX(), n6);
        int n11 = Math.max(planarImage.getMinY(), n7);
        int n12 = Math.min(planarImage.getMaxY(), n8);
        int n13 = writableRaster.getSampleModel().getDataType();
        if (n13 == 4) {
            float[] fArray = new float[n4];
            int n14 = 0;
            while (n14 < n4) {
                fArray[n14] = n14 < this.constants.length ? (float)this.constants[n14] : 0.0f;
                ++n14;
            }
            float[] fArray2 = new float[n2 * n4];
            int n15 = 0;
            int n16 = 0;
            while (n16 < n2) {
                int n17 = 0;
                while (n17 < n4) {
                    fArray2[n15++] = fArray[n17];
                    ++n17;
                }
                ++n16;
            }
            if (n9 > n10 || n11 > n12) {
                int n18 = n7;
                while (n18 < n8) {
                    writableRaster.setPixels(n5, n18, n2, 1, fArray2);
                    ++n18;
                }
            } else {
                int n19 = n7;
                while (n19 < n11) {
                    writableRaster.setPixels(n5, n19, n2, 1, fArray2);
                    ++n19;
                }
                n19 = n11;
                while (n19 < n12) {
                    if (n5 < n9) {
                        writableRaster.setPixels(n5, n19, n9 - n5, 1, fArray2);
                    }
                    if (n10 < n6) {
                        writableRaster.setPixels(n10, n19, n6 - n10, 1, fArray2);
                    }
                    ++n19;
                }
                n19 = n12;
                while (n19 < n8) {
                    writableRaster.setPixels(n5, n19, n2, 1, fArray2);
                    ++n19;
                }
            }
        } else if (n13 == 5) {
            double[] dArray = new double[n4];
            int n20 = 0;
            while (n20 < n4) {
                dArray[n20] = n20 < this.constants.length ? this.constants[n20] : 0.0;
                ++n20;
            }
            double[] dArray2 = new double[n2 * n4];
            int n21 = 0;
            int n22 = 0;
            while (n22 < n2) {
                int n23 = 0;
                while (n23 < n4) {
                    dArray2[n21++] = dArray[n23];
                    ++n23;
                }
                ++n22;
            }
            if (n9 > n10 || n11 > n12) {
                int n24 = n7;
                while (n24 < n8) {
                    writableRaster.setPixels(n5, n24, n2, 1, dArray2);
                    ++n24;
                }
            } else {
                int n25 = n7;
                while (n25 < n11) {
                    writableRaster.setPixels(n5, n25, n2, 1, dArray2);
                    ++n25;
                }
                n25 = n11;
                while (n25 < n12) {
                    if (n5 < n9) {
                        writableRaster.setPixels(n5, n25, n9 - n5, 1, dArray2);
                    }
                    if (n10 < n6) {
                        writableRaster.setPixels(n10, n25, n6 - n10, 1, dArray2);
                    }
                    ++n25;
                }
                n25 = n12;
                while (n25 < n8) {
                    writableRaster.setPixels(n5, n25, n2, 1, dArray2);
                    ++n25;
                }
            }
        } else {
            int[] nArray = new int[n4];
            switch (n13) {
                case 0: {
                    int n26 = 0;
                    while (n26 < n4) {
                        nArray[n26] = this.clamp(n26, 0, 255);
                        ++n26;
                    }
                    break;
                }
                case 2: {
                    int n27 = 0;
                    while (n27 < n4) {
                        nArray[n27] = this.clamp(n27, Short.MIN_VALUE, Short.MAX_VALUE);
                        ++n27;
                    }
                    break;
                }
                case 1: {
                    int n28 = 0;
                    while (n28 < n4) {
                        nArray[n28] = this.clamp(n28, 0, 65535);
                        ++n28;
                    }
                    break;
                }
                case 3: {
                    int n29 = 0;
                    while (n29 < n4) {
                        nArray[n29] = this.clamp(n29, Integer.MIN_VALUE, Integer.MAX_VALUE);
                        ++n29;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JaiI18N.getString("Generic3"));
                }
            }
            int[] nArray2 = new int[n2 * n4];
            int n30 = 0;
            int n31 = 0;
            while (n31 < n2) {
                int n32 = 0;
                while (n32 < n4) {
                    nArray2[n30++] = nArray[n32];
                    ++n32;
                }
                ++n31;
            }
            if (n9 > n10 || n11 > n12) {
                int n33 = n7;
                while (n33 < n8) {
                    writableRaster.setPixels(n5, n33, n2, 1, nArray2);
                    ++n33;
                }
            } else {
                int n34 = n7;
                while (n34 < n11) {
                    writableRaster.setPixels(n5, n34, n2, 1, nArray2);
                    ++n34;
                }
                n34 = n11;
                while (n34 < n12) {
                    if (n5 < n9) {
                        writableRaster.setPixels(n5, n34, n9 - n5, 1, nArray2);
                    }
                    if (n10 < n6) {
                        writableRaster.setPixels(n10, n34, n6 - n10, 1, nArray2);
                    }
                    ++n34;
                }
                n34 = n12;
                while (n34 < n8) {
                    writableRaster.setPixels(n5, n34, n2, 1, nArray2);
                    ++n34;
                }
            }
        }
    }
}

