/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.dsj.src.rtmp;

import de.humatic.dsj.DSJUtils;

public class AMF {
    public static final int NUM = 0;
    public static final int BOOL = 1;
    public static final int STRING = 2;
    public static final int OBJECT = 3;
    public static final int INT = 4;
    public static final int NULL = 5;
    public static final int UNDEFINED = 6;
    public static final int REF = 7;
    public static final int ECMA_ARRAY = 8;
    public static final int END = 9;
    public static final int STRICT_ARRAY = 10;
    public static final int XML = 11;
    public static final int BYTE_ARRAY = 12;
    public static final int SHORT = 16;
    public static final int LOF_NULL = 1;
    public static final int LOF_BOOL = 2;
    public static final int LOF_INT = 4;
    public static final int LOF_NUM = 9;
    public static final int LOF_REF = 12;
    public static final int LOF_SWFDATE = 11;
    public static final String STR_UNDEFINED = "undefined";
    public static final String STR_TRUE = "true";
    public static final String STR_FALSE = "false";

    public static int objectLength(byte[] byArray, int n2, int n3) {
        int n4 = byArray[n2] & 0xFF;
        switch (n4) {
            case 0: {
                return 9;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) + 3;
            }
            case 3: {
                for (n4 = n2; n4 < byArray.length - 2; ++n4) {
                    if (byArray[n4] != 0 || byArray[n4 + 1] != 0 || byArray[n4 + 2] != 9) continue;
                    return n4 + 3 - n2;
                }
                return n3 - n2;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 1;
            }
            case 10: {
                return DSJUtils.readInt(byArray, n2 + 1) * AMF.objectLength(byArray, n2 + 5, n3) + 5;
            }
            case 11: {
                return 11;
            }
            case 16: {
                return 2;
            }
        }
        return -1;
    }

    public static int encodeNum(long l2, byte[] byArray, int n2) {
        byArray[n2++] = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[n2++] = (byte)(l2 >> 8 * (7 - i2));
        }
        return n2;
    }

    public static int encodeShort(int n2, byte[] byArray, int n3) {
        for (int i2 = 0; i2 < 2; ++i2) {
            byArray[n3++] = (byte)(n2 >> 8 * (1 - i2));
        }
        return n3;
    }

    public static int encodeInt(int n2, byte[] byArray, int n3) {
        for (int i2 = 0; i2 < 4; ++i2) {
            byArray[n3++] = (byte)(n2 >> 8 * (3 - i2));
        }
        return n3;
    }

    public static int encodeBool(boolean bl, byte[] byArray, int n2) {
        byArray[n2++] = 1;
        byArray[n2++] = (byte)(bl ? 1 : 0);
        return n2;
    }

    public static int encodeString(String string, boolean n2, byte[] byArray, int n3) {
        if (string == null) {
            return n3;
        }
        if (string.equals(STR_UNDEFINED)) {
            byArray[n3++] = 6;
            return n3;
        }
        if (n2 != 0) {
            byArray[n3++] = 2;
        }
        byArray[n3++] = (byte)(string.length() >> 16);
        byArray[n3++] = (byte)string.length();
        for (n2 = 0; n2 < string.length(); ++n2) {
            byArray[n3++] = string.getBytes()[n2];
        }
        return n3;
    }

    public static int encodeNull(byte[] byArray, int n2) {
        byArray[n2++] = 5;
        return n2;
    }

    public static int writeObjectStart(int n2, byte[] byArray) {
        byArray[n2++] = 3;
        return n2;
    }

    public static int writeObjectEnd(int n2, byte[] byArray) {
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        byArray[n2++] = 9;
        return n2;
    }

    public static String readString(byte[] byArray, int n2) {
        int n3 = (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2 + 2, byArray2, 0, n3);
        return new String(byArray2);
    }

    public static byte[] createAMFHeader(int n2, int n3, byte[] byArray, int n4, int n5, int n6, byte[] byArray2) {
        byte[] byArray3 = null;
        byArray3 = byArray2 == null ? new byte[n2] : new byte[n2 + byArray2.length];
        switch (n2) {
            case 1: {
                if (byArray2 == null) {
                    return new byte[]{(byte)(0xC0 | n3 & 0x3F)};
                }
                byArray3[0] = (byte)(0xC0 | n3 & 0x3F);
                break;
            }
            case 4: {
                byArray3[0] = (byte)(0x80 | n3 & 0x3F);
                byArray3[3] = 0;
                break;
            }
            case 8: {
                byArray3[0] = (byte)(0x40 | n3 & 0x3F);
                byArray3[3] = 0;
                if (n4 < 0 && byArray2 != null) {
                    n4 = byArray2.length;
                }
                for (n3 = 0; n3 < 3; ++n3) {
                    byArray3[n3 + 4] = (byte)(n4 >> 8 * (2 - n3));
                }
                byArray3[7] = (byte)n5;
                break;
            }
            case 12: {
                byArray3[0] = (byte)(n3 & 0x3F);
                byArray3[3] = 0;
                for (n3 = 0; n3 < 3; ++n3) {
                    byArray3[n3 + 4] = (byte)(n4 >> 8 * (2 - n3));
                }
                byArray3[7] = (byte)n5;
                if (n6 < 0) {
                    n6 = 0;
                }
                for (n3 = 0; n3 < 4; ++n3) {
                    byArray3[n3 + 8] = (byte)(n6 >> n3 * 8);
                }
                break;
            }
        }
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray3, 1, 3);
        }
        if (byArray2 != null) {
            System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
        }
        return byArray3;
    }
}

