/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.dsj.ext;

import de.humatic.dsj.DSJException;
import de.humatic.dsj.ext.KeyValue;
import java.util.Vector;

public class Registry {
    public static final int HKEY_CLASSES_ROOT = 0;
    public static final int HKEY_CURRENT_USER = 1;
    public static final int HKEY_LOCAL_MACHINE = 2;
    public static final int HKEY_USERS = 4;
    public static final int HKEY_CURRENT_CONFIG = 8;
    public static final int SUCCESS = 0;
    public static final int E_KEY_NOT_FOUND = -2;
    public static final int E_ACCESS_DENIED = -5;
    public static final int KEY_TYPE_INT = 0;
    public static final int KEY_TYPE_STRING = 1;
    public static final int KEY_TYPE_BINARY = 2;
    public static final int KEY_ALL_ACCESS = 983103;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_NOTIFY = 16;
    public static final int KEY_CREATE_LINK = 32;
    public static final int KEY_WRITE = 131078;

    public static native int setAccessLevel(int var0);

    public static native int isKeyAccessible(int var0, String var1);

    public static native int isSubKeyAccessible(int var0, String var1, String var2);

    public static KeyValue[] getKeyValues(int n2, String string) {
        Vector vector = new Vector();
        if ((n2 = Registry.nativeGetKeyValues(n2, string, vector)) != 0) {
            throw new DSJException("Registry key not accessible", n2);
        }
        KeyValue[] keyValueArray = new KeyValue[vector.size()];
        vector.toArray(keyValueArray);
        return keyValueArray;
    }

    static native int nativeGetKeyValues(int var0, String var1, Vector var2);

    public static void setKeyValue(int n2, String string, KeyValue keyValue) {
        Registry.setKeyValues(n2, string, new KeyValue[]{keyValue});
    }

    public static void setKeyValues(int n2, String string, KeyValue[] keyValueArray) {
        Registry.setAccessLevel(983103);
        int n3 = Registry.isKeyAccessible(n2, string);
        if (n3 == -5) {
            Registry.setAccessLevel(2);
            if (Registry.isKeyAccessible(n2, string) == -5) {
                throw new a("Access denied", -5);
            }
        } else if (n3 == -2) {
            Registry.createKey(n2, string);
        }
        block5: for (n3 = 0; n3 < keyValueArray.length; ++n3) {
            int n4 = Registry.isSubKeyAccessible(n2, string, keyValueArray[n3].getName());
            if (n4 == -2) {
                Registry.createKeyValue(n2, string, keyValueArray[n3].getName(), keyValueArray[n3].getType());
            } else if (n4 == -5) {
                throw new a("Access denied", -5);
            }
            switch (keyValueArray[n3].getType()) {
                case 0: {
                    Registry.setSubKeyValue_Int(n2, string, keyValueArray[n3].getName(), keyValueArray[n3].getValue_Int());
                    continue block5;
                }
                case 1: {
                    Registry.setSubKeyValue_String(n2, string, keyValueArray[n3].getName(), keyValueArray[n3].getValue_String());
                    continue block5;
                }
                case 2: {
                    Registry.setSubKeyValue_Binary(n2, string, keyValueArray[n3].getName(), keyValueArray[n3].getValue_Binary());
                }
            }
        }
    }

    public static int getSubKeyValueType(int n2, String string, String string2) {
        if ((n2 = Registry.getReturnType(n2, string, string2)) < 0) {
            throw new DSJException("Cant read registry key:", n2);
        }
        switch (n2) {
            case 3: {
                return 2;
            }
            case 4: {
                return 0;
            }
        }
        return 1;
    }

    static native int getReturnType(int var0, String var1, String var2);

    public static int getSubKeyValue_Int(int n2, String string, String string2) {
        int n3 = Registry.isSubKeyAccessible(n2, string, string2);
        if (n3 != 0) {
            throw new DSJException("Registry key not accessible", n3);
        }
        return Registry.getSubKeyValueInt(n2, string, string2);
    }

    static native int getSubKeyValueInt(int var0, String var1, String var2);

    public static String getSubKeyValue_String(int n2, String string, String string2) {
        int n3 = Registry.isSubKeyAccessible(n2, string, string2);
        if (n3 != 0) {
            throw new DSJException("Registry key not accessible", n3);
        }
        return Registry.getSubKeyValueString(n2, string, string2);
    }

    static native String getSubKeyValueString(int var0, String var1, String var2);

    public static byte[] getSubKeyValue_Binary(int n2, String string, String string2) {
        int n3 = Registry.isSubKeyAccessible(n2, string, string2);
        if (n3 != 0) {
            throw new DSJException("Registry key not accessible", n3);
        }
        return Registry.getSubKeyValueBinary(n2, string, string2);
    }

    static native byte[] getSubKeyValueBinary(int var0, String var1, String var2);

    public static void setSubKeyValue_Int(int n2, String string, String string2, int n3) {
        int n4 = Registry.isKeyAccessible(n2, string);
        if (n4 != 0) {
            throw new a("Registry key not accessible", n4);
        }
        Registry.nativeSetSubKeyValueInt(n2, string, string2, n3);
    }

    public static void setSubKeyValue_String(int n2, String string, String string2, String string3) {
        int n3 = Registry.isKeyAccessible(n2, string);
        if (n3 != 0) {
            throw new a("Registry key not accessible", n3);
        }
        Registry.nativeSetSubKeyValueString(n2, string, string2, string3);
    }

    public static void setSubKeyValue_Binary(int n2, String string, String string2, byte[] byArray) {
        int n3 = Registry.isKeyAccessible(n2, string);
        if (n3 != 0) {
            throw new a("Registry key not accessible", n3);
        }
        Registry.nativeSetSubKeyValueBinary(n2, string, string2, byArray, byArray.length);
    }

    static native void nativeSetSubKeyValueInt(int var0, String var1, String var2, int var3);

    static native void nativeSetSubKeyValueString(int var0, String var1, String var2, String var3);

    static native void nativeSetSubKeyValueBinary(int var0, String var1, String var2, byte[] var3, int var4);

    public static native int createKey(int var0, String var1);

    public static native int createKeyValue(int var0, String var1, String var2, int var3);

    public static native int deleteKey(int var0, String var1);

    public static native int deleteKeyValue(int var0, String var1, String var2);

    static final class a
    extends RuntimeException {
        a(String string, int n2) {
            super(string);
        }
    }
}

