/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import com.sun.media.jai.util.JaiI18N;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

public abstract class PropertyGeneratorImpl
implements PropertyGenerator {
    private String[] propertyNames;
    private Class[] propertyClasses;
    private Class[] supportedOpClasses;

    protected PropertyGeneratorImpl(String[] stringArray, Class[] classArray, Class[] classArray2) {
        if (stringArray == null || classArray == null || classArray2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PropertyGeneratorImpl0"));
        }
        if (stringArray.length == 0 || classArray.length == 0 || classArray2.length == 0) {
            throw new IllegalArgumentException(JaiI18N.getString("PropertyGeneratorImpl1"));
        }
        if (stringArray.length != classArray.length) {
            throw new IllegalArgumentException(JaiI18N.getString("PropertyGeneratorImpl2"));
        }
        int n2 = 0;
        while (n2 < classArray.length) {
            if (classArray[n2].isPrimitive()) {
                throw new IllegalArgumentException(JaiI18N.getString("PropertyGeneratorImpl4"));
            }
            ++n2;
        }
        this.propertyNames = stringArray;
        this.propertyClasses = classArray;
        this.supportedOpClasses = classArray2;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Class getClass(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PropertyGeneratorImpl0"));
        }
        int n2 = this.propertyNames.length;
        int n3 = 0;
        while (n3 < n2) {
            if (string.equalsIgnoreCase(this.propertyNames[n3])) {
                return this.propertyClasses[n3];
            }
            ++n3;
        }
        return null;
    }

    public boolean canGenerateProperties(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PropertyGeneratorImpl0"));
        }
        int n2 = this.supportedOpClasses.length;
        if (n2 == 1) {
            return this.supportedOpClasses[0].isInstance(object);
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.supportedOpClasses[n3].isInstance(object)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public abstract Object getProperty(String var1, Object var2);

    public Object getProperty(String string, RenderedOp renderedOp) {
        return this.getProperty(string, (Object)renderedOp);
    }

    public Object getProperty(String string, RenderableOp renderableOp) {
        return this.getProperty(string, (Object)renderableOp);
    }

    protected void validate(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PropertyGeneratorImpl0"));
        }
        if (!this.canGenerateProperties(object)) {
            throw new IllegalArgumentException(JaiI18N.getString("PropertyGeneratorImpl3"));
        }
    }
}

