/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public final class JDKWorkarounds {
    private JDKWorkarounds() {
    }

    private static boolean setRectBilevel(WritableRaster writableRaster, Raster raster, int n2, int n3) {
        int n4 = raster.getWidth();
        int n5 = raster.getHeight();
        int n6 = raster.getMinX();
        int n7 = raster.getMinY();
        int n8 = n2 + n6;
        int n9 = n3 + n7;
        int n10 = writableRaster.getMinX();
        int n11 = writableRaster.getMinY();
        int n12 = writableRaster.getWidth();
        int n13 = writableRaster.getHeight();
        if (n8 + n4 > n10 + n12) {
            n4 = n10 + n12 - n8;
        }
        if (n9 + n5 > n11 + n13) {
            n5 = n11 + n13 - n9;
        }
        Rectangle rectangle = new Rectangle(n8, n9, n4, n5);
        byte[] byArray = ImageUtil.getPackedBinaryData(raster, rectangle);
        ImageUtil.setPackedBinaryData(byArray, writableRaster, rectangle);
        return true;
    }

    public static void setRect(WritableRaster writableRaster, Raster raster) {
        JDKWorkarounds.setRect(writableRaster, raster, 0, 0);
    }

    public static void setRect(WritableRaster writableRaster, Raster raster, int n2, int n3) {
        int n4;
        SampleModel sampleModel = raster.getSampleModel();
        SampleModel sampleModel2 = writableRaster.getSampleModel();
        if (sampleModel instanceof MultiPixelPackedSampleModel && sampleModel2 instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)sampleModel2;
            DataBuffer dataBuffer = raster.getDataBuffer();
            DataBuffer dataBuffer2 = raster.getDataBuffer();
            if (dataBuffer instanceof DataBufferByte && dataBuffer2 instanceof DataBufferByte && multiPixelPackedSampleModel.getPixelBitStride() == 1 && multiPixelPackedSampleModel2.getPixelBitStride() == 1 && JDKWorkarounds.setRectBilevel(writableRaster, raster, n2, n3)) {
                return;
            }
        }
        if ((n4 = writableRaster.getSampleModel().getDataType()) != 4 && n4 != 5) {
            writableRaster.setRect(n2, n3, raster);
            return;
        }
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        int n7 = raster.getMinX();
        int n8 = raster.getMinY();
        int n9 = n2 + n7;
        int n10 = n3 + n8;
        int n11 = writableRaster.getMinX();
        int n12 = writableRaster.getMinY();
        int n13 = writableRaster.getWidth();
        int n14 = writableRaster.getHeight();
        if (n9 + n5 > n11 + n13) {
            n5 = n11 + n13 - n9;
        }
        if (n10 + n6 > n12 + n14) {
            n6 = n12 + n14 - n10;
        }
        switch (raster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int[] nArray = null;
                int n15 = 0;
                while (n15 < n6) {
                    nArray = raster.getPixels(n7, n8 + n15, n5, 1, nArray);
                    writableRaster.setPixels(n9, n10 + n15, n5, 1, nArray);
                    ++n15;
                }
                break;
            }
            case 4: {
                float[] fArray = null;
                int n16 = 0;
                while (n16 < n6) {
                    fArray = raster.getPixels(n7, n8 + n16, n5, 1, fArray);
                    writableRaster.setPixels(n9, n10 + n16, n5, 1, fArray);
                    ++n16;
                }
                break;
            }
            case 5: {
                double[] dArray = null;
                int n17 = 0;
                while (n17 < n6) {
                    dArray = raster.getPixels(n7, n8 + n17, n5, 1, dArray);
                    writableRaster.setPixels(n9, n10 + n17, n5, 1, dArray);
                    ++n17;
                }
                break;
            }
        }
    }

    public static boolean areCompatibleDataModels(SampleModel sampleModel, ColorModel colorModel) {
        if (sampleModel == null || colorModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("JDKWorkarounds0"));
        }
        if (!colorModel.isCompatibleSampleModel(sampleModel)) {
            return false;
        }
        if (colorModel instanceof ComponentColorModel) {
            int n2 = sampleModel.getNumBands();
            if (n2 != colorModel.getNumComponents()) {
                return false;
            }
            int n3 = 0;
            while (n3 < n2) {
                if (sampleModel.getSampleSize(n3) < colorModel.getComponentSize(n3)) {
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }
}

