/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import javax.media.jai.Interpolation;

public class InterpAverage
extends Interpolation {
    public InterpAverage(int n2, int n3) {
        super(n2, n3, 0, n2 - 1, 0, n3 - 1, 32, 32);
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("blockX <= 0 || blockY <= 0");
        }
    }

    public int interpolateH(int[] nArray, int n2) {
        int n3 = nArray.length;
        double d2 = 0.0;
        int n4 = 0;
        while (n4 < n3) {
            d2 += (double)(nArray[n4] / n3);
            ++n4;
        }
        return (int)(d2 + 0.5);
    }

    public float interpolateH(float[] fArray, float f2) {
        int n2 = fArray.length;
        float f3 = 0.0f;
        int n3 = 0;
        while (n3 < n2) {
            f3 += fArray[n3] / (float)n2;
            ++n3;
        }
        return f3;
    }

    public double interpolateH(double[] dArray, float f2) {
        int n2 = dArray.length;
        double d2 = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            d2 += dArray[n3] / (double)n2;
            ++n3;
        }
        return d2;
    }
}

