/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import com.sun.media.jai.util.JaiI18N;
import java.io.Serializable;
import java.util.Hashtable;
import javax.media.jai.util.CaselessStringKey;

public class CaselessStringArrayTable
implements Serializable {
    private CaselessStringKey[] keys;
    private Hashtable indices;

    public CaselessStringArrayTable() {
        this((CaselessStringKey[])null);
    }

    public CaselessStringArrayTable(CaselessStringKey[] caselessStringKeyArray) {
        this.keys = caselessStringKeyArray;
        this.indices = new Hashtable();
        if (caselessStringKeyArray != null) {
            int n2 = 0;
            while (n2 < caselessStringKeyArray.length) {
                this.indices.put(caselessStringKeyArray[n2], new Integer(n2));
                ++n2;
            }
        }
    }

    public CaselessStringArrayTable(String[] stringArray) {
        this(CaselessStringArrayTable.toCaselessStringKey(stringArray));
    }

    private static CaselessStringKey[] toCaselessStringKey(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        CaselessStringKey[] caselessStringKeyArray = new CaselessStringKey[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            caselessStringKeyArray[n2] = new CaselessStringKey(stringArray[n2]);
            ++n2;
        }
        return caselessStringKeyArray;
    }

    public int indexOf(CaselessStringKey caselessStringKey) {
        if (caselessStringKey == null) {
            throw new IllegalArgumentException(JaiI18N.getString("CaselessStringArrayTable0"));
        }
        Integer n2 = (Integer)this.indices.get(caselessStringKey);
        if (n2 == null) {
            throw new IllegalArgumentException(caselessStringKey.getName() + " - " + JaiI18N.getString("CaselessStringArrayTable1"));
        }
        return n2;
    }

    public int indexOf(String string) {
        return this.indexOf(new CaselessStringKey(string));
    }

    public String getName(int n2) {
        if (this.keys == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.keys[n2].getName();
    }

    public CaselessStringKey get(int n2) {
        if (this.keys == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.keys[n2];
    }

    public boolean contains(CaselessStringKey caselessStringKey) {
        if (caselessStringKey == null) {
            throw new IllegalArgumentException(JaiI18N.getString("CaselessStringArrayTable0"));
        }
        return this.indices.get(caselessStringKey) != null;
    }

    public boolean contains(String string) {
        return this.contains(new CaselessStringKey(string));
    }
}

