/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.tilecodec;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.media.jai.tilecodec.JaiI18N;
import com.sun.media.jai.tilecodec.TileCodecUtils;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.media.jai.RasterFactory;
import javax.media.jai.tilecodec.TileCodecDescriptor;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileDecoderImpl;
import javax.media.jai.util.ImagingListener;

public class JPEGTileDecoder
extends TileDecoderImpl {
    private TileCodecDescriptor tcd = TileCodecUtils.getTileCodecDescriptor("tileDecoder", "jpeg");

    public JPEGTileDecoder(InputStream inputStream, TileCodecParameterList tileCodecParameterList) {
        super("jpeg", inputStream, tileCodecParameterList);
    }

    public Raster decode() throws IOException {
        if (!this.tcd.includesLocationInfo()) {
            throw new IllegalArgumentException(JaiI18N.getString("JPEGTileDecoder0"));
        }
        return this.decode(null);
    }

    public Raster decode(Point point) throws IOException {
        SampleModel sampleModel = null;
        byte[] byArray = null;
        ObjectInputStream objectInputStream = new ObjectInputStream(this.inputStream);
        try {
            try {
                this.paramList.setParameter("quality", objectInputStream.readFloat());
                this.paramList.setParameter("qualitySet", objectInputStream.readBoolean());
                sampleModel = TileCodecUtils.deserializeSampleModel(objectInputStream.readObject());
                point = (Point)objectInputStream.readObject();
                byArray = (byte[])objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                ImagingListener imagingListener = ImageUtil.getImagingListener((RenderingHints)null);
                imagingListener.errorOccurred(JaiI18N.getString("ClassNotFound"), classNotFoundException, this, false);
                Raster raster = null;
                Object var9_6 = null;
                objectInputStream.close();
                return raster;
            }
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            objectInputStream.close();
            throw throwable;
        }
        objectInputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
        Raster raster = jPEGImageDecoder.decodeAsRaster().createTranslatedChild(point.x, point.y);
        this.extractParameters(jPEGImageDecoder.getJPEGDecodeParam(), raster.getSampleModel().getNumBands());
        if (sampleModel != null) {
            int n2 = raster.getMinX();
            int n3 = raster.getMinY();
            int n4 = raster.getHeight();
            int n5 = raster.getWidth();
            double[] dArray = raster.getPixels(n2, n3, n5, n4, (double[])null);
            raster = RasterFactory.createWritableRaster(sampleModel, new Point(n2, n3));
            ((WritableRaster)raster).setPixels(n2, n3, n5, n4, dArray);
        }
        return raster;
    }

    private void extractParameters(JPEGDecodeParam jPEGDecodeParam, int n2) {
        int n3;
        Object object;
        int[] nArray = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            nArray[n4] = jPEGDecodeParam.getHorizontalSubsampling(n4);
            ++n4;
        }
        this.paramList.setParameter("horizontalSubsampling", nArray);
        int[] nArray2 = new int[n2];
        int n5 = 0;
        while (n5 < n2) {
            nArray2[n5] = jPEGDecodeParam.getVerticalSubsampling(n5);
            ++n5;
        }
        this.paramList.setParameter("verticalSubsampling", nArray2);
        if (!this.paramList.getBooleanParameter("qualitySet")) {
            int n6 = 0;
            while (n6 < 4) {
                object = jPEGDecodeParam.getQTable(n6);
                this.paramList.setParameter("quantizationTable" + n6, object == null ? null : object.getTable());
                ++n6;
            }
        } else {
            object = this.paramList.getParameterListDescriptor();
            n3 = 0;
            while (n3 < 4) {
                this.paramList.setParameter("quantizationTable" + n3, object.getParamDefaultValue("quantizationTable" + n3));
                ++n3;
            }
        }
        object = new int[n2];
        n3 = 0;
        while (n3 < n2) {
            object[n3] = jPEGDecodeParam.getQTableComponentMapping(n3);
            ++n3;
        }
        this.paramList.setParameter("quantizationTableMapping", object);
        this.paramList.setParameter("writeTableInfo", jPEGDecodeParam.isTableInfoValid());
        this.paramList.setParameter("writeImageInfo", jPEGDecodeParam.isImageInfoValid());
        this.paramList.setParameter("restartInterval", jPEGDecodeParam.getRestartInterval());
        this.paramList.setParameter("writeJFIFHeader", jPEGDecodeParam.getMarker(224));
    }
}

