/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.RMIServerProxy;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.remote.PlanarImageServerProxy;
import javax.media.jai.remote.RemoteRenderedOp;
import javax.media.jai.remote.SerializableRenderedImage;

public final class JAIRMIUtil {
    public static Vector replaceIdWithSources(Vector vector, Hashtable hashtable, String string, RenderingHints renderingHints) {
        Vector<Object> vector2 = new Vector<Object>();
        int n2 = 0;
        while (n2 < vector.size()) {
            Object object;
            Object e2 = vector.elementAt(n2);
            if (e2 instanceof String) {
                boolean bl;
                object = (String)e2;
                int n3 = ((String)object).indexOf("::");
                boolean bl2 = bl = n3 != -1;
                if (bl) {
                    vector2.add(new RMIServerProxy((String)object, string, renderingHints));
                } else {
                    vector2.add(hashtable.get(Long.valueOf((String)object)));
                }
            } else {
                object = PlanarImage.wrapRenderedImage((RenderedImage)e2);
                vector2.add(object);
            }
            ++n2;
        }
        return vector2;
    }

    public static Vector replaceSourcesWithId(Vector vector, String string) {
        Vector<Object> vector2 = new Vector<Object>();
        int n2 = 0;
        while (n2 < vector.size()) {
            Object object;
            RenderedImage renderedImage;
            Object e2 = vector.elementAt(n2);
            if (e2 instanceof RMIServerProxy) {
                renderedImage = (RMIServerProxy)e2;
                if (((PlanarImageServerProxy)renderedImage).getServerName().equalsIgnoreCase(string)) {
                    vector2.add(((RMIServerProxy)renderedImage).getRMIID().toString());
                } else {
                    object = new String(((PlanarImageServerProxy)renderedImage).getServerName() + "::" + ((RMIServerProxy)renderedImage).getRMIID());
                    vector2.add(object);
                }
            } else if (e2 instanceof RemoteRenderedOp) {
                RenderedImage renderedImage2;
                renderedImage = (RemoteRenderedOp)e2;
                object = ((RenderedOp)renderedImage).getRendering();
                if (object instanceof RMIServerProxy) {
                    renderedImage2 = (RMIServerProxy)object;
                    if (((PlanarImageServerProxy)renderedImage2).getServerName().equalsIgnoreCase(string)) {
                        vector2.add(((RMIServerProxy)renderedImage2).getRMIID().toString());
                    } else {
                        String string2 = new String(((PlanarImageServerProxy)renderedImage2).getServerName() + "::" + ((RMIServerProxy)renderedImage2).getRMIID());
                        vector2.add(string2);
                    }
                } else {
                    renderedImage2 = (RenderedImage)object;
                    vector2.add(new SerializableRenderedImage(renderedImage2));
                }
            } else if (e2 instanceof RenderedOp) {
                renderedImage = (RenderedOp)e2;
                vector2.add(new SerializableRenderedImage(((RenderedOp)renderedImage).getRendering()));
            } else if (e2 instanceof Serializable) {
                vector2.add(e2);
            } else if (e2 instanceof RenderedImage) {
                renderedImage = (RenderedImage)e2;
                vector2.add(new SerializableRenderedImage(renderedImage));
            }
            ++n2;
        }
        return vector2;
    }

    public static Object replaceImage(RenderedImage renderedImage, String string) {
        if (renderedImage instanceof RMIServerProxy) {
            RMIServerProxy rMIServerProxy = (RMIServerProxy)renderedImage;
            if (rMIServerProxy.getServerName().equalsIgnoreCase(string)) {
                return "::" + rMIServerProxy.getRMIID();
            }
            return rMIServerProxy.getServerName() + "::" + rMIServerProxy.getRMIID() + ";;" + rMIServerProxy.getOperationName();
        }
        if (renderedImage instanceof RenderedOp) {
            PlanarImage planarImage = ((RenderedOp)renderedImage).getRendering();
            return JAIRMIUtil.replaceImage(planarImage, string);
        }
        if (renderedImage instanceof RenderedImage) {
            if (renderedImage instanceof Serializable) {
                return renderedImage;
            }
            return new SerializableRenderedImage(renderedImage);
        }
        return renderedImage;
    }

    public static void checkClientParameters(ParameterBlock parameterBlock, String string) {
        if (parameterBlock == null) {
            return;
        }
        int n2 = parameterBlock.getNumParameters();
        Vector<Object> vector = parameterBlock.getParameters();
        int n3 = 0;
        while (n3 < n2) {
            Object object = vector.elementAt(n3);
            if (object != null && object instanceof RenderedImage) {
                parameterBlock.set(JAIRMIUtil.replaceImage((RenderedImage)object, string), n3);
            }
            ++n3;
        }
    }

    public static void checkClientParameters(Vector vector, String string) {
        if (vector == null) {
            return;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            Object e2 = vector.elementAt(n2);
            if (e2 != null && e2 instanceof RenderedImage) {
                vector.set(n2, JAIRMIUtil.replaceImage((RenderedImage)e2, string));
            }
            ++n2;
        }
    }

    public static Object replaceStringWithImage(String string, Hashtable hashtable) {
        int n2 = string.indexOf("::");
        int n3 = string.indexOf(";;");
        if (n2 == -1) {
            return string;
        }
        if (n3 == -1) {
            Long l2 = Long.valueOf(string.substring(n2 + 2));
            return hashtable.get(l2);
        }
        Long l3 = Long.valueOf(string.substring(n2 + 2, n3));
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n3 + 2);
        return new RMIServerProxy(string2 + "::" + l3, string3, null);
    }

    public static void checkServerParameters(ParameterBlock parameterBlock, Hashtable hashtable) {
        if (parameterBlock == null) {
            return;
        }
        int n2 = parameterBlock.getNumParameters();
        Vector<Object> vector = parameterBlock.getParameters();
        int n3 = 0;
        while (n3 < n2) {
            Object object = vector.elementAt(n3);
            if (object != null && object instanceof String) {
                parameterBlock.set(JAIRMIUtil.replaceStringWithImage((String)object, hashtable), n3);
            }
            ++n3;
        }
    }

    public static void checkServerParameters(Vector vector, Hashtable hashtable) {
        if (vector == null) {
            return;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            Object e2 = vector.elementAt(n2);
            if (e2 != null && e2 instanceof String) {
                vector.set(n2, JAIRMIUtil.replaceStringWithImage((String)e2, hashtable));
            }
            ++n2;
        }
    }
}

