/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.ImageServer;
import com.sun.media.jai.rmi.JaiI18N;
import com.sun.media.jai.rmi.RMIServerProxy;
import com.sun.media.jai.rmi.RenderableRMIServerProxy;
import com.sun.media.jai.rmi.SerializableRenderableImage;
import com.sun.media.jai.util.ImageUtil;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.OperationNode;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PropertyChangeEventJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.remote.NegotiableCapabilitySet;
import javax.media.jai.remote.PlanarImageServerProxy;
import javax.media.jai.remote.RemoteCRIF;
import javax.media.jai.remote.RemoteImagingException;
import javax.media.jai.remote.RemoteRenderableOp;
import javax.media.jai.remote.RemoteRenderedImage;
import javax.media.jai.remote.RemoteRenderedOp;
import javax.media.jai.remote.SerializableRenderedImage;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;
import javax.media.jai.tilecodec.TileDecoderFactory;
import javax.media.jai.util.ImagingListener;

public class JAIRMICRIF
implements RemoteCRIF {
    public RenderContext mapRenderContext(String string, String string2, int n2, RenderContext renderContext, ParameterBlock parameterBlock, RenderableImage renderableImage) throws RemoteImagingException {
        RemoteRenderableOp remoteRenderableOp = (RemoteRenderableOp)renderableImage;
        RenderableRMIServerProxy renderableRMIServerProxy = this.createProxy(remoteRenderableOp);
        SerializableState serializableState = SerializerFactory.getState(renderContext, null);
        try {
            SerializableState serializableState2 = renderableRMIServerProxy.getImageServer(string).mapRenderContext(n2, renderableRMIServerProxy.getRMIID(), string2, serializableState);
        }
        catch (RemoteException remoteException) {
            String string3 = JaiI18N.getString("JAIRMICRIF5");
            this.sendExceptionToListener(renderContext, string3, remoteException);
        }
        return (RenderContext)serializableState.getObject();
    }

    public Rectangle2D getBounds2D(String string, String string2, ParameterBlock parameterBlock) throws RemoteImagingException {
        SerializableState serializableState = null;
        RemoteRenderableOp remoteRenderableOp = new RemoteRenderableOp("jairmi", string, string2, parameterBlock);
        RenderableRMIServerProxy renderableRMIServerProxy = this.createProxy(remoteRenderableOp);
        try {
            serializableState = renderableRMIServerProxy.getImageServer(string).getBounds2D(renderableRMIServerProxy.getRMIID(), string2);
        }
        catch (RemoteException remoteException) {
            String string3 = JaiI18N.getString("JAIRMICRIF6");
            this.sendExceptionToListener(null, string3, remoteException);
        }
        return (Rectangle2D.Float)serializableState.getObject();
    }

    public Object getProperty(String string, String string2, ParameterBlock parameterBlock, String string3) throws RemoteImagingException {
        ParameterBlock parameterBlock2 = null;
        parameterBlock2 = parameterBlock == null ? new ParameterBlock() : (ParameterBlock)parameterBlock.clone();
        RemoteRenderableOp remoteRenderableOp = new RemoteRenderableOp("jairmi", string, string2, parameterBlock);
        RenderableRMIServerProxy renderableRMIServerProxy = this.createProxy(remoteRenderableOp);
        try {
            return renderableRMIServerProxy.getProperty(string3);
        }
        catch (Exception exception) {
            String string4 = JaiI18N.getString("JAIRMICRIF7");
            this.sendExceptionToListener(null, string4, new RemoteImagingException(string4, exception));
            return null;
        }
    }

    public String[] getPropertyNames(String string, String string2) throws RemoteImagingException {
        ImageServer imageServer = this.getImageServer(string);
        try {
            return imageServer.getPropertyNames(string2);
        }
        catch (RemoteException remoteException) {
            String string3 = JaiI18N.getString("JAIRMICRIF8");
            this.sendExceptionToListener(null, string3, new RemoteImagingException(string3, remoteException));
            return null;
        }
    }

    private ImageServer getImageServer(String string) {
        if (string == null) {
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                String string2 = JaiI18N.getString("RMIServerProxy11");
                this.sendExceptionToListener(null, string2, new RemoteImagingException(string2, unknownHostException));
            }
        }
        String string3 = new String("rmi://" + string + "/" + "JAIRMIRemoteServer1.1");
        try {
            return (ImageServer)Naming.lookup(string3);
        }
        catch (NotBoundException notBoundException) {
            String string4 = JaiI18N.getString("RMIServerProxy12");
            this.sendExceptionToListener(null, string4, new RemoteImagingException(string4, notBoundException));
        }
        catch (MalformedURLException malformedURLException) {
            String string5 = JaiI18N.getString("RMIServerProxy12");
            this.sendExceptionToListener(null, string5, new RemoteImagingException(string5, malformedURLException));
        }
        catch (RemoteException remoteException) {
            String string6 = JaiI18N.getString("RMIServerProxy12");
            this.sendExceptionToListener(null, string6, new RemoteImagingException(string6, remoteException));
        }
        return null;
    }

    public boolean isDynamic(String string, String string2) throws RemoteImagingException {
        ImageServer imageServer = this.getImageServer(string);
        try {
            return imageServer.isDynamic(string2);
        }
        catch (RemoteException remoteException) {
            String string3 = JaiI18N.getString("JAIRMICRIF9");
            this.sendExceptionToListener(null, string3, new RemoteImagingException(string3, remoteException));
            return true;
        }
    }

    public RemoteRenderedImage create(String string, String string2, ParameterBlock parameterBlock, RenderingHints renderingHints) throws RemoteImagingException {
        RMIServerProxy rMIServerProxy = new RMIServerProxy(string, string2, parameterBlock, renderingHints);
        boolean bl = rMIServerProxy.canBeRendered();
        if (!bl) {
            return null;
        }
        return rMIServerProxy;
    }

    public RemoteRenderedImage create(PlanarImageServerProxy planarImageServerProxy, OperationNode operationNode, PropertyChangeEventJAI propertyChangeEventJAI) throws RemoteImagingException {
        RMIServerProxy rMIServerProxy;
        if (!(operationNode instanceof RemoteRenderedOp)) {
            return null;
        }
        String string = propertyChangeEventJAI.getPropertyName();
        if (string.equals("servername")) {
            rMIServerProxy = new RMIServerProxy(planarImageServerProxy, operationNode, (String)propertyChangeEventJAI.getNewValue());
        } else {
            if (string.equals("operationregistry") || string.equals("protocolname") || string.equals("protocolandservername")) {
                return this.create(((RemoteRenderedOp)operationNode).getServerName(), operationNode.getOperationName(), operationNode.getParameterBlock(), operationNode.getRenderingHints());
            }
            rMIServerProxy = new RMIServerProxy(planarImageServerProxy, operationNode, propertyChangeEventJAI);
        }
        return rMIServerProxy;
    }

    public RemoteRenderedImage create(String string, String string2, RenderContext renderContext, ParameterBlock parameterBlock) throws RemoteImagingException {
        RMIServerProxy rMIServerProxy = new RMIServerProxy(string, string2, parameterBlock, renderContext, true);
        Long l2 = rMIServerProxy.getRenderingID();
        return new RMIServerProxy(string + "::" + l2, parameterBlock, string2, renderContext.getRenderingHints());
    }

    public NegotiableCapabilitySet getClientCapabilities() {
        OperationRegistry operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        String string = "tileDecoder";
        String[] stringArray = operationRegistry.getDescriptorNames(string);
        TileDecoderFactory tileDecoderFactory = null;
        NegotiableCapabilitySet negotiableCapabilitySet = new NegotiableCapabilitySet(false);
        int n2 = 0;
        while (n2 < stringArray.length) {
            Iterator iterator = operationRegistry.getFactoryIterator(string, stringArray[n2]);
            while (iterator.hasNext()) {
                tileDecoderFactory = (TileDecoderFactory)iterator.next();
                negotiableCapabilitySet.add(tileDecoderFactory.getDecodeCapability());
            }
            ++n2;
        }
        return negotiableCapabilitySet;
    }

    private RenderableRMIServerProxy createProxy(RemoteRenderableOp remoteRenderableOp) {
        Object object;
        ParameterBlock parameterBlock = remoteRenderableOp.getParameterBlock();
        ParameterBlock parameterBlock2 = (ParameterBlock)parameterBlock.clone();
        Vector<Object> vector = parameterBlock.getSources();
        parameterBlock2.removeSources();
        ImageServer imageServer = this.getImageServer(remoteRenderableOp.getServerName());
        ImagingListener imagingListener = ImageUtil.getImagingListener(remoteRenderableOp.getRenderingHints());
        Long l2 = new Long(0L);
        try {
            l2 = imageServer.getRemoteID();
            imageServer.createRenderableOp(l2, remoteRenderableOp.getOperationName(), parameterBlock2);
        }
        catch (RemoteException remoteException) {
            object = JaiI18N.getString("RMIServerProxy8");
            imagingListener.errorOccurred((String)object, new RemoteImagingException((String)object, remoteException), this, false);
        }
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                block25: {
                    Serializable serializable;
                    String string;
                    Object object2;
                    object = vector.elementAt(n2);
                    if (object instanceof RemoteRenderedOp) {
                        object2 = (RMIServerProxy)((RemoteRenderedOp)object).getRendering();
                        try {
                            if (((PlanarImageServerProxy)object2).getServerName().equalsIgnoreCase(remoteRenderableOp.getServerName())) {
                                imageServer.setRenderedSource(l2, ((RMIServerProxy)object2).getRMIID(), n2);
                                parameterBlock2.setSource(object2, n2);
                                break block25;
                            }
                            imageServer.setRenderedSource(l2, ((RMIServerProxy)object2).getRMIID(), ((PlanarImageServerProxy)object2).getServerName(), ((PlanarImageServerProxy)object2).getOperationName(), n2);
                            parameterBlock2.setSource(object2, n2);
                        }
                        catch (RemoteException remoteException) {
                            string = JaiI18N.getString("RMIServerProxy6");
                            imagingListener.errorOccurred(string, new RemoteImagingException(string, remoteException), this, false);
                        }
                    } else if (object instanceof RenderedOp) {
                        object2 = ((RenderedOp)object).getRendering();
                        try {
                            serializable = new SerializableRenderedImage((RenderedImage)object2);
                            imageServer.setRenderedSource(l2, (RenderedImage)((Object)serializable), n2);
                            parameterBlock2.setSource(serializable, n2);
                        }
                        catch (RemoteException remoteException) {
                            string = JaiI18N.getString("RMIServerProxy6");
                            imagingListener.errorOccurred(string, new RemoteImagingException(string, remoteException), this, false);
                        }
                    } else if (object instanceof RenderedImage) {
                        object2 = (RenderedImage)object;
                        try {
                            serializable = new SerializableRenderedImage((RenderedImage)object2);
                            imageServer.setRenderedSource(l2, (RenderedImage)((Object)serializable), n2);
                            parameterBlock2.setSource(serializable, n2);
                        }
                        catch (RemoteException remoteException) {
                            string = JaiI18N.getString("RMIServerProxy6");
                            imagingListener.errorOccurred(string, new RemoteImagingException(string, remoteException), this, false);
                        }
                    } else if (object instanceof RemoteRenderableOp) {
                        object2 = this.createProxy((RemoteRenderableOp)object);
                        try {
                            if (((RenderableRMIServerProxy)object2).getServerName().equalsIgnoreCase(remoteRenderableOp.getServerName())) {
                                imageServer.setRenderableSource(l2, ((RenderableRMIServerProxy)object2).getRMIID(), n2);
                                parameterBlock2.setSource(object2, n2);
                                break block25;
                            }
                            imageServer.setRenderableRMIServerProxyAsSource(l2, ((RenderableRMIServerProxy)object2).getRMIID(), ((RenderableRMIServerProxy)object2).getServerName(), ((RenderableRMIServerProxy)object2).getOperationName(), n2);
                            parameterBlock2.setSource(object2, n2);
                        }
                        catch (RemoteException remoteException) {
                            string = JaiI18N.getString("RMIServerProxy6");
                            imagingListener.errorOccurred(string, new RemoteImagingException(string, remoteException), this, false);
                        }
                    } else if (object instanceof RenderableImage) {
                        object2 = (RenderableImage)object;
                        try {
                            serializable = new SerializableRenderableImage((RenderableImage)object2);
                            imageServer.setRenderableSource(l2, (SerializableRenderableImage)serializable, n2);
                            parameterBlock2.setSource(serializable, n2);
                        }
                        catch (RemoteException remoteException) {
                            string = JaiI18N.getString("RMIServerProxy6");
                            imagingListener.errorOccurred(string, new RemoteImagingException(string, remoteException), this, false);
                        }
                    }
                }
                ++n2;
            }
        }
        RenderableRMIServerProxy renderableRMIServerProxy = new RenderableRMIServerProxy(remoteRenderableOp.getServerName(), remoteRenderableOp.getOperationName(), parameterBlock2, l2);
        return renderableRMIServerProxy;
    }

    private void sendExceptionToListener(RenderContext renderContext, String string, Exception exception) {
        ImagingListener imagingListener = ImageUtil.getImagingListener(renderContext);
        imagingListener.errorOccurred(string, new RemoteImagingException(string, exception), this, false);
    }
}

