/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.Warp;
import javax.media.jai.WarpOpImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

final class WarpGeneralOpImage
extends WarpOpImage {
    private byte[][] ctable = null;

    public WarpGeneralOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, Warp warp, Interpolation interpolation, double[] dArray) {
        super(renderedImage, imageLayout, map, false, borderExtender, interpolation, warp, dArray);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            this.ctable = new byte[3][indexColorModel.getMapSize()];
            indexColorModel.getReds(this.ctable[0]);
            indexColorModel.getGreens(this.ctable[1]);
            indexColorModel.getBlues(this.ctable[2]);
        }
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(planarImageArray[0], rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(planarImageArray[0], rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(planarImageArray[0], rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(planarImageArray[0], rasterAccessor);
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (this.interp != null) {
            n9 = this.interp.getLeftPadding();
            n8 = this.interp.getRightPadding();
            n7 = this.interp.getTopPadding();
            n6 = this.interp.getBottomPadding();
        } else {
            n6 = 0;
            n7 = 0;
            n8 = 0;
            n9 = 0;
        }
        if (this.extender != null) {
            n5 = planarImage.getMinX();
            n4 = planarImage.getMaxX();
            n3 = planarImage.getMinY();
            n2 = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n9, planarImage.getMinY() - n7, planarImage.getWidth() + n9 + n8, planarImage.getHeight() + n7 + n6);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n5 = planarImage.getMinX() + n9;
            n4 = planarImage.getMaxX() - n8;
            n3 = planarImage.getMinY() + n7;
            n2 = planarImage.getMaxY() - n6;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n10 = this.interp.getWidth();
        int n11 = this.interp.getHeight();
        int n12 = rasterAccessor.getWidth();
        int n13 = rasterAccessor.getHeight();
        int n14 = rasterAccessor.getNumBands();
        int n15 = rasterAccessor.getScanlineStride();
        int n16 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n17 = 1 << this.interp.getSubsampleBitsH();
        int n18 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n12];
        int[][] nArray2 = new int[n11][n10];
        int n19 = 0;
        byte[] byArray2 = new byte[n14];
        int n20 = 0;
        while (n20 < n14) {
            byArray2[n20] = (byte)this.backgroundValues[n20];
            ++n20;
        }
        if (this.ctable == null) {
            int n21 = 0;
            while (n21 < n13) {
                int n22 = n19;
                n19 += n15;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n21, n12, 1, fArray);
                int n23 = 0;
                int n24 = 0;
                while (n24 < n12) {
                    int n25;
                    float f2 = fArray[n23++];
                    float f3 = fArray[n23++];
                    int n26 = WarpGeneralOpImage.floor(f2);
                    int n27 = WarpGeneralOpImage.floor(f3);
                    int n28 = (int)((f2 - (float)n26) * (float)n17);
                    int n29 = (int)((f3 - (float)n27) * (float)n18);
                    if (n26 < n5 || n26 >= n4 || n27 < n3 || n27 >= n2) {
                        if (this.setBackground) {
                            n25 = 0;
                            while (n25 < n14) {
                                byArray[n25][n22 + nArray[n25]] = byArray2[n25];
                                ++n25;
                            }
                        }
                    } else {
                        n26 -= n9;
                        n27 -= n7;
                        n25 = 0;
                        while (n25 < n14) {
                            int n30 = 0;
                            while (n30 < n11) {
                                int n31 = 0;
                                while (n31 < n10) {
                                    nArray2[n30][n31] = randomIter.getSample(n26 + n31, n27 + n30, n25) & 0xFF;
                                    ++n31;
                                }
                                ++n30;
                            }
                            byArray[n25][n22 + nArray[n25]] = ImageUtil.clampByte(this.interp.interpolate(nArray2, n28, n29));
                            ++n25;
                        }
                    }
                    n22 += n16;
                    ++n24;
                }
                ++n21;
            }
        } else {
            int n32 = 0;
            while (n32 < n13) {
                int n33 = n19;
                n19 += n15;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n32, n12, 1, fArray);
                int n34 = 0;
                int n35 = 0;
                while (n35 < n12) {
                    int n36;
                    float f4 = fArray[n34++];
                    float f5 = fArray[n34++];
                    int n37 = WarpGeneralOpImage.floor(f4);
                    int n38 = WarpGeneralOpImage.floor(f5);
                    int n39 = (int)((f4 - (float)n37) * (float)n17);
                    int n40 = (int)((f5 - (float)n38) * (float)n18);
                    if (n37 < n5 || n37 >= n4 || n38 < n3 || n38 >= n2) {
                        if (this.setBackground) {
                            n36 = 0;
                            while (n36 < n14) {
                                byArray[n36][n33 + nArray[n36]] = byArray2[n36];
                                ++n36;
                            }
                        }
                    } else {
                        n37 -= n9;
                        n38 -= n7;
                        n36 = 0;
                        while (n36 < n14) {
                            byte[] byArray3 = this.ctable[n36];
                            int n41 = 0;
                            while (n41 < n11) {
                                int n42 = 0;
                                while (n42 < n10) {
                                    nArray2[n41][n42] = byArray3[randomIter.getSample(n37 + n42, n38 + n41, 0) & 0xFF] & 0xFF;
                                    ++n42;
                                }
                                ++n41;
                            }
                            byArray[n36][n33 + nArray[n36]] = ImageUtil.clampByte(this.interp.interpolate(nArray2, n39, n40));
                            ++n36;
                        }
                    }
                    n33 += n16;
                    ++n35;
                }
                ++n32;
            }
        }
    }

    private void computeRectUShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (this.interp != null) {
            n9 = this.interp.getLeftPadding();
            n8 = this.interp.getRightPadding();
            n7 = this.interp.getTopPadding();
            n6 = this.interp.getBottomPadding();
        } else {
            n6 = 0;
            n7 = 0;
            n8 = 0;
            n9 = 0;
        }
        if (this.extender != null) {
            n5 = planarImage.getMinX();
            n4 = planarImage.getMaxX();
            n3 = planarImage.getMinY();
            n2 = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n9, planarImage.getMinY() - n7, planarImage.getWidth() + n9 + n8, planarImage.getHeight() + n7 + n6);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n5 = planarImage.getMinX() + n9;
            n4 = planarImage.getMaxX() - n8;
            n3 = planarImage.getMinY() + n7;
            n2 = planarImage.getMaxY() - n6;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n10 = this.interp.getWidth();
        int n11 = this.interp.getHeight();
        int n12 = rasterAccessor.getWidth();
        int n13 = rasterAccessor.getHeight();
        int n14 = rasterAccessor.getNumBands();
        int n15 = rasterAccessor.getScanlineStride();
        int n16 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n17 = 1 << this.interp.getSubsampleBitsH();
        int n18 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n12];
        int[][] nArray2 = new int[n11][n10];
        int n19 = 0;
        short[] sArray2 = new short[n14];
        int n20 = 0;
        while (n20 < n14) {
            sArray2[n20] = (short)this.backgroundValues[n20];
            ++n20;
        }
        int n21 = 0;
        while (n21 < n13) {
            int n22 = n19;
            n19 += n15;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n21, n12, 1, fArray);
            int n23 = 0;
            int n24 = 0;
            while (n24 < n12) {
                int n25;
                float f2 = fArray[n23++];
                float f3 = fArray[n23++];
                int n26 = WarpGeneralOpImage.floor(f2);
                int n27 = WarpGeneralOpImage.floor(f3);
                int n28 = (int)((f2 - (float)n26) * (float)n17);
                int n29 = (int)((f3 - (float)n27) * (float)n18);
                if (n26 < n5 || n26 >= n4 || n27 < n3 || n27 >= n2) {
                    if (this.setBackground) {
                        n25 = 0;
                        while (n25 < n14) {
                            sArray[n25][n22 + nArray[n25]] = sArray2[n25];
                            ++n25;
                        }
                    }
                } else {
                    n26 -= n9;
                    n27 -= n7;
                    n25 = 0;
                    while (n25 < n14) {
                        int n30 = 0;
                        while (n30 < n11) {
                            int n31 = 0;
                            while (n31 < n10) {
                                nArray2[n30][n31] = randomIter.getSample(n26 + n31, n27 + n30, n25) & 0xFFFF;
                                ++n31;
                            }
                            ++n30;
                        }
                        sArray[n25][n22 + nArray[n25]] = ImageUtil.clampUShort(this.interp.interpolate(nArray2, n28, n29));
                        ++n25;
                    }
                }
                n22 += n16;
                ++n24;
            }
            ++n21;
        }
    }

    private void computeRectShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (this.interp != null) {
            n9 = this.interp.getLeftPadding();
            n8 = this.interp.getRightPadding();
            n7 = this.interp.getTopPadding();
            n6 = this.interp.getBottomPadding();
        } else {
            n6 = 0;
            n7 = 0;
            n8 = 0;
            n9 = 0;
        }
        if (this.extender != null) {
            n5 = planarImage.getMinX();
            n4 = planarImage.getMaxX();
            n3 = planarImage.getMinY();
            n2 = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n9, planarImage.getMinY() - n7, planarImage.getWidth() + n9 + n8, planarImage.getHeight() + n7 + n6);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n5 = planarImage.getMinX() + n9;
            n4 = planarImage.getMaxX() - n8;
            n3 = planarImage.getMinY() + n7;
            n2 = planarImage.getMaxY() - n6;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n10 = this.interp.getWidth();
        int n11 = this.interp.getHeight();
        int n12 = rasterAccessor.getWidth();
        int n13 = rasterAccessor.getHeight();
        int n14 = rasterAccessor.getNumBands();
        int n15 = rasterAccessor.getScanlineStride();
        int n16 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n17 = 1 << this.interp.getSubsampleBitsH();
        int n18 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n12];
        int[][] nArray2 = new int[n11][n10];
        int n19 = 0;
        short[] sArray2 = new short[n14];
        int n20 = 0;
        while (n20 < n14) {
            sArray2[n20] = (short)this.backgroundValues[n20];
            ++n20;
        }
        int n21 = 0;
        while (n21 < n13) {
            int n22 = n19;
            n19 += n15;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n21, n12, 1, fArray);
            int n23 = 0;
            int n24 = 0;
            while (n24 < n12) {
                int n25;
                float f2 = fArray[n23++];
                float f3 = fArray[n23++];
                int n26 = WarpGeneralOpImage.floor(f2);
                int n27 = WarpGeneralOpImage.floor(f3);
                int n28 = (int)((f2 - (float)n26) * (float)n17);
                int n29 = (int)((f3 - (float)n27) * (float)n18);
                if (n26 < n5 || n26 >= n4 || n27 < n3 || n27 >= n2) {
                    if (this.setBackground) {
                        n25 = 0;
                        while (n25 < n14) {
                            sArray[n25][n22 + nArray[n25]] = sArray2[n25];
                            ++n25;
                        }
                    }
                } else {
                    n26 -= n9;
                    n27 -= n7;
                    n25 = 0;
                    while (n25 < n14) {
                        int n30 = 0;
                        while (n30 < n11) {
                            int n31 = 0;
                            while (n31 < n10) {
                                nArray2[n30][n31] = randomIter.getSample(n26 + n31, n27 + n30, n25);
                                ++n31;
                            }
                            ++n30;
                        }
                        sArray[n25][n22 + nArray[n25]] = ImageUtil.clampShort(this.interp.interpolate(nArray2, n28, n29));
                        ++n25;
                    }
                }
                n22 += n16;
                ++n24;
            }
            ++n21;
        }
    }

    private void computeRectInt(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (this.interp != null) {
            n9 = this.interp.getLeftPadding();
            n8 = this.interp.getRightPadding();
            n7 = this.interp.getTopPadding();
            n6 = this.interp.getBottomPadding();
        } else {
            n6 = 0;
            n7 = 0;
            n8 = 0;
            n9 = 0;
        }
        if (this.extender != null) {
            n5 = planarImage.getMinX();
            n4 = planarImage.getMaxX();
            n3 = planarImage.getMinY();
            n2 = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n9, planarImage.getMinY() - n7, planarImage.getWidth() + n9 + n8, planarImage.getHeight() + n7 + n6);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n5 = planarImage.getMinX() + n9;
            n4 = planarImage.getMaxX() - n8;
            n3 = planarImage.getMinY() + n7;
            n2 = planarImage.getMaxY() - n6;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n10 = this.interp.getWidth();
        int n11 = this.interp.getHeight();
        int n12 = rasterAccessor.getWidth();
        int n13 = rasterAccessor.getHeight();
        int n14 = rasterAccessor.getNumBands();
        int n15 = rasterAccessor.getScanlineStride();
        int n16 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n17 = 1 << this.interp.getSubsampleBitsH();
        int n18 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n12];
        int[][] nArray3 = new int[n11][n10];
        int n19 = 0;
        int[] nArray4 = new int[n14];
        int n20 = 0;
        while (n20 < n14) {
            nArray4[n20] = (int)this.backgroundValues[n20];
            ++n20;
        }
        int n21 = 0;
        while (n21 < n13) {
            int n22 = n19;
            n19 += n15;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n21, n12, 1, fArray);
            int n23 = 0;
            int n24 = 0;
            while (n24 < n12) {
                int n25;
                float f2 = fArray[n23++];
                float f3 = fArray[n23++];
                int n26 = WarpGeneralOpImage.floor(f2);
                int n27 = WarpGeneralOpImage.floor(f3);
                int n28 = (int)((f2 - (float)n26) * (float)n17);
                int n29 = (int)((f3 - (float)n27) * (float)n18);
                if (n26 < n5 || n26 >= n4 || n27 < n3 || n27 >= n2) {
                    if (this.setBackground) {
                        n25 = 0;
                        while (n25 < n14) {
                            nArray2[n25][n22 + nArray[n25]] = nArray4[n25];
                            ++n25;
                        }
                    }
                } else {
                    n26 -= n9;
                    n27 -= n7;
                    n25 = 0;
                    while (n25 < n14) {
                        int n30 = 0;
                        while (n30 < n11) {
                            int n31 = 0;
                            while (n31 < n10) {
                                nArray3[n30][n31] = randomIter.getSample(n26 + n31, n27 + n30, n25);
                                ++n31;
                            }
                            ++n30;
                        }
                        nArray2[n25][n22 + nArray[n25]] = this.interp.interpolate(nArray3, n28, n29);
                        ++n25;
                    }
                }
                n22 += n16;
                ++n24;
            }
            ++n21;
        }
    }

    private void computeRectFloat(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (this.interp != null) {
            n9 = this.interp.getLeftPadding();
            n8 = this.interp.getRightPadding();
            n7 = this.interp.getTopPadding();
            n6 = this.interp.getBottomPadding();
        } else {
            n6 = 0;
            n7 = 0;
            n8 = 0;
            n9 = 0;
        }
        if (this.extender != null) {
            n5 = planarImage.getMinX();
            n4 = planarImage.getMaxX();
            n3 = planarImage.getMinY();
            n2 = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n9, planarImage.getMinY() - n7, planarImage.getWidth() + n9 + n8, planarImage.getHeight() + n7 + n6);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n5 = planarImage.getMinX() + n9;
            n4 = planarImage.getMaxX() - n8;
            n3 = planarImage.getMinY() + n7;
            n2 = planarImage.getMaxY() - n6;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n10 = this.interp.getWidth();
        int n11 = this.interp.getHeight();
        int n12 = rasterAccessor.getWidth();
        int n13 = rasterAccessor.getHeight();
        int n14 = rasterAccessor.getNumBands();
        int n15 = rasterAccessor.getScanlineStride();
        int n16 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        float[] fArray2 = new float[2 * n12];
        float[][] fArray3 = new float[n11][n10];
        int n17 = 0;
        float[] fArray4 = new float[n14];
        int n18 = 0;
        while (n18 < n14) {
            fArray4[n18] = (float)this.backgroundValues[n18];
            ++n18;
        }
        int n19 = 0;
        while (n19 < n13) {
            int n20 = n17;
            n17 += n15;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n19, n12, 1, fArray2);
            int n21 = 0;
            int n22 = 0;
            while (n22 < n12) {
                int n23;
                float f2 = fArray2[n21++];
                float f3 = fArray2[n21++];
                int n24 = WarpGeneralOpImage.floor(f2);
                int n25 = WarpGeneralOpImage.floor(f3);
                float f4 = f2 - (float)n24;
                float f5 = f3 - (float)n25;
                if (n24 < n5 || n24 >= n4 || n25 < n3 || n25 >= n2) {
                    if (this.setBackground) {
                        n23 = 0;
                        while (n23 < n14) {
                            fArray[n23][n20 + nArray[n23]] = fArray4[n23];
                            ++n23;
                        }
                    }
                } else {
                    n24 -= n9;
                    n25 -= n7;
                    n23 = 0;
                    while (n23 < n14) {
                        int n26 = 0;
                        while (n26 < n11) {
                            int n27 = 0;
                            while (n27 < n10) {
                                fArray3[n26][n27] = randomIter.getSampleFloat(n24 + n27, n25 + n26, n23);
                                ++n27;
                            }
                            ++n26;
                        }
                        fArray[n23][n20 + nArray[n23]] = this.interp.interpolate(fArray3, f4, f5);
                        ++n23;
                    }
                }
                n20 += n16;
                ++n22;
            }
            ++n19;
        }
    }

    private void computeRectDouble(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (this.interp != null) {
            n9 = this.interp.getLeftPadding();
            n8 = this.interp.getRightPadding();
            n7 = this.interp.getTopPadding();
            n6 = this.interp.getBottomPadding();
        } else {
            n6 = 0;
            n7 = 0;
            n8 = 0;
            n9 = 0;
        }
        if (this.extender != null) {
            n5 = planarImage.getMinX();
            n4 = planarImage.getMaxX();
            n3 = planarImage.getMinY();
            n2 = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n9, planarImage.getMinY() - n7, planarImage.getWidth() + n9 + n8, planarImage.getHeight() + n7 + n6);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n5 = planarImage.getMinX() + n9;
            n4 = planarImage.getMaxX() - n8;
            n3 = planarImage.getMinY() + n7;
            n2 = planarImage.getMaxY() - n6;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n10 = this.interp.getWidth();
        int n11 = this.interp.getHeight();
        int n12 = rasterAccessor.getWidth();
        int n13 = rasterAccessor.getHeight();
        int n14 = rasterAccessor.getNumBands();
        int n15 = rasterAccessor.getScanlineStride();
        int n16 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        float[] fArray = new float[2 * n12];
        double[][] dArray2 = new double[n11][n10];
        int n17 = 0;
        int n18 = 0;
        while (n18 < n13) {
            int n19 = n17;
            n17 += n15;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n18, n12, 1, fArray);
            int n20 = 0;
            int n21 = 0;
            while (n21 < n12) {
                int n22;
                float f2 = fArray[n20++];
                float f3 = fArray[n20++];
                int n23 = WarpGeneralOpImage.floor(f2);
                int n24 = WarpGeneralOpImage.floor(f3);
                float f4 = f2 - (float)n23;
                float f5 = f3 - (float)n24;
                if (n23 < n5 || n23 >= n4 || n24 < n3 || n24 >= n2) {
                    if (this.setBackground) {
                        n22 = 0;
                        while (n22 < n14) {
                            dArray[n22][n19 + nArray[n22]] = this.backgroundValues[n22];
                            ++n22;
                        }
                    }
                } else {
                    n23 -= n9;
                    n24 -= n7;
                    n22 = 0;
                    while (n22 < n14) {
                        int n25 = 0;
                        while (n25 < n11) {
                            int n26 = 0;
                            while (n26 < n10) {
                                dArray2[n25][n26] = randomIter.getSampleDouble(n23 + n26, n24 + n25, n22);
                                ++n26;
                            }
                            ++n25;
                        }
                        dArray[n22][n19 + nArray[n22]] = this.interp.interpolate(dArray2, f4, f5);
                        ++n22;
                    }
                }
                n19 += n16;
                ++n21;
            }
            ++n18;
        }
    }

    private static final int floor(float f2) {
        return f2 >= 0.0f ? (int)f2 : (int)f2 - 1;
    }
}

